/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.efabricator;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.MultiLineLabel;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Column;
import github.kasuminova.mmce.client.gui.widget.container.Row;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.novaeng.client.gui.GuiEFabricatorController;
import github.kasuminova.novaeng.client.gui.widget.ProgressBar;
import github.kasuminova.novaeng.client.gui.widget.efabricator.event.EFGUIDataUpdateEvent;
import github.kasuminova.novaeng.common.container.data.EFabricatorData;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class HeatStatisticPanel
extends Column {
    public static final int WIDTH = 51;
    public static final int HEIGHT = 77;
    public static final TextureProperties TEXTURE_BACKGROUND = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 204, 24, 51, 77);
    private final BackgroundLabel energyUsage;
    private final BackgroundLabel activeCooling;
    private final ProgressBar energyUsageBar;
    private final ProgressBar coolantBar;
    private final ProgressBar hotCoolantBar;

    public HeatStatisticPanel() {
        this.width = 51;
        this.height = 77;
        this.energyUsage = new BackgroundLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.max_energy_usage", (Object[])new Object[]{0})));
        this.energyUsage.setTooltipFunction(label -> Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.max_energy_usage.tip", (Object[])new Object[0]))).setBackground(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)210, (int)102, (int)45, (int)9)).setPadding(1);
        this.energyUsage.getLabel().setAutoRecalculateSize(false).setAutoWrap(false).setVerticalCentering(true).setScale(0.6f).setWidthHeight(43, 6).setMarginDown(2);
        this.activeCooling = new BackgroundLabel(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.active_cooling", (Object[])new Object[]{I18n.func_135052_a((String)"gui.efabricator.active_cooling.off", (Object[])new Object[0])})));
        this.activeCooling.setBackground(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)210, (int)102, (int)45, (int)9)).setPadding(1);
        this.activeCooling.getLabel().setAutoRecalculateSize(false).setAutoWrap(false).setVerticalCentering(true).setScale(0.75f).setWidthHeight(43, 7);
        this.energyUsageBar = new ProgressBar();
        this.coolantBar = new ProgressBar();
        this.hotCoolantBar = new ProgressBar();
        this.addWidgets(new DynamicWidget[]{this.energyUsage.setWidthHeight(45, 9).setMargin(3, 0, 3, 0), this.energyUsageBar.setBackgroundTexture(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)210, (int)122, (int)45, (int)9)).addForegroundTexture(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)210, (int)112, (int)45, (int)9)).setLeftToRight(true).setMaxProgress(1.0f).setWidthHeight(45, 9).setMargin(3, 0, 3, 0), this.activeCooling.setWidthHeight(45, 9).setMargin(3, 0, 3, 0), new Row().addWidgets(new DynamicWidget[]{this.coolantBar.setBackgroundTexture(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)212, (int)134, (int)21, (int)36)).addForegroundTexture(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)108, (int)149, (int)21, (int)36)).setDownToUp(true).setMaxProgress(1.0f).setWidthHeight(21, 36).setMarginRight(2), this.hotCoolantBar.setBackgroundTexture(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)234, (int)134, (int)21, (int)36)).addForegroundTexture(TextureProperties.of((ResourceLocation)TEXTURE_BACKGROUND.texRes(), (int)130, (int)149, (int)21, (int)36)).setDownToUp(true).setMaxProgress(1.0f).setWidthHeight(21, 36)}).setMargin(3, 0, 3, 0)});
    }

    public boolean onGuiEvent(GuiEvent event) {
        if (event instanceof EFGUIDataUpdateEvent) {
            EFGUIDataUpdateEvent efGUIEvent = (EFGUIDataUpdateEvent)event;
            EFabricatorData data = efGUIEvent.getEFGui().getData();
            if (data == null) {
                return super.onGuiEvent(event);
            }
            this.activeCooling.getLabel().setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.active_cooling", (Object[])new Object[]{data.activeCooling() ? I18n.func_135052_a((String)"gui.efabricator.active_cooling.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.efabricator.active_cooling.off", (Object[])new Object[0])})));
            int length = data.length();
            int queueDepth = 32;
            if (data.overclocked()) {
                queueDepth = data.level().applyOverclockQueueDepth(queueDepth);
            }
            int maxEnergy = 500000 * length;
            this.energyUsageBar.setMaxProgress(maxEnergy).setProgress(data.energyStored());
            int energyUsage = 100 * length * queueDepth;
            if (data.overclocked() && !data.activeCooling()) {
                energyUsage = data.level().applyOverclockEnergyUsage(energyUsage);
            }
            this.energyUsage.getLabel().setContents(Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.max_energy_usage", (Object[])new Object[]{NovaEngUtils.formatNumber(energyUsage, 1)})));
            this.coolantBar.setMaxProgress(data.maxCoolant()).setProgress(data.coolant());
            this.hotCoolantBar.setMaxProgress(data.maxHotCoolant()).setProgress(data.hotCoolant());
        }
        return super.onGuiEvent(event);
    }

    protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        TEXTURE_BACKGROUND.render(renderPos, gui);
        super.preRenderInternal(gui, renderSize, renderPos, mousePos);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static class BackgroundLabel
    extends Column {
        private final MultiLineLabel label;
        private TextureProperties background = TextureProperties.EMPTY;
        private Function<BackgroundLabel, List<String>> tooltipFunction = null;

        public BackgroundLabel(List<String> contents) {
            this.label = new MultiLineLabel(contents);
            this.addWidget((DynamicWidget)this.label);
        }

        protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
            this.background.renderIfPresent(renderPos, gui);
            super.preRenderInternal(gui, renderSize, renderPos, mousePos);
        }

        public TextureProperties getBackground() {
            return this.background;
        }

        public BackgroundLabel setBackground(TextureProperties background) {
            this.background = background;
            return this;
        }

        public MultiLineLabel getLabel() {
            return this.label;
        }

        public BackgroundLabel setPadding(int padding) {
            this.label.setMargin(padding, padding, padding, padding);
            return this;
        }

        public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
            return this.tooltipFunction != null ? this.tooltipFunction.apply(this) : Collections.emptyList();
        }

        public BackgroundLabel setTooltipFunction(Function<BackgroundLabel, List<String>> tooltipFunction) {
            this.tooltipFunction = tooltipFunction;
            return this;
        }
    }
}

