/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.efabricator;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Column;
import github.kasuminova.mmce.client.gui.widget.container.Row;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.novaeng.client.gui.GuiEFabricatorController;
import github.kasuminova.novaeng.client.gui.widget.efabricator.CraftingStatus;
import github.kasuminova.novaeng.client.gui.widget.efabricator.ParallelProcStatus;
import github.kasuminova.novaeng.client.gui.widget.efabricator.event.EFGUIDataUpdateEvent;
import github.kasuminova.novaeng.common.container.data.EFabricatorData;
import java.util.List;

public class CraftingStatusPanel
extends Column {
    public static final int WIDTH = 229;
    public static final int HEIGHT = 58;
    public static final TextureProperties TEXTURE_BACKGROUND = new TextureProperties(GuiEFabricatorController.TEXTURES_INVENTORY, 1, 197, 229, 58);
    public static final int MAX_COL = 12;
    public static final int MAX_ROW = 3;
    public static final int PROC_ROW_WIDGET_IDX_0 = 0;
    public static final int PROC_ROW_WIDGET_IDX_1 = 2;
    public static final int WORKER_ROW_WIDGET_IDX = 1;
    protected int length = 0;

    public CraftingStatusPanel() {
        this.width = 229;
        this.height = 58;
        this.rebuildWidgets(0);
    }

    private void rebuildWidgets(int len) {
        int c;
        this.widgets.clear();
        Row row = new Row();
        for (c = 0; c < 12; ++c) {
            row.addWidget(new ParallelProcStatus(len > c).setMargin(1, 0, 1, 0));
        }
        this.addWidget((DynamicWidget)row);
        row = new Row();
        for (c = 0; c < 12; ++c) {
            row.addWidget(new CraftingStatus(len > c).setMargin(1, 0, 1, 0));
        }
        this.addWidget((DynamicWidget)row);
        row = new Row();
        for (c = 0; c < 12; ++c) {
            row.addWidget(new ParallelProcStatus(len > c).setMargin(1, 0, 1, 0));
        }
        this.addWidget((DynamicWidget)row);
        this.length = len;
    }

    public boolean onGuiEvent(GuiEvent event) {
        if (event instanceof EFGUIDataUpdateEvent) {
            EFGUIDataUpdateEvent efGUIEvent = (EFGUIDataUpdateEvent)event;
            this.rebuildStatus(efGUIEvent.getEFGui().getData());
        }
        return super.onGuiEvent(event);
    }

    private void rebuildStatus(EFabricatorData data) {
        List widgets = this.getWidgets();
        List<EFabricatorData.WorkerStatus> workers = data.workers();
        int length = data.length();
        if (this.length != length) {
            this.rebuildWidgets(length);
        }
        for (int i = 0; i < length; ++i) {
            ParallelProcStatus procStatus;
            Row row = (Row)widgets.get(1);
            DynamicWidget widget = (DynamicWidget)row.getWidgets().get(i);
            if (widget instanceof CraftingStatus) {
                CraftingStatus status = (CraftingStatus)widget;
                EFabricatorData.WorkerStatus workerStatus = workers.get(i);
                int queueDepth = 32;
                status.update(workerStatus.queueLength(), data.overclocked() ? data.level().applyOverclockQueueDepth(queueDepth) : queueDepth, workerStatus.crafting());
            }
            if ((widget = (DynamicWidget)(row = (Row)widgets.get(0)).getWidgets().get(i)) instanceof ParallelProcStatus) {
                procStatus = (ParallelProcStatus)widget;
                procStatus.setLevel(data.level());
            }
            if (!((widget = (DynamicWidget)(row = (Row)widgets.get(2)).getWidgets().get(i)) instanceof ParallelProcStatus)) continue;
            procStatus = (ParallelProcStatus)widget;
            procStatus.setLevel(data.level());
        }
    }

    protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        TEXTURE_BACKGROUND.render(renderPos, gui);
        super.preRenderInternal(gui, renderSize, renderPos, mousePos);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

