/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.efabricator;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Column;
import github.kasuminova.novaeng.client.gui.GuiEFabricatorController;
import github.kasuminova.novaeng.client.gui.widget.ProgressBar;
import github.kasuminova.novaeng.client.gui.widget.efabricator.SlotItemVirtualJEISmall;
import java.util.Collections;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class CraftingStatus
extends Column {
    private static final TextureProperties TEXTURE_BACKGROUND = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 20, 126, 18, 18);
    private static final TextureProperties TEXTURE_BACKGROUND_DISABLED = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 39, 126, 18, 18);
    private static final TextureProperties TEXTURE_UNAVAILABLE = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 58, 126, 18, 18);
    private static final TextureProperties TEXTURE_PROGRESS_FOREGROUND = new TextureProperties(GuiEFabricatorController.TEXTURES_ELEMENTS, 77, 126, 14, 3);
    private final SlotItemVirtualJEISmall slot = SlotItemVirtualJEISmall.of();
    private final ProgressBar progress = new ProgressBar();
    private boolean available;

    public CraftingStatus(boolean available) {
        this.width = 18;
        this.height = 18;
        this.slot.setMargin(6, 0, 2, 1);
        this.progress.setLeftToRight(true).setHorizontal(true).addForegroundTexture(TEXTURE_PROGRESS_FOREGROUND).setMaxProgress(100.0f).setTooltipFunction(input -> Collections.singletonList(I18n.func_135052_a((String)"gui.efabricator.queue.status", (Object[])new Object[]{(int)input.getProgress(), (int)input.getMaxProgress()}))).setWidthHeight(14, 3).setMarginLeft(2);
        this.available = available;
        if (!available) {
            return;
        }
        this.addWidgets(new DynamicWidget[]{this.slot, this.progress});
    }

    public void update(int queueLen, int maxQueueLen, ItemStack crafting) {
        this.slot.setStackInSlot(crafting);
        this.progress.setMaxProgress(maxQueueLen).setProgress(queueLen);
    }

    protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        if (!this.available) {
            TEXTURE_UNAVAILABLE.render(renderPos, gui.getGui());
        } else if (this.progress.getProgress() > 0.0) {
            TEXTURE_BACKGROUND.render(renderPos, gui.getGui());
        } else {
            TEXTURE_BACKGROUND_DISABLED.render(renderPos, gui.getGui());
        }
        super.preRenderInternal(gui, renderSize, renderPos, mousePos);
    }

    public ProgressBar getProgress() {
        return this.progress;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public CraftingStatus setAvailable(boolean available) {
        this.available = available;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

