/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.craftingtree;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderFunction;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Row;
import github.kasuminova.novaeng.client.gui.widget.craftingtree.PlaceHolder;
import github.kasuminova.novaeng.client.gui.widget.craftingtree.TreeNode;

public class TreeRow
extends Row {
    private int cachedWidth = -1;
    private int cachedHeight = -1;
    private int cachedWidgetSize = -1;

    public TreeRow() {
        this.setUseScissor(false);
    }

    protected void doRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos, RenderFunction renderFunction) {
        int x = 0;
        int height = this.getHeight();
        for (int i = 0; i < this.widgets.size(); ++i) {
            DynamicWidget widget = (DynamicWidget)this.widgets.get(i);
            if (widget.isDisabled()) continue;
            if (widget instanceof PlaceHolder) {
                x += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
                continue;
            }
            RenderPos widgetRenderPos = this.getWidgetRenderOffset(widget, height, x);
            if (widgetRenderPos == null) continue;
            if (widget.isVisible()) {
                RenderPos absRenderPos = widgetRenderPos.add(renderPos);
                int totalWidth = widget.getWidth() + widget.getMarginRight() + this.getPlaceHolderWidth(i + 1);
                if (absRenderPos.posX() + totalWidth > 0) {
                    renderFunction.doRender(widget, gui, new RenderSize(widget.getWidth(), widget.getHeight()).smaller(renderSize), absRenderPos, mousePos.relativeTo(absRenderPos));
                }
            }
            if (renderSize.isWidthLimited() && (x += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight()) > renderSize.width()) break;
        }
    }

    public int getPlaceHolderWidth(int startIdx) {
        DynamicWidget widget;
        int width = 0;
        for (int i = startIdx; i < this.widgets.size() && (widget = (DynamicWidget)this.widgets.get(i)) instanceof PlaceHolder; ++i) {
            width += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
        }
        return width;
    }

    public RenderPos getRelativeRenderPos(TreeNode node) {
        if (!this.widgets.contains((Object)node)) {
            return null;
        }
        int x = 0;
        int height = this.getHeight();
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, height, x)) == null) continue;
            if (widget == node) {
                return widgetRenderPos;
            }
            x += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
        }
        return null;
    }

    public TreeRow addWidget(DynamicWidget widget) {
        super.addWidget(widget);
        if (this.cachedWidgetSize + 1 == this.widgets.size()) {
            ++this.cachedWidgetSize;
            this.cachedWidth += widget.getMarginLeft() + widget.getWidth() + widget.getMarginRight();
            int widgetHeight = widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
            if (widget.isUseAbsPos()) {
                widgetHeight += widget.getAbsY();
            }
            if (widgetHeight > this.cachedHeight) {
                this.cachedHeight = widgetHeight;
            }
        } else {
            this.cachedWidgetSize = this.widgets.size();
            this.cachedWidth = super.getWidth();
            this.cachedHeight = super.getHeight();
        }
        return this;
    }

    public int getWidth() {
        if (this.cachedWidgetSize == this.widgets.size()) {
            return this.cachedWidth;
        }
        this.cachedWidgetSize = this.widgets.size();
        this.cachedHeight = super.getHeight();
        this.cachedWidth = super.getWidth();
        return this.cachedWidth;
    }

    public int getHeight() {
        if (this.cachedWidgetSize == this.widgets.size()) {
            return this.cachedHeight;
        }
        this.cachedWidgetSize = this.widgets.size();
        this.cachedWidth = super.getWidth();
        this.cachedHeight = super.getHeight();
        return this.cachedHeight;
    }
}

