/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.craftingtree;

import appeng.api.storage.data.IAEItemStack;
import appeng.client.render.StackSizeRenderer;
import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.novaeng.client.gui.widget.craftingtree.CraftingTree;
import github.kasuminova.novaeng.client.gui.widget.craftingtree.TreeRow;
import github.kasuminova.novaeng.client.gui.widget.craftingtree.event.TreeNodeSelectEvent;
import github.kasuminova.novaeng.common.integration.ae2.data.LiteCraftTreeNode;
import github.kasuminova.novaeng.common.integration.ae2.data.LiteCraftTreeProc;
import hellfirepvp.modularmachinery.client.ClientProxy;
import hellfirepvp.modularmachinery.common.integration.ModIntegrationJEI;
import hellfirepvp.modularmachinery.common.integration.ingredient.IngredientItemStackRenderer;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.config.KeyBindings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;

public class TreeNode
extends DynamicWidget {
    public static final int LINE_WIDTH = 1;
    public static final int LINE_HEIGHT = 2;
    public static final int PARENT_LINE_HEIGHT = 2;
    public static final int LINE_TOTAL_HEIGHT = 6;
    public static final int WIDTH = 20;
    public static final int HEIGHT = 20;
    public static final int TOTAL_HEIGHT = 26;
    public static final int ROOT_MARGIN_TOP = 4;
    public static final int MARGIN_LEFT = 6;
    public static final int LINE_RENDER_OFFSET = 9;
    public static final int LINE_COLOR = -855310;
    public static final int LINE_SHADOW_COLOR = -11711129;
    public static final int MISSING_LINE_COLOR = -1154205;
    public static final int MISSING_LINE_SHADOW_COLOR = -7652806;
    public static final int ITEM_RENDER_OFFSET = 2;
    private static final TextureProperties BACKGROUND = TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_dark.png"), (int)0, (int)216, (int)20, (int)20);
    private static final TextureProperties BACKGROUND_MISSING = TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_dark.png"), (int)0, (int)236, (int)20, (int)20);
    private static final TextureProperties MISSING = TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_dark.png"), (int)40, (int)216, (int)20, (int)20);
    private static final TextureProperties SELECTED = TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_dark.png"), (int)0, (int)196, (int)20, (int)20);
    private static final StackSizeRenderer STACK_SIZE_RENDERER = new StackSizeRenderer();
    protected final CraftingTree tree;
    protected boolean root = false;
    protected int linkedSubNodes = 0;
    protected LiteCraftTreeNode node = null;
    protected TreeRow parentRow = null;
    protected TreeNode prev = null;
    protected TreeNode next = null;
    protected boolean mouseOver = false;
    protected boolean selected = false;

    public TreeNode(CraftingTree tree) {
        this.tree = tree;
        this.setHeight(26);
        this.setMargin(6, 0, 0, 0);
    }

    public void update(WidgetGui gui) {
        super.update(gui);
        this.mouseOver = false;
    }

    public void preRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        this.mouseOver = this.isMouseOver(mousePos.mouseX(), mousePos.mouseY());
        if (renderPos.posX() + 20 < 0 && renderPos.posY() + 26 < 0) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (LiteCraftTreeNode.isMissing(this.node)) {
            BACKGROUND_MISSING.render(renderPos.add(new RenderPos(0, 2)), gui);
        } else {
            BACKGROUND.render(renderPos.add(new RenderPos(0, 2)), gui);
        }
        if (this.selected) {
            SELECTED.render(renderPos.add(new RenderPos(0, 2)), gui);
        }
    }

    public void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        if (renderPos.posX() + 20 < 0 && renderPos.posY() + 26 < 0) {
            return;
        }
        this.renderItem(renderPos.add(new RenderPos(0, 2)).add(new RenderPos(2, 2)));
        if (LiteCraftTreeNode.isMissing(this.node) && this.node.missing() > 0L) {
            GlStateManager.func_179097_i();
            MISSING.render(renderPos.add(new RenderPos(0, 2)), gui);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179140_f();
    }

    public void postRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        this.renderParentNodeLink(renderPos);
        this.renderSubNodeLinkLine(renderPos.add(new RenderPos(0, 22)));
        CraftingTree.DEBUG_RENDERED_NODES.incrementAndGet();
    }

    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        IAEItemStack output = this.node.output();
        if (output == null) {
            return Collections.emptyList();
        }
        ItemStack definition = output.getDefinition();
        GuiScreen g = widgetGui.getGui();
        GuiUtils.preItemToolTip((ItemStack)definition);
        List toolTip = g.func_191927_a(definition);
        if (LiteCraftTreeNode.isMissing(this.node)) {
            toolTip.add(this.node.missing() > 0L ? I18n.func_135052_a((String)"gui.crafting_tree.missing", (Object[])new Object[]{MiscUtils.formatDecimal((double)this.node.missing())}) : I18n.func_135052_a((String)"gui.crafting_tree.sub_node_missing", (Object[])new Object[0]));
        }
        if (output.getStackSize() >= 10000L) {
            toolTip.add(MiscUtils.formatDecimal((double)output.getStackSize()));
        }
        return toolTip;
    }

    protected void renderItem(RenderPos renderPos) {
        if (this.node.output() == null) {
            return;
        }
        IngredientItemStackRenderer.DEFAULT_INSTANCE.render(Minecraft.func_71410_x(), renderPos.posX(), renderPos.posY(), this.node.output().getCachedItemStack(1L));
        STACK_SIZE_RENDERER.renderStackSize(Minecraft.func_71410_x().field_71466_p, this.node.output(), renderPos.posX(), renderPos.posY());
    }

    protected void renderParentNodeLink(RenderPos renderPos) {
        if (this.root) {
            return;
        }
        int lineColor = LiteCraftTreeNode.isMissing(this.node) ? -1154205 : -855310;
        int lineShadowColor = LiteCraftTreeNode.isMissing(this.node) ? -7652806 : -11711129;
        TreeNode.renderLine(renderPos.add(new RenderPos(9, -1)), 1, 3, lineColor);
        TreeNode.renderLine(renderPos.add(new RenderPos(10, 0)), 1, 2, lineShadowColor);
    }

    protected void renderSubNodeLinkLine(RenderPos renderPos) {
        int lineShadowColor;
        if (this.node.inputs().isEmpty()) {
            return;
        }
        int lineColor = LiteCraftTreeNode.isMissing(this.node) ? -1154205 : -855310;
        int n = lineShadowColor = LiteCraftTreeNode.isMissing(this.node) ? -7652806 : -11711129;
        if (this.linkedSubNodes > 0) {
            int totalWidth = this.linkedSubNodes * 26 + 1;
            TreeNode.renderLine(renderPos.add(new RenderPos(9, 2)), totalWidth, 1, lineColor);
            TreeNode.renderLine(renderPos.add(new RenderPos(10, 3)), totalWidth, 1, lineShadowColor);
            TreeNode.renderLine(renderPos.add(new RenderPos(9, 0)), 1, 2, lineColor);
            TreeNode.renderLine(renderPos.add(new RenderPos(10, 0)), 1, 2, lineShadowColor);
        } else {
            TreeNode.renderLine(renderPos.add(new RenderPos(9, 0)), 1, 3, lineColor);
            TreeNode.renderLine(renderPos.add(new RenderPos(10, 0)), 1, 4, lineShadowColor);
        }
    }

    protected static void renderLine(RenderPos pos, int width, int height, int color) {
        GuiContainer.func_73734_a((int)pos.posX(), (int)pos.posY(), (int)(pos.posX() + width), (int)(pos.posY() + height), (int)color);
    }

    public boolean onGuiEvent(GuiEvent event) {
        if (event instanceof TreeNodeSelectEvent) {
            TreeNodeSelectEvent selectEvent = (TreeNodeSelectEvent)event;
            if (this.selected && selectEvent.getSelectedNode() != this) {
                this.selected = false;
            }
        }
        return super.onGuiEvent(event);
    }

    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        if (!this.selected) {
            this.select();
            return true;
        }
        return false;
    }

    public boolean onKeyTyped(char typedChar, int keyCode) {
        if (!this.mouseOver || this.node == null) {
            return false;
        }
        int showRecipeKeyCode = KeyBindings.showRecipe.func_151463_i();
        int showUsesKeyCode = KeyBindings.showUses.func_151463_i();
        int bookmarkKeyCode = KeyBindings.bookmark.func_151463_i();
        if (showRecipeKeyCode > 0 && showRecipeKeyCode <= 255 && showRecipeKeyCode == keyCode) {
            return this.showStackFocus(IFocus.Mode.OUTPUT);
        }
        if (showUsesKeyCode > 0 && showUsesKeyCode <= 255 && showUsesKeyCode == keyCode) {
            return this.showStackFocus(IFocus.Mode.INPUT);
        }
        if (bookmarkKeyCode > 0 && bookmarkKeyCode <= 255 && bookmarkKeyCode == keyCode) {
            ModIntegrationJEI.addItemStackToBookmarkList((ItemStack)this.node.output().getCachedItemStack(1L));
            return true;
        }
        return false;
    }

    protected boolean showStackFocus(IFocus.Mode output) {
        ClientProxy.clientScheduler.addRunnable(() -> {
            IFocus focus = ModIntegrationJEI.recipeRegistry.createFocus(output, (Object)this.node.output().getCachedItemStack(1L));
            ModIntegrationJEI.jeiRuntime.getRecipesGui().show(focus);
        }, 0);
        return true;
    }

    protected int getTotalSubNodes() {
        int total = 0;
        for (LiteCraftTreeProc input : this.node.inputs()) {
            total += input.inputs().size();
        }
        return total;
    }

    public TreeNode select() {
        this.selected = true;
        this.tree.onGuiEvent(new TreeNodeSelectEvent(this));
        return this;
    }

    public TreeNode setNode(LiteCraftTreeNode node) {
        this.node = node;
        return this;
    }

    public TreeRow getParentRow() {
        return this.parentRow;
    }

    public TreeNode setParentRow(TreeRow parentRow) {
        this.parentRow = parentRow;
        return this;
    }

    public TreeNode getPrev() {
        return this.prev;
    }

    public TreeNode getNext() {
        return this.next;
    }

    public TreeNode setPrev(TreeNode prev) {
        this.prev = prev;
        return this;
    }

    public TreeNode setNext(TreeNode next) {
        this.next = next;
        return this;
    }

    public TreeNode setLinkedSubNodes(int linkedSubNodes) {
        this.linkedSubNodes = linkedSubNodes;
        return this;
    }

    public TreeNode setRoot(boolean root) {
        this.root = root;
        return this;
    }

    public boolean isMouseOver(MousePos mousePos) {
        return this.isMouseOver(0, 2, mousePos.mouseX(), mousePos.mouseY(), 20, 20);
    }

    public boolean isMouseOver(int startX, int startY, int mouseX, int mouseY, int width, int height) {
        if (this.isInvisible()) {
            return false;
        }
        int endX = startX + width;
        int endY = startY + height;
        return mouseX >= startX && mouseX < endX && mouseY >= startY && mouseY < endY;
    }
}

