/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.craftingtree;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderFunction;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.client.gui.widget.container.Column;
import github.kasuminova.mmce.client.gui.widget.container.Row;
import github.kasuminova.mmce.client.gui.widget.event.GuiEvent;
import github.kasuminova.novaeng.client.gui.widget.craftingtree.PlaceHolder;
import github.kasuminova.novaeng.client.gui.widget.craftingtree.TreeNode;
import github.kasuminova.novaeng.client.gui.widget.craftingtree.TreeRow;
import github.kasuminova.novaeng.client.gui.widget.craftingtree.event.CraftingTreeDataUpdateEvent;
import github.kasuminova.novaeng.client.gui.widget.craftingtree.event.TreeNodeSelectEvent;
import github.kasuminova.novaeng.common.integration.ae2.data.LiteCraftTreeNode;
import github.kasuminova.novaeng.common.integration.ae2.data.LiteCraftTreeProc;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Keyboard;

public class CraftingTree
extends Column {
    public static final AtomicInteger DEBUG_RENDERED_NODES = new AtomicInteger(0);
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected boolean mouseDown = false;
    protected int mouseClickX = 0;
    protected int mouseClickY = 0;
    protected int prevMouseX = 0;
    protected int prevMouseY = 0;
    protected float scale = 1.0f;
    protected int nodes = 0;
    protected LiteCraftTreeNode root = null;
    protected LiteCraftTreeNode missingOnlyRoot = null;
    protected TreeNode selected = null;
    protected boolean missingOnly = false;
    protected boolean darkMode = true;

    protected void preRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        int totalWidth = Math.round((float)super.getWidth() * this.scale);
        int totalHeight = Math.round((float)super.getHeight() * this.scale);
        if (this.mouseDown) {
            int mouseX = mousePos.mouseX();
            int mouseY = mousePos.mouseY();
            int offsetX = Math.round((float)(mouseX - this.prevMouseX) / this.scale);
            int offsetY = Math.round((float)(mouseY - this.prevMouseY) / this.scale);
            this.offsetX = Math.min(this.offsetX + offsetX, 0);
            this.offsetY = Math.min(this.offsetY + offsetY, 0);
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
        }
        if (totalWidth > this.width) {
            if ((float)this.width + (float)this.offsetX * this.scale > (float)totalWidth) {
                this.offsetX = totalWidth - this.width;
            } else if ((float)this.width + Math.abs((float)this.offsetX * this.scale) > (float)totalWidth) {
                this.offsetX = Math.round((float)(-(totalWidth - this.width)) / this.scale);
            }
        } else {
            this.offsetX = 0;
        }
        if (totalHeight > this.height) {
            if ((float)this.height + (float)this.offsetY * this.scale > (float)totalHeight) {
                this.offsetY = totalHeight - this.height;
            } else if ((float)this.height + Math.abs((float)this.offsetY * this.scale) > (float)totalHeight) {
                this.offsetY = Math.round((float)(-(totalHeight - this.height)) / this.scale);
            }
        } else {
            this.offsetY = 0;
        }
        super.preRenderInternal(gui, renderSize, renderPos, mousePos);
    }

    protected void postRenderInternal(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        super.postRenderInternal(gui, renderSize, renderPos, mousePos);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (this.selected == null) {
            fr.func_175063_a(String.format("DEBUG: Rendered Nodes: %s / %s", DEBUG_RENDERED_NODES.getAndSet(0), this.nodes), (float)(renderPos.posX() + 2), (float)(renderPos.posY() + renderSize.height() - 18), -2130706433);
            fr.func_175063_a(I18n.func_135052_a((String)"gui.crafting_tree.tip.0", (Object[])new Object[0]), (float)(renderPos.posX() + 2), (float)(renderPos.posY() + renderSize.height() - 9), -2130706433);
        } else {
            fr.func_175063_a(String.format("DEBUG: Rendered Nodes: %s / %s", DEBUG_RENDERED_NODES.getAndSet(0), this.nodes), (float)(renderPos.posX() + 2), (float)(renderPos.posY() + renderSize.height() - 27), -2130706433);
            fr.func_175063_a(I18n.func_135052_a((String)"gui.crafting_tree.tip.1", (Object[])new Object[0]), (float)(renderPos.posX() + 2), (float)(renderPos.posY() + renderSize.height() - 18), -2130706433);
            fr.func_175063_a(I18n.func_135052_a((String)"gui.crafting_tree.tip.2", (Object[])new Object[0]), (float)(renderPos.posX() + 2), (float)(renderPos.posY() + renderSize.height() - 9), -2130706433);
        }
    }

    protected void doRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos, RenderFunction renderFunction) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)renderPos.posX(), (float)renderPos.posY(), (float)0.0f);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        int width = (int)((float)this.width / this.scale);
        RenderPos newRenderPos = new RenderPos(0, 0);
        MousePos newMousePos = new MousePos((int)((float)mousePos.mouseX() / this.scale), (int)((float)mousePos.mouseY() / this.scale));
        RenderSize newRenderSize = new RenderSize((int)((float)renderSize.width() / this.scale) + Math.abs(this.offsetX), (int)((float)renderSize.height() / this.scale));
        int y = this.offsetY;
        for (DynamicWidget widget : this.widgets) {
            int offsetY;
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            if (widget.isVisible() && (offsetY = widgetRenderPos.posY()) + widget.getHeight() >= 0) {
                RenderPos absRenderPos = widgetRenderPos.add(newRenderPos);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)absRenderPos.posX(), (float)absRenderPos.posY(), (float)0.0f);
                renderFunction.doRender(widget, gui, new RenderSize(widget.getWidth(), widget.getHeight()).smaller(newRenderSize), new RenderPos(this.offsetX, 0), newMousePos.relativeTo(widgetRenderPos));
                GlStateManager.func_179121_F();
            }
            if (!newRenderSize.isHeightLimited() || (y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown()) <= newRenderSize.height()) continue;
            break;
        }
        GlStateManager.func_179121_F();
    }

    public boolean onGuiEvent(GuiEvent event) {
        if (event instanceof CraftingTreeDataUpdateEvent) {
            this.root = ((CraftingTreeDataUpdateEvent)event).getRoot();
            this.root.sort();
            this.missingOnlyRoot = null;
            this.rebuildTree();
            return true;
        }
        if (event instanceof TreeNodeSelectEvent) {
            TreeNodeSelectEvent selectEvent = (TreeNodeSelectEvent)event;
            this.selected = selectEvent.getSelectedNode();
        }
        return super.onGuiEvent(event);
    }

    public void rebuildTree() {
        this.selected = null;
        this.nodes = 0;
        this.getWidgets().clear();
        this.recursiveAddNode(this.missingOnly ? this.missingOnlyRoot : this.root, 0);
    }

    protected void recursiveAddNode(LiteCraftTreeNode node, int depth) {
        List<LiteCraftTreeProc> inputs;
        TreeNode nodeWidget = new TreeNode(this).setNode(node);
        if (depth == 0) {
            nodeWidget.setRoot(true).setMarginUp(4).setMarginRight(6);
        }
        nodeWidget.setWidth(20);
        this.addNode(nodeWidget, depth);
        for (LiteCraftTreeProc proc : node.inputs()) {
            for (LiteCraftTreeNode input : proc.inputs()) {
                this.recursiveAddNode(input, depth + 1);
            }
        }
        int extraRenderNodes = node.getRenderExpandNodes();
        this.fillEmpty(depth, extraRenderNodes);
        if (extraRenderNodes == 0 && (inputs = node.inputs()).size() > 1) {
            extraRenderNodes += inputs.size() - 1;
        }
        nodeWidget.setLinkedSubNodes(extraRenderNodes - node.getLastNodeRenderExpandNodes());
    }

    protected void fillEmpty(int depth, int fillNodes) {
        int nodeWidth = 26;
        Row row = (Row)this.widgets.get(depth);
        int totalWidth = row.getWidth() + fillNodes * nodeWidth;
        for (int i = depth; i < this.widgets.size(); ++i) {
            Row nextRow = (Row)this.widgets.get(i);
            int nextRowWidth = nextRow.getWidth();
            if (nextRowWidth >= totalWidth) continue;
            while (nextRowWidth < totalWidth) {
                nextRow.addWidget(new PlaceHolder().setWidth(20).setMarginLeft(6));
                nextRowWidth += nodeWidth;
            }
        }
    }

    protected void addNode(TreeNode node, int depth) {
        while (this.widgets.size() <= depth) {
            this.widgets.add(new TreeRow());
        }
        TreeRow row = (TreeRow)((Object)this.widgets.get(depth));
        row.addWidget(node.setParentRow(row));
        ++this.nodes;
        List rowWidgets = row.getWidgets();
        if (rowWidgets.isEmpty()) {
            return;
        }
        for (int i = rowWidgets.size() - 2; i >= 0; --i) {
            DynamicWidget prev = (DynamicWidget)rowWidgets.get(i);
            if (!(prev instanceof TreeNode)) continue;
            TreeNode prevNode = (TreeNode)prev;
            prevNode.setNext(node);
            node.setPrev(prevNode);
            break;
        }
    }

    public CraftingTree setMissingOnly(boolean missingOnly) {
        if (this.root == null) {
            return this;
        }
        if (!LiteCraftTreeNode.isMissing(this.root)) {
            return this;
        }
        if (missingOnly == this.missingOnly) {
            return this;
        }
        if (this.missingOnlyRoot == null) {
            this.missingOnlyRoot = this.root.withMissingOnly();
            if (this.missingOnlyRoot == null) {
                throw new NullPointerException("Cannot get missing only node because `this.root.withMissingOnly()` returns null (" + this.root.toString() + ").");
            }
            this.missingOnlyRoot.sort();
        }
        this.missingOnly = missingOnly;
        this.rebuildTree();
        return this;
    }

    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        MousePos newMousePos = new MousePos((int)((float)mousePos.mouseX() / this.scale), (int)((float)mousePos.mouseY() / this.scale));
        int y = this.offsetY;
        int width = (int)((float)this.width / this.scale);
        for (DynamicWidget widget : this.widgets) {
            RenderPos absRenderPos;
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            MousePos relativeMousePos = newMousePos.relativeTo(widgetRenderPos).relativeTo(new RenderPos(this.offsetX, 0));
            if (widget.isMouseOver(relativeMousePos) && widget.onMouseClick(relativeMousePos, absRenderPos = widgetRenderPos.add(renderPos).add(new RenderPos(this.offsetX, 0)), mouseButton)) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        this.mouseDown = true;
        this.prevMouseX = mousePos.mouseX();
        this.prevMouseY = mousePos.mouseY();
        this.mouseClickX = mousePos.mouseX();
        this.mouseClickY = mousePos.mouseY();
        return true;
    }

    public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
        MousePos newMousePos = new MousePos((int)((float)mousePos.mouseX() / this.scale), (int)((float)mousePos.mouseY() / this.scale));
        int y = this.offsetY;
        int width = (int)((float)this.width / this.scale);
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseReleased(newMousePos.relativeTo(widgetRenderPos).add(new RenderPos(this.offsetX, 0)), absRenderPos.add(new RenderPos(this.offsetX, 0)))) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        if (this.mouseDown && Math.abs(mousePos.mouseX() - this.mouseClickX) <= 2 && Math.abs(mousePos.mouseY() - this.mouseClickY) <= 2) {
            this.onGuiEvent(new TreeNodeSelectEvent(null));
        }
        this.mouseDown = false;
        return false;
    }

    public boolean onMouseDWheel(MousePos mousePos, RenderPos renderPos, int wheel) {
        MousePos newMousePos = new MousePos((int)((float)mousePos.mouseX() / this.scale), (int)((float)mousePos.mouseY() / this.scale));
        int y = this.offsetY;
        int width = (int)((float)this.width / this.scale);
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseDWheel(newMousePos.relativeTo(widgetRenderPos).add(new RenderPos(this.offsetX, 0)), absRenderPos.add(new RenderPos(this.offsetX, 0)), wheel)) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        if (this.isMouseOver(mousePos)) {
            this.scale = MathHelper.func_76131_a((float)(this.scale + (wheel < 0 ? -0.05f : 0.05f)), (float)0.25f, (float)1.0f);
            return true;
        }
        return false;
    }

    public void onMouseClickGlobal(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        MousePos newMousePos = new MousePos((int)((float)mousePos.mouseX() / this.scale), (int)((float)mousePos.mouseY() / this.scale));
        int y = this.offsetY;
        int width = (int)((float)this.width / this.scale);
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            widget.onMouseClickGlobal(newMousePos.relativeTo(widgetRenderPos).add(new RenderPos(this.offsetX, 0)), absRenderPos.add(new RenderPos(this.offsetX, 0)), mouseButton);
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
    }

    public boolean onMouseClickMove(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        MousePos newMousePos = new MousePos((int)((float)mousePos.mouseX() / this.scale), (int)((float)mousePos.mouseY() / this.scale));
        int y = this.offsetY;
        int width = (int)((float)this.width / this.scale);
        for (DynamicWidget widget : this.widgets) {
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            RenderPos absRenderPos = widgetRenderPos.add(renderPos);
            if (widget.onMouseClickMove(newMousePos.relativeTo(widgetRenderPos).add(new RenderPos(this.offsetX, 0)), absRenderPos.add(new RenderPos(this.offsetX, 0)), mouseButton)) {
                return true;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        return false;
    }

    public boolean onKeyTyped(char typedChar, int keyCode) {
        if (super.onKeyTyped(typedChar, keyCode)) {
            return true;
        }
        if (this.selected == null) {
            return false;
        }
        boolean ctrlPressed = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        boolean selectChanged = false;
        if (keyCode == 203) {
            selectChanged = CraftingTree.findLeftNode(this.selected, ctrlPressed);
        } else if (keyCode == 205) {
            selectChanged = CraftingTree.findRightNode(this.selected, ctrlPressed);
        } else if (keyCode == 200) {
            selectChanged = this.findUpNode();
        } else if (keyCode == 208) {
            selectChanged = this.findDownNode();
        }
        if (!selectChanged) {
            return false;
        }
        TreeRow treeRow = this.selected.getParentRow();
        RenderPos rowRenderPos = this.getRelativeRenderPos((DynamicWidget)treeRow);
        RenderPos renderPos = treeRow.getRelativeRenderPos(this.selected);
        if (rowRenderPos == null || renderPos == null) {
            return false;
        }
        RenderPos absRenderPos = renderPos.add(rowRenderPos);
        int newOffsetX = -absRenderPos.posX() + 6;
        int newOffsetY = -absRenderPos.posY() + 4;
        if (this.offsetX < newOffsetX || Math.abs(this.offsetX) + this.width < Math.abs(newOffsetX) + 20) {
            this.offsetX = newOffsetX;
        }
        if (this.offsetY < newOffsetY || Math.abs(this.offsetY) + this.height < Math.abs(newOffsetY) + 20) {
            this.offsetY = newOffsetY;
        }
        return true;
    }

    protected static boolean findLeftNode(TreeNode node, boolean missingOnly) {
        if (node == null) {
            return false;
        }
        for (TreeNode prev = node.getPrev(); prev != null; prev = prev.getPrev()) {
            if (missingOnly && !LiteCraftTreeNode.isMissing(prev.node)) continue;
            prev.select();
            return true;
        }
        return false;
    }

    protected static boolean findRightNode(TreeNode node, boolean missingOnly) {
        if (node == null) {
            return false;
        }
        for (TreeNode next = node.getNext(); next != null; next = next.getNext()) {
            if (missingOnly && !LiteCraftTreeNode.isMissing(next.node)) continue;
            next.select();
            return true;
        }
        return false;
    }

    protected boolean findUpNode() {
        if (this.selected == null) {
            return false;
        }
        TreeRow treeRow = this.selected.getParentRow();
        int idx = this.widgets.indexOf((Object)treeRow);
        if (idx > 0) {
            TreeRow prevRow = (TreeRow)((Object)this.widgets.get(idx - 1));
            List prevRowWidgets = prevRow.getWidgets();
            for (int rowIdx = treeRow.getWidgets().indexOf((Object)this.selected); rowIdx >= 0 && rowIdx < prevRowWidgets.size(); --rowIdx) {
                DynamicWidget up = (DynamicWidget)prevRowWidgets.get(rowIdx);
                if (!(up instanceof TreeNode)) continue;
                TreeNode upNode = (TreeNode)up;
                upNode.select();
                return true;
            }
        }
        return false;
    }

    protected boolean findDownNode() {
        if (this.selected == null) {
            return false;
        }
        TreeRow treeRow = this.selected.getParentRow();
        int idx = this.widgets.indexOf((Object)treeRow);
        if (idx < this.widgets.size() - 1) {
            TreeRow nextRow = (TreeRow)((Object)this.widgets.get(idx + 1));
            List nextRowWidgets = nextRow.getWidgets();
            for (int rowIdx = treeRow.getWidgets().indexOf((Object)this.selected); rowIdx >= 0 && rowIdx < nextRowWidgets.size(); --rowIdx) {
                DynamicWidget down = (DynamicWidget)nextRowWidgets.get(rowIdx);
                if (!(down instanceof TreeNode)) continue;
                TreeNode downNode = (TreeNode)down;
                downNode.select();
                return true;
            }
        }
        return false;
    }

    public RenderPos getRelativeRenderPos(DynamicWidget target) {
        if (!this.widgets.contains(target)) {
            return null;
        }
        int width = (int)((float)this.width / this.scale);
        int y = this.offsetY;
        for (DynamicWidget widget : this.widgets) {
            int offsetY;
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            if (widget.isVisible() && (offsetY = widgetRenderPos.posY()) + widget.getHeight() >= 0 && widget == target) {
                return widgetRenderPos;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        return null;
    }

    public boolean isDarkMode() {
        return this.darkMode;
    }

    public CraftingTree setDarkMode(boolean darkMode) {
        this.darkMode = darkMode;
        return this;
    }

    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        MousePos newMousePos = new MousePos((int)((float)mousePos.mouseX() / this.scale), (int)((float)mousePos.mouseY() / this.scale));
        int y = this.offsetY;
        int width = (int)((float)this.width / this.scale);
        List tooltips = null;
        for (DynamicWidget widget : this.widgets) {
            List hoverTooltips;
            RenderPos widgetRenderPos;
            if (widget.isDisabled() || (widgetRenderPos = this.getWidgetRenderOffset(widget, width, y)) == null) continue;
            MousePos relativeMousePos = newMousePos.relativeTo(widgetRenderPos.add(new RenderPos(this.offsetX, 0)));
            if (widget.isMouseOver(relativeMousePos) && !(hoverTooltips = widget.getHoverTooltips(widgetGui, relativeMousePos)).isEmpty()) {
                tooltips = hoverTooltips;
                break;
            }
            y += widget.getMarginUp() + widget.getHeight() + widget.getMarginDown();
        }
        return tooltips != null ? tooltips : Collections.emptyList();
    }

    public CraftingTree setWidth(int width) {
        this.width = width;
        return this;
    }

    public CraftingTree setHeight(int height) {
        this.height = height;
        return this;
    }

    public CraftingTree setWidthHeight(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

