/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget.craftingtree;

import github.kasuminova.mmce.client.gui.util.TextureProperties;
import net.minecraft.util.ResourceLocation;

public enum Background {
    BG_256_256_LIGHT(TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_256x256_light.png"), (int)0, (int)0, (int)256, (int)256), false),
    BG_256_256_DARK(TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_256x256_dark.png"), (int)0, (int)0, (int)256, (int)256), true),
    BG_320_256_LIGHT(TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_320x256_light.png"), (int)0, (int)0, (int)320, (int)256), false),
    BG_320_256_DARK(TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_320x256_dark.png"), (int)0, (int)0, (int)320, (int)256), true),
    BG_384_320_LIGHT(TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_384x320_light.png"), (int)0, (int)0, (int)384, (int)320), false),
    BG_384_320_DARK(TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_384x320_dark.png"), (int)0, (int)0, (int)384, (int)320), true),
    BG_512_320_LIGHT(TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_512x320_light.png"), (int)0, (int)0, (int)512, (int)320), false),
    BG_512_320_DARK(TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_512x320_dark.png"), (int)0, (int)0, (int)512, (int)320), true),
    BG_640_384_LIGHT(TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_640x384_light.png"), (int)0, (int)0, (int)640, (int)384), false),
    BG_640_384_DARK(TextureProperties.of((ResourceLocation)new ResourceLocation("novaeng_core", "textures/gui/guicraftingtree_640x384_dark.png"), (int)0, (int)0, (int)640, (int)384), true);

    private final TextureProperties texture;
    private final int internalWidth;
    private final int internalHeight;
    private final int internalXOffset;
    private final int internalYOffset;
    private final boolean dark;

    private Background(TextureProperties texture, boolean dark) {
        this.texture = texture;
        this.dark = dark;
        this.internalWidth = texture.width() - 14;
        this.internalHeight = texture.height() - 34;
        this.internalXOffset = 7;
        this.internalYOffset = 25;
    }

    public TextureProperties getTexture() {
        return this.texture;
    }

    public int getInternalWidth() {
        return this.internalWidth;
    }

    public int getInternalHeight() {
        return this.internalHeight;
    }

    public int getInternalXOffset() {
        return this.internalXOffset;
    }

    public int getInternalYOffset() {
        return this.internalYOffset;
    }

    public static Background getLargest(int screenWidth, int screenHeight, boolean dark) {
        for (int i = Background.values().length - 1; i >= 0; --i) {
            Background bg = Background.values()[i];
            if (bg.dark != dark || !((double)screenWidth >= (double)bg.texture.width() * 1.25) || screenHeight < bg.texture.height()) continue;
            return bg;
        }
        return dark ? BG_256_256_DARK : BG_256_256_LIGHT;
    }
}

