/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget;

import github.kasuminova.mmce.client.gui.util.AnimationValue;
import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.util.TextureProperties;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.GuiScreen;

public class ProgressBar
extends DynamicWidget {
    protected boolean leftToRight = true;
    protected boolean vertical = false;
    protected TextureProperties backgroundTexture = null;
    protected List<TextureProperties> progressTextures = new ArrayList<TextureProperties>();
    protected AnimationValue progress = AnimationValue.ofFinished((double)0.0, (int)500, (double)0.25, (double)0.1, (double)0.25, (double)1.0);
    protected double maxProgress = 1.0;
    protected boolean shouldUseAnimation = true;
    protected Function<ProgressBar, List<String>> tooltipFunction = null;

    public void render(WidgetGui widgetGui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        GuiScreen gui = widgetGui.getGui();
        if (this.backgroundTexture != null) {
            this.backgroundTexture.render(renderPos, gui);
        }
        if (this.progressTextures.isEmpty() || this.maxProgress <= 0.0) {
            return;
        }
        double percent = Math.min(1.0, this.progress.get() / this.maxProgress);
        this.findProgressBackgroundTex(percent).ifPresent(tex -> tex.render(renderPos, gui));
        float renderPercent = (float)percent;
        if (this.isHorizontal()) {
            if (this.leftToRight) {
                this.findProgressForegroundTex(percent).ifPresent(tex -> {
                    tex.bind(gui.field_146297_k.func_110434_K());
                    gui.func_73729_b(renderPos.posX(), renderPos.posY(), tex.texX(), tex.texY(), (int)((float)tex.width() * renderPercent), tex.height());
                });
            } else {
                this.findProgressForegroundTex(percent).ifPresent(tex -> {
                    tex.bind(gui.field_146297_k.func_110434_K());
                    gui.func_73729_b(renderPos.posX() + (int)((float)tex.width() * (1.0f - renderPercent)), renderPos.posY(), tex.texX(), tex.texY(), (int)((float)tex.width() * renderPercent), tex.height());
                });
            }
        } else if (this.leftToRight) {
            this.findProgressForegroundTex(percent).ifPresent(tex -> {
                tex.bind(gui.field_146297_k.func_110434_K());
                gui.func_73729_b(renderPos.posX(), renderPos.posY(), tex.texX(), tex.texY(), tex.width(), (int)((float)tex.height() * renderPercent));
            });
        } else {
            this.findProgressForegroundTex(percent).ifPresent(tex -> {
                tex.bind(gui.field_146297_k.func_110434_K());
                gui.func_73729_b(renderPos.posX(), renderPos.posY() + (int)((float)tex.height() * (1.0f - renderPercent)), tex.texX(), tex.texY() + (int)((float)tex.height() * (1.0f - renderPercent)), tex.width(), (int)((float)tex.height() * renderPercent));
            });
        }
    }

    protected Optional<TextureProperties> findProgressForegroundTex(double percent) {
        if (this.progressTextures.isEmpty()) {
            return Optional.empty();
        }
        int idx = (int)percent;
        if (idx >= this.progressTextures.size()) {
            return Optional.of(this.progressTextures.get(this.progressTextures.size() - 1));
        }
        return Optional.of(this.progressTextures.get(idx));
    }

    protected Optional<TextureProperties> findProgressBackgroundTex(double percent) {
        if (this.progressTextures.isEmpty()) {
            return Optional.empty();
        }
        int idx = (int)percent - 1;
        if (idx <= 0) {
            return Optional.empty();
        }
        if (idx >= this.progressTextures.size()) {
            return Optional.empty();
        }
        return Optional.of(this.progressTextures.get(idx));
    }

    public double getProgressPercent() {
        if (this.maxProgress <= 0.0) {
            return 0.0;
        }
        return this.progress.get() / this.maxProgress;
    }

    public double getProgress() {
        return this.progress.get();
    }

    public ProgressBar setProgress(double progress) {
        if (this.shouldUseAnimation) {
            this.progress.set(progress);
        } else {
            this.progress.setImmediate(progress);
        }
        return this;
    }

    public double getMaxProgress() {
        return this.maxProgress;
    }

    public ProgressBar setMaxProgress(float maxProgress) {
        this.maxProgress = maxProgress;
        if (this.progress.getTargetValue() > (double)maxProgress) {
            if (this.shouldUseAnimation) {
                this.progress.set((double)maxProgress);
            } else {
                this.progress.setImmediate((double)maxProgress);
            }
        }
        return this;
    }

    public boolean isShouldUseAnimation() {
        return this.shouldUseAnimation;
    }

    public ProgressBar setShouldUseAnimation(boolean shouldUseAnimation) {
        this.shouldUseAnimation = shouldUseAnimation;
        if (!shouldUseAnimation && !this.progress.isAnimFinished()) {
            this.progress.setImmediate(this.progress.getTargetValue());
        }
        return this;
    }

    public ProgressBar setVertical(boolean vertical) {
        this.vertical = vertical;
        return this;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public ProgressBar setHorizontal(boolean horizontal) {
        this.vertical = !horizontal;
        return this;
    }

    public boolean isHorizontal() {
        return !this.vertical;
    }

    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    public ProgressBar setLeftToRight(boolean leftToRight) {
        this.leftToRight = leftToRight;
        return this.setHorizontal(true);
    }

    public ProgressBar setRightToLeft() {
        return this.setLeftToRight(!this.leftToRight);
    }

    public boolean isRightToLeft() {
        return !this.leftToRight;
    }

    public boolean isUpToDown() {
        return !this.leftToRight;
    }

    public boolean isDownToUp() {
        return this.leftToRight;
    }

    public ProgressBar setUpToDown(boolean upToDown) {
        this.leftToRight = upToDown;
        return this.setVertical(true);
    }

    public ProgressBar setDownToUp(boolean downToUp) {
        return this.setUpToDown(!downToUp);
    }

    public TextureProperties getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public ProgressBar setBackgroundTexture(TextureProperties backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public List<TextureProperties> getProgressTextures() {
        return this.progressTextures;
    }

    public ProgressBar addForegroundTexture(TextureProperties foregroundTex) {
        this.progressTextures.add(foregroundTex);
        return this;
    }

    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        return this.tooltipFunction != null ? this.tooltipFunction.apply(this) : Collections.emptyList();
    }

    public ProgressBar setTooltipFunction(Function<ProgressBar, List<String>> tooltipFunction) {
        this.tooltipFunction = tooltipFunction;
        return this;
    }
}

