/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.widget;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.novaeng.common.util.BiFunction2Bool;
import github.kasuminova.novaeng.common.util.NumberUtils;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;

public class InputBox
extends DynamicWidget {
    protected final GuiTextField field;
    protected InputType inputType;
    protected BiFunction2Bool<InputBox, Character> onUserKeyTyped;
    protected BiFunction2Bool<InputBox, String> onUserConfirm;
    protected BiFunction2Bool<InputBox, Integer> onUserConfirmInt;
    protected BiFunction2Bool<InputBox, Long> onUserConfirmLong;
    protected BiFunction2Bool<InputBox, Double> onUserConfirmDouble;
    protected Function<InputBox, List<String>> tooltipFunction;

    public InputBox() {
        this.field = new GuiTextField(-1, Minecraft.func_71410_x().field_71466_p, 0, 0, 100, 14);
        this.inputType = InputType.STRING;
        this.onUserKeyTyped = null;
        this.onUserConfirm = null;
        this.onUserConfirmInt = null;
        this.onUserConfirmLong = null;
        this.onUserConfirmDouble = null;
        this.tooltipFunction = null;
    }

    public void render(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        int height = renderSize.height();
        int heightOffset = height > 10 ? (height - 10) / 2 : 0;
        this.field.field_146218_h = renderSize.width();
        this.field.field_146219_i = Math.min(height, 10);
        this.field.field_146209_f = renderPos.posX();
        this.field.field_146210_g = renderPos.posY() + heightOffset;
        this.field.func_146194_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean onKeyTyped(char typedChar, int keyCode) {
        boolean bl;
        if (!this.field.func_146206_l()) {
            return false;
        }
        String text = this.field.func_146179_b();
        if (!text.isEmpty() && keyCode == 28) {
            return this.processUserConfirm(text);
        }
        if (GuiScreen.func_175280_f((int)keyCode) || GuiScreen.func_175279_e((int)keyCode) || GuiScreen.func_175277_d((int)keyCode) || GuiScreen.func_175278_g((int)keyCode) || keyCode == 14 || keyCode == 211 || keyCode == 203 || keyCode == 205 || keyCode == 199 || keyCode == 207) {
            return this.field.func_146201_a(typedChar, keyCode);
        }
        if (this.onUserKeyTyped != null && this.onUserKeyTyped.apply(this, Character.valueOf(typedChar))) {
            return true;
        }
        switch (this.inputType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case STRING: {
                bl = this.field.func_146201_a(typedChar, keyCode);
                break;
            }
            case NUMBER: {
                boolean result = this.processNumberTypeInput(typedChar, keyCode);
                String newText = this.field.func_146179_b();
                if (newText.isEmpty() || NumberUtils.canParse(newText)) {
                    this.field.func_146193_g(0xFFFFFF);
                } else {
                    this.field.func_146193_g(0xFF0000);
                }
                bl = result;
                break;
            }
        }
        return bl;
    }

    protected boolean processNumberTypeInput(char typedChar, int keyCode) {
        boolean isValid;
        String text = this.field.func_146179_b();
        if (typedChar == '-' && text.isEmpty()) {
            this.field.func_146180_a("-");
            return true;
        }
        String newInput = text.startsWith("-") ? text.substring(1) : text;
        switch (InputBox.getActiveBase(newInput)) {
            case 2: {
                boolean bl;
                if (typedChar == '0' || typedChar == '1') {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 8: {
                boolean bl = Character.toString(typedChar).matches("[0-7]");
                break;
            }
            case 10: {
                boolean bl;
                if (Character.isDigit(typedChar) || typedChar == '.') {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 16: {
                boolean bl = Character.toString(typedChar).matches("[0-9a-fA-F]");
                break;
            }
            default: {
                boolean bl = isValid = false;
            }
        }
        if (isValid) {
            return this.field.func_146201_a(typedChar, keyCode);
        }
        return false;
    }

    protected boolean processUserConfirm(String text) {
        Object parsed;
        if (this.inputType == InputType.STRING && this.onUserConfirm != null && this.onUserConfirm.apply(this, text)) {
            this.field.func_146180_a("");
            return true;
        }
        if (this.onUserConfirmInt != null && ((OptionalInt)(parsed = NumberUtils.tryParseInt(text))).isPresent() && this.onUserConfirmInt.apply(this, ((OptionalInt)parsed).getAsInt())) {
            this.field.func_146180_a("");
            return true;
        }
        if (this.onUserConfirmLong != null && ((OptionalLong)(parsed = NumberUtils.tryParseLong(text))).isPresent() && this.onUserConfirmLong.apply(this, ((OptionalLong)parsed).getAsLong())) {
            this.field.func_146180_a("");
            return true;
        }
        if (this.onUserConfirmDouble != null && ((OptionalDouble)(parsed = NumberUtils.tryParseDouble(text))).isPresent() && this.onUserConfirmDouble.apply(this, ((OptionalDouble)parsed).getAsDouble())) {
            this.field.func_146180_a("");
            return true;
        }
        return false;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public InputBox setInputType(InputType inputType) {
        this.inputType = inputType;
        return this;
    }

    public InputBox setWidth(int width) {
        super.setWidth(width);
        this.field.field_146218_h = width;
        return this;
    }

    public InputBox setHeight(int height) {
        super.setHeight(height);
        this.field.field_146219_i = height;
        return this;
    }

    public InputBox setMaxStringLength(int length) {
        this.field.func_146203_f(length);
        return this;
    }

    public InputBox setEnableBackground(boolean enableBackground) {
        this.field.func_146185_a(enableBackground);
        return this;
    }

    public InputBox setOnUserKeyTyped(BiFunction2Bool<InputBox, Character> onUserKeyTyped) {
        this.onUserKeyTyped = onUserKeyTyped;
        return this;
    }

    public InputBox setOnUserConfirm(BiFunction2Bool<InputBox, String> onUserConfirm) {
        this.onUserConfirm = onUserConfirm;
        return this;
    }

    public InputBox setOnUserConfirmInt(BiFunction2Bool<InputBox, Integer> onUserConfirmInt) {
        this.onUserConfirmInt = onUserConfirmInt;
        return this;
    }

    public InputBox setOnUserConfirmLong(BiFunction2Bool<InputBox, Long> onUserConfirmLong) {
        this.onUserConfirmLong = onUserConfirmLong;
        return this;
    }

    public InputBox setOnUserConfirmDouble(BiFunction2Bool<InputBox, Double> onUserConfirmDouble) {
        this.onUserConfirmDouble = onUserConfirmDouble;
        return this;
    }

    public InputBox setTooltipFunction(Function<InputBox, List<String>> tooltipFunction) {
        this.tooltipFunction = tooltipFunction;
        return this;
    }

    public List<String> getHoverTooltips(WidgetGui widgetGui, MousePos mousePos) {
        if (this.tooltipFunction != null) {
            return this.tooltipFunction.apply(this);
        }
        return super.getHoverTooltips(widgetGui, mousePos);
    }

    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        if (!this.field.func_146206_l() && mouseButton == 0) {
            this.field.func_146195_b(true);
            return true;
        }
        if (this.field.func_146206_l() && mouseButton == 1) {
            this.field.func_146180_a("");
            return true;
        }
        return super.onMouseClick(mousePos, renderPos, mouseButton);
    }

    public void onMouseClickGlobal(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        if (this.field.func_146206_l() && !this.isMouseOver(mousePos)) {
            this.field.func_146195_b(false);
        }
        super.onMouseClickGlobal(mousePos, renderPos, mouseButton);
    }

    protected static int getActiveBase(String input) {
        if (input.startsWith("0x") || input.startsWith("0X")) {
            return 16;
        }
        if (input.startsWith("0b") || input.startsWith("0B")) {
            return 2;
        }
        if (input.startsWith("0o") || input.startsWith("0O")) {
            return 8;
        }
        return 10;
    }

    public static enum InputType {
        NUMBER,
        STRING;

    }
}

