/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui.misc;

import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TechLevelText {
    private final String levelText;
    private final String subLevelText;

    public TechLevelText(float level) {
        String[] strings = TechLevelText.splitSubLevel(level);
        this.levelText = strings[0];
        this.subLevelText = strings[1];
    }

    public static String getLevelText(float level) {
        int intLevel = (int)level;
        return I18n.func_135052_a((String)("novaeng.hypernet.tech_level." + intLevel), (Object[])new Object[0]);
    }

    public static String getSubLevelText(float level) {
        float subLevel = level - (float)((int)level);
        return String.valueOf(Math.round(subLevel * 10.0f));
    }

    public static String[] splitSubLevel(float level) {
        String levelText = TechLevelText.getLevelText(level);
        String subLevelText = levelText.substring(levelText.length() - 3) + TechLevelText.getSubLevelText(level);
        return new String[]{levelText, subLevelText.replace(".", "")};
    }

    public String getLevelText() {
        return this.levelText;
    }

    public String getSubLevelText() {
        return this.subLevelText;
    }
}

