/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client.gui;

import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.client.gui.misc.TechLevelText;
import github.kasuminova.novaeng.client.gui.widget.GuiScrollbarThin;
import github.kasuminova.novaeng.common.container.ContainerHyperNetTerminal;
import github.kasuminova.novaeng.common.crafttweaker.hypernet.HyperNetHelper;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.old.ComputationCenterCache;
import github.kasuminova.novaeng.common.hypernet.old.Database;
import github.kasuminova.novaeng.common.hypernet.old.HyperNetTerminal;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchCognitionData;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchStationType;
import github.kasuminova.novaeng.common.network.PktResearchTaskProvide;
import github.kasuminova.novaeng.common.network.PktResearchTaskProvideCreative;
import github.kasuminova.novaeng.common.network.PktResearchTaskReset;
import github.kasuminova.novaeng.common.network.PktTerminalGuiData;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import github.kasuminova.novaeng.common.tile.TileHyperNetTerminal;
import github.kasuminova.novaeng.common.util.StringUtils;
import github.kasuminova.novaeng.common.util.TimeUtils;
import hellfirepvp.modularmachinery.client.ClientScheduler;
import hellfirepvp.modularmachinery.client.gui.GuiContainerBase;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import io.netty.util.internal.ThrowableUtil;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiHyperNetTerminal
extends GuiContainerBase<ContainerHyperNetTerminal> {
    private static final ResourceLocation TEXTURES_TERMINAL = new ResourceLocation("novaeng_core", "textures/gui/guiterminal.png");
    private static final ResourceLocation TEXTURES_TERMINAL_ELEMENTS = new ResourceLocation("novaeng_core", "textures/gui/guiterminalelement.png");
    private static final int TERMINAL_ELEMENT_WIDTH = 92;
    private static final int TERMINAL_ELEMENT_HEIGHT = 22;
    private static final float FONT_SCALE = 0.72f;
    private static final int DATA_SCROLL_BAR_LEFT = 100;
    private static final int DATA_SCROLL_BAR_TOP = 44;
    private static final int DATA_SCROLL_BAR_HEIGHT = 198;
    private static final int MAX_PAGE_ELEMENTS = 9;
    private static final int SCREEN_SCROLL_BAR_LEFT = 336;
    private static final int SCREEN_SCROLL_BAR_TOP = 44;
    private static final int SCREEN_SCROLL_BAR_HEIGHT = 118;
    private static final int SCREEN_TEXT_MAX_LINES = 11;
    private static final int SCREEN_TEXT_MAX_WIDTH = 217;
    private static String searchTextCache = "";
    private static ResearchDataContext currentCache = null;
    protected final TileHyperNetTerminal terminal;
    protected final Set<ResearchCognitionData> unlockedData = new HashSet<ResearchCognitionData>();
    protected final List<ResearchCognitionData> lockedData = new ArrayList<ResearchCognitionData>();
    protected final List<ResearchCognitionData> unavailableData = new ArrayList<ResearchCognitionData>();
    protected final Object2DoubleOpenHashMap<ResearchCognitionData> researchingData = new Object2DoubleOpenHashMap();
    protected final List<ResearchDataContext> renderingData = new ArrayList<ResearchDataContext>();
    protected boolean darkMode = true;
    protected boolean showLockedResearchDesc = false;
    protected GuiTextField searchTextField = null;
    protected GuiScrollbarThin dataScrollbar = null;
    protected GuiScrollbarThin screenScrollbar = null;
    protected GuiButtonImage startResearch = null;
    protected GuiButtonImage toggleResearchDesc = null;
    protected ResearchDataContext current = null;

    public GuiHyperNetTerminal(TileHyperNetTerminal terminal, EntityPlayer opening) {
        super((Container)new ContainerHyperNetTerminal(terminal, opening));
        this.terminal = terminal;
        this.field_146999_f = 350;
        this.field_147000_g = 250;
    }

    private static void updateUnlockedData(Set<ResearchCognitionData> unlockedData) {
        unlockedData.clear();
        unlockedData.addAll(PktTerminalGuiData.getUnlockedData());
    }

    private static void updateResearchingData(Object2DoubleOpenHashMap<ResearchCognitionData> researchingData) {
        researchingData.clear();
        researchingData.putAll(PktTerminalGuiData.getResearchingData());
    }

    public static boolean isMouseOver(int startX, int startY, int endX, int endY, int mouseX, int mouseY) {
        return mouseX >= startX && mouseX <= endX && mouseY >= startY && mouseY <= endY;
    }

    public static boolean hasDatabaseSpace(List<Database.Status> databases) {
        return databases.stream().anyMatch(Database.Status::hasDatabaseSpace);
    }

    public static void renderItemStackToGUI(Minecraft mc, RenderItem ri, int x, int y, ItemStack stack) {
        RenderHelper.func_74520_c();
        ri.func_180450_b(stack, x, y);
        ri.func_175030_a(mc.field_71466_p, stack, x, y);
        RenderHelper.func_74518_a();
    }

    protected static void drawTechLevelTitleText(ResearchCognitionData data, FontRenderer fr) {
        TechLevelText techLevelText = new TechLevelText(data.getTechLevel());
        String levelText = I18n.func_135052_a((String)"gui.terminal_controller.screen.info.tech_level", (Object[])new Object[0]) + techLevelText.getLevelText();
        String subLevelText = techLevelText.getSubLevelText();
        float levelTextWidth = fr.func_78256_a(levelText);
        float subLevelTextWidth = fr.func_78256_a(subLevelText);
        fr.func_175063_a(levelText, 330.0f - (levelTextWidth + subLevelTextWidth * 0.72f), 46.0f, 0xFFFFFF);
        GlStateManager.func_179152_a((float)0.72f, (float)0.72f, (float)0.72f);
        fr.func_175063_a(subLevelText, (332.0f - subLevelTextWidth) / 0.72f, 66.52778f, 0xFFFFFF);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchTextField = new GuiTextField(0, this.field_146289_q, 25, 32, 78, 11);
        this.searchTextField.func_146203_f(18);
        this.searchTextField.func_146185_a(false);
        this.searchTextField.func_146180_a(searchTextCache);
        this.startResearch = new GuiButtonImage(0, 316, 143, 16, 16, 60, 22, 0, TEXTURES_TERMINAL_ELEMENTS);
        this.toggleResearchDesc = new GuiButtonImage(0, 296, 143, 16, 16, 76, 22, 0, TEXTURES_TERMINAL_ELEMENTS);
        this.dataScrollbar = new GuiScrollbarThin();
        this.screenScrollbar = new GuiScrollbarThin();
        this.current = currentCache;
        GuiHyperNetTerminal.updateUnlockedData(this.unlockedData);
        GuiHyperNetTerminal.updateResearchingData(this.researchingData);
        this.updateFilteredData();
        this.updateRenderingData();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        try {
            this.drawTitle();
            this.updateSearchTextField();
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)0.72f, (float)0.72f, (float)0.72f);
            this.drawNetworkAndControllerStatus();
            this.drawCardStatus();
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            this.updateAndDrawScrollbar();
            this.renderDataList(x, y);
            this.drawScreen(mouseX, mouseY);
        }
        catch (Exception e) {
            NovaEngineeringCore.log.warn(ThrowableUtil.stackTraceToString((Throwable)e));
        }
    }

    protected void drawScreen(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.current == null) {
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.screen.none", (Object[])new Object[0]), 115.0f, 46.0f, 0xFFFFFF);
            this.screenScrollbar.setRange(0, 0, 1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        } else {
            this.drawDataInfo();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            this.startResearch.func_191745_a(this.field_146297_k, mouseX, mouseY, Animation.getPartialTickTime());
            if (!this.current.isLocked()) {
                this.toggleResearchDesc.func_191745_a(this.field_146297_k, mouseX, mouseY, Animation.getPartialTickTime());
                this.drawToggleResearchDescBtnHoverText(mouseX, mouseY);
            }
            this.drawStartBtnOverlayAndHoveringText(mouseX, mouseY);
        }
    }

    protected void drawToggleResearchDescBtnHoverText(int mouseX, int mouseY) {
        if (GuiHyperNetTerminal.isMouseOver(296, 143, 312, 159, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            String formatted = I18n.func_135052_a((String)"gui.terminal_controller.screen.info.toggle", (Object[])new Object[0]);
            this.func_146283_a(Collections.singletonList(formatted), 276 - this.field_146289_q.func_78256_a(formatted), 159);
        }
    }

    protected void drawStartBtnOverlayAndHoveringText(int mouseX, int mouseY) {
        List<Database.Status> databases;
        ArrayList<String> hoveredTip = new ArrayList<String>();
        ArrayList<String> warnTip = new ArrayList<String>();
        ArrayList<String> errorTip = new ArrayList<String>();
        ResearchCognitionData data = this.current.getData();
        ResearchStationType stationType = PktTerminalGuiData.getResearchStationType();
        double consumption = ComputationCenterCache.getComputationPointConsumption();
        double generation = ComputationCenterCache.getComputationPointGeneration();
        if (stationType == null || stationType.getMaxTechLevel() < data.getTechLevel()) {
            errorTip.add(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.start.error.tech_level", (Object[])new Object[0]));
        }
        if (generation < data.getMinComputationPointPerTick()) {
            errorTip.add(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.start.error.computation", (Object[])new Object[0]));
        } else if (generation - consumption < data.getMinComputationPointPerTick()) {
            warnTip.add(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.start.warn.computation", (Object[])new Object[0]));
        }
        List<ResearchCognitionData> missingDependencies = this.getMissingResearches(data);
        if (!missingDependencies.isEmpty()) {
            errorTip.add(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.start.error.dependencies", (Object[])new Object[]{missingDependencies.stream().map(ResearchCognitionData::getTranslatedName).collect(Collectors.joining(TextFormatting.RESET + ", "))}));
        }
        if (!GuiHyperNetTerminal.hasDatabaseSpace(databases = PktTerminalGuiData.getDatabases())) {
            errorTip.add(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.start.error.database_space", (Object[])new Object[0]));
        }
        if (!this.current.isLocked()) {
            this.drawButtonOverlay(44, 22);
            hoveredTip.add(I18n.func_135052_a((String)"gui.terminal_controller.data.unlocked", (Object[])new Object[0]));
        } else if (errorTip.isEmpty()) {
            hoveredTip.add(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.start", (Object[])new Object[0]));
            long tickRequired = (long)((data.getRequiredPoints() - this.current.getProgress()) / data.getMinComputationPointPerTick());
            hoveredTip.add(TimeUtils.formatResearchRequiredTime(tickRequired * 50L));
            hoveredTip.addAll(warnTip);
            hoveredTip.add(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.reset", (Object[])new Object[0]));
        } else {
            this.drawButtonOverlay(28, 22);
            hoveredTip.add(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.start.error", (Object[])new Object[0]));
            hoveredTip.addAll(errorTip);
            hoveredTip.add(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.reset", (Object[])new Object[0]));
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.current.isLocked() && player != null && player.func_184812_l_()) {
            hoveredTip.add(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.start.instant", (Object[])new Object[0]));
        }
        if (GuiHyperNetTerminal.isMouseOver(316, 143, 332, 159, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            this.func_146283_a(hoveredTip.stream().flatMap(s -> this.field_146289_q.func_78271_c(s, this.field_146294_l / 3).stream()).collect(Collectors.toList()), this.field_147003_i + 316 - this.field_146294_l / 3, 179);
        }
    }

    protected List<ResearchCognitionData> getMissingResearches(ResearchCognitionData data) {
        return data.getDependencies().stream().filter(dependency -> !this.unlockedData.contains(dependency)).collect(Collectors.toList());
    }

    protected void drawButtonOverlay(int textureX, int textureY) {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES_TERMINAL_ELEMENTS);
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(316, 143, textureX, textureY, 16, 16);
        GlStateManager.func_179126_j();
    }

    protected void drawDataInfo() {
        ResearchCognitionData data = this.current.getData();
        this.field_146289_q.func_175063_a(data.getTranslatedName(), 115.0f, 46.0f, 0xFFFFFF);
        GuiHyperNetTerminal.drawTechLevelTitleText(data, this.field_146289_q);
        float descDrawOffsetX = 159.72221f;
        float descDrawOffsetY = 83.33333f;
        List<Object> lines = this.current.isAvailable() && (this.current.isLocked() || this.showLockedResearchDesc) ? data.getDescriptions().stream().flatMap(desc -> this.field_146289_q.func_78271_c(desc, 301).stream()).collect(Collectors.toList()) : (!this.current.isLocked() ? data.getUnlockedDescriptions().stream().flatMap(desc -> this.field_146289_q.func_78271_c(desc, 301).stream()).collect(Collectors.toList()) : Arrays.asList(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.unavailable.0", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.terminal_controller.screen.info.unavailable.1", (Object[])new Object[0])));
        int currentIndex = 0;
        for (int i = this.screenScrollbar.getCurrentScroll(); i < lines.size(); ++i) {
            String str = (String)lines.get(i);
            this.field_146289_q.func_175063_a(str, descDrawOffsetX, descDrawOffsetY, 0xFFFFFF);
            descDrawOffsetY += 10.0f;
            if (++currentIndex >= 11) break;
        }
        float infoDrawOffsetY = 199.99998f;
        String dependencies = data.getDependencies().isEmpty() ? I18n.func_135052_a((String)"gui.terminal_controller.screen.info.dependencies.none", (Object[])new Object[0]) : data.getDependencies().stream().map(ResearchCognitionData::getTranslatedName).collect(Collectors.joining(TextFormatting.RESET + ", "));
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.dependencies", (Object[])new Object[0]) + dependencies, descDrawOffsetX, infoDrawOffsetY, 0xFFFFFF);
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.required_points", (Object[])new Object[0]) + MiscUtils.formatDecimal((double)((long)data.getRequiredPoints())), descDrawOffsetX, infoDrawOffsetY + 12.0f, 0xFFFFFF);
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.screen.info.min_computation_point_per_tick", (Object[])new Object[0]) + NovaEngUtils.formatFLOPS(data.getMinComputationPointPerTick()), descDrawOffsetX + 125.0f, infoDrawOffsetY + 12.0f, 0xFFFFFF);
        this.screenScrollbar.setRange(0, Math.max(0, lines.size() - 11), 1);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawTitle() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        FontRenderer fr = this.field_146289_q;
        if (player != null && player.func_70005_c_().equals("nxc_in_china")) {
            fr.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.title.nxc", (Object[])new Object[0]), 8.0f, 9.0f, 0xFFFFFF);
        } else {
            fr.func_175063_a(I18n.func_135052_a((String)"tile.novaeng_core.hypernet_terminal_controller.name", (Object[])new Object[0]), 8.0f, 9.0f, 0xFFFFFF);
        }
        GlStateManager.func_179121_F();
    }

    protected void drawNetworkAndControllerStatus() {
        float statusRenderX = 156.94444f;
        float statusRenderY = 236.1111f;
        if (!this.terminal.isStructureFormed()) {
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.status", (Object[])new Object[0]) + I18n.func_135052_a((String)"gui.terminal_controller.status.missing_structure", (Object[])new Object[0]), 156.94444f, statusRenderY, 0xFFFFFF);
            return;
        }
        CraftingStatus status = this.terminal.getControllerStatus();
        if (!status.isCrafting()) {
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.status", (Object[])new Object[0]) + I18n.func_135052_a((String)status.getUnlocMessage(), (Object[])new Object[0]), 156.94444f, statusRenderY, 0xFFFFFF);
            return;
        }
        HyperNetTerminal nodeProxy = this.terminal.getNodeProxy();
        if (!nodeProxy.isConnected()) {
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.status", (Object[])new Object[0]) + I18n.func_135052_a((String)"gui.terminal_controller.status.offline", (Object[])new Object[0]), 156.94444f, statusRenderY, 0xFFFFFF);
            return;
        }
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.status", (Object[])new Object[0]) + I18n.func_135052_a((String)"gui.terminal_controller.status.online", (Object[])new Object[0]), 156.94444f, statusRenderY, 0xFFFFFF);
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.status.network.computation_point_consumption", (Object[])new Object[0]), 156.94444f, statusRenderY += 15.0f, 0xFFFFFF);
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.status.network.computation_point.info", (Object[])new Object[]{NovaEngUtils.formatFLOPS(ComputationCenterCache.getComputationPointConsumption())}), 156.94444f, statusRenderY += 10.0f, 0xFFFFFF);
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.status.network.computation_point_generation", (Object[])new Object[0]), 156.94444f, statusRenderY += 10.0f, 0xFFFFFF);
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.status.network.computation_point.info", (Object[])new Object[]{NovaEngUtils.formatFLOPS(ComputationCenterCache.getComputationPointGeneration())}), 156.94444f, statusRenderY += 10.0f, 0xFFFFFF);
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.status.network.total_connected", (Object[])new Object[0]) + ComputationCenterCache.getTotalConnected(), 156.94444f, statusRenderY += 15.0f, 0xFFFFFF);
    }

    protected void drawCardStatus() {
        float statusRenderX = 156.94444f;
        float statusRenderY = 320.8333f;
        IOInventory cardInventory = this.terminal.getCardInventory();
        ItemStack stack = cardInventory.getStackInSlot(0);
        if (stack == ItemStack.field_190927_a) {
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.connect_card.empty", (Object[])new Object[0]), 156.94444f, statusRenderY, 0xFFFFFF);
        } else if (RegistryHyperNet.getHyperNetConnectCard() == stack.func_77973_b() && HyperNetHelper.isValidConnectCard(stack)) {
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.connect_card.validate", (Object[])new Object[0]), 156.94444f, statusRenderY, 0xFFFFFF);
        } else {
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.connect_card.invalidate", (Object[])new Object[0]), 156.94444f, statusRenderY, 0xFFFFFF);
        }
    }

    protected void updateSearchTextField() {
        this.searchTextField.func_146194_f();
        if (this.searchTextField.func_146206_l() || !this.searchTextField.func_146179_b().isEmpty()) {
            return;
        }
        int textRenderX = this.searchTextField.field_146209_f;
        int textRenderY = this.searchTextField.field_146210_g;
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.terminal_controller.search", (Object[])new Object[0]), (float)textRenderX, (float)textRenderY, 0xFFFFFF);
    }

    protected void updateRenderingData() {
        this.renderingData.clear();
        LinkedHashMap tmp = new LinkedHashMap();
        this.researchingData.forEach((data, progress) -> {
            ResearchDataContext context = new ResearchDataContext((ResearchCognitionData)data, true, true, (Double)progress);
            tmp.put(data.getTranslatedName(), context);
            if (context.equals(this.current)) {
                this.setCurrent(context);
            }
        });
        this.unlockedData.forEach(data -> {
            ResearchDataContext context = new ResearchDataContext((ResearchCognitionData)data, false, true, -1.0);
            tmp.put(data.getTranslatedName(), context);
            if (context.equals(this.current)) {
                this.setCurrent(context);
            }
        });
        this.lockedData.forEach(data -> {
            ResearchDataContext context = new ResearchDataContext((ResearchCognitionData)data, true, true, -1.0);
            tmp.put(data.getTranslatedName(), context);
            if (context.equals(this.current)) {
                this.setCurrent(context);
            }
        });
        this.unavailableData.forEach(data -> {
            ResearchDataContext context = new ResearchDataContext((ResearchCognitionData)data, true, false, -1.0);
            tmp.put(data.getTranslatedName(), context);
            if (context.equals(this.current)) {
                this.setCurrent(context);
            }
        });
        String searchFilter = this.searchTextField.func_146179_b();
        if (!searchFilter.isEmpty()) {
            List<String> filtered = StringUtils.sortWithMatchRate(tmp.keySet(), searchFilter);
            if (filtered.isEmpty()) {
                this.searchTextField.func_146193_g(0xFF0000);
            } else {
                this.searchTextField.func_146193_g(0xFFFFFF);
                for (String s : filtered) {
                    this.renderingData.add((ResearchDataContext)tmp.get(s));
                }
            }
        } else {
            this.searchTextField.func_146193_g(0xFFFFFF);
            this.renderingData.addAll(tmp.values());
        }
    }

    protected void setCurrent(ResearchDataContext context) {
        this.current = context;
        currentCache = context;
    }

    protected void renderDataList(int mouseX, int mouseY) {
        int offsetY = 44;
        int currentScroll = this.dataScrollbar.getCurrentScroll();
        for (int currentIndex = 0; currentIndex + currentScroll < this.renderingData.size() && currentIndex < 9; ++currentIndex) {
            ResearchDataContext dataContext = this.renderingData.get(currentIndex + currentScroll);
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawResearchData(dataContext, offsetY, mouseX, mouseY);
            offsetY += 22;
            GlStateManager.func_179121_F();
        }
    }

    protected void drawResearchData(ResearchDataContext dataContext, int offsetY, int mouseX, int mouseY) {
        if (this.darkMode) {
            GlStateManager.func_179131_c((float)0.7f, (float)0.7f, (float)0.7f, (float)1.0f);
        }
        if (dataContext.isLocked()) {
            if (this.darkMode) {
                GlStateManager.func_179131_c((float)1.0f, (float)0.85f, (float)0.45f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)0.9f, (float)0.6f, (float)1.0f);
            }
        }
        if (!dataContext.isAvailable()) {
            GlStateManager.func_179131_c((float)1.0f, (float)0.6f, (float)0.6f, (float)1.0f);
        }
        if (GuiHyperNetTerminal.isMouseOver(8, offsetY, 99, offsetY + 22 - 1, mouseX, mouseY)) {
            GlStateManager.func_179131_c((float)0.7f, (float)0.9f, (float)1.0f, (float)1.0f);
        }
        if (dataContext.equals(this.current)) {
            GlStateManager.func_179131_c((float)0.4f, (float)0.6f, (float)1.0f, (float)1.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES_TERMINAL_ELEMENTS);
        this.func_73729_b(8, offsetY, 0, 0, 92, 22);
        ResearchCognitionData data = dataContext.getData();
        double researchProgress = dataContext.getProgress();
        if (researchProgress > 0.0) {
            GlStateManager.func_179131_c((float)0.6f, (float)1.0f, (float)0.6f, (float)1.0f);
            double progress = researchProgress / data.getRequiredPoints();
            this.func_73729_b(8, offsetY, 0, 0, (int)(92.0 * progress), 22);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack previewStack = data.getPreviewStack();
        GuiHyperNetTerminal.renderItemStackToGUI(this.field_146297_k, this.field_146297_k.func_175599_af(), 11, offsetY + 3, previewStack);
        GlStateManager.func_179152_a((float)0.72f, (float)0.72f, (float)0.72f);
        float textRenderOffsetX = 40.277775f;
        float textRenderOffsetY = (float)(48 + (offsetY - 44)) / 0.72f;
        this.field_146289_q.func_78276_b(data.getTranslatedName(), (int)textRenderOffsetX, (int)textRenderOffsetY, 0x404040);
        if (dataContext.isLocked()) {
            if (researchProgress >= 0.0) {
                if (researchProgress == 0.0) {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.terminal_controller.data.progress", (Object[])new Object[]{"0.00%"}), (int)textRenderOffsetX, (int)textRenderOffsetY + 12, 0x404040);
                } else {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.terminal_controller.data.progress", (Object[])new Object[]{NovaEngUtils.formatPercent(researchProgress, data.getRequiredPoints())}), (int)textRenderOffsetX, (int)textRenderOffsetY + 12, 0x404040);
                }
            } else if (dataContext.isAvailable()) {
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.terminal_controller.data.locked", (Object[])new Object[0]), (int)textRenderOffsetX, (int)textRenderOffsetY + 12, 0x404040);
            } else {
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.terminal_controller.data.unavailable", (Object[])new Object[0]), (int)textRenderOffsetX, (int)textRenderOffsetY + 12, 0x404040);
            }
        } else {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.terminal_controller.data.unlocked", (Object[])new Object[0]), (int)textRenderOffsetX, (int)textRenderOffsetY + 12, 0x404040);
        }
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.searchTextField.func_146178_a();
        if (ClientScheduler.getClientTick() % 20L == 0L) {
            GuiHyperNetTerminal.updateResearchingData(this.researchingData);
            GuiHyperNetTerminal.updateUnlockedData(this.unlockedData);
            this.updateFilteredData();
            this.updateRenderingData();
        }
    }

    protected void setWidthHeight() {
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        if (mouseButton == 0) {
            if (this.searchTextField.func_146192_a(x, y, mouseButton)) {
                return;
            }
        } else if (mouseButton == 1 && GuiHyperNetTerminal.isMouseOver(this.searchTextField.field_146209_f, this.searchTextField.field_146210_g, this.searchTextField.field_146209_f + this.searchTextField.field_146218_h, this.searchTextField.field_146210_g + this.searchTextField.field_146219_i, x, y)) {
            this.searchTextField.func_146180_a("");
            searchTextCache = "";
            this.updateRenderingData();
        }
        if (this.startResearch.func_146116_c(this.field_146297_k, x, y)) {
            if (mouseButton == 0 && this.current != null && this.current.isLocked() && this.canStartResearch(this.current.getData())) {
                NovaEngineeringCore.NET_CHANNEL.sendToServer((IMessage)new PktResearchTaskProvide(this.current.getData()));
                this.startResearch.func_146113_a(this.field_146297_k.func_147118_V());
                return;
            }
            if (mouseButton == 1) {
                NovaEngineeringCore.NET_CHANNEL.sendToServer((IMessage)new PktResearchTaskReset());
                this.startResearch.func_146113_a(this.field_146297_k.func_147118_V());
                return;
            }
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (mouseButton == 2 && this.current != null && this.current.isLocked() && player != null && player.func_184812_l_()) {
                NovaEngineeringCore.NET_CHANNEL.sendToServer((IMessage)new PktResearchTaskProvideCreative(this.current.getData()));
                this.startResearch.func_146113_a(this.field_146297_k.func_147118_V());
                return;
            }
        }
        if (this.toggleResearchDesc.func_146116_c(this.field_146297_k, x, y) && mouseButton == 0 && this.current != null && !this.current.isLocked()) {
            this.showLockedResearchDesc = !this.showLockedResearchDesc;
            this.toggleResearchDesc.func_146113_a(this.field_146297_k.func_147118_V());
            return;
        }
        if (mouseButton == 0 && (this.screenScrollbar.click(x, y) || this.dataScrollbar.click(x, y))) {
            return;
        }
        int offsetY = 44;
        int index = this.dataScrollbar.getCurrentScroll();
        for (int currentIndex = 0; index < this.renderingData.size() && currentIndex < 9; ++currentIndex, ++index) {
            ResearchDataContext data = this.renderingData.get(index);
            if (GuiHyperNetTerminal.isMouseOver(8, offsetY, 99, offsetY + 22 - 1, x, y)) {
                if (mouseButton == 0) {
                    this.setCurrent(data);
                    break;
                }
                if (mouseButton != 1) break;
                this.setCurrent(null);
                break;
            }
            offsetY += 22;
        }
    }

    private void updateFilteredData() {
        this.lockedData.clear();
        this.unavailableData.clear();
        RegistryHyperNet.getAllResearchCognitionData().stream().filter(data -> !this.researchingData.containsKey(data)).filter(data -> !this.unlockedData.contains(data)).forEach(data -> {
            List<ResearchCognitionData> dependencies = data.getDependencies();
            if (dependencies.isEmpty() || this.unlockedData.containsAll(dependencies)) {
                this.lockedData.add((ResearchCognitionData)data);
            } else if (!data.isHideByDefault()) {
                this.unavailableData.add((ResearchCognitionData)data);
            }
        });
    }

    private boolean canStartResearch(ResearchCognitionData data) {
        ResearchStationType stationType = PktTerminalGuiData.getResearchStationType();
        if (stationType == null || stationType.getMaxTechLevel() < data.getTechLevel()) {
            return false;
        }
        double generation = ComputationCenterCache.getComputationPointGeneration();
        if (generation < data.getMinComputationPointPerTick()) {
            return false;
        }
        if (!this.unlockedData.containsAll(data.getDependencies())) {
            return false;
        }
        List<Database.Status> databases = PktTerminalGuiData.getDatabases();
        return GuiHyperNetTerminal.hasDatabaseSpace(databases);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        int x = mouseX - this.field_147003_i;
        int y = mouseY - this.field_147009_r;
        this.dataScrollbar.click(x, y);
        this.screenScrollbar.click(x, y);
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (!this.searchTextField.func_146206_l()) {
            super.func_73869_a(c, i);
        }
        if (this.searchTextField.func_146201_a(c, i)) {
            searchTextCache = this.searchTextField.func_146179_b();
            this.updateRenderingData();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            int mouseY;
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            if (GuiHyperNetTerminal.isMouseOver(7, 43, 106, 242, mouseX - this.field_147003_i, (mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1) - this.field_147009_r)) {
                this.dataScrollbar.wheel(i);
            }
            if (GuiHyperNetTerminal.isMouseOver(111, 43, 342, 162, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                this.screenScrollbar.wheel(i);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.darkMode) {
            GlStateManager.func_179131_c((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES_TERMINAL);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)this.field_146999_f, (float)this.field_147000_g);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void updateAndDrawScrollbar() {
        if (this.darkMode) {
            GlStateManager.func_179131_c((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.dataScrollbar.setLeft(100).setTop(44).setHeight(198).setRange(0, Math.max(0, this.renderingData.size() - 9), 1);
        this.screenScrollbar.setLeft(336).setTop(44).setHeight(118);
        this.dataScrollbar.draw((GuiScreen)this, this.field_146297_k);
        this.screenScrollbar.draw((GuiScreen)this, this.field_146297_k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static class ResearchDataContext {
        private final ResearchCognitionData data;
        private final boolean locked;
        private final boolean available;
        private final double progress;

        public ResearchDataContext(ResearchCognitionData data, boolean locked, boolean available, Double progress) {
            this.data = data;
            this.locked = locked;
            this.available = available;
            this.progress = progress;
        }

        public ResearchCognitionData getData() {
            return this.data;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public double getProgress() {
            return this.progress;
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ResearchDataContext)) {
                return false;
            }
            ResearchDataContext other = (ResearchDataContext)obj;
            return this.data.equals(other.data);
        }
    }
}

