/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.client;

import appeng.api.storage.ITerminalHost;
import appeng.container.implementations.ContainerCraftConfirm;
import github.kasuminova.mmce.client.renderer.MachineControllerRenderer;
import github.kasuminova.novaeng.client.gui.GuiCraftingTree;
import github.kasuminova.novaeng.client.gui.GuiEFabricatorController;
import github.kasuminova.novaeng.client.gui.GuiEFabricatorPatternBus;
import github.kasuminova.novaeng.client.gui.GuiEStorageController;
import github.kasuminova.novaeng.client.gui.GuiGeocentricDrill;
import github.kasuminova.novaeng.client.gui.GuiHyperNetTerminal;
import github.kasuminova.novaeng.client.gui.GuiModularServerAssembler;
import github.kasuminova.novaeng.client.gui.GuiSingularityCore;
import github.kasuminova.novaeng.client.handler.BlockAngelRendererHandler;
import github.kasuminova.novaeng.client.handler.ClientEventHandler;
import github.kasuminova.novaeng.client.handler.HyperNetClientEventHandler;
import github.kasuminova.novaeng.client.util.TitleUtils;
import github.kasuminova.novaeng.common.CommonProxy;
import github.kasuminova.novaeng.common.command.CommandPacketProfiler;
import github.kasuminova.novaeng.common.command.ExportResearchDataToJson;
import github.kasuminova.novaeng.common.registry.RegistryBlocks;
import github.kasuminova.novaeng.common.registry.RegistryItems;
import github.kasuminova.novaeng.common.tile.TileHyperNetTerminal;
import github.kasuminova.novaeng.common.tile.TileModularServerAssembler;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorController;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorPatternBus;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageController;
import github.kasuminova.novaeng.common.tile.machine.GeocentricDrillController;
import github.kasuminova.novaeng.common.tile.machine.SingularityCore;
import hellfirepvp.modularmachinery.common.base.Mods;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    public ClientProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void construction() {
        super.construction();
        TitleUtils.setRandomTitle("*Construction*");
    }

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)HyperNetClientEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ClientEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)BlockAngelRendererHandler.INSTANCE);
        if (Mods.GECKOLIB.isPresent()) {
            ClientRegistry.bindTileEntitySpecialRenderer(SingularityCore.class, (TileEntitySpecialRenderer)MachineControllerRenderer.INSTANCE);
        }
        TitleUtils.setRandomTitle("*PreInit*");
    }

    @Override
    public void init() {
        super.init();
        TitleUtils.setRandomTitle("*Init*");
    }

    @Override
    public void postInit() {
        super.postInit();
        ClientCommandHandler.instance.func_71560_a((ICommand)ExportResearchDataToJson.INSTANCE);
        ClientCommandHandler.instance.func_71560_a((ICommand)CommandPacketProfiler.INSTANCE);
        TitleUtils.setRandomTitle("*PostInit*");
    }

    @Override
    public void loadComplete() {
        super.loadComplete();
        TitleUtils.setRandomTitle();
    }

    @SubscribeEvent
    public void onModelRegister(ModelRegistryEvent event) {
        RegistryBlocks.registerBlockModels();
        RegistryItems.registerItemModels();
    }

    @Override
    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        Object object;
        CommonProxy.GuiType type = CommonProxy.GuiType.values()[MathHelper.func_76125_a((int)ID, (int)0, (int)(CommonProxy.GuiType.values().length - 1))];
        Class<? extends TileEntity> required = type.requiredTileEntity;
        TileEntity present = null;
        if (required != null) {
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (te != null && required.isAssignableFrom(te.getClass())) {
                present = te;
            } else {
                return null;
            }
        }
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case HYPERNET_TERMINAL: {
                object = new GuiHyperNetTerminal((TileHyperNetTerminal)present, player);
                break;
            }
            case MODULAR_SERVER_ASSEMBLER: {
                object = new GuiModularServerAssembler((TileModularServerAssembler)present, player);
                break;
            }
            case ESTORAGE_CONTROLLER: {
                object = new GuiEStorageController((EStorageController)present, player);
                break;
            }
            case SINGULARITY_CORE: {
                object = new GuiSingularityCore((SingularityCore)present, player);
                break;
            }
            case EFABRICATOR_CONTROLLER: {
                object = new GuiEFabricatorController((EFabricatorController)present, player);
                break;
            }
            case EFABRICATOR_PATTERN_BUS: {
                object = new GuiEFabricatorPatternBus((EFabricatorPatternBus)present, player);
                break;
            }
            case CRAFTING_TREE: {
                Container container = player.field_71070_bA;
                if (!(container instanceof ContainerCraftConfirm)) {
                    object = null;
                    break;
                }
                ContainerCraftConfirm confirm = (ContainerCraftConfirm)container;
                object = new GuiCraftingTree(player.field_71071_by, (ITerminalHost)confirm.getTarget());
                break;
            }
            case GEOCENTRIC_DRILL_CONTROLLER: {
                object = new GuiGeocentricDrill((GeocentricDrillController)present, player);
            }
        }
        return object;
    }
}

