/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.widget;

import github.kasuminova.mmce.client.gui.util.MousePos;
import github.kasuminova.mmce.client.gui.util.RenderPos;
import github.kasuminova.mmce.client.gui.util.RenderSize;
import github.kasuminova.mmce.client.gui.widget.base.DynamicWidget;
import github.kasuminova.mmce.client.gui.widget.base.WidgetGui;
import github.kasuminova.mmce.common.util.DataReference;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class DragBar
extends DynamicWidget {
    public static final ResourceLocation DEFAULT_TEX_RES = new ResourceLocation("novaeng_core", "textures/gui/dragbar.png");
    public static final int DEFAULT_BAR_HEIGHT = 7;
    public static final int DEFAULT_BAR_PADDING_HORIZONTAL = 10;
    public static final int DEFAULT_BAR_LEFT_TEX_OFFSET_X = 8;
    public static final int DEFAULT_BAR_LEFT_TEX_OFFSET_Y = 1;
    public static final int DEFAULT_BAR_LEFT_TEX_OFFSET_X_FILLED = 0;
    public static final int DEFAULT_BAR_LEFT_TEX_OFFSET_Y_FILLED = 1;
    public static final int DEFAULT_BAR_LEFT_TEX_WIDTH = 3;
    public static final int DEFAULT_BAR_MID_TEX_OFFSET_X = 11;
    public static final int DEFAULT_BAR_MID_TEX_OFFSET_Y = 1;
    public static final int DEFAULT_BAR_MID_TEX_OFFSET_X_FILLED = 3;
    public static final int DEFAULT_BAR_MID_TEX_OFFSET_Y_FILLED = 1;
    public static final int DEFAULT_BAR_RIGHT_TEX_OFFSET_X = 12;
    public static final int DEFAULT_BAR_RIGHT_TEX_OFFSET_Y = 1;
    public static final int DEFAULT_BAR_RIGHT_TEX_OFFSET_X_FILLED = 4;
    public static final int DEFAULT_BAR_RIGHT_TEX_OFFSET_Y_FILLED = 1;
    public static final int DEFAULT_BAR_RIGHT_TEX_WIDTH = 3;
    protected final DragBarButton dragBarButton = new DragBarButton();
    protected int paddingHorizontal = 10;
    protected ResourceLocation texLocation = DEFAULT_TEX_RES;
    protected int barHeight = 7;
    protected int barLeftTexOffsetX = 8;
    protected int barLeftTexOffsetY = 1;
    protected int barLeftTexOffsetXFilled = 0;
    protected int barLeftTexOffsetYFilled = 1;
    protected int barLeftTexWidth = 3;
    protected int barMidTexOffsetX = 11;
    protected int barMidTexOffsetY = 1;
    protected int barMidTexOffsetXFilled = 3;
    protected int barMidTexOffsetYFilled = 1;
    protected int barRightTexOffsetX = 12;
    protected int barRightTexOffsetY = 1;
    protected int barRightTexOffsetXFilled = 4;
    protected int barRightTexOffsetYFilled = 1;
    protected int barRightTexWidth = 3;
    protected DataReference<Double> value;
    protected DataReference<Double> min;
    protected DataReference<Double> max;

    public DragBar(DataReference<Double> value, DataReference<Double> min, DataReference<Double> max) {
        this.value = value;
        this.min = min;
        this.max = max;
        this.width = 100;
        this.height = this.barHeight + 2;
    }

    public void initWidget(WidgetGui gui) {
        this.dragBarButton.initWidget(gui);
    }

    public void update(WidgetGui gui) {
        this.dragBarButton.update(gui);
    }

    public void preRender(WidgetGui gui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        if (!this.dragBarButton.isMouseDown()) {
            return;
        }
        int width = this.getWidth() - this.paddingHorizontal * 2;
        int mouseX = mousePos.mouseX() - this.paddingHorizontal;
        if (mouseX <= 0) {
            this.value.setValue(0.0);
            return;
        }
        if (mouseX >= width) {
            this.value.setValue(this.max.getValue());
            return;
        }
        float percent = (float)mouseX / (float)width;
        this.value.setValue(this.max.getValue() * (double)percent);
    }

    public void render(WidgetGui widgetGui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
        int toFillFinal;
        GuiScreen gui = widgetGui.getGui();
        gui.field_146297_k.func_110434_K().func_110577_a(this.texLocation);
        int width = this.getWidth() - this.paddingHorizontal * 2;
        int height = this.getHeight();
        int renderX = renderPos.posX() + this.paddingHorizontal;
        int renderY = renderPos.posY() + (height - this.barHeight) / 2;
        int offsetX = 0;
        double max = this.max.getValue();
        double percent = Math.min(this.value.getValue(), max) / max;
        int toFill = toFillFinal = (int)Math.round((double)width * percent);
        if (toFill >= this.barLeftTexWidth) {
            gui.func_73729_b(renderX, renderY, this.barLeftTexOffsetXFilled, this.barLeftTexOffsetYFilled, this.barLeftTexWidth, this.barHeight);
            offsetX += this.barLeftTexWidth;
            toFill -= this.barLeftTexWidth;
        } else {
            gui.func_73729_b(renderX, renderY, this.barLeftTexOffsetX, this.barLeftTexOffsetY, this.barLeftTexWidth, this.barHeight);
            if (toFill > 0) {
                gui.func_73729_b(renderX, renderY, this.barLeftTexOffsetXFilled, this.barLeftTexOffsetYFilled, toFill, this.barHeight);
            }
            offsetX += this.barLeftTexWidth;
            toFill = 0;
        }
        while (toFill > 0 && offsetX <= width - this.barRightTexWidth) {
            gui.func_73729_b(renderX + offsetX, renderY, this.barMidTexOffsetXFilled, this.barMidTexOffsetYFilled, 1, this.barHeight);
            ++offsetX;
            --toFill;
        }
        while (offsetX <= width - this.barRightTexWidth) {
            gui.func_73729_b(renderX + offsetX, renderY, this.barMidTexOffsetX, this.barMidTexOffsetY, 1, this.barHeight);
            ++offsetX;
        }
        if (toFill >= this.barRightTexWidth) {
            gui.func_73729_b(renderX + offsetX, renderY, this.barRightTexOffsetXFilled, this.barRightTexOffsetYFilled, this.barRightTexWidth, this.barHeight);
        } else {
            gui.func_73729_b(renderX + offsetX, renderY, this.barRightTexOffsetX, this.barRightTexOffsetY, this.barRightTexWidth, this.barHeight);
            if (toFill > 0) {
                gui.func_73729_b(renderX + offsetX, renderY, this.barRightTexOffsetXFilled, this.barRightTexOffsetYFilled, toFill, this.barHeight);
            }
        }
        int dragBarButtonWidth = this.dragBarButton.getWidth();
        int dragBarButtonHeight = this.dragBarButton.getHeight();
        RenderPos dragBarButtonRenderOffset = new RenderPos(toFillFinal - dragBarButtonWidth / 2 + this.paddingHorizontal, (height - dragBarButtonHeight) / 2);
        this.dragBarButton.render(widgetGui, renderSize, renderPos.add(dragBarButtonRenderOffset), mousePos.relativeTo(dragBarButtonRenderOffset));
    }

    public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
        int dragBarButtonHeight;
        int dragBarButtonWidth;
        int width = this.getWidth() - this.paddingHorizontal * 2;
        double max = this.max.getValue();
        double percent = Math.min(this.value.getValue(), max) / max;
        int toFill = (int)Math.round((double)width * percent);
        RenderPos dragBarButtonRenderOffset = new RenderPos(toFill - (dragBarButtonWidth = this.dragBarButton.getWidth()) / 2 + this.paddingHorizontal, (this.height - (dragBarButtonHeight = this.dragBarButton.getHeight())) / 2);
        MousePos relativeMousePos = mousePos.relativeTo(dragBarButtonRenderOffset);
        if (this.dragBarButton.isMouseOver(relativeMousePos)) {
            return this.dragBarButton.onMouseClick(relativeMousePos, renderPos.add(dragBarButtonRenderOffset), mouseButton);
        }
        return false;
    }

    public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
        return this.dragBarButton.onMouseReleased(mousePos, renderPos);
    }

    public int getWidth() {
        return super.getWidth() + this.paddingHorizontal * 2;
    }

    public DragBarButton getDragBarButton() {
        return this.dragBarButton;
    }

    public int getPaddingHorizontal() {
        return this.paddingHorizontal;
    }

    public DragBar setPaddingHorizontal(int paddingHorizontal) {
        this.paddingHorizontal = paddingHorizontal;
        return this;
    }

    public ResourceLocation getTexLocation() {
        return this.texLocation;
    }

    public DragBar setTexLocation(ResourceLocation texLocation) {
        this.texLocation = texLocation;
        return this;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public DragBar setBarHeight(int barHeight) {
        this.barHeight = barHeight;
        return this;
    }

    public int getBarLeftTexOffsetX() {
        return this.barLeftTexOffsetX;
    }

    public DragBar setBarLeftTexOffsetX(int barLeftTexOffsetX) {
        this.barLeftTexOffsetX = barLeftTexOffsetX;
        return this;
    }

    public int getBarLeftTexOffsetY() {
        return this.barLeftTexOffsetY;
    }

    public DragBar setBarLeftTexOffsetY(int barLeftTexOffsetY) {
        this.barLeftTexOffsetY = barLeftTexOffsetY;
        return this;
    }

    public int getBarLeftTexOffsetXFilled() {
        return this.barLeftTexOffsetXFilled;
    }

    public DragBar setBarLeftTexOffsetXFilled(int barLeftTexOffsetXFilled) {
        this.barLeftTexOffsetXFilled = barLeftTexOffsetXFilled;
        return this;
    }

    public int getBarLeftTexOffsetYFilled() {
        return this.barLeftTexOffsetYFilled;
    }

    public DragBar setBarLeftTexOffsetYFilled(int barLeftTexOffsetYFilled) {
        this.barLeftTexOffsetYFilled = barLeftTexOffsetYFilled;
        return this;
    }

    public int getBarLeftTexWidth() {
        return this.barLeftTexWidth;
    }

    public DragBar setBarLeftTexWidth(int barLeftTexWidth) {
        this.barLeftTexWidth = barLeftTexWidth;
        return this;
    }

    public int getBarMidTexOffsetX() {
        return this.barMidTexOffsetX;
    }

    public DragBar setBarMidTexOffsetX(int barMidTexOffsetX) {
        this.barMidTexOffsetX = barMidTexOffsetX;
        return this;
    }

    public int getBarMidTexOffsetY() {
        return this.barMidTexOffsetY;
    }

    public DragBar setBarMidTexOffsetY(int barMidTexOffsetY) {
        this.barMidTexOffsetY = barMidTexOffsetY;
        return this;
    }

    public int getBarMidTexOffsetXFilled() {
        return this.barMidTexOffsetXFilled;
    }

    public DragBar setBarMidTexOffsetXFilled(int barMidTexOffsetXFilled) {
        this.barMidTexOffsetXFilled = barMidTexOffsetXFilled;
        return this;
    }

    public int getBarMidTexOffsetYFilled() {
        return this.barMidTexOffsetYFilled;
    }

    public DragBar setBarMidTexOffsetYFilled(int barMidTexOffsetYFilled) {
        this.barMidTexOffsetYFilled = barMidTexOffsetYFilled;
        return this;
    }

    public int getBarRightTexOffsetX() {
        return this.barRightTexOffsetX;
    }

    public DragBar setBarRightTexOffsetX(int barRightTexOffsetX) {
        this.barRightTexOffsetX = barRightTexOffsetX;
        return this;
    }

    public int getBarRightTexOffsetY() {
        return this.barRightTexOffsetY;
    }

    public DragBar setBarRightTexOffsetY(int barRightTexOffsetY) {
        this.barRightTexOffsetY = barRightTexOffsetY;
        return this;
    }

    public int getBarRightTexOffsetXFilled() {
        return this.barRightTexOffsetXFilled;
    }

    public DragBar setBarRightTexOffsetXFilled(int barRightTexOffsetXFilled) {
        this.barRightTexOffsetXFilled = barRightTexOffsetXFilled;
        return this;
    }

    public int getBarRightTexOffsetYFilled() {
        return this.barRightTexOffsetYFilled;
    }

    public DragBar setBarRightTexOffsetYFilled(int barRightTexOffsetYFilled) {
        this.barRightTexOffsetYFilled = barRightTexOffsetYFilled;
        return this;
    }

    public int getBarRightTexWidth() {
        return this.barRightTexWidth;
    }

    public DragBar setBarRightTexWidth(int barRightTexWidth) {
        this.barRightTexWidth = barRightTexWidth;
        return this;
    }

    public DataReference<Double> getValue() {
        return this.value;
    }

    public DragBar setValue(DataReference<Double> value) {
        this.value = value;
        return this;
    }

    public DataReference<Double> getMin() {
        return this.min;
    }

    public DragBar setMin(DataReference<Double> min) {
        this.min = min;
        return this;
    }

    public DataReference<Double> getMax() {
        return this.max;
    }

    public DragBar setMax(DataReference<Double> max) {
        this.max = max;
        return this;
    }

    public class DragBarButton
    extends DynamicWidget {
        public static final int DEFAULT_BUTTON_HEIGHT = 9;
        public static final int DEFAULT_BUTTON_LEFT_TEX_OFFSET_X = 16;
        public static final int DEFAULT_BUTTON_LEFT_TEX_OFFSET_Y = 0;
        public static final int DEFAULT_BUTTON_LEFT_TEX_WIDTH = 3;
        public static final int DEFAULT_BUTTON_MID_TEX_OFFSET_X = 19;
        public static final int DEFAULT_BUTTON_MID_TEX_OFFSET_Y = 0;
        public static final int DEFAULT_BUTTON_RIGHT_TEX_OFFSET_X = 20;
        public static final int DEFAULT_BUTTON_RIGHT_TEX_OFFSET_Y = 0;
        public static final int DEFAULT_BUTTON_RIGHT_TEX_WIDTH = 3;
        public static final int DEFAULT_ANIMATION_DURATION = 250;
        public static final float MOUSE_OVER_DARK_VALUE = 0.15f;
        public static final float MOUSE_DOWN_DARK_VALUE = 0.3f;
        protected ResourceLocation texLocation = DEFAULT_TEX_RES;
        protected float width = 0.0f;
        protected float height = 9.0f;
        protected int buttonLeftTexOffsetX = 16;
        protected int buttonLeftTexOffsetY = 0;
        protected int buttonLeftTexWidth = 3;
        protected int buttonMidTexOffsetX = 19;
        protected int buttonMidTexOffsetY = 0;
        protected int buttonRightTexOffsetX = 20;
        protected int buttonRightTexOffsetY = 0;
        protected int buttonRightTexWidth = 3;
        protected int animationDuration = 250;
        protected double cachedValue;
        protected long expandAnimationStartTime = 0L;
        protected boolean expandAnimationStarted = false;
        protected float expandedWidth = 0.0f;
        protected float lastExpandedWidth = 0.0f;
        protected long lastColorUpdateTime = 0L;
        protected float darkValue = 0.0f;
        protected boolean mouseOver = false;
        protected boolean mouseDown = false;

        public void initWidget(WidgetGui gui) {
            this.cachedValue = DragBar.this.value.getValue();
            this.lastExpandedWidth = this.expandedWidth = (float)this.getContentWidth(gui);
            this.width = (float)this.buttonLeftTexWidth + this.expandedWidth + (float)this.buttonRightTexWidth;
        }

        public void update(WidgetGui gui) {
            super.update(gui);
            this.updateExpandAnimation(gui);
            this.updateColorAnimation();
        }

        protected void updateExpandAnimation(WidgetGui gui) {
            Double currentValue = DragBar.this.value.getValue();
            if (this.cachedValue != currentValue) {
                this.cachedValue = currentValue;
                if (!this.expandAnimationStarted) {
                    this.lastExpandedWidth = this.expandedWidth;
                    this.expandAnimationStartTime = System.currentTimeMillis();
                    this.expandAnimationStarted = true;
                }
                return;
            }
            if (!this.expandAnimationStarted || this.expandAnimationStartTime == 0L) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            int requiredWidth = this.getContentWidth(gui);
            if (this.expandAnimationStartTime + (long)this.animationDuration < currentTime) {
                this.expandedWidth = requiredWidth;
                this.width = (float)this.buttonLeftTexWidth + this.expandedWidth + (float)this.buttonRightTexWidth;
                this.expandAnimationStarted = false;
                return;
            }
            float animationPercent = (float)(currentTime - this.expandAnimationStartTime) / (float)this.animationDuration;
            float toExpand = ((float)requiredWidth - this.lastExpandedWidth) * animationPercent;
            this.expandedWidth = this.lastExpandedWidth + toExpand;
            this.width = (float)this.buttonLeftTexWidth + this.expandedWidth + (float)this.buttonRightTexWidth;
        }

        protected void updateColorAnimation() {
            float requiredValue;
            float f = this.mouseDown ? 0.3f : (requiredValue = this.mouseOver ? 0.15f : 0.0f);
            if (requiredValue == this.darkValue) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            int timeLags = (int)(currentTime - this.lastColorUpdateTime);
            if (timeLags <= 0) {
                return;
            }
            float animationValue = (float)timeLags / ((float)this.animationDuration * 10.0f);
            this.darkValue = requiredValue > this.darkValue ? Math.min(this.darkValue + animationValue, requiredValue) : Math.max(this.darkValue - animationValue, requiredValue);
        }

        public void render(WidgetGui widgetGui, RenderSize renderSize, RenderPos renderPos, MousePos mousePos) {
            GuiScreen gui = widgetGui.getGui();
            if (this.mouseOver) {
                if (!this.isMouseOver(mousePos)) {
                    this.mouseOver = false;
                    this.lastColorUpdateTime = System.currentTimeMillis();
                }
            } else if (this.isMouseOver(mousePos)) {
                this.mouseOver = true;
                this.lastColorUpdateTime = System.currentTimeMillis();
            }
            gui.field_146297_k.func_110434_K().func_110577_a(this.texLocation);
            int contentWidth = this.getContentWidth(widgetGui);
            float width = this.width;
            float height = this.height;
            float offsetX = ((float)((int)width) - width) / 2.0f;
            GlStateManager.func_179124_c((float)(1.0f - this.darkValue), (float)(1.0f - this.darkValue), (float)(1.0f - this.darkValue));
            gui.func_175174_a((float)renderPos.posX() + offsetX, (float)renderPos.posY(), this.buttonLeftTexOffsetX, this.buttonLeftTexOffsetY, this.buttonLeftTexWidth, (int)height);
            offsetX += (float)this.buttonLeftTexWidth;
            while (offsetX + (float)this.buttonRightTexWidth < width) {
                gui.func_175174_a((float)renderPos.posX() + offsetX, (float)renderPos.posY(), this.buttonMidTexOffsetX, this.buttonMidTexOffsetY, 1, (int)height);
                offsetX += 1.0f;
            }
            if (offsetX < width - (float)this.buttonRightTexWidth) {
                gui.func_175174_a((float)renderPos.posX() + offsetX - (width - (float)this.buttonRightTexWidth - offsetX), (float)renderPos.posY(), this.buttonMidTexOffsetX, this.buttonMidTexOffsetY, 1, (int)height);
                offsetX += width - (float)this.buttonRightTexWidth - offsetX;
            }
            gui.func_175174_a((float)renderPos.posX() + offsetX, (float)renderPos.posY(), this.buttonRightTexOffsetX, this.buttonRightTexOffsetY, this.buttonRightTexWidth, (int)height);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            String formattedValue = NovaEngUtils.formatDouble(this.cachedValue, 2);
            gui.field_146297_k.field_71466_p.func_175065_a(formattedValue, (float)renderPos.posX() + (width - (float)contentWidth) / 2.0f, (float)renderPos.posY(), 0xFFFFFF, false);
        }

        public int getWidth() {
            return (int)this.width;
        }

        public DragBarButton setWidth(int width) {
            this.width = width;
            return this;
        }

        public int getHeight() {
            return (int)this.height;
        }

        public DragBarButton setHeight(int height) {
            this.height = height;
            return this;
        }

        public boolean onMouseClick(MousePos mousePos, RenderPos renderPos, int mouseButton) {
            this.mouseDown = true;
            this.lastColorUpdateTime = System.currentTimeMillis();
            return true;
        }

        public boolean onMouseReleased(MousePos mousePos, RenderPos renderPos) {
            this.mouseDown = false;
            this.lastColorUpdateTime = System.currentTimeMillis();
            return false;
        }

        protected int getContentWidth(WidgetGui widgetGui) {
            String formattedValue = NovaEngUtils.formatDouble(this.cachedValue, 2);
            return widgetGui.getGui().field_146297_k.field_71466_p.func_78256_a(formattedValue);
        }

        public ResourceLocation getTexLocation() {
            return this.texLocation;
        }

        public DragBarButton setTexLocation(ResourceLocation texLocation) {
            this.texLocation = texLocation;
            return this;
        }

        public int getButtonLeftTexOffsetX() {
            return this.buttonLeftTexOffsetX;
        }

        public DragBarButton setButtonLeftTexOffsetX(int buttonLeftTexOffsetX) {
            this.buttonLeftTexOffsetX = buttonLeftTexOffsetX;
            return this;
        }

        public int getButtonLeftTexOffsetY() {
            return this.buttonLeftTexOffsetY;
        }

        public DragBarButton setButtonLeftTexOffsetY(int buttonLeftTexOffsetY) {
            this.buttonLeftTexOffsetY = buttonLeftTexOffsetY;
            return this;
        }

        public int getButtonLeftTexWidth() {
            return this.buttonLeftTexWidth;
        }

        public DragBarButton setButtonLeftTexWidth(int buttonLeftTexWidth) {
            this.buttonLeftTexWidth = buttonLeftTexWidth;
            return this;
        }

        public int getButtonMidTexOffsetX() {
            return this.buttonMidTexOffsetX;
        }

        public DragBarButton setButtonMidTexOffsetX(int buttonMidTexOffsetX) {
            this.buttonMidTexOffsetX = buttonMidTexOffsetX;
            return this;
        }

        public int getButtonMidTexOffsetY() {
            return this.buttonMidTexOffsetY;
        }

        public DragBarButton setButtonMidTexOffsetY(int buttonMidTexOffsetY) {
            this.buttonMidTexOffsetY = buttonMidTexOffsetY;
            return this;
        }

        public int getButtonRightTexOffsetX() {
            return this.buttonRightTexOffsetX;
        }

        public DragBarButton setButtonRightTexOffsetX(int buttonRightTexOffsetX) {
            this.buttonRightTexOffsetX = buttonRightTexOffsetX;
            return this;
        }

        public int getButtonRightTexOffsetY() {
            return this.buttonRightTexOffsetY;
        }

        public DragBarButton setButtonRightTexOffsetY(int buttonRightTexOffsetY) {
            this.buttonRightTexOffsetY = buttonRightTexOffsetY;
            return this;
        }

        public int getButtonRightTexWidth() {
            return this.buttonRightTexWidth;
        }

        public DragBarButton setButtonRightTexWidth(int buttonRightTexWidth) {
            this.buttonRightTexWidth = buttonRightTexWidth;
            return this;
        }

        public int getAnimationDuration() {
            return this.animationDuration;
        }

        public DragBarButton setAnimationDuration(int animationDuration) {
            this.animationDuration = animationDuration;
            return this;
        }

        public long getExpandAnimationStartTime() {
            return this.expandAnimationStartTime;
        }

        public DragBarButton setExpandAnimationStartTime(long expandAnimationStartTime) {
            this.expandAnimationStartTime = expandAnimationStartTime;
            return this;
        }

        public boolean isExpandAnimationStarted() {
            return this.expandAnimationStarted;
        }

        public DragBarButton setExpandAnimationStarted(boolean expandAnimationStarted) {
            this.expandAnimationStarted = expandAnimationStarted;
            return this;
        }

        public float getExpandedWidth() {
            return this.expandedWidth;
        }

        public DragBarButton setExpandedWidth(float expandedWidth) {
            this.expandedWidth = expandedWidth;
            return this;
        }

        public float getLastExpandedWidth() {
            return this.lastExpandedWidth;
        }

        public DragBarButton setLastExpandedWidth(float lastExpandedWidth) {
            this.lastExpandedWidth = lastExpandedWidth;
            return this;
        }

        public long getLastColorUpdateTime() {
            return this.lastColorUpdateTime;
        }

        public DragBarButton setLastColorUpdateTime(long lastColorUpdateTime) {
            this.lastColorUpdateTime = lastColorUpdateTime;
            return this;
        }

        public float getDarkValue() {
            return this.darkValue;
        }

        public DragBarButton setDarkValue(float darkValue) {
            this.darkValue = darkValue;
            return this;
        }

        public boolean isMouseOver() {
            return this.mouseOver;
        }

        public DragBarButton setMouseOver(boolean mouseOver) {
            this.mouseOver = mouseOver;
            return this;
        }

        public boolean isMouseDown() {
            return this.mouseDown;
        }

        public DragBarButton setMouseDown(boolean mouseDown) {
            this.mouseDown = mouseDown;
            return this;
        }
    }
}

