/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.world;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.core.util.UtilKt;
import thedarkcolour.futuremc.world.OldWorldHandler;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u0016\u0010\u0011\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0007J\u0016\u0010\u0013\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0007J\u0016\u0010\u0015\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0007J\u0016\u0010\u0017\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fH\u0007JH\u0010\u0019\u001a\u00020\u000b\"\u000e\b\u0000\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u001a0\u001b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u000f2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001fH\u0002J\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lthedarkcolour/futuremc/world/OldWorldHandler;", "", "()V", "BLOCK_MAPPINGS", "Lcom/google/common/collect/ImmutableMap;", "", "ENCHANTMENT_MAPPINGS", "ENTITY_MAPPINGS", "ITEM_MAPPINGS", "TILE_MAPPINGS", "onChunkEntityLoad", "", "event", "Lnet/minecraftforge/event/world/ChunkDataEvent;", "onOldBlocksLoad", "Lnet/minecraftforge/event/RegistryEvent$MissingMappings;", "Lnet/minecraft/block/Block;", "onOldEnchantmentsLoad", "Lnet/minecraft/enchantment/Enchantment;", "onOldEntityLoad", "Lnet/minecraftforge/fml/common/registry/EntityEntry;", "onOldItemsLoad", "Lnet/minecraft/item/Item;", "onOldSoundLoad", "Lnet/minecraft/util/SoundEvent;", "remap", "T", "Lnet/minecraftforge/registries/IForgeRegistryEntry;", "mappings", "", "registry", "Lnet/minecraftforge/registries/IForgeRegistry;", "remapTile", "data", "Lnet/minecraft/nbt/NBTTagCompound;", "oldID", "FutureMC"})
public final class OldWorldHandler {
    private static ImmutableMap<String, String> BLOCK_MAPPINGS;
    private static ImmutableMap<String, String> ENCHANTMENT_MAPPINGS;
    private static final ImmutableMap<String, String> ENTITY_MAPPINGS;
    private static ImmutableMap<String, String> ITEM_MAPPINGS;
    private static final ImmutableMap<String, String> TILE_MAPPINGS;
    public static final OldWorldHandler INSTANCE;

    @SubscribeEvent
    public final void onOldBlocksLoad(@NotNull RegistryEvent.MissingMappings<Block> event) {
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        Map map = (Map)BLOCK_MAPPINGS;
        IForgeRegistry iForgeRegistry = ForgeRegistries.BLOCKS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iForgeRegistry, (String)"ForgeRegistries.BLOCKS");
        this.remap(event, map, iForgeRegistry);
    }

    @SubscribeEvent
    public final void onOldEnchantmentsLoad(@NotNull RegistryEvent.MissingMappings<Enchantment> event) {
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        Map map = (Map)ENCHANTMENT_MAPPINGS;
        IForgeRegistry iForgeRegistry = ForgeRegistries.ENCHANTMENTS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iForgeRegistry, (String)"ForgeRegistries.ENCHANTMENTS");
        this.remap(event, map, iForgeRegistry);
    }

    @SubscribeEvent
    public final void onOldEntityLoad(@NotNull RegistryEvent.MissingMappings<EntityEntry> event) {
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        Map map = (Map)ENTITY_MAPPINGS;
        IForgeRegistry iForgeRegistry = ForgeRegistries.ENTITIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)iForgeRegistry, (String)"ForgeRegistries.ENTITIES");
        this.remap(event, map, iForgeRegistry);
    }

    @SubscribeEvent
    public final void onOldItemsLoad(@NotNull RegistryEvent.MissingMappings<Item> event) {
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        Map map = (Map)ITEM_MAPPINGS;
        IForgeRegistry iForgeRegistry = ForgeRegistries.ITEMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iForgeRegistry, (String)"ForgeRegistries.ITEMS");
        this.remap(event, map, iForgeRegistry);
    }

    @SubscribeEvent
    public final void onOldSoundLoad(@NotNull RegistryEvent.MissingMappings<SoundEvent> event) {
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation resourceLocation = mapping.key;
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceLocation, (String)"mapping.key");
            if (!Intrinsics.areEqual((Object)resourceLocation.func_110624_b(), (Object)"minecraftfuture")) continue;
            mapping.ignore();
        }
    }

    private final <T extends IForgeRegistryEntry<T>> void remap(RegistryEvent.MissingMappings<T> event, Map<String, String> mappings, IForgeRegistry<T> registry) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            String string;
            ResourceLocation key;
            ResourceLocation resourceLocation = key = mapping.key;
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceLocation, (String)"key");
            String path = resourceLocation.func_110623_a();
            if (Intrinsics.areEqual((Object)path, (Object)"scaffolding") || Intrinsics.areEqual((Object)path, (Object)"debugger")) {
                mapping.ignore();
            }
            if (!Intrinsics.areEqual((Object)key.func_110624_b(), (Object)"minecraftfuture")) continue;
            if (mappings.get(key.toString()) == null) {
                continue;
            }
            IForgeRegistryEntry r = registry.getValue(new ResourceLocation(string));
            mapping.remap(r);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onChunkEntityLoad(@NotNull ChunkDataEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        NBTTagList tileEntities = event.getData().func_74775_l("Level").func_150295_c("TileEntities", 10);
        Chunk chunk = event.getChunk();
        int n = 0;
        int n2 = tileEntities.func_74745_c();
        while (n < n2) {
            String id;
            void i2;
            NBTTagCompound data = tileEntities.func_150305_b((int)i2);
            String string = id = data.func_74779_i("id");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            if (StringsKt.startsWith$default((String)string, (String)"minecraftfuture", (boolean)false, (int)2, null)) {
                BlockPos pos = new BlockPos(data.func_74762_e("x"), data.func_74762_e("y"), data.func_74762_e("z"));
                NBTTagCompound nBTTagCompound = data;
                Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"data");
                this.remapTile(nBTTagCompound, id);
                chunk.func_177425_e(pos);
                Chunk chunk2 = chunk;
                Intrinsics.checkExpressionValueIsNotNull((Object)chunk2, (String)"chunk");
                TileEntity tileEntity = TileEntity.func_190200_a((World)chunk2.func_177412_p(), (NBTTagCompound)data);
                if (tileEntity == null) {
                    Intrinsics.throwNpe();
                }
                chunk.func_177426_a(pos, tileEntity);
            }
            ++i2;
        }
    }

    private final void remapTile(NBTTagCompound data, String oldID) {
        Object object = TILE_MAPPINGS.get((Object)oldID);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        data.func_74778_a("id", (String)object);
    }

    private OldWorldHandler() {
    }

    static {
        OldWorldHandler oldWorldHandler;
        INSTANCE = oldWorldHandler = new OldWorldHandler();
        BLOCK_MAPPINGS = UtilKt.immutableMapOf(BLOCK_MAPPINGS.1.INSTANCE);
        ENCHANTMENT_MAPPINGS = UtilKt.immutableMapOf(ENCHANTMENT_MAPPINGS.1.INSTANCE);
        ENTITY_MAPPINGS = UtilKt.immutableMapOf(ENTITY_MAPPINGS.1.INSTANCE);
        ITEM_MAPPINGS = UtilKt.immutableMapOf(ITEM_MAPPINGS.1.INSTANCE);
        TILE_MAPPINGS = UtilKt.immutableMapOf(TILE_MAPPINGS.1.INSTANCE);
    }

    public static final /* synthetic */ ImmutableMap access$getBLOCK_MAPPINGS$p(OldWorldHandler $this) {
        OldWorldHandler oldWorldHandler = $this;
        return BLOCK_MAPPINGS;
    }

    public static final /* synthetic */ void access$setBLOCK_MAPPINGS$p(OldWorldHandler $this, ImmutableMap immutableMap) {
        OldWorldHandler oldWorldHandler = $this;
        BLOCK_MAPPINGS = immutableMap;
    }
}

