/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.entity.fish.tropical;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.core.util.UtilKt;
import thedarkcolour.futuremc.entity.fish.EntityGroupFish;
import thedarkcolour.futuremc.registry.FItems;
import thedarkcolour.futuremc.registry.FSounds;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 12\u00020\u0001:\u000212B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\nH\u0014J\u0012\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\b\u0010!\u001a\u00020\u001cH\u0014J\u0006\u0010\"\u001a\u00020\u001aJ\u0006\u0010#\u001a\u00020\u001cJ\u0006\u0010$\u001a\u00020\u0010J\b\u0010%\u001a\u00020\nH\u0014J\u001a\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0006H\u0016J\u0010\u00100\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u00063"}, d2={"Lthedarkcolour/futuremc/entity/fish/tropical/EntityTropicalFish;", "Lthedarkcolour/futuremc/entity/fish/EntityGroupFish;", "worldIn", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "fishBucket", "Lnet/minecraft/item/ItemStack;", "getFishBucket", "()Lnet/minecraft/item/ItemStack;", "flopSound", "Lnet/minecraft/util/SoundEvent;", "getFlopSound", "()Lnet/minecraft/util/SoundEvent;", "isSpecialVariant", "", "value", "", "variant", "getVariant", "()I", "setVariant", "(I)V", "entityInit", "", "generateVariant", "getBodyColorComponentValues", "", "getBodyTexture", "Lnet/minecraft/util/ResourceLocation;", "getDeathSound", "getHurtSound", "damageSourceIn", "Lnet/minecraft/util/DamageSource;", "getLootTable", "getPatternColorComponentValues", "getPatternTexture", "getSize", "getSwimSound", "onInitialSpawn", "Lnet/minecraft/entity/IEntityLivingData;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "livingdata", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "setBucketData", "stack", "writeEntityToNBT", "Companion", "Type", "FutureMC"})
public final class EntityTropicalFish
extends EntityGroupFish {
    private boolean isSpecialVariant;
    @NotNull
    private final ItemStack fishBucket;
    @NotNull
    private final SoundEvent flopSound;
    private static final DataParameter<Integer> VARIANT;
    @NotNull
    private static final ResourceLocation LOOT_TABLE;
    private static final ResourceLocation[] BODY_TEXTURES;
    private static final ResourceLocation[] PATTERN_TEXTURES_A;
    private static final ResourceLocation[] PATTERN_TEXTURES_B;
    @NotNull
    private static final int[] SPECIAL_VARIANTS;
    public static final Companion Companion;

    public final int getVariant() {
        Object object = this.field_70180_af.func_187225_a(VARIANT);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataManager[VARIANT]");
        return ((Number)object).intValue();
    }

    public final void setVariant(int value) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)value);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    @Override
    public void func_70014_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    @Override
    public void func_70037_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    @Override
    public void setBucketData(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        super.setBucketData(stack);
        NBTTagCompound nbt = UtilKt.getOrCreateTag(stack);
        nbt.func_74768_a("BucketVariant", this.getVariant());
    }

    @Override
    @NotNull
    public ItemStack getFishBucket() {
        return this.fishBucket;
    }

    @NotNull
    protected SoundEvent func_184615_bR() {
        return FSounds.INSTANCE.getTROPICAL_FISH_DEATH();
    }

    @NotNull
    protected SoundEvent func_184601_bQ(@Nullable DamageSource damageSourceIn) {
        return FSounds.INSTANCE.getTROPICAL_FISH_HURT();
    }

    @Override
    @NotNull
    public SoundEvent getFlopSound() {
        return this.flopSound;
    }

    @Override
    @NotNull
    protected SoundEvent func_184184_Z() {
        return FSounds.INSTANCE.getTROPICAL_FISH_SWIM();
    }

    public final int getSize() {
        return EntityTropicalFish.Companion.getBody(this.getVariant());
    }

    @NotNull
    public final ResourceLocation getPatternTexture() {
        return EntityTropicalFish.Companion.getBody(this.getVariant()) == 0 ? PATTERN_TEXTURES_A[EntityTropicalFish.Companion.getPattern(this.getVariant())] : PATTERN_TEXTURES_B[EntityTropicalFish.Companion.getPattern(this.getVariant())];
    }

    @NotNull
    public final float[] getPatternColorComponentValues() {
        EnumDyeColor enumDyeColor = EnumDyeColor.func_176764_b((int)EntityTropicalFish.Companion.getPatternColor(this.getVariant()));
        Intrinsics.checkExpressionValueIsNotNull((Object)enumDyeColor, (String)"EnumDyeColor.byMetadata(getPatternColor(variant))");
        float[] fArray = enumDyeColor.func_193349_f();
        Intrinsics.checkExpressionValueIsNotNull((Object)fArray, (String)"EnumDyeColor.byMetadata(\u2026nt)).colorComponentValues");
        return fArray;
    }

    @NotNull
    public final float[] getBodyColorComponentValues() {
        EnumDyeColor enumDyeColor = EnumDyeColor.func_176764_b((int)EntityTropicalFish.Companion.getBodyColor(this.getVariant()));
        Intrinsics.checkExpressionValueIsNotNull((Object)enumDyeColor, (String)"EnumDyeColor.byMetadata(getBodyColor(variant))");
        float[] fArray = enumDyeColor.func_193349_f();
        Intrinsics.checkExpressionValueIsNotNull((Object)fArray, (String)"EnumDyeColor.byMetadata(\u2026nt)).colorComponentValues");
        return fArray;
    }

    @NotNull
    public final ResourceLocation getBodyTexture() {
        return BODY_TEXTURES[EntityTropicalFish.Companion.getBody(this.getVariant())];
    }

    @Override
    @NotNull
    public IEntityLivingData func_180482_a(@NotNull DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Intrinsics.checkParameterIsNotNull((Object)difficulty, (String)"difficulty");
        this.generateVariant();
        return super.func_180482_a(difficulty, livingdata);
    }

    public final void generateVariant() {
        int i2 = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        if (this.field_70146_Z.nextFloat() < 0.9f) {
            int specialVariant = SPECIAL_VARIANTS[this.field_70146_Z.nextInt(SPECIAL_VARIANTS.length)];
            i2 = specialVariant & 0xFF;
            j = (specialVariant & 0xFF00) >> 8;
            k = (specialVariant & 0xFF0000) >> 16;
            l = (specialVariant & 0xFF000000) >> 24;
        } else {
            this.isSpecialVariant = false;
            i2 = this.field_70146_Z.nextInt(2);
            j = this.field_70146_Z.nextInt(6);
            k = this.field_70146_Z.nextInt(15);
            l = this.field_70146_Z.nextInt(15);
        }
        this.setVariant(i2 | j << 8 | k << 16 | l << 24);
    }

    @Override
    @NotNull
    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public EntityTropicalFish(@NotNull World worldIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        super(worldIn);
        this.isSpecialVariant = true;
        this.func_70105_a(0.5f, 0.4f);
        this.fishBucket = new ItemStack((Item)FItems.INSTANCE.getTROPICAL_FISH_BUCKET());
        this.flopSound = FSounds.INSTANCE.getTROPICAL_FISH_FLOP();
    }

    static {
        Companion = new Companion(null);
        VARIANT = EntityDataManager.func_187226_a(EntityTropicalFish.class, (DataSerializer)DataSerializers.field_187192_b);
        LOOT_TABLE = new ResourceLocation("futuremc", "entities/tropical_fish");
        BODY_TEXTURES = new ResourceLocation[]{new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_a.png"), new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_b.png")};
        PATTERN_TEXTURES_A = new ResourceLocation[]{new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_a_pattern_1.png"), new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_a_pattern_2.png"), new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_a_pattern_3.png"), new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_a_pattern_4.png"), new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_a_pattern_5.png"), new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_a_pattern_6.png")};
        PATTERN_TEXTURES_B = new ResourceLocation[]{new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_b_pattern_1.png"), new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_b_pattern_2.png"), new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_b_pattern_3.png"), new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_b_pattern_4.png"), new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_b_pattern_5.png"), new ResourceLocation("futuremc", "textures/entity/tropical_fish/tropical_b_pattern_6.png")};
        SPECIAL_VARIANTS = new int[]{EntityTropicalFish.Companion.makeVariant(Type.STRIPEY, EnumDyeColor.ORANGE, EnumDyeColor.GRAY), EntityTropicalFish.Companion.makeVariant(Type.FLOPPER, EnumDyeColor.GRAY, EnumDyeColor.GRAY), EntityTropicalFish.Companion.makeVariant(Type.FLOPPER, EnumDyeColor.GRAY, EnumDyeColor.BLUE), EntityTropicalFish.Companion.makeVariant(Type.CLAYFISH, EnumDyeColor.WHITE, EnumDyeColor.GRAY), EntityTropicalFish.Companion.makeVariant(Type.SUNSTREAK, EnumDyeColor.BLUE, EnumDyeColor.GRAY), EntityTropicalFish.Companion.makeVariant(Type.KOB, EnumDyeColor.ORANGE, EnumDyeColor.WHITE), EntityTropicalFish.Companion.makeVariant(Type.SPOTTY, EnumDyeColor.PINK, EnumDyeColor.LIGHT_BLUE), EntityTropicalFish.Companion.makeVariant(Type.BLOCKFISH, EnumDyeColor.PURPLE, EnumDyeColor.YELLOW), EntityTropicalFish.Companion.makeVariant(Type.CLAYFISH, EnumDyeColor.WHITE, EnumDyeColor.RED), EntityTropicalFish.Companion.makeVariant(Type.SPOTTY, EnumDyeColor.WHITE, EnumDyeColor.YELLOW), EntityTropicalFish.Companion.makeVariant(Type.GLITTER, EnumDyeColor.WHITE, EnumDyeColor.GRAY), EntityTropicalFish.Companion.makeVariant(Type.CLAYFISH, EnumDyeColor.WHITE, EnumDyeColor.ORANGE), EntityTropicalFish.Companion.makeVariant(Type.DASHER, EnumDyeColor.CYAN, EnumDyeColor.PINK), EntityTropicalFish.Companion.makeVariant(Type.BRINELY, EnumDyeColor.LIME, EnumDyeColor.LIGHT_BLUE), EntityTropicalFish.Companion.makeVariant(Type.BETTY, EnumDyeColor.RED, EnumDyeColor.WHITE), EntityTropicalFish.Companion.makeVariant(Type.SNOOPER, EnumDyeColor.GRAY, EnumDyeColor.RED), EntityTropicalFish.Companion.makeVariant(Type.BLOCKFISH, EnumDyeColor.RED, EnumDyeColor.WHITE), EntityTropicalFish.Companion.makeVariant(Type.FLOPPER, EnumDyeColor.WHITE, EnumDyeColor.YELLOW), EntityTropicalFish.Companion.makeVariant(Type.KOB, EnumDyeColor.RED, EnumDyeColor.WHITE), EntityTropicalFish.Companion.makeVariant(Type.SUNSTREAK, EnumDyeColor.GRAY, EnumDyeColor.WHITE), EntityTropicalFish.Companion.makeVariant(Type.DASHER, EnumDyeColor.CYAN, EnumDyeColor.YELLOW), EntityTropicalFish.Companion.makeVariant(Type.FLOPPER, EnumDyeColor.YELLOW, EnumDyeColor.YELLOW)};
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lthedarkcolour/futuremc/entity/fish/tropical/EntityTropicalFish$Type;", "", "primary", "", "secondary", "(Ljava/lang/String;III)V", "getPrimary", "()I", "getSecondary", "KOB", "SUNSTREAK", "SNOOPER", "DASHER", "BRINELY", "SPOTTY", "FLOPPER", "STRIPEY", "GLITTER", "BLOCKFISH", "BETTY", "CLAYFISH", "FutureMC"})
    private static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type KOB;
        public static final /* enum */ Type SUNSTREAK;
        public static final /* enum */ Type SNOOPER;
        public static final /* enum */ Type DASHER;
        public static final /* enum */ Type BRINELY;
        public static final /* enum */ Type SPOTTY;
        public static final /* enum */ Type FLOPPER;
        public static final /* enum */ Type STRIPEY;
        public static final /* enum */ Type GLITTER;
        public static final /* enum */ Type BLOCKFISH;
        public static final /* enum */ Type BETTY;
        public static final /* enum */ Type CLAYFISH;
        private static final /* synthetic */ Type[] $VALUES;
        private final int primary;
        private final int secondary;

        static {
            Type[] typeArray = new Type[12];
            Type[] typeArray2 = typeArray;
            typeArray[0] = KOB = new Type(0, 0);
            typeArray[1] = SUNSTREAK = new Type(0, 1);
            typeArray[2] = SNOOPER = new Type(0, 2);
            typeArray[3] = DASHER = new Type(0, 3);
            typeArray[4] = BRINELY = new Type(0, 4);
            typeArray[5] = SPOTTY = new Type(0, 5);
            typeArray[6] = FLOPPER = new Type(1, 0);
            typeArray[7] = STRIPEY = new Type(1, 1);
            typeArray[8] = GLITTER = new Type(1, 2);
            typeArray[9] = BLOCKFISH = new Type(1, 3);
            typeArray[10] = BETTY = new Type(1, 4);
            typeArray[11] = CLAYFISH = new Type(1, 5);
            $VALUES = typeArray;
        }

        public final int getPrimary() {
            return this.primary;
        }

        public final int getSecondary() {
            return this.secondary;
        }

        private Type(int primary, int secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0012J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0012J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u0010\"\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0012J \u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u0018H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR2\u0010\u0010\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lthedarkcolour/futuremc/entity/fish/tropical/EntityTropicalFish$Companion;", "", "()V", "BODY_TEXTURES", "", "Lnet/minecraft/util/ResourceLocation;", "[Lnet/minecraft/util/ResourceLocation;", "LOOT_TABLE", "getLOOT_TABLE", "()Lnet/minecraft/util/ResourceLocation;", "PATTERN_TEXTURES_A", "PATTERN_TEXTURES_B", "SPECIAL_VARIANTS", "", "getSPECIAL_VARIANTS", "()[I", "VARIANT", "Lnet/minecraft/network/datasync/DataParameter;", "", "kotlin.jvm.PlatformType", "getBody", "variant", "getBodyColor", "getBodyDyeColor", "Lnet/minecraft/item/EnumDyeColor;", "getPattern", "getPatternColor", "getPatternDyeColor", "getTranslation", "", "i", "j", "getTranslationPrefix", "", "getTranslationPrefixSpecial", "makeVariant", "size", "Lthedarkcolour/futuremc/entity/fish/tropical/EntityTropicalFish$Type;", "pattern", "bodyColor", "FutureMC"})
    public static final class Companion {
        @NotNull
        public final ResourceLocation getLOOT_TABLE() {
            return LOOT_TABLE;
        }

        @NotNull
        public final int[] getSPECIAL_VARIANTS() {
            return SPECIAL_VARIANTS;
        }

        private final int makeVariant(Type size, EnumDyeColor pattern, EnumDyeColor bodyColor) {
            return size.getPrimary() & 0xFF | (size.getSecondary() & 0xFF) << 8 | (pattern.func_176765_a() & 0xFF) << 16 | (bodyColor.func_176765_a() & 0xFF) << 24;
        }

        @NotNull
        public final EnumDyeColor getBodyDyeColor(int variant) {
            EnumDyeColor enumDyeColor = EnumDyeColor.func_176764_b((int)this.getBodyColor(variant));
            Intrinsics.checkExpressionValueIsNotNull((Object)enumDyeColor, (String)"EnumDyeColor.byMetadata(getBodyColor(variant))");
            return enumDyeColor;
        }

        private final int getBodyColor(int variant) {
            return (variant & 0xFF0000) >> 16;
        }

        @NotNull
        public final EnumDyeColor getPatternDyeColor(int variant) {
            EnumDyeColor enumDyeColor = EnumDyeColor.func_176764_b((int)this.getPatternColor(variant));
            Intrinsics.checkExpressionValueIsNotNull((Object)enumDyeColor, (String)"EnumDyeColor.byMetadata(getPatternColor(variant))");
            return enumDyeColor;
        }

        private final int getPatternColor(int variant) {
            return (variant & 0xFF000000) >> 24;
        }

        @NotNull
        public final String getTranslationPrefixSpecial(int variant) {
            return "entity.minecraft.tropical_fish.predefined." + variant;
        }

        @NotNull
        public final String getTranslationPrefix(int variant) {
            int i2 = this.getBody(variant);
            int j = this.getPattern(variant);
            StringBuilder stringBuilder = new StringBuilder().append("entity.futuremc.tropical_fish.type.");
            this.getTranslation(i2, j);
            return stringBuilder.append(Unit.INSTANCE).toString();
        }

        private final int getBody(int variant) {
            return RangesKt.coerceAtMost((int)(variant & 0xFF), (int)1);
        }

        private final int getPattern(int variant) {
            return RangesKt.coerceAtMost((int)((variant & 0xFF00) >> 8), (int)5);
        }

        private final void getTranslation(int i2, int j) {
            String string = Type.values()[i2 + 6 * j].name();
            Locale locale = Locale.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
            Locale locale2 = locale;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.toLowerCase(locale2), (String)"(this as java.lang.String).toLowerCase(locale)");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

