/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.core.inventory;

import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010)\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004:\u0001/B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u000fJ\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u001c\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0013\u001a\u00020\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0011\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0007H\u0086\u0002J\u0006\u0010\u001f\u001a\u00020\u0007J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010!\u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J \u0010#\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0018\u0010%\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0005H\u0016J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050'H\u0096\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J \u0010)\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u000e\u0010*\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0007J\b\u0010+\u001a\u00020\u0003H\u0016J\u0019\u0010,\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010.\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0005H\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u00060"}, d2={"Lthedarkcolour/core/inventory/FInventory;", "Lnet/minecraftforge/items/IItemHandlerModifiable;", "Lnet/minecraftforge/common/util/INBTSerializable;", "Lnet/minecraft/nbt/NBTTagCompound;", "", "Lnet/minecraft/item/ItemStack;", "size", "", "(I)V", "stacks", "", "[Lnet/minecraft/item/ItemStack;", "anyMatch", "", "predicate", "Lkotlin/Function1;", "canTakeStack", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "slot", "delegate", "Lkotlin/properties/ReadWriteProperty;", "", "deserializeNBT", "", "tag", "extractItem", "amount", "simulate", "get", "index", "getSize", "getSlotLimit", "getSlots", "getStackInSlot", "insertItem", "stack", "isItemValid", "iterator", "", "onContentsChanged", "onTake", "remove", "serializeNBT", "set", "setSize", "setStackInSlot", "DarkInventoryDelegate", "FutureMC"})
public class FInventory
implements IItemHandlerModifiable,
INBTSerializable<NBTTagCompound>,
Iterable<ItemStack>,
KMappedMarker {
    @JvmField
    @NotNull
    protected ItemStack[] stacks;

    private final void setSize(int size) {
        if (size == this.stacks.length) {
            Arrays.fill(this.stacks, ItemStack.field_190927_a);
        } else {
            ItemStack[] itemStackArray;
            FInventory fInventory = this;
            ItemStack[] itemStackArray2 = new ItemStack[size];
            int n = 0;
            while (n < size) {
                ItemStack itemStack;
                int n2 = n;
                int n3 = n++;
                itemStackArray = itemStackArray2;
                boolean bl = false;
                itemStackArray[n3] = itemStack = ItemStack.field_190927_a;
            }
            itemStackArray = itemStackArray2;
            fInventory.stacks = itemStackArray;
        }
    }

    public final int getSize() {
        return this.stacks.length;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        this.stacks[slot] = stack;
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.stacks.length;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.stacks[slot];
    }

    @NotNull
    public final ItemStack get(int index) {
        return this.stacks[index];
    }

    public final void set(int index, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        this.stacks[index] = stack;
        this.onContentsChanged(index);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack itemStack;
        boolean reachedLimit;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (stack.func_190926_b() || !this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack existing = this.stacks[slot];
        int limit = this.getSlotLimit(slot);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                Intrinsics.checkExpressionValueIsNotNull((Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack), (String)"if (reachedLimit) ItemHa\u2026(stack, limit) else stack");
                this.stacks[slot] = this.stacks[slot];
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        if (reachedLimit) {
            ItemStack itemStack2 = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit));
            itemStack = itemStack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemHandlerHelper.copySt\u2026ack, stack.count - limit)");
        } else {
            ItemStack itemStack3 = ItemStack.field_190927_a;
            itemStack = itemStack3;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"ItemStack.EMPTY");
        }
        return itemStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack itemStack;
        if (amount == 0) {
            ItemStack itemStack2 = ItemStack.field_190927_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"ItemStack.EMPTY");
            return itemStack2;
        }
        ItemStack existing = this.stacks[slot];
        if (existing.func_190926_b()) {
            ItemStack itemStack3 = ItemStack.field_190927_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"ItemStack.EMPTY");
            return itemStack3;
        }
        int toExtract = RangesKt.coerceAtMost((int)amount, (int)existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                Intrinsics.checkExpressionValueIsNotNull((Object)ItemStack.field_190927_a, (String)"ItemStack.EMPTY");
                this.onContentsChanged(slot);
            }
            itemStack = existing;
        } else {
            if (!simulate) {
                Intrinsics.checkExpressionValueIsNotNull((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)), (String)"ItemHandlerHelper.copySt\u2026isting.count - toExtract)");
                this.onContentsChanged(slot);
            }
            ItemStack itemStack4 = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
            itemStack = itemStack4;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack4, (String)"ItemHandlerHelper.copySt\u2026Size(existing, toExtract)");
        }
        return itemStack;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        int n = 0;
        int n2 = this.stacks.length;
        while (n < n2) {
            void i2;
            if (!this.stacks[i2].func_190926_b()) {
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74768_a("Slot", (int)i2);
                this.stacks[i2].func_77955_b(itemTag);
                nbtTagList.func_74742_a((NBTBase)itemTag);
            }
            ++i2;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Items", (NBTBase)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.length);
        return nbt;
    }

    /*
     * WARNING - void declaration
     */
    public void deserializeNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.setSize(tag.func_150297_b("Size", 3) ? tag.func_74762_e("Size") : this.stacks.length);
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        int n = 0;
        int n2 = tagList.func_74745_c();
        while (n < n2) {
            void i2;
            NBTTagCompound itemTags = tagList.func_150305_b((int)i2);
            int slot = itemTags.func_74762_e("Slot");
            if (slot >= 0 && slot < this.stacks.length) {
                this.stacks[slot] = new ItemStack(itemTags);
            }
            ++i2;
        }
    }

    public void onContentsChanged(int slot) {
    }

    public final void remove(int slot) {
        Intrinsics.checkExpressionValueIsNotNull((Object)ItemStack.field_190927_a, (String)"ItemStack.EMPTY");
    }

    @NotNull
    public final ReadWriteProperty<Object, ItemStack> delegate(int slot) {
        int n = slot;
        if (0 > n || this.stacks.length <= n) {
            throw (Throwable)new IllegalArgumentException("Cannot delegate to slot " + slot + ": Outside of inventory indices");
        }
        return new DarkInventoryDelegate(this, slot);
    }

    public final boolean anyMatch(@NotNull Function1<? super ItemStack, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        for (ItemStack stack : this) {
            if (!((Boolean)predicate.invoke((Object)stack)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean canTakeStack(@NotNull EntityPlayer playerIn, int slot) {
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        return true;
    }

    @NotNull
    public ItemStack onTake(@NotNull EntityPlayer playerIn, @NotNull ItemStack stack, int slot) {
        Intrinsics.checkParameterIsNotNull((Object)playerIn, (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return stack;
    }

    @Override
    @NotNull
    public Iterator<ItemStack> iterator() {
        Iterator<ItemStack> iterator = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(this.stacks, this.stacks.length)).iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"arrayListOf(*stacks).iterator()");
        return iterator;
    }

    public FInventory(int size) {
        ItemStack[] itemStackArray;
        FInventory fInventory = this;
        ItemStack[] itemStackArray2 = new ItemStack[size];
        int n = 0;
        while (n < size) {
            ItemStack itemStack;
            int n2 = n;
            int n3 = n++;
            itemStackArray = itemStackArray2;
            boolean bl = false;
            itemStackArray[n3] = itemStack = ItemStack.field_190927_a;
        }
        itemStackArray = itemStackArray2;
        fInventory.stacks = itemStackArray;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0096\u0002J'\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lthedarkcolour/core/inventory/FInventory$DarkInventoryDelegate;", "Lkotlin/properties/ReadWriteProperty;", "", "Lnet/minecraft/item/ItemStack;", "inventory", "Lthedarkcolour/core/inventory/FInventory;", "slot", "", "(Lthedarkcolour/core/inventory/FInventory;I)V", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "setValue", "", "value", "FutureMC"})
    private static final class DarkInventoryDelegate
    implements ReadWriteProperty<Object, ItemStack> {
        private final FInventory inventory;
        private final int slot;

        @NotNull
        public ItemStack getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
            Intrinsics.checkParameterIsNotNull(property, (String)"property");
            return this.inventory.get(this.slot);
        }

        public void setValue(@Nullable Object thisRef, @NotNull KProperty<?> property, @NotNull ItemStack value) {
            Intrinsics.checkParameterIsNotNull(property, (String)"property");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.inventory.set(this.slot, value);
        }

        public DarkInventoryDelegate(@NotNull FInventory inventory2, int slot) {
            Intrinsics.checkParameterIsNotNull((Object)inventory2, (String)"inventory");
            this.inventory = inventory2;
            this.slot = slot;
        }
    }
}

