/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.core.block;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.config.FConfig;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lthedarkcolour/core/block/FBlock;", "Lnet/minecraft/block/Block;", "properties", "Lthedarkcolour/core/block/FBlock$Properties;", "(Lthedarkcolour/core/block/FBlock$Properties;)V", "isBeaconBase", "", "shape", "Lnet/minecraft/util/math/AxisAlignedBB;", "getBoundingBox", "state", "Lnet/minecraft/block/state/IBlockState;", "worldIn", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "worldObj", "beacon", "toString", "", "Companion", "Properties", "FutureMC"})
public class FBlock
extends Block {
    private final AxisAlignedBB shape;
    private final boolean isBeaconBase;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return this.shape;
    }

    @NotNull
    public String toString() {
        return ((Object)((Object)this)).getClass().getCanonicalName() + '{' + this.getRegistryName() + '}';
    }

    public boolean isBeaconBase(@NotNull IBlockAccess worldObj, @NotNull BlockPos pos, @NotNull BlockPos beacon) {
        Intrinsics.checkParameterIsNotNull((Object)worldObj, (String)"worldObj");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)beacon, (String)"beacon");
        return this.isBeaconBase;
    }

    /*
     * WARNING - void declaration
     */
    public FBlock(@NotNull Properties properties) {
        CreativeTabs creativeTabs;
        Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
        super(properties.getMaterial(), properties.getColor());
        this.isBeaconBase = properties.isBeaconBase();
        this.func_149663_c("futuremc." + properties.getRegistryName());
        this.setRegistryName(new ResourceLocation("futuremc", properties.getRegistryName()));
        this.field_149762_H = properties.getSound();
        this.field_149782_v = properties.getHardness();
        this.field_149781_w = properties.getResistance();
        this.field_149784_t = properties.getLight();
        this.field_149789_z = properties.getRandomTick();
        this.field_149765_K = properties.getSlipperiness();
        AxisAlignedBB axisAlignedBB = properties.getShape();
        if (axisAlignedBB == null) {
            AxisAlignedBB axisAlignedBB2 = Block.field_185505_j;
            axisAlignedBB = axisAlignedBB2;
            Intrinsics.checkExpressionValueIsNotNull((Object)axisAlignedBB2, (String)"FULL_BLOCK_AABB");
        }
        this.shape = axisAlignedBB;
        if (FConfig.INSTANCE.getUseVanillaCreativeTabs()) {
            void var2_2;
            CreativeTabs group = properties.getGroup();
            if (group == null && FutureMC.DEBUG) {
                FutureMC.LOGGER.debug("No creative tab for block " + this.toString());
            }
            creativeTabs = var2_2;
        } else {
            creativeTabs = FutureMC.INSTANCE.getGROUP();
        }
        this.func_149647_a(creativeTabs);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010@\u001a\u00020\u0000J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020AJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010B\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010.\u001a\u00020\u0015J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J\u000e\u00101\u001a\u00020\u00002\u0006\u00101\u001a\u000202J\u000e\u00107\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0015J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010:\u001a\u00020;J\u0006\u0010C\u001a\u00020\u0000J\u0006\u0010D\u001a\u00020\u0000R\"\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001c\"\u0004\b+\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0017\"\u0004\b0\u0010\u0019R\u001c\u00101\u001a\u0004\u0018\u000102X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0017\"\u0004\b9\u0010\u0019R\"\u0010:\u001a\n \t*\u0004\u0018\u00010;0;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u00a8\u0006E"}, d2={"Lthedarkcolour/core/block/FBlock$Properties;", "", "material", "Lnet/minecraft/block/material/Material;", "registryName", "", "(Lnet/minecraft/block/material/Material;Ljava/lang/String;)V", "color", "Lnet/minecraft/block/material/MapColor;", "kotlin.jvm.PlatformType", "getColor", "()Lnet/minecraft/block/material/MapColor;", "setColor", "(Lnet/minecraft/block/material/MapColor;)V", "group", "Lnet/minecraft/creativetab/CreativeTabs;", "getGroup", "()Lnet/minecraft/creativetab/CreativeTabs;", "setGroup", "(Lnet/minecraft/creativetab/CreativeTabs;)V", "hardness", "", "getHardness", "()F", "setHardness", "(F)V", "isBeaconBase", "", "()Z", "setBeaconBase", "(Z)V", "light", "", "getLight", "()I", "setLight", "(I)V", "getMaterial", "()Lnet/minecraft/block/material/Material;", "setMaterial", "(Lnet/minecraft/block/material/Material;)V", "randomTick", "getRandomTick", "setRandomTick", "getRegistryName", "()Ljava/lang/String;", "resistance", "getResistance", "setResistance", "shape", "Lnet/minecraft/util/math/AxisAlignedBB;", "getShape", "()Lnet/minecraft/util/math/AxisAlignedBB;", "setShape", "(Lnet/minecraft/util/math/AxisAlignedBB;)V", "slipperiness", "getSlipperiness", "setSlipperiness", "sound", "Lnet/minecraft/block/SoundType;", "getSound", "()Lnet/minecraft/block/SoundType;", "setSound", "(Lnet/minecraft/block/SoundType;)V", "breakInstantly", "Lnet/minecraft/item/EnumDyeColor;", "hardnessAndResistance", "tickRandomly", "usableBeaconBase", "FutureMC"})
    public static final class Properties {
        private MapColor color;
        @Nullable
        private CreativeTabs group;
        private float hardness;
        private float resistance;
        private int light;
        private SoundType sound;
        private boolean randomTick;
        private float slipperiness;
        @Nullable
        private AxisAlignedBB shape;
        private boolean isBeaconBase;
        @NotNull
        private Material material;
        @NotNull
        private final String registryName;

        public final MapColor getColor() {
            return this.color;
        }

        public final void setColor(MapColor mapColor) {
            this.color = mapColor;
        }

        @Nullable
        public final CreativeTabs getGroup() {
            return this.group;
        }

        public final void setGroup(@Nullable CreativeTabs creativeTabs) {
            this.group = creativeTabs;
        }

        public final float getHardness() {
            return this.hardness;
        }

        public final void setHardness(float f) {
            this.hardness = f;
        }

        public final float getResistance() {
            return this.resistance;
        }

        public final void setResistance(float f) {
            this.resistance = f;
        }

        public final int getLight() {
            return this.light;
        }

        public final void setLight(int n) {
            this.light = n;
        }

        public final SoundType getSound() {
            return this.sound;
        }

        public final void setSound(SoundType soundType) {
            this.sound = soundType;
        }

        public final boolean getRandomTick() {
            return this.randomTick;
        }

        public final void setRandomTick(boolean bl) {
            this.randomTick = bl;
        }

        public final float getSlipperiness() {
            return this.slipperiness;
        }

        public final void setSlipperiness(float f) {
            this.slipperiness = f;
        }

        @Nullable
        public final AxisAlignedBB getShape() {
            return this.shape;
        }

        public final void setShape(@Nullable AxisAlignedBB axisAlignedBB) {
            this.shape = axisAlignedBB;
        }

        public final boolean isBeaconBase() {
            return this.isBeaconBase;
        }

        public final void setBeaconBase(boolean bl) {
            this.isBeaconBase = bl;
        }

        @NotNull
        public final Properties color(@NotNull MapColor color) {
            Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
            this.color = color;
            return this;
        }

        @NotNull
        public final Properties color(@NotNull EnumDyeColor color) {
            Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
            this.color = MapColor.func_193558_a((EnumDyeColor)color);
            return this;
        }

        @NotNull
        public final Properties group(@NotNull CreativeTabs group) {
            Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
            this.group = group;
            return this;
        }

        @NotNull
        public final Properties hardnessAndResistance(float hardness, float resistance) {
            this.hardness = hardness;
            this.resistance = resistance;
            return this;
        }

        public static /* synthetic */ Properties hardnessAndResistance$default(Properties properties, float f, float f2, int n, Object object) {
            if ((n & 2) != 0) {
                f2 = f;
            }
            return properties.hardnessAndResistance(f, f2);
        }

        @NotNull
        public final Properties breakInstantly() {
            this.hardnessAndResistance(0.0f, 0.0f);
            return this;
        }

        @NotNull
        public final Properties light(int light) {
            int n = light;
            if (0 > n || 15 < n) {
                throw (Throwable)new IllegalArgumentException("Light value must be in 0..15");
            }
            this.light = light;
            return this;
        }

        @NotNull
        public final Properties sound(@NotNull SoundType sound) {
            Intrinsics.checkParameterIsNotNull((Object)sound, (String)"sound");
            this.sound = sound;
            return this;
        }

        @NotNull
        public final Properties tickRandomly() {
            this.randomTick = true;
            return this;
        }

        @NotNull
        public final Properties slipperiness(float slipperiness) {
            this.slipperiness = slipperiness;
            return this;
        }

        @NotNull
        public final Properties shape(@NotNull AxisAlignedBB shape) {
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            this.shape = shape;
            return this;
        }

        @NotNull
        public final Properties usableBeaconBase() {
            this.isBeaconBase = true;
            return this;
        }

        @NotNull
        public final Material getMaterial() {
            return this.material;
        }

        public final void setMaterial(@NotNull Material material) {
            Intrinsics.checkParameterIsNotNull((Object)material, (String)"<set-?>");
            this.material = material;
        }

        @NotNull
        public final String getRegistryName() {
            return this.registryName;
        }

        public Properties(@NotNull Material material, @NotNull String registryName) {
            Intrinsics.checkParameterIsNotNull((Object)material, (String)"material");
            Intrinsics.checkParameterIsNotNull((Object)registryName, (String)"registryName");
            this.material = material;
            this.registryName = registryName;
            this.color = this.material.func_151565_r();
            this.hardness = 3.0f;
            this.resistance = 3.0f;
            this.sound = SoundType.field_185851_d;
            this.slipperiness = 0.6f;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lthedarkcolour/core/block/FBlock$Companion;", "", "()V", "cube", "Lnet/minecraft/util/math/AxisAlignedBB;", "startX", "", "startY", "startZ", "endX", "endY", "endZ", "FutureMC"})
    public static final class Companion {
        @NotNull
        public final AxisAlignedBB cube(double startX, double startY, double startZ, double endX, double endY, double endZ) {
            return new AxisAlignedBB(startX / 16.0, startY / 16.0, startZ / 16.0, endX / 16.0, endY / 16.0, endZ / 16.0);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

