/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.item;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.item.ItemBase;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.compat.crafttweaker.CraftTweakerUtils;
import com.blakebr0.extendedcrafting.compat.jei.CompatJEI;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.lib.IExtendedTable;
import com.blakebr0.extendedcrafting.tile.TileEnderCrafter;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class ItemRecipeMaker
extends ItemBase
implements IEnableable {
    private static final String NEW_LINE = System.lineSeparator() + "\t";

    public ItemRecipeMaker() {
        super("ec.recipe_maker");
        this.func_77637_a(ExtendedCrafting.CREATIVE_TAB);
        this.func_77625_d(1);
        this.func_77627_a(true);
        if (Loader.isModLoaded((String)"jei") && this.isEnabled()) {
            CompatJEI.items.add((Item)this);
        }
    }

    public boolean isEnabled() {
        return ModConfig.confRMEnabled;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            NBTHelper.setBoolean((ItemStack)stack, (String)"Shapeless", (boolean)false);
            items.add((Object)stack);
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IExtendedTable) {
            if (world.field_72995_K && this.setClipboard((IExtendedTable)tile, stack)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.ec.copied_recipe", new Object[0]));
                if (ModConfig.confRMNBT && !Loader.isModLoaded((String)"crafttweaker")) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.ec.nbt_requires_crafttweaker", new Object[0]));
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            NBTHelper.flipBoolean((ItemStack)stack, (String)"Shapeless");
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.ec.changed_mode", new Object[]{this.getModeString(stack)}));
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(Utils.localize((String)"tooltip.ec.mode", (Object[])new Object[]{this.getModeString(stack)}));
    }

    private boolean setClipboard(IExtendedTable table, ItemStack stack) {
        if (Desktop.isDesktopSupported()) {
            StringBuilder string = new StringBuilder("mods.extendedcrafting.").append(table instanceof TileEnderCrafter ? "EnderCrafting" : "TableCrafting");
            if (this.isShapeless(stack)) {
                string.append(".addShapeless(0, <>, [").append(this.makeItemArrayShapeless(table));
            } else {
                string.append(".addShaped(0, <>, [").append(NEW_LINE).append(this.makeItemArrayShaped(table));
            }
            string.append("]);");
            StringSelection stringSelection = new StringSelection(string.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
            return true;
        }
        return false;
    }

    private String makeItemArrayShaped(IExtendedTable table) {
        StringBuilder string = new StringBuilder();
        NonNullList<ItemStack> matrix = table.getMatrix();
        for (int i = 0; i < matrix.size(); ++i) {
            int[] oreIds;
            int sr = (int)Math.sqrt(matrix.size());
            if (i == 0 || i % sr == 0) {
                string.append("[");
            }
            ItemStack stack = (ItemStack)matrix.get(i);
            String item = "";
            if (ModConfig.confRMOredict && !stack.func_190926_b() && (oreIds = OreDictionary.getOreIDs((ItemStack)stack)).length > 0) {
                item = "ore:" + OreDictionary.getOreName((int)oreIds[0]);
            }
            if (item.isEmpty()) {
                String reg = Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString();
                String string2 = item = stack.func_190926_b() ? "null" : reg;
                if (!stack.func_190926_b() && stack.func_77960_j() > 0) {
                    item = item + ":" + stack.func_77960_j();
                }
            }
            if (!item.equalsIgnoreCase("null")) {
                string.append("<").append(item).append(">");
                if (ModConfig.confRMNBT && !stack.func_190926_b() && stack.func_77942_o() && Loader.isModLoaded((String)"crafttweaker")) {
                    NBTBase nbt = stack.serializeNBT().func_74781_a("tag");
                    String tag = CraftTweakerUtils.writeTag(nbt);
                    string.append(".withTag(").append(tag).append(")");
                }
            } else {
                string.append(item);
            }
            if ((i + 1) % sr != 0) {
                string.append(", ");
            }
            if (i + 1 != sr && (i + 1) % sr != 0) continue;
            string.append("]");
            if (i + 1 < matrix.size()) {
                string.append(", ");
                string.append(NEW_LINE);
                continue;
            }
            string.append(System.lineSeparator());
        }
        return string.toString();
    }

    private String makeItemArrayShapeless(IExtendedTable table) {
        StringBuilder string = new StringBuilder();
        NonNullList<ItemStack> matrix = table.getMatrix();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int lastSlot = 0;
        for (int i = 0; i < matrix.size(); ++i) {
            ItemStack stack = (ItemStack)matrix.get(i);
            if (stack.func_190926_b()) continue;
            slots.add(i);
            lastSlot = i;
        }
        Iterator iterator = slots.iterator();
        while (iterator.hasNext()) {
            String item;
            int i = (Integer)iterator.next();
            ItemStack stack = (ItemStack)matrix.get(i);
            int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack);
            if (ModConfig.confRMOredict && oreIds.length > 0) {
                item = "ore:" + OreDictionary.getOreName((int)oreIds[0]);
            } else {
                String reg = Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString();
                String string2 = item = stack.func_190926_b() ? "null" : reg;
                if (!stack.func_190926_b() && stack.func_77960_j() > 0) {
                    item = item + ":" + stack.func_77960_j();
                }
            }
            string.append("<").append(item).append(">");
            if (ModConfig.confRMNBT && !stack.func_190926_b() && stack.func_77942_o() && Loader.isModLoaded((String)"crafttweaker")) {
                NBTBase nbt = stack.serializeNBT().func_74781_a("tag");
                String tag = CraftTweakerUtils.writeTag(nbt);
                string.append(".withTag(").append(tag).append(")");
            }
            if (i == lastSlot) continue;
            string.append(", ");
        }
        return string.toString();
    }

    private String getModeString(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        boolean shapeless = tag != null && tag.func_74764_b("Shapeless") && tag.func_74767_n("Shapeless");
        return shapeless ? "Shapeless" : "Shaped";
    }

    private boolean isShapeless(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b("Shapeless") && tag.func_74767_n("Shapeless");
    }
}

