/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.compat.crafttweaker.CraftTweakerUtils;
import com.blakebr0.extendedcrafting.crafting.table.ITieredRecipe;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeManager;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShaped;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShapeless;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extendedcrafting.TableCrafting")
public class TableCrafting {
    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        TableCrafting.addShaped(0, output, ingredients);
    }

    @ZenMethod
    public static void addShaped(int tier, IItemStack output, IIngredient[][] ingredients) {
        CraftTweakerAPI.apply((IAction)new Add(TableCrafting.makeShaped(tier, output, ingredients)));
    }

    @ZenMethod
    public static void addShapedMirrored(IItemStack output, IIngredient[][] ingredients) {
        TableCrafting.addShapedMirrored(0, output, ingredients);
    }

    @ZenMethod
    public static void addShapedMirrored(int tier, IItemStack output, IIngredient[][] ingredients) {
        TableRecipeShaped recipe = TableCrafting.makeShaped(tier, output, ingredients);
        CraftTweakerAPI.apply((IAction)new Add(recipe.setMirrored(true)));
    }

    private static TableRecipeShaped makeShaped(int tier, IItemStack output, IIngredient[][] ingredients) {
        if (tier > 4 || tier < 0) {
            CraftTweakerAPI.getLogger().logError("Unable to assign a tier to the Table Recipe for stack " + output.getDisplayName() + ". Tier cannot be greater than 4 or less than 0.");
            tier = 0;
        }
        int rows = ingredients.length;
        int columns = 0;
        for (IIngredient[] row : ingredients) {
            if (columns >= row.length) continue;
            columns = row.length;
        }
        NonNullList input = NonNullList.func_191197_a((int)(rows * columns), (Object)Ingredient.field_193370_a);
        HashMap<Integer, Function<ItemStack, ItemStack>> transformers = new HashMap<Integer, Function<ItemStack, ItemStack>>();
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < ingredients[row].length; ++column) {
                IIngredient iing = ingredients[row][column];
                Ingredient ing = CraftTweakerUtils.toIngredient(iing);
                input.set(row * columns + column, (Object)ing);
                if (ing == Ingredient.field_193370_a || !iing.hasNewTransformers()) continue;
                transformers.put(row * columns + column, stack -> {
                    IItemStack istack = iing.applyNewTransform(CraftTweakerMC.getIItemStack((ItemStack)stack));
                    return CraftTweakerMC.getItemStack((IItemStack)istack);
                });
            }
        }
        TableRecipeShaped recipe = new TableRecipeShaped(tier, CraftTweakerMC.getItemStack((IItemStack)output), columns, rows, (NonNullList<Ingredient>)input).withTransformers(transformers);
        return recipe;
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        TableCrafting.addShapeless(0, output, ingredients);
    }

    @ZenMethod
    public static void addShapeless(int tier, IItemStack output, IIngredient[] ingredients) {
        if (tier > 4 || tier < 0) {
            CraftTweakerAPI.getLogger().logError("Unable to assign a tier to the Table Recipe for stack " + output.getDisplayName() + ". Tier cannot be greater than 4 or less than 0.");
            tier = 0;
        }
        NonNullList input = NonNullList.func_191197_a((int)ingredients.length, (Object)Ingredient.field_193370_a);
        HashMap<Integer, Function<ItemStack, ItemStack>> transformers = new HashMap<Integer, Function<ItemStack, ItemStack>>();
        for (int i = 0; i < ingredients.length; ++i) {
            IIngredient iing = ingredients[i];
            Ingredient ing = CraftTweakerUtils.toIngredient(iing);
            input.set(i, (Object)ing);
            if (ing == Ingredient.field_193370_a || !iing.hasNewTransformers()) continue;
            transformers.put(i, stack -> {
                IItemStack istack = iing.applyNewTransform(CraftTweakerMC.getIItemStack((ItemStack)stack));
                return CraftTweakerMC.getItemStack((IItemStack)istack);
            });
        }
        CraftTweakerAPI.apply((IAction)new Add(new TableRecipeShapeless(tier, CraftTweakerMC.getItemStack((IItemStack)output), (NonNullList<Ingredient>)input).withTransforms(transformers)));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerMC.getItemStack((IItemStack)target)));
    }

    private static class Add
    implements IAction {
        final ITieredRecipe recipe;

        public Add(ITieredRecipe add) {
            this.recipe = add;
        }

        public void apply() {
            TableRecipeManager.getInstance().getRecipes().add(this.recipe);
        }

        public String describe() {
            return "Adding a Table Crafting recipe for " + this.recipe.func_77571_b().func_82833_r();
        }
    }

    private static class Remove
    implements IAction {
        final ItemStack remove;

        public Remove(ItemStack remove) {
            this.remove = remove;
        }

        public void apply() {
            TableRecipeManager.getInstance().removeRecipes(this.remove);
        }

        public String describe() {
            return "Removing all Table Crafting recipes for " + this.remove.func_82833_r();
        }
    }
}

