/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.compat.crafttweaker.CraftTweakerUtils;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipe;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipeManager;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extendedcrafting.CombinationCrafting")
public class CombinationCrafting {
    @ZenMethod
    public static void addRecipe(IItemStack output, long cost, IItemStack input, IIngredient[] ingredients) {
        CraftTweakerAPI.apply((IAction)new Add(new CombinationRecipe(CraftTweakerMC.getItemStack((IItemStack)output), cost, CraftTweakerUtils.toIngredient((IIngredient)input), CraftTweakerUtils.toIngredients(ingredients))));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, long cost, int perTick, IItemStack input, IIngredient[] ingredients) {
        CraftTweakerAPI.apply((IAction)new Add(new CombinationRecipe(CraftTweakerMC.getItemStack((IItemStack)output), cost, perTick, CraftTweakerUtils.toIngredient((IIngredient)input), CraftTweakerUtils.toIngredients(ingredients))));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerMC.getItemStack((IItemStack)target)));
    }

    private static class Add
    implements IAction {
        final CombinationRecipe recipe;

        public Add(CombinationRecipe add) {
            this.recipe = add;
        }

        public void apply() {
            CombinationRecipeManager.getInstance().getRecipes().add(this.recipe);
        }

        public String describe() {
            return "Adding a Combination Crafting recipe for " + this.recipe.getOutput().func_82833_r();
        }
    }

    private static class Remove
    implements IAction {
        final ItemStack remove;

        public Remove(ItemStack remove) {
            this.remove = remove;
        }

        public void apply() {
            CombinationRecipeManager.getInstance().removeRecipes(this.remove);
        }

        public String describe() {
            return "Removing all Combination Crafting recipes for " + this.remove.func_82833_r();
        }
    }
}

