/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.world;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class MeteorWorldSaveData
extends WorldSavedData {
    private static final String DATA_NAME = "taiga_meteors";
    private List<BlockPos> posList;

    public MeteorWorldSaveData() {
        super(DATA_NAME);
    }

    public MeteorWorldSaveData(String name) {
        super(name);
    }

    public static MeteorWorldSaveData getForWorld(World world) {
        MapStorage storage = world.getPerWorldStorage();
        MeteorWorldSaveData instance = (MeteorWorldSaveData)storage.func_75742_a(MeteorWorldSaveData.class, DATA_NAME);
        if (instance == null) {
            instance = new MeteorWorldSaveData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    public List<BlockPos> getPosList() {
        return this.posList;
    }

    public void addPos(BlockPos pos) {
        if (this.posList == null) {
            this.posList = new ArrayList<BlockPos>();
        }
        this.posList.add(pos);
    }

    public boolean removePos(BlockPos pos) {
        return this.posList != null && this.posList.remove(pos);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("posData") && !nbt.func_74779_i("posData").isEmpty()) {
            this.posList = (List)new Gson().fromJson(nbt.func_74779_i("posData"), new TypeToken<List<BlockPos>>(){}.getType());
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        if (this.posList == null) {
            return null;
        }
        compound.func_74778_a("posData", new Gson().toJson(this.posList));
        return compound;
    }
}

