/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.util;

import com.google.common.base.Predicate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StateMatcher
implements Predicate<IBlockState> {
    private final IBlockState state;
    private final IProperty property;
    private final Comparable value;

    private StateMatcher(IBlockState state, IProperty property, Comparable value) {
        this.state = state;
        this.property = property;
        this.value = value;
    }

    static StateMatcher forState(IBlockState state, IProperty property, Comparable value) {
        return new StateMatcher(state, property, value);
    }

    public boolean apply(IBlockState state, BlockPos pos, World world) {
        if (state != null) {
            if (this.property != null && this.value != null) {
                if (state.func_177230_c() == this.state.func_177230_c()) {
                    return this.checkLayerForBlocks(3, 3, -1, world, pos) || this.checkLayerForBlocks(3, 3, 0, world, pos) || this.checkLayerForBlocks(3, 3, 1, world, pos);
                }
            } else {
                return state.func_177230_c() == this.state.func_177230_c();
            }
        }
        return false;
    }

    public boolean apply(IBlockState input) {
        if (this.state != null) {
            if (this.property != null && this.value != null) {
                return this.state.func_177230_c() == this.state.func_177230_c() && this.state.func_177229_b(this.property) == this.value;
            }
            return this.state.func_177230_c() == this.state.func_177230_c();
        }
        return false;
    }

    private boolean checkLayerForBlocks(int X, int Z, int Y, World world, BlockPos origin) {
        int x = 0;
        int z = 0;
        int dx = 0;
        int dz = -1;
        int t = Math.max(X, Z);
        int maxI = t * t;
        for (int i = 0; i < maxI; ++i) {
            if (-X / 2 <= x && x <= X / 2 && -Z / 2 <= z && z <= Z / 2) {
                BlockPos blockPos = new BlockPos(origin.func_177958_n() + x, origin.func_177956_o() + Y, origin.func_177952_p() + z);
                if (blockPos == origin || i % 2 == 0) continue;
                IBlockState bState = world.func_180495_p(blockPos);
                if (bState.func_177230_c() == this.state.func_177230_c() && bState.func_177229_b(this.property) == this.value) {
                    return true;
                }
            }
            if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                t = dx;
                dx = -dz;
                dz = t;
            }
            x += dx;
            z += dz;
        }
        return false;
    }
}

