/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import com.sosnitzka.taiga.util.Utils;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitSoulEater
extends AbstractTrait {
    public TraitSoulEater() {
        super(TraitSoulEater.class.getSimpleName().toLowerCase().substring(5), TextFormatting.RED);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTargetKilled(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntity() instanceof EntityLiving) {
            World w = event.getSource().func_76346_g().field_70170_p;
            ItemStack tool = ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca();
            if (!w.field_72995_K && TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier)) {
                NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
                Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
                float health = ((EntityLiving)event.getEntity()).func_110138_aP();
                ++data.killcount;
                data.health = health;
                float divisor = 25000.0f;
                float bonus = (float)Math.round(random.nextFloat() * health * 100.0f) / divisor;
                data.bonus += bonus;
                data.bonus = (float)Math.round(data.bonus * 100.0f) / 100.0f;
                data.write(tag);
                TagUtil.setExtraTag((ItemStack)tool, (NBTTagCompound)tag);
            }
        }
    }

    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
        Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
        float bonus = data.bonus;
        return newDamage + bonus;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        ItemStack tool = e.getItemStack();
        if (TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier)) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
            if (data.killcount != 0) {
                e.getToolTip().add(TextFormatting.WHITE + "Killed: " + TextFormatting.WHITE + data.killcount);
                e.getToolTip().add(TextFormatting.WHITE + "Bonus: " + TextFormatting.WHITE + data.bonus);
            }
        }
    }
}

