/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import com.google.common.collect.ImmutableList;
import com.sosnitzka.taiga.traits.TraitProgressiveStats;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;

public class TraitDecay
extends TraitProgressiveStats {
    protected static int TICK_PER_STAT = 24;
    protected static int DURABILITY_STEP = 1;
    protected static float SPEED_STEP = 0.05f;
    protected static float ATTACK_STEP = 0.05f;

    public TraitDecay() {
        super("decay", TextFormatting.GREEN);
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        if (!this.hasPool(rootCompound)) {
            TraitProgressiveStats.StatNBT data = new TraitProgressiveStats.StatNBT();
            block5: for (int statPoints = 800; statPoints > 0; --statPoints) {
                switch (random.nextInt(3)) {
                    case 0: {
                        data.durability += DURABILITY_STEP;
                        continue block5;
                    }
                    case 1: {
                        data.speed += SPEED_STEP;
                        continue block5;
                    }
                    case 2: {
                        data.attack += ATTACK_STEP;
                    }
                }
            }
            this.setPool(rootCompound, data);
        }
        super.applyEffect(rootCompound, modifierTag);
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof FakePlayer || entity.field_70170_p.field_72995_K || entity.field_70173_aa % TICK_PER_STAT != 0 || this.playerIsBreakingBlock(entity)) {
            return;
        }
        NBTTagCompound root = TagUtil.getTagSafe((ItemStack)tool);
        TraitProgressiveStats.StatNBT distributed = this.getBonus(root);
        ToolNBT data = TagUtil.getToolStats((ItemStack)tool);
        if (entity.field_70173_aa % (TICK_PER_STAT * 3) == 0) {
            float A = ATTACK_STEP * random.nextFloat();
            data.attack -= A;
            distributed.attack -= A;
        } else if (entity.field_70173_aa % (TICK_PER_STAT * 2) == 0) {
            float S = SPEED_STEP * random.nextFloat();
            data.speed -= S;
            distributed.speed -= S;
        } else {
            int D = random.nextInt(DURABILITY_STEP) + 1;
            data.durability -= D;
            distributed.durability -= D;
        }
        TagUtil.setToolTag((NBTTagCompound)root, (NBTTagCompound)data.get());
        this.setBonus(root, distributed);
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        TraitProgressiveStats.StatNBT pool = this.getBonus(TagUtil.getTagSafe((ItemStack)tool));
        return ImmutableList.of((Object)HeadMaterialStats.formatDurability((int)pool.durability), (Object)HeadMaterialStats.formatMiningSpeed((float)pool.speed), (Object)HeadMaterialStats.formatAttack((float)pool.attack));
    }
}

