/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import com.google.common.collect.Lists;
import com.sosnitzka.taiga.util.Utils;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitCurvature
extends AbstractTrait {
    public static int chance = 5;
    public static int distance = 10;

    public TraitCurvature() {
        super("curvature", TextFormatting.DARK_PURPLE);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        if (!event.getWorld().field_72995_K && (double)random.nextFloat() < 0.05) {
            IBlockState mainstate;
            ArrayList blockstates = Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150348_b.func_176223_P(), Blocks.field_150424_aL.func_176223_P(), Blocks.field_150377_bs.func_176223_P(), Blocks.field_150350_a.func_176223_P(), Blocks.field_150346_d.func_176223_P()});
            if (blockstates.contains(mainstate = event.getState())) {
                return;
            }
            for (int i = 0; i < chance; ++i) {
                int x = event.getPos().func_177958_n() + Utils.nextInt(random, -distance, distance);
                int y = event.getPos().func_177956_o() + Utils.nextInt(random, -distance, distance);
                int z = event.getPos().func_177952_p() + Utils.nextInt(random, -distance, distance);
                BlockPos cPos = new BlockPos(x, y, z);
                IBlockState state = event.getWorld().func_180495_p(cPos);
                if (!blockstates.contains(state)) continue;
                event.getDrops().clear();
                event.getWorld().func_175656_a(cPos, mainstate);
                event.getHarvester().func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                event.getHarvester().func_146105_b((ITextComponent)new TextComponentString("Teleported to: " + x + " " + y + " " + z), false);
                return;
            }
        }
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean wasCritical, boolean wasHit) {
        if ((double)random.nextFloat() <= 0.15) {
            target.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            this.changePos(player, target);
        }
    }

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        World w = event.getEntity().func_130014_f_();
        if (!w.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (event.getEntity() instanceof EntityMob && TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)player.func_184614_ca()), (String)this.identifier)) {
                ItemStack i = new ItemStack(Items.field_151079_bi, random.nextInt(2));
                event.getDrops().add(0, new EntityItem(w, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, i));
            }
        }
    }

    private void changePos(EntityLivingBase player, EntityLivingBase target) {
        BlockPos pp = new BlockPos((Vec3i)player.func_180425_c());
        BlockPos tp = new BlockPos((Vec3i)target.func_180425_c());
        player.func_70107_b((double)tp.func_177958_n(), (double)tp.func_177956_o(), (double)tp.func_177952_p());
        target.func_70107_b((double)pp.func_177958_n(), (double)pp.func_177956_o(), (double)pp.func_177952_p());
    }
}

