/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.gui;

import com.mrcrayfish.furniture.gui.components.TextFieldComponent;
import com.mrcrayfish.furniture.gui.components.ToggleComponent;
import com.mrcrayfish.furniture.gui.components.ValueComponent;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.network.message.MessageUpdateValueContainer;
import com.mrcrayfish.furniture.tileentity.IValueContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiEditValueContainer
extends GuiScreen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("cfm:textures/gui/value_container.png");
    public static final int WIDTH = 176;
    public static final int PADDING = 10;
    public static final int VALUE_HEIGHT = 35;
    private List<ValueComponent> values = new ArrayList<ValueComponent>();
    private IValueContainer valueContainer;
    private int containerHeight;

    public GuiEditValueContainer(IValueContainer valueContainer) {
        this.valueContainer = valueContainer;
        valueContainer.getEntries().forEach(entry -> {
            if (entry.getType() != null) {
                switch (entry.getType()) {
                    case TEXT_FIELD: {
                        this.values.add(new TextFieldComponent((IValueContainer.Entry)entry));
                        break;
                    }
                    case TOGGLE: {
                        this.values.add(new ToggleComponent((IValueContainer.Entry)entry));
                    }
                }
            }
        });
        this.containerHeight = this.values.size() * 35 + 20;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        int startX = (this.field_146294_l - 176) / 2;
        int startY = (this.field_146295_m - this.containerHeight) / 2;
        this.field_146292_n.add(new GuiButton(0, startX + 176 + 5, startY + 5, 20, 20, "X"));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int startX = (this.field_146294_l - 176) / 2;
        int startY = (this.field_146295_m - this.containerHeight) / 2;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        GuiEditValueContainer.func_152125_a((int)startX, (int)startY, (float)0.0f, (float)0.0f, (int)176, (int)10, (int)176, (int)10, (float)256.0f, (float)256.0f);
        GuiEditValueContainer.func_152125_a((int)startX, (int)(startY + 10), (float)0.0f, (float)10.0f, (int)176, (int)1, (int)176, (int)(this.values.size() * 35), (float)256.0f, (float)256.0f);
        GuiEditValueContainer.func_152125_a((int)startX, (int)(startY + this.values.size() * 35 + 10), (float)0.0f, (float)10.0f, (int)176, (int)10, (int)176, (int)10, (float)256.0f, (float)256.0f);
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.get(i).render(startX + 10, startY + i * 35 + 10, mouseX, mouseY);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (ValueComponent value : this.values) {
            value.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        for (ValueComponent value : this.values) {
            value.keyTyped(typedChar, keyCode);
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageUpdateValueContainer(this.values, this.valueContainer));
    }
}

