/*
 * Decompiled with CFR 0.152.
 */
package mekanism.weapons.common.item;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.base.IModuleUpgrade;
import mekanism.common.config.MekanismConfig;
import mekanism.common.moduleUpgrade;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeHelper;
import mekanism.weapons.common.item.ItemMekaEnergyBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMekaTana
extends ItemMekaEnergyBase
implements IModuleUpgrade {
    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        return state.func_177230_c() == Blocks.field_150321_G;
    }

    public int func_77619_b() {
        return 5;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return MekanismConfig.current().weapons.mekaTanaBaseChargeRate.val();
    }

    @Override
    public List<moduleUpgrade> getValidModule(ItemStack stack) {
        ArrayList<moduleUpgrade> list = new ArrayList<moduleUpgrade>();
        list.add(moduleUpgrade.EnergyUnit);
        list.add(moduleUpgrade.ATTACK_AMPLIFICATION_UNIT);
        return list;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return MekanismUtils.getModuleMaxEnergy(itemStack, MekanismConfig.current().weapons.mekaTanaBaseEnergyCapacity.val());
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase target, EntityLivingBase attacker) {
        double energy = this.getEnergy(itemstack);
        double energyCost = MekanismConfig.current().weapons.mekaTanaEnergyUsage.val();
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            if (energy > 0.0 && !player.field_71075_bZ.field_75098_d) {
                this.setEnergy(itemstack, energy - energyCost);
            }
        }
        return true;
    }

    public int getAttackDamage(ItemStack itemStack) {
        NBTTagCompound dataMap;
        int damage = MekanismConfig.current().weapons.mekaTanaBaseDamage.val();
        int numUpgrades = UpgradeHelper.getUpgradeLevel(itemStack, moduleUpgrade.ATTACK_AMPLIFICATION_UNIT);
        if (numUpgrades == 0 && (dataMap = ItemDataUtils.getDataMap(itemStack)).func_82582_d() && itemStack.func_77978_p() != null) {
            itemStack.func_77978_p().func_82580_o("mekData");
        }
        for (int i = 0; i < numUpgrades; ++i) {
            damage += MekanismConfig.current().weapons.mekaTanaBaseDamage.val();
        }
        return damage;
    }

    public boolean func_179218_a(ItemStack itemstack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityliving) {
        this.setEnergy(itemstack, this.getEnergy(itemstack) - 200.0);
        return true;
    }

    public float func_150893_a(ItemStack itemstack, IBlockState state) {
        return this.getEnergy(itemstack) != 0.0 ? MekanismConfig.current().weapons.mekaTanaAttackSpeed.val() : super.func_150893_a(itemstack, state);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multiMap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multiMap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getAttackDamage(stack), 0));
            multiMap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)MekanismConfig.current().weapons.mekaTanaAttackSpeed.val(), 0));
        }
        return multiMap;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergy(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getEnergy(stack) / this.getMaxEnergy(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void func_150895_a(@Nonnull CreativeTabs tabs, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        ItemStack discharged = new ItemStack((Item)this);
        list.add((Object)discharged);
        ItemStack charged = new ItemStack((Item)this);
        this.setEnergy(charged, ((IEnergizedItem)charged.func_77973_b()).getMaxEnergy(charged));
        list.add((Object)charged);
        ItemStack fullupgrade = new ItemStack((Item)this);
        for (moduleUpgrade upgrade : this.getValidModule(fullupgrade)) {
            UpgradeHelper.setUpgradeLevel(fullupgrade, upgrade, upgrade.getMax());
        }
        this.setEnergy(fullupgrade, ((IEnergizedItem)fullupgrade.func_77973_b()).getMaxEnergy(fullupgrade));
        list.add((Object)fullupgrade);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        list.addAll(UpgradeHelper.getUpgradeStats(itemstack));
    }
}

