/*
 * Decompiled with CFR 0.152.
 */
package mekanism.weapons.common.item;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.EnumColor;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.base.IModuleUpgrade;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.ic2.IC2ItemManager;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.moduleUpgrade;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeHelper;
import mekanism.weapons.common.MekanismWeapons;
import mekanism.weapons.common.MekanismWeaponsItems;
import mekanism.weapons.common.entity.EntityMekaArrow;
import mekanism.weapons.common.item.ItemMekaArrow;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2"), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux")})
public class ItemMekaBow
extends ItemBow
implements IModuleUpgrade,
IEnergizedItem,
ISpecialElectricItem,
IEnergyContainerItem {
    public ItemMekaBow() {
        this.func_77625_d(1);
        this.func_77637_a(MekanismWeapons.tabMekanismWeapons);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return !(entityIn.func_184607_cu().func_77973_b() instanceof ItemMekaBow) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public static int clamp(int a, int min, int max) {
        return a < min ? min : Math.min(a, max);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return MekanismUtils.getModuleMaxEnergy(itemStack, MekanismConfig.current().weapons.mekaBowBaseEnergyCapacity.val());
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return MekanismConfig.current().weapons.mekaBowBaseChargeRate.val();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack), this.getMaxEnergy(itemstack)));
        list.addAll(UpgradeHelper.getUpgradeStats(itemstack));
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityLivingBase entityLiving, int itemUseCount) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (this.getEnergy(itemstack) > 0.0) {
                boolean flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemstack) > 0 || UpgradeHelper.isUpgradeInstalled(itemstack, moduleUpgrade.ARROWENERGY_UNIT);
                ItemStack ammo = this.func_185060_a(player);
                int charge = this.func_77626_a(itemstack) - itemUseCount;
                if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)itemstack, (World)world, (EntityPlayer)player, (int)charge, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                    return;
                }
                float drawArrowSpeedModifier = Math.min((float)charge / (float)this.getDrawTicks(itemstack), 1.0f);
                if ((double)drawArrowSpeedModifier < 0.1) {
                    return;
                }
                if (flag || !ammo.func_190926_b()) {
                    boolean noConsume;
                    if (ammo.func_190926_b()) {
                        ammo = new ItemStack((Item)MekanismWeaponsItems.mekaArrow);
                    }
                    boolean bl = noConsume = flag && itemstack.func_77973_b() instanceof ItemMekaArrow;
                    if (!world.field_72995_K) {
                        ItemMekaArrow itemarrow = ammo.func_77973_b() instanceof ItemMekaArrow ? ammo.func_77973_b() : MekanismWeaponsItems.mekaArrow;
                        int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)itemstack);
                        int punch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)itemstack);
                        boolean fire = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)itemstack) > 0;
                        int speed = this.getSpeed(itemstack);
                        float velocity = (float)speed * drawArrowSpeedModifier * 3.0f;
                        int damage = this.getDamage(itemstack);
                        for (int ArrowAmount = 0; ArrowAmount <= this.getArrowNumber(itemstack); ++ArrowAmount) {
                            EntityMekaArrow entityarrow = itemarrow.createArrow(world, itemstack, (EntityLivingBase)player);
                            entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity, 1.0f);
                            entityarrow.func_70239_b(damage);
                            if (drawArrowSpeedModifier >= 1.0f) {
                                entityarrow.func_70243_d(true);
                            }
                            if (power > 0) {
                                entityarrow.func_70239_b((double)damage + 0.5 * (double)power + 0.5);
                            }
                            if (punch > 0) {
                                entityarrow.func_70240_a(punch);
                            }
                            if (fire) {
                                entityarrow.func_70015_d(100);
                            }
                            entityarrow.setPicked(!UpgradeHelper.isUpgradeInstalled(itemstack, moduleUpgrade.ARROWENERGY_UNIT) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemstack) < 0);
                            if (noConsume || ArrowAmount > 0) {
                                entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                            }
                            world.func_72838_d((Entity)entityarrow);
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            this.setEnergy(itemstack, this.getEnergy(itemstack) - MekanismConfig.current().weapons.mekaBowEnergyUsage.val());
                        }
                    }
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + (drawArrowSpeedModifier + (float)this.getSpeed(itemstack) / 40.0f) * 0.5f);
                    if (!noConsume) {
                        ammo.func_190918_g(1);
                        if (ammo.func_190916_E() == 0) {
                            player.field_71071_by.func_184437_d(ammo);
                        }
                    }
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                }
            }
        }
    }

    public int getArrowNumber(ItemStack itemStack) {
        NBTTagCompound dataMap;
        int quantity = UpgradeHelper.getUpgradeLevel(itemStack, moduleUpgrade.MultipleArrowsUnit);
        if (quantity == 0 && (dataMap = ItemDataUtils.getDataMap(itemStack)).func_82582_d()) {
            itemStack.func_77982_d(null);
        }
        return ItemMekaBow.clamp(quantity * 2, 0, 10);
    }

    public int getSpeed(ItemStack itemStack) {
        NBTTagCompound dataMap;
        int speed = 1;
        int numUpgrades = UpgradeHelper.getUpgradeLevel(itemStack, moduleUpgrade.ARROWVELOCITY_UNIT);
        if (numUpgrades == 0 && (dataMap = ItemDataUtils.getDataMap(itemStack)).func_82582_d()) {
            itemStack.func_77982_d(null);
        }
        for (int i = 0; i < numUpgrades; ++i) {
            ++speed;
        }
        return speed;
    }

    public int getDamage(ItemStack itemStack) {
        NBTTagCompound dataMap;
        int damage = MekanismConfig.current().weapons.mekaBowBaseDamage.val();
        int numUpgrades = UpgradeHelper.getUpgradeLevel(itemStack, moduleUpgrade.ATTACK_AMPLIFICATION_UNIT);
        if (numUpgrades == 0 && (dataMap = ItemDataUtils.getDataMap(itemStack)).func_82582_d()) {
            itemStack.func_77982_d(null);
        }
        for (int i = 0; i < numUpgrades; ++i) {
            damage += MekanismConfig.current().weapons.mekaBowBaseDamage.val();
        }
        return damage;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        boolean flag;
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemStackIn, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)hand, (boolean)(flag = !this.func_185060_a(playerIn).func_190926_b() || UpgradeHelper.isUpgradeInstalled(itemStackIn, moduleUpgrade.ARROWENERGY_UNIT) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemStackIn) > 0));
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    protected boolean func_185058_h_(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemMekaArrow;
    }

    @Override
    public List<moduleUpgrade> getValidModule(ItemStack stack) {
        ArrayList<moduleUpgrade> list = new ArrayList<moduleUpgrade>();
        list.add(moduleUpgrade.EnergyUnit);
        list.add(moduleUpgrade.ATTACK_AMPLIFICATION_UNIT);
        list.add(moduleUpgrade.ARROWVELOCITY_UNIT);
        list.add(moduleUpgrade.ARROWENERGY_UNIT);
        list.add(moduleUpgrade.AUTOFIRE_UNIT);
        list.add(moduleUpgrade.DRAWSPEED_UNIT);
        list.add(moduleUpgrade.MultipleArrowsUnit);
        return list;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergy(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getEnergy(stack) / this.getMaxEnergy(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void func_150895_a(@Nonnull CreativeTabs tabs, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        ItemStack discharged = new ItemStack((Item)this);
        list.add((Object)discharged);
        ItemStack charged = new ItemStack((Item)this);
        this.setEnergy(charged, ((IEnergizedItem)charged.func_77973_b()).getMaxEnergy(charged));
        list.add((Object)charged);
        ItemStack fullupgrade = new ItemStack((Item)this);
        for (moduleUpgrade upgrade : this.getValidModule(fullupgrade)) {
            UpgradeHelper.setUpgradeLevel(fullupgrade, upgrade, upgrade.getMax());
        }
        this.setEnergy(fullupgrade, ((IEnergizedItem)fullupgrade.func_77973_b()).getMaxEnergy(fullupgrade));
        list.add((Object)fullupgrade);
        ItemStack full = new ItemStack((Item)this);
        for (moduleUpgrade upgrade : this.getValidModule(full)) {
            UpgradeHelper.setUpgradeLevel(full, upgrade, upgrade.getMax());
        }
        this.setEnergy(full, ((IEnergizedItem)full.func_77973_b()).getMaxEnergy(full));
        full.func_77966_a(Enchantments.field_185309_u, 5);
        full.func_77966_a(Enchantments.field_185310_v, 2);
        list.add((Object)full);
    }

    public int func_77619_b() {
        return 5;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min(RFIntegration.fromRF(energy), energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return RFIntegration.toRF(toReceive);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min(RFIntegration.fromRF(energy), energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return RFIntegration.toRF(toSend);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack theItem) {
        return RFIntegration.toRF(this.getEnergy(theItem));
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack theItem) {
        return RFIntegration.toRF(this.getMaxEnergy(theItem));
    }

    @Optional.Method(modid="ic2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        return ItemDataUtils.getDouble(itemStack, "energyStored");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (amount == 0.0) {
            NBTTagCompound dataMap = ItemDataUtils.getDataMap(itemStack);
            dataMap.func_82580_o("energyStored");
            if (dataMap.func_82582_d() && itemStack.func_77978_p() != null) {
                itemStack.func_77978_p().func_82580_o("mekData");
            }
        } else {
            ItemDataUtils.setDouble(itemStack, "energyStored", Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0));
        }
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) - this.getEnergy(itemStack) > 0.0;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entityLivingBase, int count) {
        if (entityLivingBase instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            int j = this.func_77626_a(stack) - count;
            if (UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.AUTOFIRE_UNIT) && j >= this.getDrawTicks(stack)) {
                player.func_184597_cx();
            }
        }
    }

    public int getDrawTicks(ItemStack stack) {
        NBTTagCompound dataMap;
        int numUpgrades = UpgradeHelper.getUpgradeLevel(stack, moduleUpgrade.DRAWSPEED_UNIT);
        if (numUpgrades == 0 && (dataMap = ItemDataUtils.getDataMap(stack)).func_82582_d()) {
            stack.func_77982_d(null);
        }
        int reduction = Math.min(numUpgrades, 4);
        double d = (double)(reduction * reduction * reduction) * 0.25;
        return (int)(20.0 / (1.0 + d));
    }
}

