/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.common.config.MekanismConfig;
import mekanism.tools.common.IHasRepairType;
import mekanism.tools.common.Materials;
import mekanism.tools.common.MekanismTools;
import mekanism.tools.item.ItemMekanismArmor;
import mekanism.tools.item.ItemMekanismAxe;
import mekanism.tools.item.ItemMekanismHoe;
import mekanism.tools.item.ItemMekanismPaxel;
import mekanism.tools.item.ItemMekanismPickaxe;
import mekanism.tools.item.ItemMekanismShield;
import mekanism.tools.item.ItemMekanismShovel;
import mekanism.tools.item.ItemMekanismSword;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum ToolsItem {
    WOOD_PAXEL("WoodPaxel", new ItemMekanismPaxel(Item.ToolMaterial.WOOD)),
    STONE_PAXEL("StonePaxel", new ItemMekanismPaxel(Item.ToolMaterial.STONE)),
    IRON_PAXEL("IronPaxel", new ItemMekanismPaxel(Item.ToolMaterial.IRON)),
    DIAMOND_PAXEL("DiamondPaxel", new ItemMekanismPaxel(Item.ToolMaterial.DIAMOND)),
    GOLD_PAXEL("GoldPaxel", new ItemMekanismPaxel(Item.ToolMaterial.GOLD)),
    GLOWSTONE_PICKAXE("GlowstonePickaxe", new ItemMekanismPickaxe(Materials.GLOWSTONE)),
    GLOWSTONE_AXE("GlowstoneAxe", new ItemMekanismAxe(Materials.GLOWSTONE)),
    GLOWSTONE_SHOVEL("GlowstoneShovel", new ItemMekanismShovel(Materials.GLOWSTONE)),
    GLOWSTONE_HOE("GlowstoneHoe", new ItemMekanismHoe(Materials.GLOWSTONE)),
    GLOWSTONE_SWORD("GlowstoneSword", new ItemMekanismSword(Materials.GLOWSTONE)),
    GLOWSTONE_PAXEL("GlowstonePaxel", new ItemMekanismPaxel(Materials.GLOWSTONE)),
    GLOWSTONE_HELMET("GlowstoneHelmet", new ItemMekanismArmor(Materials.GLOWSTONE, 0, EntityEquipmentSlot.HEAD)),
    GLOWSTONE_CHESTPLATE("GlowstoneChestplate", new ItemMekanismArmor(Materials.GLOWSTONE, 1, EntityEquipmentSlot.CHEST)),
    GLOWSTONE_LEGGINGS("GlowstoneLeggings", new ItemMekanismArmor(Materials.GLOWSTONE, 2, EntityEquipmentSlot.LEGS)),
    GLOWSTONE_BOOTS("GlowstoneBoots", new ItemMekanismArmor(Materials.GLOWSTONE, 3, EntityEquipmentSlot.FEET)),
    GLOWSTONE_SHIELD("GlowstoneShield", new ItemMekanismShield(Materials.GLOWSTONE, MekanismConfig.current().tools.toolGLOWSTONE.maxShieldUses.val())),
    BRONZE_PICKAXE("BronzePickaxe", new ItemMekanismPickaxe(Materials.BRONZE)),
    BRONZE_AXE("BronzeAxe", new ItemMekanismAxe(Materials.BRONZE)),
    BRONZE_SHOVEL("BronzeShovel", new ItemMekanismShovel(Materials.BRONZE)),
    BRONZE_HOE("BronzeHoe", new ItemMekanismHoe(Materials.BRONZE)),
    BRONZE_SWORD("BronzeSword", new ItemMekanismSword(Materials.BRONZE)),
    BRONZE_PAXEL("BronzePaxel", new ItemMekanismPaxel(Materials.BRONZE)),
    BRONZE_HELMET("BronzeHelmet", new ItemMekanismArmor(Materials.BRONZE, 0, EntityEquipmentSlot.HEAD)),
    BRONZE_CHESTPLATE("BronzeChestplate", new ItemMekanismArmor(Materials.BRONZE, 1, EntityEquipmentSlot.CHEST)),
    BRONZE_LEGGINGS("BronzeLeggings", new ItemMekanismArmor(Materials.BRONZE, 2, EntityEquipmentSlot.LEGS)),
    BRONZE_BOOTS("BronzeBoots", new ItemMekanismArmor(Materials.BRONZE, 3, EntityEquipmentSlot.FEET)),
    BRONZE_SHIELD("BronzeShield", new ItemMekanismShield(Materials.BRONZE, MekanismConfig.current().tools.toolBRONZE.maxShieldUses.val())),
    OSMIUM_PICKAXE("OsmiumPickaxe", new ItemMekanismPickaxe(Materials.OSMIUM)),
    OSMIUM_AXE("OsmiumAxe", new ItemMekanismAxe(Materials.OSMIUM)),
    OSMIUM_SHOVEL("OsmiumShovel", new ItemMekanismShovel(Materials.OSMIUM)),
    OSMIUM_HOE("OsmiumHoe", new ItemMekanismHoe(Materials.OSMIUM)),
    OSMIUM_SWORD("OsmiumSword", new ItemMekanismSword(Materials.OSMIUM)),
    OSMIUM_PAXEL("OsmiumPaxel", new ItemMekanismPaxel(Materials.OSMIUM)),
    OSMIUM_HELMET("OsmiumHelmet", new ItemMekanismArmor(Materials.OSMIUM, 0, EntityEquipmentSlot.HEAD)),
    OSMIUM_CHESTPLATE("OsmiumChestplate", new ItemMekanismArmor(Materials.OSMIUM, 1, EntityEquipmentSlot.CHEST)),
    OSMIUM_LEGGINGS("OsmiumLeggings", new ItemMekanismArmor(Materials.OSMIUM, 2, EntityEquipmentSlot.LEGS)),
    OSMIUM_BOOTS("OsmiumBoots", new ItemMekanismArmor(Materials.OSMIUM, 3, EntityEquipmentSlot.FEET)),
    OSMIUM_SHIELD("OsmiumShield", new ItemMekanismShield(Materials.OSMIUM, MekanismConfig.current().tools.toolOSMIUM.maxShieldUses.val())),
    OBSIDIAN_PICKAXE("ObsidianPickaxe", new ItemMekanismPickaxe(Materials.OBSIDIAN)),
    OBSIDIAN_AXE("ObsidianAxe", new ItemMekanismAxe(Materials.OBSIDIAN)),
    OBSIDIAN_SHOVEL("ObsidianShovel", new ItemMekanismShovel(Materials.OBSIDIAN)),
    OBSIDIAN_HOE("ObsidianHoe", new ItemMekanismHoe(Materials.OBSIDIAN)),
    OBSIDIAN_SWORD("ObsidianSword", new ItemMekanismSword(Materials.OBSIDIAN)),
    OBSIDIAN_PAXEL("ObsidianPaxel", new ItemMekanismPaxel(Materials.OBSIDIAN)),
    OBSIDIAN_HELMET("ObsidianHelmet", new ItemMekanismArmor(Materials.OBSIDIAN, 0, EntityEquipmentSlot.HEAD)),
    OBSIDIAN_CHESTPLATE("ObsidianChestplate", new ItemMekanismArmor(Materials.OBSIDIAN, 1, EntityEquipmentSlot.CHEST)),
    OBSIDIAN_LEGGINGS("ObsidianLeggings", new ItemMekanismArmor(Materials.OBSIDIAN, 2, EntityEquipmentSlot.LEGS)),
    OBSIDIAN_BOOTS("ObsidianBoots", new ItemMekanismArmor(Materials.OBSIDIAN, 3, EntityEquipmentSlot.FEET)),
    OBSIDIAN_SHIELD("ObsidianShield", new ItemMekanismShield(Materials.OBSIDIAN, MekanismConfig.current().tools.toolOBSIDIAN.maxShieldUses.val())),
    LAPIS_LAZULI_PICKAXE("LapisLazuliPickaxe", new ItemMekanismPickaxe(Materials.LAZULI)),
    LAPIS_LAZULI_AXE("LapisLazuliAxe", new ItemMekanismAxe(Materials.LAZULI)),
    LAPIS_LAZULI_SHOVEL("LapisLazuliShovel", new ItemMekanismShovel(Materials.LAZULI)),
    LAPIS_LAZULI_HOE("LapisLazuliHoe", new ItemMekanismHoe(Materials.LAZULI)),
    LAPIS_LAZULI_SWORD("LapisLazuliSword", new ItemMekanismSword(Materials.LAZULI)),
    LAPIS_LAZULI_PAXEL("LapisLazuliPaxel", new ItemMekanismPaxel(Materials.LAZULI)),
    LAPIS_LAZULI_HELMET("LapisLazuliHelmet", new ItemMekanismArmor(Materials.LAZULI, 0, EntityEquipmentSlot.HEAD)),
    LAPIS_LAZULI_CHESTPLATE("LapisLazuliChestplate", new ItemMekanismArmor(Materials.LAZULI, 1, EntityEquipmentSlot.CHEST)),
    LAPIS_LAZULI_LEGGINGS("LapisLazuliLeggings", new ItemMekanismArmor(Materials.LAZULI, 2, EntityEquipmentSlot.LEGS)),
    LAPIS_LAZULI_BOOTS("LapisLazuliBoots", new ItemMekanismArmor(Materials.LAZULI, 3, EntityEquipmentSlot.FEET)),
    LAPIS_SHIELD("LapisShield", new ItemMekanismShield(Materials.LAZULI, MekanismConfig.current().tools.toolLAZULI.maxShieldUses.val())),
    STEEL_PICKAXE("SteelPickaxe", new ItemMekanismPickaxe(Materials.STEEL)),
    STEEL_AXE("SteelAxe", new ItemMekanismAxe(Materials.STEEL)),
    STEEL_SHOVEL("SteelShovel", new ItemMekanismShovel(Materials.STEEL)),
    STEEL_HOE("SteelHoe", new ItemMekanismHoe(Materials.STEEL)),
    STEEL_SWORD("SteelSword", new ItemMekanismSword(Materials.STEEL)),
    STEEL_PAXEL("SteelPaxel", new ItemMekanismPaxel(Materials.STEEL)),
    STEEL_HELMET("SteelHelmet", new ItemMekanismArmor(Materials.STEEL, 0, EntityEquipmentSlot.HEAD)),
    STEEL_CHESTPLATE("SteelChestplate", new ItemMekanismArmor(Materials.STEEL, 1, EntityEquipmentSlot.CHEST)),
    STEEL_LEGGINGS("SteelLeggings", new ItemMekanismArmor(Materials.STEEL, 2, EntityEquipmentSlot.LEGS)),
    STEEL_BOOTS("SteelBoots", new ItemMekanismArmor(Materials.STEEL, 3, EntityEquipmentSlot.FEET)),
    STEEL_SHIELD("SteelShield", new ItemMekanismShield(Materials.STEEL, MekanismConfig.current().tools.toolSTEEL.maxShieldUses.val()));

    public static final List<ToolsItem> BRONZE_SET;
    public static final List<ToolsItem> OSMIUM_SET;
    public static final List<ToolsItem> OBSIDIAN_SET;
    public static final List<ToolsItem> GLOWSTONE_SET;
    public static final List<ToolsItem> STEEL_SET;
    public static final List<ToolsItem> LAPIS_LAZULI_SET;
    @Nonnull
    private Item item;

    private <ITEM extends Item> ToolsItem(String name, ITEM item) {
        this.item = ((Item)item.func_77655_b(name).setRegistryName(new ResourceLocation("mekanismtools", name))).func_77637_a((CreativeTabs)MekanismTools.tabMekanismTools);
    }

    @Nonnull
    public Item getItem() {
        return this.item;
    }

    private void updateItem(Item item) {
        this.item = item;
    }

    @Nonnull
    public ItemStack getRepairStack() {
        ItemStack itemStack;
        Item item = this.item;
        if (item instanceof IHasRepairType) {
            IHasRepairType type = (IHasRepairType)item;
            itemStack = type.getRepairStack();
        } else {
            itemStack = ItemStack.field_190927_a;
        }
        return itemStack;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    @Nonnull
    public ItemStack getItemStack(int size) {
        return new ItemStack(this.getItem(), size);
    }

    @Nonnull
    public ItemStack getItemStackAnyDamage() {
        return this.getItemStackAnyDamage(1);
    }

    @Nonnull
    public ItemStack getItemStackAnyDamage(int size) {
        return new ItemStack(this.getItem(), size, Short.MAX_VALUE);
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        for (ToolsItem toolsItem : ToolsItem.values()) {
            registry.register((IForgeRegistryEntry)toolsItem.getItem());
        }
    }

    public static void remapItems() {
        for (ToolsItem toolsItem : ToolsItem.values()) {
            if (toolsItem.getItemStack().func_190926_b()) continue;
            ResourceLocation registryName = toolsItem.getItem().getRegistryName();
            toolsItem.updateItem((Item)ForgeRegistries.ITEMS.getValue(registryName));
        }
    }

    static {
        BRONZE_SET = Arrays.asList(BRONZE_PICKAXE, BRONZE_AXE, BRONZE_SHOVEL, BRONZE_HOE, BRONZE_SWORD, BRONZE_PAXEL, BRONZE_HELMET, BRONZE_CHESTPLATE, BRONZE_LEGGINGS, BRONZE_BOOTS, BRONZE_SHIELD);
        OSMIUM_SET = Arrays.asList(OSMIUM_PICKAXE, OSMIUM_AXE, OSMIUM_SHOVEL, OSMIUM_HOE, OSMIUM_SWORD, OSMIUM_PAXEL, OSMIUM_HELMET, OSMIUM_CHESTPLATE, OSMIUM_LEGGINGS, OSMIUM_BOOTS, OSMIUM_SHIELD);
        OBSIDIAN_SET = Arrays.asList(OBSIDIAN_PICKAXE, OBSIDIAN_AXE, OBSIDIAN_SHOVEL, OBSIDIAN_HOE, OBSIDIAN_SWORD, OBSIDIAN_PAXEL, OBSIDIAN_HELMET, OBSIDIAN_CHESTPLATE, OBSIDIAN_LEGGINGS, OBSIDIAN_BOOTS, OBSIDIAN_SHIELD);
        GLOWSTONE_SET = Arrays.asList(GLOWSTONE_PICKAXE, GLOWSTONE_AXE, GLOWSTONE_SHOVEL, GLOWSTONE_HOE, GLOWSTONE_SWORD, GLOWSTONE_PAXEL, GLOWSTONE_HELMET, GLOWSTONE_CHESTPLATE, GLOWSTONE_LEGGINGS, GLOWSTONE_BOOTS, GLOWSTONE_SHIELD);
        STEEL_SET = Arrays.asList(STEEL_PICKAXE, STEEL_AXE, STEEL_SHOVEL, STEEL_HOE, STEEL_SWORD, STEEL_PAXEL, STEEL_HELMET, STEEL_CHESTPLATE, STEEL_LEGGINGS, STEEL_BOOTS, STEEL_SHIELD);
        LAPIS_LAZULI_SET = Arrays.asList(LAPIS_LAZULI_PICKAXE, LAPIS_LAZULI_AXE, LAPIS_LAZULI_SHOVEL, LAPIS_LAZULI_HOE, LAPIS_LAZULI_SWORD, LAPIS_LAZULI_PAXEL, LAPIS_LAZULI_HELMET, LAPIS_LAZULI_CHESTPLATE, LAPIS_LAZULI_LEGGINGS, LAPIS_LAZULI_BOOTS, LAPIS_SHIELD);
    }
}

