/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.EjectSpeedController;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.FluidTankSync;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TankProvider;
import mekanism.common.util.TileUtils;
import mekanism.multiblockmachine.client.render.bloom.machine.BloomRenderLargeChemicalWasher;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachine;
import mekanism.multiblockmachine.common.tile.machine.prefab.TileEntityMultiblockBasicMachine;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeChemicalWasher
extends TileEntityMultiblockBasicMachine<GasInput, GasOutput, WasherRecipe>
implements IGasHandler,
IFluidHandlerWrapper,
ISustainedData,
Upgrade.IUpgradeInfoHandler,
ITankManager,
IAdvancedBoundingBlock {
    public static int WATER_USAGE = 5;
    public FluidTank fluidTank = new FluidTankSync(5120000);
    public GasTank inputTank = new GasTank(0x7D0000);
    public GasTank outputTank = new GasTank(0x7D0000);
    public WasherRecipe cachedRecipe;
    public double clientEnergyUsed;
    public int updateDelay;
    public boolean needsPacket;
    public int numPowering;
    private int currentRedstoneLevel;
    private boolean rendererInitialized = false;
    private final EjectSpeedController gasSpeedController = new EjectSpeedController();

    public TileEntityLargeChemicalWasher() {
        super("washer", BlockStateMultiblockMachine.MultiblockMachineType.LARGE_CHEMICAL_WASHER, 1, 4);
        this.inventory = NonNullListSynchronized.withSize(5, ItemStack.field_190927_a);
        this.upgradeComponent.setSupported(Upgrade.THREAD);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    this.needsPacket = true;
                }
            }
            ChargeUtils.discharge(3, this);
            this.manageBuckets();
            TileUtils.drawGas((ItemStack)this.inventory.get(2), this.outputTank);
            WasherRecipe recipe = this.getRecipe();
            if (this.canOperate(recipe) && this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                ++this.operatingTicks;
                if (this.operatingTicks >= this.ticksRequired) {
                    for (int i = 0; i <= this.Thread(); ++i) {
                        this.operate(recipe);
                    }
                    this.operatingTicks = 0;
                }
                double prev = this.getEnergy();
                this.setEnergy(this.getEnergy() - this.energyPerTick * (double)this.getUpgradedUsage() * (double)this.Thread());
                this.clientEnergyUsed = prev - this.getEnergy();
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.prevEnergy = this.getEnergy();
            if (this.needsPacket) {
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            this.needsPacket = false;
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> {
                this.gasSpeedController.ensureSize(1, () -> Collections.singletonList(new TankProvider.Gas(this.outputTank)));
                this.handleTank(this.outputTank, this.getRightTankSide(), this.facing);
                this.handleTank(this.outputTank, this.getRightTankSide(), MekanismUtils.getRight(this.facing));
                int newRedstoneLevel = this.getRedstoneLevel();
                if (newRedstoneLevel != this.currentRedstoneLevel) {
                    this.updateComparatorOutputLevelSync();
                    this.currentRedstoneLevel = newRedstoneLevel;
                }
            });
        } else if (this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    private TileEntity getRightTankSide() {
        BlockPos pos = this.func_174877_v().func_177972_a(MekanismUtils.getRight(this.facing)).func_177972_a(this.facing);
        if (this.field_145850_b.func_175625_s(pos) != null) {
            return this.field_145850_b.func_175625_s(pos);
        }
        return null;
    }

    private void handleTank(GasTank tank, TileEntity tile, EnumFacing side) {
        if (tile != null) {
            this.ejectGas(Collections.singleton(side), tank, this.gasSpeedController, tile);
        }
    }

    private void ejectGas(Set<EnumFacing> outputSides, GasTank tank, EjectSpeedController speedController, TileEntity tile) {
        speedController.record(0);
        if (tank.getGas() == null || tank.getStored() <= 0 || tank.getGas().getGas() == null) {
            return;
        }
        if (!speedController.canEject(0)) {
            return;
        }
        GasStack toEmit = tank.getGas().copy().withAmount(Math.min(tank.getMaxGas(), tank.getStored()));
        int emitted = GasUtils.emit(toEmit, tile, outputSides);
        speedController.eject(0, emitted);
        if (emitted <= 0) {
            return;
        }
        tank.draw(emitted, true);
    }

    @Override
    public WasherRecipe getRecipe() {
        GasInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((GasInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getChemicalWasherRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    @Override
    public GasInput getInput() {
        return new GasInput(this.inputTank.getGas());
    }

    @Override
    public boolean canOperate(WasherRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inputTank, this.fluidTank, this.outputTank);
    }

    @Override
    public void operate(WasherRecipe recipe) {
        recipe.operate(this.inputTank, this.fluidTank, this.outputTank, this.getUpgradedUsage());
    }

    @Override
    public Map<GasInput, WasherRecipe> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_WASHER.get();
    }

    private void manageBuckets() {
        if (FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(0)) && this.fluidTank.getFluidAmount() != this.fluidTank.getCapacity()) {
            FluidContainerUtils.handleContainerItemEmpty(this, this.fluidTank, 0, 1, FluidContainerUtils.FluidChecker.check(FluidRegistry.WATER));
        }
    }

    public int getUpgradedUsage() {
        int possibleProcess = Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), MekanismConfig.current().mekce.MAXspeedmachines.val());
        possibleProcess = Math.min(Math.min(this.inputTank.getStored(), this.outputTank.getNeeded()), possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return Math.min(this.fluidTank.getFluidAmount() / WATER_USAGE, possibleProcess);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clientEnergyUsed = dataStream.readDouble();
            TileUtils.readTankData(dataStream, this.fluidTank);
            TileUtils.readTankData(dataStream, this.inputTank);
            TileUtils.readTankData(dataStream, this.outputTank);
            this.numPowering = dataStream.readInt();
            if (this.updateDelay == 0) {
                this.updateDelay = MekanismConfig.current().general.UPDATE_DELAY.val();
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.clientEnergyUsed);
        TileUtils.addTankData(data, this.fluidTank);
        TileUtils.addTankData(data, this.inputTank);
        TileUtils.addTankData(data, this.outputTank);
        data.add(this.numPowering);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        this.inputTank.read(nbtTags.func_74775_l("inputTank"));
        this.outputTank.read(nbtTags.func_74775_l("outputTank"));
        this.numPowering = nbtTags.func_74762_e("numPowering");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("inputTank", (NBTBase)this.inputTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("outputTank", (NBTBase)this.outputTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (side == this.facing || side == MekanismUtils.getLeft(this.facing)) {
            return this.inputTank.canReceive(type) && RecipeHandler.Recipe.CHEMICAL_WASHER.containsRecipe(type);
        }
        return false;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            return this.inputTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.outputTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.outputTank.canDraw(type) && (side == this.facing || side == MekanismUtils.getRight(this.facing));
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.inputTank, this.outputTank};
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return FluidUtil.getFluidContained((ItemStack)itemstack) != null && FluidUtil.getFluidContained((ItemStack)itemstack).getFluid() == FluidRegistry.WATER;
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    @NotNull
    public int[] func_180463_a(@NotNull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.fluidTank.fill(resource, doFill);
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        return fluid.getFluid().equals(FluidRegistry.WATER);
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "fluidTank", this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.inputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "inputTank", this.inputTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "outputTank", this.outputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "fluidTank")));
        this.inputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "inputTank")));
        this.outputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "outputTank")));
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank, this.inputTank, this.outputTank};
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getStored(), this.inputTank.getMaxGas());
    }

    @Override
    public String[] getMethods() {
        return new String[0];
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        return new Object[0];
    }

    @Override
    public boolean canBoundReceiveEnergy(BlockPos coord, EnumFacing side) {
        EnumFacing back = MekanismUtils.getBack(this.facing);
        if (coord.equals((Object)this.func_174877_v().func_177972_a(back))) {
            return side == back;
        }
        return false;
    }

    @Override
    public boolean canBoundOutPutEnergy(BlockPos location, EnumFacing side) {
        return false;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return side == MekanismUtils.getBack(this.facing);
    }

    @Override
    public void onPower() {
        ++this.numPowering;
    }

    @Override
    public void onNoPower() {
        --this.numPowering;
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public void onPlace() {
        for (int y = 0; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos pos1 = this.func_174877_v().func_177982_a(x, y, z);
                    if (y == 0) {
                        MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, pos1, Coord4D.get(this));
                    } else {
                        MekanismUtils.makeBoundingBlock(this.field_145850_b, pos1, Coord4D.get(this));
                    }
                    this.field_145850_b.func_175685_c(pos1, this.func_145838_q(), true);
                }
            }
        }
    }

    @Override
    public void onBreak() {
        for (int y = 0; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x, y, z));
                }
            }
        }
    }

    @Override
    public boolean hasOffsetCapability(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return false;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            return true;
        }
        return this.hasCapability(capability, side);
    }

    @Override
    @Nullable
    public <T> T getOffsetCapability(@NotNull Capability<T> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        if (this.isStrictEnergy(capability)) {
            return (T)this;
        }
        if (this.isTesla(capability, side)) {
            return (T)this.getTeslaEnergyWrapper(side);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getForgeEnergyWrapper(side));
        }
        return this.getCapability(capability, side);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        EnumFacing back = this.facing.func_176734_d();
        EnumFacing left = MekanismUtils.getLeft(this.facing);
        EnumFacing right = MekanismUtils.getRight(this.facing);
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            if (this.facing == EnumFacing.EAST) {
                if (offset.equals((Object)new Vec3i(1, 0, 1))) {
                    return side != this.facing && side != left;
                }
                if (offset.equals((Object)new Vec3i(1, 0, -1))) {
                    return side != this.facing && side != right;
                }
            } else if (this.facing == EnumFacing.SOUTH) {
                if (offset.equals((Object)new Vec3i(-1, 0, 1))) {
                    return side != this.facing && side != left;
                }
                if (offset.equals((Object)new Vec3i(1, 0, 1))) {
                    return side != this.facing && side != right;
                }
            } else if (this.facing == EnumFacing.WEST) {
                if (offset.equals((Object)new Vec3i(-1, 0, 1))) {
                    return side != this.facing && side != right;
                }
                if (offset.equals((Object)new Vec3i(-1, 0, -1))) {
                    return side != this.facing && side != left;
                }
            } else if (this.facing == EnumFacing.NORTH) {
                if (offset.equals((Object)new Vec3i(-1, 0, -1))) {
                    return side != this.facing && side != right;
                }
                if (offset.equals((Object)new Vec3i(1, 0, -1))) {
                    return side != this.facing && side != left;
                }
            }
            return true;
        }
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            if (offset.equals((Object)new Vec3i(back.func_82601_c(), 0, back.func_82599_e()))) {
                return side != back;
            }
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.facing == EnumFacing.EAST) {
                if (offset.equals((Object)new Vec3i(-1, 0, 1))) {
                    return side != left && side != back;
                }
                if (offset.equals((Object)new Vec3i(-1, 0, -1))) {
                    return side != right && side != back;
                }
            } else if (this.facing == EnumFacing.SOUTH) {
                if (offset.equals((Object)new Vec3i(1, 0, -1))) {
                    return side != right && side != back;
                }
                if (offset.equals((Object)new Vec3i(-1, 0, -1))) {
                    return side != left && side != back;
                }
            } else if (this.facing == EnumFacing.WEST) {
                if (offset.equals((Object)new Vec3i(1, 0, -1))) {
                    return side != left && side != back;
                }
                if (offset.equals((Object)new Vec3i(1, 0, 1))) {
                    return side != right && side != back;
                }
            } else if (this.facing == EnumFacing.NORTH) {
                if (offset.equals((Object)new Vec3i(1, 0, 1))) {
                    return side != left && side != back;
                }
                if (offset.equals((Object)new Vec3i(-1, 0, 1))) {
                    return side != right && side != back;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K && !this.rendererInitialized) {
            this.rendererInitialized = true;
            if (Mekanism.hooks.Bloom && MekanismConfig.current().client.enableBloom.val()) {
                new BloomRenderLargeChemicalWasher(this);
            }
        }
    }
}

