/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.EjectSpeedController;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TankProvider;
import mekanism.common.util.TileUtils;
import mekanism.multiblockmachine.client.render.bloom.machine.BloomRenderLargeChemicalInfuser;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachine;
import mekanism.multiblockmachine.common.tile.machine.prefab.TileEntityMultiblockBasicMachine;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeChemicalInfuser
extends TileEntityMultiblockBasicMachine<ChemicalPairInput, GasOutput, ChemicalInfuserRecipe>
implements IGasHandler,
ISustainedData,
Upgrade.IUpgradeInfoHandler,
ITankManager,
IAdvancedBoundingBlock {
    public GasTank leftTank = new GasTank(0x7D0000);
    public GasTank rightTank = new GasTank(0x7D0000);
    public GasTank centerTank = new GasTank(0x7D0000);
    public int gasOutput = 256;
    public ChemicalInfuserRecipe cachedRecipe;
    public int updateDelay;
    public boolean needsPacket;
    public int numPowering;
    public double clientEnergyUsed;
    private int currentRedstoneLevel;
    private boolean rendererInitialized = false;
    private final EjectSpeedController gasSpeedController = new EjectSpeedController();

    public TileEntityLargeChemicalInfuser() {
        super("cheminfuser", BlockStateMultiblockMachine.MultiblockMachineType.LARGE_CHEMICAL_INFUSER, 1, 4);
        this.inventory = NonNullListSynchronized.withSize(5, ItemStack.field_190927_a);
        this.upgradeComponent.setSupported(Upgrade.THREAD);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    this.needsPacket = true;
                }
            }
            ChargeUtils.discharge(3, this);
            TileUtils.receiveGasItem((ItemStack)this.inventory.get(0), this.leftTank);
            TileUtils.receiveGasItem((ItemStack)this.inventory.get(1), this.rightTank);
            TileUtils.drawGas((ItemStack)this.inventory.get(2), this.centerTank);
            ChemicalInfuserRecipe recipe = this.getRecipe();
            if (this.canOperate(recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                this.setActive(true);
                ++this.operatingTicks;
                if (this.operatingTicks >= this.ticksRequired) {
                    for (int i = 0; i <= this.Thread(); ++i) {
                        this.operate(recipe);
                    }
                    this.operatingTicks = 0;
                }
                double prev = this.getEnergy();
                this.setEnergy(this.getEnergy() - this.energyPerTick * (double)this.getUpgradedUsage(recipe) * (double)this.Thread());
                this.clientEnergyUsed = prev - this.getEnergy();
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            this.prevEnergy = this.getEnergy();
            if (this.needsPacket) {
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            this.needsPacket = false;
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> {
                this.gasSpeedController.ensureSize(1, () -> Collections.singletonList(new TankProvider.Gas(this.centerTank)));
                this.handleTank(this.centerTank, this.getLeftTankside());
                this.handleTank(this.centerTank, this.getRightTankside());
                int newRedstoneLevel = this.getRedstoneLevel();
                if (newRedstoneLevel != this.currentRedstoneLevel) {
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                    this.currentRedstoneLevel = newRedstoneLevel;
                }
            });
        } else if (this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    private TileEntity getLeftTankside() {
        BlockPos pos = this.func_174877_v().func_177972_a(this.facing).func_177972_a(MekanismUtils.getLeft(this.facing));
        if (this.field_145850_b.func_175625_s(pos) != null) {
            return this.field_145850_b.func_175625_s(pos);
        }
        return null;
    }

    private TileEntity getRightTankside() {
        BlockPos pos = this.func_174877_v().func_177972_a(this.facing).func_177972_a(MekanismUtils.getRight(this.facing));
        if (this.field_145850_b.func_175625_s(pos) != null) {
            return this.field_145850_b.func_175625_s(pos);
        }
        return null;
    }

    private void handleTank(GasTank tank, TileEntity tile) {
        if (tile != null) {
            this.ejectGas(EnumSet.of(this.facing), tank, this.gasSpeedController, tile);
        }
    }

    private void ejectGas(Set<EnumFacing> outputSides, GasTank tank, EjectSpeedController speedController, TileEntity tile) {
        speedController.record(0);
        if (tank.getGas() == null || tank.getStored() <= 0 || tank.getGas().getGas() == null) {
            return;
        }
        if (!speedController.canEject(0)) {
            return;
        }
        GasStack toEmit = tank.getGas().copy().withAmount(Math.min(tank.getMaxGas(), tank.getStored()));
        int emitted = GasUtils.emit(toEmit, tile, outputSides);
        speedController.eject(0, emitted);
        if (emitted <= 0) {
            return;
        }
        tank.draw(emitted, true);
    }

    public int getUpgradedUsage(ChemicalInfuserRecipe recipe) {
        int possibleProcess = Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), MekanismConfig.current().mekce.MAXspeedmachines.val());
        if (this.leftTank.getGasType() == ((ChemicalPairInput)recipe.recipeInput).leftGas.getGas()) {
            possibleProcess = Math.min(this.leftTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).leftGas.amount, possibleProcess);
            possibleProcess = Math.min(this.rightTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).rightGas.amount, possibleProcess);
        } else {
            possibleProcess = Math.min(this.leftTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).rightGas.amount, possibleProcess);
            possibleProcess = Math.min(this.rightTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).leftGas.amount, possibleProcess);
        }
        possibleProcess = Math.min(this.centerTank.getNeeded() / ((GasOutput)recipe.recipeOutput).output.amount, possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return possibleProcess;
    }

    @Override
    public ChemicalPairInput getInput() {
        return new ChemicalPairInput(this.leftTank.getGas(), this.rightTank.getGas());
    }

    @Override
    public ChemicalInfuserRecipe getRecipe() {
        ChemicalPairInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ChemicalPairInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getChemicalInfuserRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    @Override
    public boolean canOperate(ChemicalInfuserRecipe recipe) {
        return recipe != null && recipe.canOperate(this.leftTank, this.rightTank, this.centerTank);
    }

    @Override
    public void operate(ChemicalInfuserRecipe recipe) {
        recipe.operate(this.leftTank, this.rightTank, this.centerTank, this.getUpgradedUsage(recipe));
    }

    @Override
    public Map<ChemicalPairInput, ChemicalInfuserRecipe> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_INFUSER.get();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clientEnergyUsed = dataStream.readDouble();
            TileUtils.readTankData(dataStream, this.leftTank);
            TileUtils.readTankData(dataStream, this.rightTank);
            TileUtils.readTankData(dataStream, this.centerTank);
            this.numPowering = dataStream.readInt();
            if (this.updateDelay == 0) {
                this.updateDelay = MekanismConfig.current().general.UPDATE_DELAY.val();
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.clientEnergyUsed);
        TileUtils.addTankData(data, this.leftTank);
        TileUtils.addTankData(data, this.rightTank);
        TileUtils.addTankData(data, this.centerTank);
        data.add(this.numPowering);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.leftTank.read(nbtTags.func_74775_l("leftTank"));
        this.rightTank.read(nbtTags.func_74775_l("rightTank"));
        this.centerTank.read(nbtTags.func_74775_l("centerTank"));
        this.numPowering = nbtTags.func_74762_e("numPowering");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("leftTank", (NBTBase)this.leftTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("rightTank", (NBTBase)this.rightTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("centerTank", (NBTBase)this.centerTank.write(new NBTTagCompound()));
        nbtTags.func_74768_a("numPowering", this.numPowering);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.leftTank, this.centerTank, this.rightTank};
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (side == MekanismUtils.getBack(this.facing) || side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing)) {
            return this.leftTank.canReceive(type) || this.rightTank.canReceive(type);
        }
        return false;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.centerTank.canDraw(type) && side == this.facing;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null) && stack != null && (side == MekanismUtils.getBack(this.facing) || side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing))) {
            if (this.leftTank.canReceive(stack.getGas()) && this.rightTank.getGasType() != stack.getGas()) {
                return this.leftTank.receive(stack, doTransfer);
            }
            if (this.rightTank.canReceive(stack.getGas()) && this.leftTank.getGasType() != stack.getGas()) {
                return this.rightTank.receive(stack, doTransfer);
            }
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.centerTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        return slotID == 3 && ChargeUtils.canBeDischarged(itemstack);
    }

    @Override
    @NotNull
    public int[] func_180463_a(@NotNull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 0 || slotID == 2) {
            return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canReceiveGas(itemstack, null);
        }
        if (slotID == 1) {
            return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.leftTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "leftTank", this.leftTank.getGas().write(new NBTTagCompound()));
        }
        if (this.rightTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "rightTank", this.rightTank.getGas().write(new NBTTagCompound()));
        }
        if (this.centerTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "centerTank", this.centerTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.leftTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "leftTank")));
        this.rightTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "rightTank")));
        this.centerTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "centerTank")));
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.leftTank, this.rightTank, this.centerTank};
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.updateDelay == 0) {
            Mekanism.packetHandler.sendUpdatePacket(this);
            this.updateDelay = 10;
        }
    }

    @Override
    public String[] getMethods() {
        return new String[0];
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        return new Object[0];
    }

    public double getScaledLeftTankGasLevel() {
        return (double)this.leftTank.getStored() / (double)this.leftTank.getMaxGas();
    }

    public double getScaledRightTankGasLevel() {
        return (double)this.rightTank.getStored() / (double)this.rightTank.getMaxGas();
    }

    public double getScaledGasTankLevel() {
        return (double)this.centerTank.getStored() / (double)this.centerTank.getMaxGas();
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.centerTank.getStored(), this.centerTank.getMaxGas());
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @Override
    public boolean canBoundReceiveEnergy(BlockPos coord, EnumFacing side) {
        EnumFacing back = MekanismUtils.getBack(this.facing);
        if (coord.equals((Object)this.func_174877_v().func_177972_a(back))) {
            return side == back;
        }
        return false;
    }

    @Override
    public boolean canBoundOutPutEnergy(BlockPos location, EnumFacing side) {
        return false;
    }

    @Override
    public void onPower() {
        ++this.numPowering;
    }

    @Override
    public void onNoPower() {
        --this.numPowering;
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public void onPlace() {
        for (int y = 0; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos pos1 = this.func_174877_v().func_177982_a(x, y, z);
                    if (y == 0) {
                        MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, pos1, Coord4D.get(this));
                    } else {
                        MekanismUtils.makeBoundingBlock(this.field_145850_b, pos1, Coord4D.get(this));
                    }
                    this.field_145850_b.func_175685_c(pos1, this.func_145838_q(), true);
                }
            }
        }
    }

    @Override
    public void onBreak() {
        for (int y = 0; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x, y, z));
                }
            }
        }
    }

    @Override
    public boolean hasOffsetCapability(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return false;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return true;
        }
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            return true;
        }
        return this.hasCapability(capability, side);
    }

    @Override
    @Nullable
    public <T> T getOffsetCapability(@NotNull Capability<T> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (this.isStrictEnergy(capability)) {
            return (T)this;
        }
        if (this.isTesla(capability, side)) {
            return (T)this.getTeslaEnergyWrapper(side);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getForgeEnergyWrapper(side));
        }
        return this.getCapability(capability, side);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        EnumFacing back = this.facing.func_176734_d();
        EnumFacing left = MekanismUtils.getLeft(this.facing);
        EnumFacing right = MekanismUtils.getRight(this.facing);
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            if (this.facing == EnumFacing.EAST) {
                if (offset.equals((Object)new Vec3i(1, 0, 1))) {
                    return side != this.facing;
                }
                if (offset.equals((Object)new Vec3i(1, 0, -1))) {
                    return side != this.facing;
                }
                if (offset.equals((Object)new Vec3i(-1, 0, 1))) {
                    return side != left && side != back;
                }
                if (offset.equals((Object)new Vec3i(-1, 0, -1))) {
                    return side != right && side != back;
                }
            } else if (this.facing == EnumFacing.SOUTH) {
                if (offset.equals((Object)new Vec3i(-1, 0, 1))) {
                    return side != this.facing;
                }
                if (offset.equals((Object)new Vec3i(1, 0, 1))) {
                    return side != this.facing;
                }
                if (offset.equals((Object)new Vec3i(1, 0, -1))) {
                    return side != right && side != back;
                }
                if (offset.equals((Object)new Vec3i(-1, 0, -1))) {
                    return side != left && side != back;
                }
            } else if (this.facing == EnumFacing.WEST) {
                if (offset.equals((Object)new Vec3i(-1, 0, 1))) {
                    return side != this.facing;
                }
                if (offset.equals((Object)new Vec3i(-1, 0, -1))) {
                    return side != this.facing;
                }
                if (offset.equals((Object)new Vec3i(1, 0, -1))) {
                    return side != left && side != back;
                }
                if (offset.equals((Object)new Vec3i(1, 0, 1))) {
                    return side != right && side != back;
                }
            } else if (this.facing == EnumFacing.NORTH) {
                if (offset.equals((Object)new Vec3i(-1, 0, -1)) || offset.equals((Object)new Vec3i(1, 0, -1))) {
                    return side != this.facing;
                }
                if (offset.equals((Object)new Vec3i(1, 0, 1))) {
                    return side != left && side != back;
                }
                if (offset.equals((Object)new Vec3i(-1, 0, 1))) {
                    return side != right && side != back;
                }
            }
            return true;
        }
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            if (offset.equals((Object)new Vec3i(back.func_82601_c(), 0, back.func_82599_e()))) {
                return side != back;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return true;
        }
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K && !this.rendererInitialized) {
            this.rendererInitialized = true;
            if (Mekanism.hooks.Bloom && MekanismConfig.current().client.enableBloom.val()) {
                new BloomRenderLargeChemicalInfuser(this);
            }
        }
    }
}

