/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.tile.machine;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.CompositeInput;
import mekanism.common.recipe.machines.DigitalAssemblyTableRecipe;
import mekanism.common.recipe.outputs.CompositeOutput;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.EjectSpeedController;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.FluidTankSync;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TankProvider;
import mekanism.common.util.TileUtils;
import mekanism.multiblockmachine.client.render.bloom.machine.BloomRenderDigitalAssemblyTable;
import mekanism.multiblockmachine.common.MultiblockMachineItems;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachine;
import mekanism.multiblockmachine.common.tile.machine.prefab.TileEntityMultiblockBasicMachine;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityDigitalAssemblyTable
extends TileEntityMultiblockBasicMachine<CompositeInput, CompositeOutput, DigitalAssemblyTableRecipe>
implements IGasHandler,
IFluidHandlerWrapper,
ITankManager,
ISustainedData,
IAdvancedBoundingBlock {
    private static Random Rand = new Random();
    private final EjectSpeedController fluidSpeedController = new EjectSpeedController();
    private final EjectSpeedController gasSpeedController = new EjectSpeedController();
    public FluidTank inputFluidTank = new FluidTankSync(5120000);
    public FluidTank outputFluidTank = new FluidTankSync(5120000);
    public GasTank inputGasTank = new GasTank(0x7D0000);
    public GasTank outputGasTank = new GasTank(0x7D0000);
    public DigitalAssemblyTableRecipe cachedRecipe;
    public int updateDelay;
    public boolean needsPacket;
    public int numPowering;
    public int DoorHeight;
    public float inputGasScale;
    public float outputGasScale;
    public float inputFluidScale;
    public float outputFluidScale;
    public int lastInputGas;
    public int lastInputFluid;
    public int lastOutputGas;
    public int lastOutputFluid;
    public int lastoperatingTicks;
    private int currentRedstoneLevel;
    private boolean rendererInitialized = false;

    public TileEntityDigitalAssemblyTable() {
        super("digitalassemblytable", BlockStateMultiblockMachine.MultiblockMachineType.DIGITAL_ASSEMBLY_TABLE, 200, 0);
        this.inventory = NonNullListSynchronized.withSize(15, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    this.needsPacket = true;
                }
            }
            DigitalAssemblyTableRecipe recipe = this.getRecipe();
            ChargeUtils.discharge(1, this);
            if (this.canOperate(recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy) && this.isMachiningTools()) {
                boolean update = this.BASE_TICKS_REQUIRED != recipe.ticks;
                this.BASE_TICKS_REQUIRED = recipe.ticks;
                if (update) {
                    this.recalculateUpgradables(Upgrade.SPEED);
                }
                this.setActive(true);
                for (int i = 11; i < 14; ++i) {
                    if (!((ItemStack)this.inventory.get(i)).func_96631_a(1, Rand, null)) continue;
                    this.inventory.set(i, ItemStack.field_190927_a);
                }
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                    this.electricityStored.addAndGet(-MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy));
                } else if (this.operatingTicks + 1 >= this.ticksRequired && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy)) {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                    this.electricityStored.addAndGet(-MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy));
                }
            } else {
                this.BASE_TICKS_REQUIRED = 100;
                if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            }
            if (!this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            if (this.prevEnergy != this.getEnergy() || this.lastInputFluid != this.inputFluidTank.getFluidAmount() || this.lastInputGas != this.inputGasTank.getStored() || this.lastOutputGas != this.outputGasTank.getStored() || this.lastOutputFluid != this.outputFluidTank.getFluidAmount() || this.lastoperatingTicks != this.operatingTicks) {
                SPacketUpdateTileEntity packet = this.func_189518_D_();
                PlayerChunkMapEntry trackingEntry = ((WorldServer)this.field_145850_b).func_184164_w().func_187301_b(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
                if (trackingEntry != null) {
                    for (EntityPlayerMP player : trackingEntry.getWatchingPlayers()) {
                        player.field_71135_a.func_147359_a((Packet)packet);
                    }
                }
            }
            this.prevEnergy = this.getEnergy();
            this.lastInputGas = this.inputGasTank.getStored();
            this.lastInputFluid = this.inputFluidTank.getFluidAmount();
            this.lastOutputGas = this.outputGasTank.getStored();
            this.lastOutputFluid = this.outputFluidTank.getFluidAmount();
            this.lastoperatingTicks = this.operatingTicks;
            if (this.needsPacket) {
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            this.needsPacket = false;
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> {
                this.gasSpeedController.ensureSize(1, () -> Collections.singletonList(new TankProvider.Gas(this.outputGasTank)));
                this.handleGasTank(this.outputGasTank, this.getGasTankside());
                this.fluidSpeedController.ensureSize(1, () -> Collections.singletonList(new TankProvider.Fluid(this.outputFluidTank)));
                this.handleFluidTank(this.outputFluidTank, this.getFluidTankside());
                int newRedstoneLevel = this.getRedstoneLevel();
                if (newRedstoneLevel != this.currentRedstoneLevel) {
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                    this.currentRedstoneLevel = newRedstoneLevel;
                }
            });
        } else {
            float targetOutputFluidScale;
            float targetInputFluidScale;
            float targetOutputGasScale;
            float targetInputGasScale;
            if (!this.isActive) {
                if (this.DoorHeight < 16) {
                    ++this.DoorHeight;
                }
            } else if (this.DoorHeight > 0) {
                --this.DoorHeight;
            }
            if ((double)Math.abs(this.inputGasScale - (targetInputGasScale = (float)(this.inputGasTank.getGas() != null ? this.inputGasTank.getGas().amount : 0) / (float)this.inputGasTank.getMaxGas())) > 0.01) {
                this.inputGasScale = (9.0f * this.inputGasScale + targetInputGasScale) / 10.0f;
            }
            if ((double)Math.abs(this.outputGasScale - (targetOutputGasScale = (float)(this.outputGasTank.getGas() != null ? this.outputGasTank.getGas().amount : 0) / (float)this.outputGasTank.getMaxGas())) > 0.01) {
                this.outputGasScale = (9.0f * this.outputGasScale + targetOutputGasScale) / 10.0f;
            }
            if ((double)Math.abs(this.inputFluidScale - (targetInputFluidScale = (float)(this.inputFluidTank.getFluid() != null ? this.inputFluidTank.getFluid().amount : 0) / (float)this.inputFluidTank.getCapacity())) > 0.01) {
                this.inputFluidScale = (9.0f * this.inputFluidScale + targetInputFluidScale) / 10.0f;
            }
            if ((double)Math.abs(this.outputFluidScale - (targetOutputFluidScale = (float)(this.outputFluidTank.getFluid() != null ? this.outputFluidTank.getFluid().amount : 0) / (float)this.outputFluidTank.getCapacity())) > 0.01) {
                this.outputFluidScale = (9.0f * this.outputFluidScale + targetOutputFluidScale) / 10.0f;
            }
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                }
            }
        }
    }

    private boolean isMachiningTools() {
        return ((ItemStack)this.inventory.get(11)).func_77973_b() == MultiblockMachineItems.gas_adsorption_fractionation_module && ((ItemStack)this.inventory.get(12)).func_77973_b() == MultiblockMachineItems.high_frequency_fusion_molding_module && ((ItemStack)this.inventory.get(13)).func_77973_b() == MultiblockMachineItems.LaserLenses;
    }

    private TileEntity getGasTankside() {
        BlockPos pos = this.func_174877_v().func_177967_a(MekanismUtils.getLeft(this.facing), 5).func_177981_b(3).func_177972_a(MekanismUtils.getBack(this.facing));
        if (this.field_145850_b.func_175625_s(pos) != null) {
            return this.field_145850_b.func_175625_s(pos);
        }
        return null;
    }

    private TileEntity getFluidTankside() {
        BlockPos pos = this.func_174877_v().func_177967_a(MekanismUtils.getLeft(this.facing), 5).func_177984_a().func_177967_a(MekanismUtils.getBack(this.facing), 3);
        if (this.field_145850_b.func_175625_s(pos) != null) {
            return this.field_145850_b.func_175625_s(pos);
        }
        return null;
    }

    private void handleGasTank(GasTank tank, TileEntity tile) {
        if (tile != null) {
            this.ejectGas(Collections.singleton(EnumFacing.UP), tank, this.gasSpeedController, tile);
        }
    }

    private void ejectGas(Set<EnumFacing> outputSides, GasTank tank, EjectSpeedController speedController, TileEntity tile) {
        speedController.record(0);
        if (tank.getGas() == null || tank.getStored() <= 0 || tank.getGas().getGas() == null) {
            return;
        }
        if (!speedController.canEject(0)) {
            return;
        }
        GasStack toEmit = tank.getGas().copy().withAmount(Math.min(tank.getMaxGas(), tank.getStored()));
        int emitted = GasUtils.emit(toEmit, tile, outputSides);
        speedController.eject(0, emitted);
        if (emitted <= 0) {
            return;
        }
        tank.draw(emitted, true);
    }

    private void handleFluidTank(FluidTank tank, TileEntity tile) {
        if (tile != null) {
            this.ejectFluid(Collections.singleton(EnumFacing.DOWN), tank, this.fluidSpeedController, tile);
        }
    }

    private void ejectFluid(Set<EnumFacing> outputSides, FluidTank tank, EjectSpeedController speedController, TileEntity tile) {
        speedController.record(0);
        if (tank.getFluid() == null || tank.getFluidAmount() <= 0) {
            return;
        }
        if (!speedController.canEject(0)) {
            return;
        }
        FluidStack toEmit = PipeUtils.copy(tank.getFluid(), Math.min(tank.getCapacity(), tank.getFluidAmount()));
        int emitted = PipeUtils.emit(outputSides, toEmit, tile);
        speedController.eject(0, emitted);
        if (emitted <= 0) {
            return;
        }
        tank.drain(emitted, true);
    }

    @Override
    public boolean canOperate(DigitalAssemblyTableRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inventory, 2, 3, 4, 5, 6, 7, 8, 9, 10, this.inputFluidTank, this.inputGasTank, 14, this.outputFluidTank, this.outputGasTank);
    }

    @Override
    public void operate(DigitalAssemblyTableRecipe recipe) {
        recipe.operate(this.inventory, 2, 3, 4, 5, 6, 7, 8, 9, 10, this.inputFluidTank, this.inputGasTank, 14, this.outputFluidTank, this.outputGasTank);
        this.markNoUpdateSync();
    }

    @Override
    public Map<CompositeInput, DigitalAssemblyTableRecipe> getRecipes() {
        return RecipeHandler.Recipe.DIGITAL_ASSEMBLY_TABLE.get();
    }

    @Override
    public DigitalAssemblyTableRecipe getRecipe() {
        CompositeInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((CompositeInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getDigitalAssemblyTableRecipe(input);
        }
        return this.cachedRecipe;
    }

    @Override
    public CompositeInput getInput() {
        return new CompositeInput((ItemStack)this.inventory.get(2), (ItemStack)this.inventory.get(3), (ItemStack)this.inventory.get(4), (ItemStack)this.inventory.get(5), (ItemStack)this.inventory.get(6), (ItemStack)this.inventory.get(7), (ItemStack)this.inventory.get(8), (ItemStack)this.inventory.get(9), (ItemStack)this.inventory.get(10), this.inputFluidTank.getFluid(), this.inputGasTank.getGas());
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 14) {
            return false;
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 2 || slotID == 3 || slotID == 4 || slotID == 5 || slotID == 6 || slotID == 7 || slotID == 8 || slotID == 9 || slotID == 10 || slotID == 11 || slotID == 12 || slotID == 13) {
            return this.InputItemValidForSlot(slotID, itemstack);
        }
        return false;
    }

    private boolean InputItemValidForSlot(int slotID, ItemStack itemstack) {
        for (CompositeInput input : this.getRecipes().keySet()) {
            if (!(slotID == 2 ? ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemInput, (ItemStack)itemstack) : (slotID == 3 ? ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemInput2, (ItemStack)itemstack) : (slotID == 4 ? ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemInput3, (ItemStack)itemstack) : (slotID == 5 ? ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemInput4, (ItemStack)itemstack) : (slotID == 6 ? ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemInput5, (ItemStack)itemstack) : (slotID == 7 ? ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemInput6, (ItemStack)itemstack) : (slotID == 8 ? ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemInput7, (ItemStack)itemstack) : (slotID == 9 ? ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemInput8, (ItemStack)itemstack) : (slotID == 10 ? ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemInput9, (ItemStack)itemstack) : (slotID == 11 ? ItemHandlerHelper.canItemStacksStack((ItemStack)MultiblockMachineItems.gas_adsorption_fractionation_module.func_190903_i(), (ItemStack)itemstack) : (slotID == 12 ? ItemHandlerHelper.canItemStacksStack((ItemStack)MultiblockMachineItems.high_frequency_fusion_molding_module.func_190903_i(), (ItemStack)itemstack) : slotID == 13 && ItemHandlerHelper.canItemStacksStack((ItemStack)MultiblockMachineItems.LaserLenses.func_190903_i(), (ItemStack)itemstack))))))))))))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 14;
    }

    @Override
    public String[] getMethods() {
        return new String[0];
    }

    @Override
    public Object[] invoke(int method, Object[] args) throws NoSuchMethodException {
        return new Object[0];
    }

    @Override
    @NotNull
    public int[] func_180463_a(@NotNull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.inputFluidTank);
            TileUtils.readTankData(dataStream, this.inputGasTank);
            TileUtils.readTankData(dataStream, this.outputFluidTank);
            TileUtils.readTankData(dataStream, this.outputGasTank);
            this.numPowering = dataStream.readInt();
            if (this.updateDelay == 0) {
                this.updateDelay = MekanismConfig.current().general.UPDATE_DELAY.val();
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.inputFluidTank);
        TileUtils.addTankData(data, this.inputGasTank);
        TileUtils.addTankData(data, this.outputFluidTank);
        TileUtils.addTankData(data, this.outputGasTank);
        data.add(this.numPowering);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.inputFluidTank.readFromNBT(nbtTags.func_74775_l("inputFluidTank"));
        this.inputGasTank.read(nbtTags.func_74775_l("inputGasTank"));
        this.outputFluidTank.readFromNBT(nbtTags.func_74775_l("outputFluidTank"));
        this.outputGasTank.read(nbtTags.func_74775_l("outputGasTank"));
        this.numPowering = nbtTags.func_74762_e("numPowering");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("inputFluidTank", (NBTBase)this.inputFluidTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("inputGasTank", (NBTBase)this.inputGasTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("outputFluidTank", (NBTBase)this.outputFluidTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("outputGasTank", (NBTBase)this.outputGasTank.write(new NBTTagCompound()));
        nbtTags.func_74768_a("numPowering", this.numPowering);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            return this.inputGasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.outputGasTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.inputGasTank.canReceive(type) && RecipeHandler.Recipe.DIGITAL_ASSEMBLY_TABLE.containsRecipe(type) && side == EnumFacing.DOWN;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.outputGasTank.canDraw(type) && side == EnumFacing.UP;
    }

    @Override
    @NotNull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.inputGasTank, this.outputGasTank};
    }

    @Override
    public int fill(EnumFacing from, @NotNull FluidStack resource, boolean doFill) {
        return this.inputFluidTank.fill(resource, doFill);
    }

    @Override
    @Nullable
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.outputFluidTank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFill(EnumFacing from, @NotNull FluidStack fluid) {
        return RecipeHandler.Recipe.DIGITAL_ASSEMBLY_TABLE.containsRecipe(fluid.getFluid()) && from == EnumFacing.UP;
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return this.outputFluidTank.getFluidAmount() > 0 && FluidContainerUtils.canDrain(this.outputFluidTank.getFluid(), fluid) && from == EnumFacing.DOWN;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.inputFluidTank.getInfo(), this.outputFluidTank.getInfo()};
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return new FluidTankInfo[]{this.inputFluidTank.getInfo(), this.outputFluidTank.getInfo()};
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputFluidTank, this.inputGasTank, this.outputFluidTank, this.outputGasTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputFluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "inputFluidTank", this.inputFluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.inputGasTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "inputGasTank", this.inputGasTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputFluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "outputFluidTank", this.outputFluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.outputGasTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "outputGasTank", this.outputGasTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputFluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "inputFluidTank")));
        this.inputGasTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "inputGasTank")));
        this.outputFluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "outputFluidTank")));
        this.outputGasTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "outputGasTank")));
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean canBoundReceiveEnergy(BlockPos coord, EnumFacing side) {
        EnumFacing back = MekanismUtils.getBack(this.facing);
        EnumFacing left = MekanismUtils.getLeft(this.facing);
        EnumFacing right = MekanismUtils.getRight(this.facing);
        if (coord.equals((Object)this.func_174877_v().func_177967_a(back, 5).func_177967_a(left, 4).func_177984_a()) || coord.equals((Object)this.func_174877_v().func_177967_a(back, 5).func_177967_a(right, 4).func_177984_a())) {
            return side == EnumFacing.DOWN;
        }
        return false;
    }

    @Override
    public boolean canBoundOutPutEnergy(BlockPos location, EnumFacing side) {
        return false;
    }

    @Override
    public void onPower() {
        ++this.numPowering;
    }

    @Override
    public void onNoPower() {
        --this.numPowering;
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public void onPlace() {
        int y;
        for (y = 0; y <= 4; ++y) {
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos pos1 = this.func_174877_v().func_177982_a(x, y, z);
                    if (y == 1) {
                        if (this.facing == EnumFacing.SOUTH || this.facing == EnumFacing.NORTH) {
                            if (!(z != 4 && z != -4 || x != 1 && x != 0 && x != -1)) {
                                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, pos1, Coord4D.get(this));
                            } else {
                                MekanismUtils.makeBoundingBlock(this.field_145850_b, pos1, Coord4D.get(this));
                            }
                        } else if (this.facing == EnumFacing.WEST || this.facing == EnumFacing.EAST) {
                            if (!(x != 4 && x != -4 || z != 1 && z != 0 && z != -1)) {
                                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, pos1, Coord4D.get(this));
                            } else {
                                MekanismUtils.makeBoundingBlock(this.field_145850_b, pos1, Coord4D.get(this));
                            }
                        }
                    } else {
                        MekanismUtils.makeBoundingBlock(this.field_145850_b, pos1, Coord4D.get(this));
                    }
                    this.field_145850_b.func_175685_c(pos1, this.func_145838_q(), true);
                }
            }
        }
        for (y = 1; y <= 3; ++y) {
            if (this.facing == EnumFacing.SOUTH) {
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(5, y, -1), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(5, y, -1), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-5, y, -1), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-5, y, -1), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(5, y, -3), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(5, y, -3), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-5, y, -3), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-5, y, -3), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(3, y, -5), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(3, y, -5), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-3, y, -5), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-3, y, -5), this.func_145838_q(), true);
                continue;
            }
            if (this.facing == EnumFacing.WEST) {
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(1, y, 5), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(1, y, 5), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(1, y, -5), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(1, y, -5), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(3, y, 5), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(3, y, 5), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(3, y, -5), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(3, y, -5), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(5, y, 3), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(5, y, 3), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(5, y, -3), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(5, y, -3), this.func_145838_q(), true);
                continue;
            }
            if (this.facing == EnumFacing.EAST) {
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-1, y, 5), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-1, y, 5), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-1, y, -5), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-1, y, -5), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-3, y, 5), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-3, y, 5), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-3, y, -5), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-3, y, -5), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-5, y, 3), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-5, y, 3), this.func_145838_q(), true);
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-5, y, -3), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-5, y, -3), this.func_145838_q(), true);
                continue;
            }
            if (this.facing != EnumFacing.NORTH) continue;
            MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(5, y, 1), Coord4D.get(this));
            this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(5, y, 1), this.func_145838_q(), true);
            MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-5, y, 1), Coord4D.get(this));
            this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-5, y, 1), this.func_145838_q(), true);
            MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(5, y, 3), Coord4D.get(this));
            this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(5, y, 3), this.func_145838_q(), true);
            MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-5, y, 3), Coord4D.get(this));
            this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-5, y, 3), this.func_145838_q(), true);
            MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(3, y, 5), Coord4D.get(this));
            this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(3, y, 5), this.func_145838_q(), true);
            MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-3, y, 5), Coord4D.get(this));
            this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-3, y, 5), this.func_145838_q(), true);
        }
    }

    @Override
    public void onBreak() {
        int y;
        for (y = 0; y <= 4; ++y) {
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x, y, z));
                }
            }
        }
        for (y = 1; y <= 3; ++y) {
            if (this.facing == EnumFacing.SOUTH) {
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(5, y, -1));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-5, y, -1));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(5, y, -3));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-5, y, -3));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(3, y, -5));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-3, y, -5));
                continue;
            }
            if (this.facing == EnumFacing.WEST) {
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(1, y, 5));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(1, y, -5));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(3, y, 5));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(3, y, -5));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(5, y, 3));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(5, y, -3));
                continue;
            }
            if (this.facing == EnumFacing.EAST) {
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-1, y, -5));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-1, y, 5));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-3, y, -5));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-3, y, 5));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-5, y, 3));
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-5, y, -3));
                continue;
            }
            if (this.facing != EnumFacing.NORTH) continue;
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-5, y, 1));
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(5, y, 1));
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-5, y, 3));
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(5, y, 3));
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(3, y, 5));
            this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-3, y, 5));
        }
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, 0, 0));
    }

    @Override
    public boolean hasOffsetCapability(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return false;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            return true;
        }
        return this.hasCapability(capability, side);
    }

    @Override
    @Nullable
    public <T> T getOffsetCapability(@NotNull Capability<T> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        if (this.isStrictEnergy(capability)) {
            return (T)this;
        }
        if (this.isTesla(capability, side)) {
            return (T)this.getTeslaEnergyWrapper(side);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getForgeEnergyWrapper(side));
        }
        return this.getCapability(capability, side);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            if (this.facing == EnumFacing.SOUTH) {
                if (offset.equals((Object)new Vec3i(5, 1, -1))) {
                    return side != EnumFacing.DOWN;
                }
                if (offset.equals((Object)new Vec3i(-5, 3, -1))) {
                    return side != EnumFacing.UP;
                }
            } else if (this.facing == EnumFacing.NORTH) {
                if (offset.equals((Object)new Vec3i(-5, 1, 1))) {
                    return side != EnumFacing.DOWN;
                }
                if (offset.equals((Object)new Vec3i(5, 3, 1))) {
                    return side != EnumFacing.UP;
                }
            } else if (this.facing == EnumFacing.WEST) {
                if (offset.equals((Object)new Vec3i(1, 1, 5))) {
                    return side != EnumFacing.DOWN;
                }
                if (offset.equals((Object)new Vec3i(1, 3, -5))) {
                    return side != EnumFacing.UP;
                }
            } else if (this.facing == EnumFacing.EAST) {
                if (offset.equals((Object)new Vec3i(-1, 1, -5))) {
                    return side != EnumFacing.DOWN;
                }
                if (offset.equals((Object)new Vec3i(-1, 3, 5))) {
                    return side != EnumFacing.UP;
                }
            }
            return true;
        }
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            if (this.facing == EnumFacing.SOUTH) {
                if (offset.equals((Object)new Vec3i(3, 1, -5))) {
                    return side != EnumFacing.DOWN;
                }
                if (offset.equals((Object)new Vec3i(-3, 1, -5))) {
                    return side != EnumFacing.DOWN;
                }
            } else if (this.facing == EnumFacing.NORTH) {
                if (offset.equals((Object)new Vec3i(3, 1, 5))) {
                    return side != EnumFacing.DOWN;
                }
                if (offset.equals((Object)new Vec3i(-3, 1, 5))) {
                    return side != EnumFacing.DOWN;
                }
            } else if (this.facing == EnumFacing.WEST) {
                if (offset.equals((Object)new Vec3i(5, 1, 3))) {
                    return side != EnumFacing.DOWN;
                }
                if (offset.equals((Object)new Vec3i(5, 1, -3))) {
                    return side != EnumFacing.DOWN;
                }
            } else if (this.facing == EnumFacing.EAST) {
                if (offset.equals((Object)new Vec3i(-5, 1, 3))) {
                    return side != EnumFacing.DOWN;
                }
                if (offset.equals((Object)new Vec3i(-5, 1, -3))) {
                    return side != EnumFacing.DOWN;
                }
            }
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.facing == EnumFacing.SOUTH) {
                if (offset.equals((Object)new Vec3i(5, 3, -3))) {
                    return side != EnumFacing.UP;
                }
                if (offset.equals((Object)new Vec3i(-5, 1, -3))) {
                    return side != EnumFacing.DOWN;
                }
            } else if (this.facing == EnumFacing.NORTH) {
                if (offset.equals((Object)new Vec3i(-5, 3, 3))) {
                    return side != EnumFacing.UP;
                }
                if (offset.equals((Object)new Vec3i(5, 1, 3))) {
                    return side != EnumFacing.DOWN;
                }
            } else if (this.facing == EnumFacing.WEST) {
                if (offset.equals((Object)new Vec3i(3, 3, 5))) {
                    return side != EnumFacing.UP;
                }
                if (offset.equals((Object)new Vec3i(3, 1, -5))) {
                    return side != EnumFacing.DOWN;
                }
            } else if (this.facing == EnumFacing.EAST) {
                if (offset.equals((Object)new Vec3i(-3, 3, -5))) {
                    return side != EnumFacing.UP;
                }
                if (offset.equals((Object)new Vec3i(-3, 1, 5))) {
                    return side != EnumFacing.DOWN;
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K && !this.rendererInitialized) {
            this.rendererInitialized = true;
            if (Mekanism.hooks.Bloom && MekanismConfig.current().client.enableBloom.val()) {
                new BloomRenderDigitalAssemblyTable(this);
            }
        }
    }
}

