/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.tile.generator;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityEffectsBlock;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachineGenerator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityMultiblockGenerator
extends TileEntityEffectsBlock
implements IComputerIntegration,
IRedstoneControl,
ISecurityTile,
IUpgradeTile {
    public double output;
    public IRedstoneControl.RedstoneControl controlType;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    public TileComponentUpgrade upgradeComponent;

    public TileEntityMultiblockGenerator(String soundPath, String name, double maxEnergy, double out, int slot) {
        super("gen." + soundPath, name, maxEnergy);
        this.output = out;
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
        this.upgradeComponent = new TileComponentUpgrade(this, slot, Upgrade.THREAD, false);
    }

    public int Thread() {
        int thread = 1;
        if (this.upgradeComponent.isUpgradeInstalled(Upgrade.THREAD)) {
            thread = this.upgradeComponent.getUpgrades(Upgrade.THREAD) + 1;
        }
        return thread;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType type;
            if (MekanismConfig.current().multiblock.destroyDisabledBlocks.val() && (type = BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.get(this.func_145838_q(), this.func_145832_p())) != null && !type.isEnabled()) {
                Mekanism.logger.info("Destroying generator of type '" + type.getBlockName() + "' at coords " + Coord4D.get(this) + " as according to config.");
                this.field_145850_b.func_175698_g(this.func_174877_v());
                return;
            }
            if (MekanismUtils.canFunction(this)) {
                Mekanism.EXECUTE_MANAGER.addSyncTask(() -> CableUtils.emit(this));
            }
        }
    }

    @Override
    public boolean supportsAsync() {
        return false;
    }

    @Override
    public double getMaxOutput() {
        return this.output;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return false;
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return side == this.facing;
    }

    public abstract boolean canOperate();

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        if (upgrade == Upgrade.ENERGY) {
            this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
            this.setEnergy(Math.min(this.getMaxEnergy(), this.getEnergy()));
        }
    }
}

