/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.tile.generator;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.CableUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.multiblockmachine.client.render.bloom.generator.BloomRenderLargeWindGenerator;
import mekanism.multiblockmachine.common.tile.generator.TileEntityMultiblockGenerator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeWindGenerator
extends TileEntityMultiblockGenerator
implements IAdvancedBoundingBlock {
    public static final float SPEED = 32.0f;
    public static final float SPEED_SCALED = 8.0f;
    static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getMultiplier"};
    private static final int[] SLOTS = new int[]{0};
    public int numPowering;
    private double angle;
    private float currentMultiplier;
    private boolean isBlacklistDimension = false;
    private int explode;
    private boolean machineStop;
    private boolean machineStop2;
    private boolean bladeDamage;
    private boolean rendererInitialized = false;

    public TileEntityLargeWindGenerator() {
        super("wind", "LargeWindGenerator", MekanismConfig.current().multiblock.largewindGeneratorStorage.val(), MekanismConfig.current().multiblock.largewindGeneratorOut.val(), 1);
        this.inventory = NonNullListSynchronized.withSize(SLOTS.length + 1, ItemStack.field_190927_a);
        this.upgradeComponent.setSupported(Upgrade.ENERGY);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.isBlacklistDimension = MekanismConfig.current().generators.windGenerationDimBlacklist.val().contains(this.field_145850_b.field_73011_w.getDimension());
        if (this.isBlacklistDimension) {
            this.setActive(false);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge(0, (IStrictEnergyStorage)this);
            if (this.isBlacklistDimension) {
                return;
            }
            if (this.ticker % 200 == 0 && MekanismConfig.current().multiblock.largewindGenerationRangeStops.val() && !this.machineStop2) {
                this.RangeStops();
            }
            if (this.ticker % 20 == 0) {
                this.currentMultiplier = this.getMultiplier();
                this.setActive(MekanismUtils.canFunction(this) && this.currentMultiplier > 0.0f && !this.machineStop && !this.machineStop2);
            }
            if (this.getActive()) {
                this.setEnergy(this.electricityStored.get() + MekanismConfig.current().multiblock.largewindGenerationMin.val() * (double)this.currentMultiplier);
                if (MekanismConfig.current().multiblock.largewindGenerationDamage.val()) {
                    this.kill();
                }
            }
            if (this.explode != 0) {
                this.bladeDamage = true;
            }
            if (this.explode >= MekanismConfig.current().multiblock.largewindGenerationExplodeCount.val() && MekanismConfig.current().multiblock.largewindGenerationExplode.val()) {
                this.explode();
            }
            if (MekanismUtils.canFunction(this)) {
                Mekanism.EXECUTE_MANAGER.addSyncTask(() -> CableUtils.emit(this, 4));
            }
        } else if (this.getActive()) {
            this.angle = (this.angle + (double)(((float)this.func_174877_v().func_177956_o() + 46.0f) / 8.0f)) % 360.0;
        }
    }

    private void RangeStops() {
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
        for (int yPos = 0; yPos <= 50; ++yPos) {
            for (int xPos = -50; xPos <= 50; ++xPos) {
                for (int zPos = -50; zPos <= 50 && (yPos != 0 || xPos != 0 || zPos != 0); ++zPos) {
                    testPos.func_181079_c(this.func_174877_v().func_177958_n() + xPos, this.func_174877_v().func_177956_o() + yPos, this.func_174877_v().func_177952_p() + zPos);
                    if (!(this.func_145831_w().func_175625_s((BlockPos)testPos) instanceof TileEntityLargeWindGenerator)) continue;
                    this.machineStop2 = true;
                }
            }
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 1) {
                this.machineStop = !this.machineStop;
            } else if (type == 2) {
                this.machineStop2 = !this.machineStop2;
            }
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.currentMultiplier = dataStream.readFloat();
            this.isBlacklistDimension = dataStream.readBoolean();
            this.numPowering = dataStream.readInt();
            this.machineStop = dataStream.readBoolean();
            this.machineStop2 = dataStream.readBoolean();
            this.explode = dataStream.readInt();
            this.bladeDamage = dataStream.readBoolean();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(Float.valueOf(this.currentMultiplier));
        data.add(this.isBlacklistDimension);
        data.add(this.numPowering);
        data.add(this.machineStop);
        data.add(this.machineStop2);
        data.add(this.explode);
        data.add(this.bladeDamage);
        return data;
    }

    public float getMultiplier() {
        BlockPos head = this.func_174877_v().func_177981_b(46);
        BlockPos head2 = this.func_174877_v().func_177981_b(46);
        if (this.facing == EnumFacing.NORTH) {
            head = this.func_174877_v().func_177981_b(46).func_177964_d(3);
            head2 = this.func_174877_v().func_177981_b(46).func_177964_d(4);
        } else if (this.facing == EnumFacing.SOUTH) {
            head = this.func_174877_v().func_177981_b(46).func_177970_e(3);
            head2 = this.func_174877_v().func_177981_b(46).func_177970_e(4);
        } else if (this.facing == EnumFacing.WEST) {
            head = this.func_174877_v().func_177981_b(46).func_177985_f(3);
            head2 = this.func_174877_v().func_177981_b(46).func_177985_f(4);
        } else if (this.facing == EnumFacing.EAST) {
            head = this.func_174877_v().func_177981_b(46).func_177965_g(3);
            head2 = this.func_174877_v().func_177981_b(46).func_177965_g(4);
        }
        if (this.field_145850_b.func_175678_i(head) && this.field_145850_b.func_175678_i(head2)) {
            int minY = MekanismConfig.current().multiblock.largewindGenerationMinY.val();
            int maxY = MekanismConfig.current().multiblock.largewindGenerationMaxY.val();
            float clampedY = Math.min(maxY, Math.max(minY, head.func_177956_o()));
            float minG = (float)MekanismConfig.current().multiblock.largewindGenerationMin.val();
            float maxG = (float)MekanismConfig.current().multiblock.largewindGenerationMax.val();
            int rangeY = maxY < minY ? minY - maxY : maxY - minY;
            float rangG = maxG < minG ? minG - maxG : maxG - minG;
            float slope = rangG / (float)rangeY;
            float toGen = minG + slope * (clampedY - (float)minY);
            return (toGen / minG * 45.0f - (float)this.explode * 0.01f) * (float)this.Thread();
        }
        return 0.0f;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.electricityStored;
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.output;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.BASE_MAX_ENERGY;
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.BASE_MAX_ENERGY - this.electricityStored.get();
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = Float.valueOf(this.getMultiplier());
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored.get() < this.BASE_MAX_ENERGY && this.getMultiplier() > 0.0f && MekanismUtils.canFunction(this);
    }

    @Override
    public void onPlace() {
        int z;
        int x;
        int y;
        int z2;
        int z3;
        int x2;
        for (x2 = -3; x2 <= 3; ++x2) {
            for (z3 = -3; z3 <= 3; ++z3) {
                if (x2 == 0 && z3 == 0) continue;
                MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x2, 0, z3), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x2, 0, z3), this.func_145838_q(), true);
            }
        }
        for (x2 = -2; x2 <= 2; ++x2) {
            for (z3 = -2; z3 <= 2; ++z3) {
                MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x2, 1, z3), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x2, 1, z3), this.func_145838_q(), true);
            }
        }
        if (this.facing == EnumFacing.WEST) {
            for (z2 = -1; z2 <= 1; ++z2) {
                MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(3, 1, z2), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(3, 1, z2), this.func_145838_q(), true);
            }
        } else if (this.facing == EnumFacing.EAST) {
            for (z2 = -1; z2 <= 1; ++z2) {
                MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(-3, 1, z2), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(-3, 1, z2), this.func_145838_q(), true);
            }
        } else if (this.facing == EnumFacing.NORTH) {
            for (x2 = -1; x2 <= 1; ++x2) {
                MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x2, 1, 3), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x2, 1, 3), this.func_145838_q(), true);
            }
        } else if (this.facing == EnumFacing.SOUTH) {
            for (x2 = -1; x2 <= 1; ++x2) {
                MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x2, 1, -3), Coord4D.get(this));
                this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x2, 1, -3), this.func_145838_q(), true);
            }
        }
        for (y = 2; y <= 47; ++y) {
            for (x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x, y, z), Coord4D.get(this));
                    this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x, y, z), this.func_145838_q(), true);
                }
            }
        }
        for (y = 43; y <= 47; ++y) {
            int x3;
            if (this.facing == EnumFacing.SOUTH) {
                for (x = -2; x <= 2; ++x) {
                    for (z = -5; z <= -3; ++z) {
                        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x, y, z), Coord4D.get(this));
                        this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x, y, z), this.func_145838_q(), true);
                    }
                    for (z = 3; z <= 4; ++z) {
                        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x, y, z), Coord4D.get(this));
                        this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x, y, z), this.func_145838_q(), true);
                    }
                }
                continue;
            }
            if (this.facing == EnumFacing.NORTH) {
                for (x = -2; x <= 2; ++x) {
                    for (z = 3; z <= 5; ++z) {
                        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x, y, z), Coord4D.get(this));
                        this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x, y, z), this.func_145838_q(), true);
                    }
                    for (z = -4; z <= -3; ++z) {
                        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x, y, z), Coord4D.get(this));
                        this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x, y, z), this.func_145838_q(), true);
                    }
                }
                continue;
            }
            if (this.facing == EnumFacing.EAST) {
                for (z3 = -2; z3 <= 2; ++z3) {
                    for (x3 = -5; x3 <= -3; ++x3) {
                        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x3, y, z3), Coord4D.get(this));
                        this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x3, y, z3), this.func_145838_q(), true);
                    }
                    for (x3 = 3; x3 <= 4; ++x3) {
                        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x3, y, z3), Coord4D.get(this));
                        this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x3, y, z3), this.func_145838_q(), true);
                    }
                }
                continue;
            }
            if (this.facing != EnumFacing.WEST) continue;
            for (z3 = -2; z3 <= 2; ++z3) {
                for (x3 = 3; x3 <= 5; ++x3) {
                    MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x3, y, z3), Coord4D.get(this));
                    this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x3, y, z3), this.func_145838_q(), true);
                }
                for (x3 = -4; x3 <= -3; ++x3) {
                    MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x3, y, z3), Coord4D.get(this));
                    this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x3, y, z3), this.func_145838_q(), true);
                }
            }
        }
        this.isBlacklistDimension = MekanismConfig.current().generators.windGenerationDimBlacklist.val().contains(this.field_145850_b.field_73011_w.getDimension());
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing) || side == this.facing;
    }

    @Override
    public void onBreak() {
        int z;
        int x;
        int y;
        int z2;
        int z3;
        int x2;
        for (x2 = -3; x2 <= 3; ++x2) {
            for (z3 = -3; z3 <= 3; ++z3) {
                if (x2 == 0 && z3 == 0) continue;
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x2, 0, z3));
            }
        }
        for (x2 = -2; x2 <= 2; ++x2) {
            for (z3 = -2; z3 <= 2; ++z3) {
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x2, 1, z3));
            }
        }
        if (this.facing == EnumFacing.WEST) {
            for (z2 = -1; z2 <= 1; ++z2) {
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(3, 1, z2));
            }
        } else if (this.facing == EnumFacing.EAST) {
            for (z2 = -1; z2 <= 1; ++z2) {
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(-3, 1, z2));
            }
        } else if (this.facing == EnumFacing.NORTH) {
            for (x2 = -1; x2 <= 1; ++x2) {
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x2, 1, 3));
            }
        } else if (this.facing == EnumFacing.SOUTH) {
            for (x2 = -1; x2 <= 1; ++x2) {
                this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x2, 1, -3));
            }
        }
        for (y = 2; y <= 47; ++y) {
            for (x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x, y, z));
                }
            }
        }
        for (y = 43; y <= 47; ++y) {
            int x3;
            if (this.facing == EnumFacing.SOUTH) {
                for (x = -2; x <= 2; ++x) {
                    for (z = -5; z <= -3; ++z) {
                        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x, y, z));
                    }
                    for (z = 3; z <= 4; ++z) {
                        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x, y, z));
                    }
                }
                continue;
            }
            if (this.facing == EnumFacing.NORTH) {
                for (x = -2; x <= 2; ++x) {
                    for (z = 3; z <= 5; ++z) {
                        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x, y, z));
                    }
                    for (z = -4; z <= -3; ++z) {
                        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x, y, z));
                    }
                }
                continue;
            }
            if (this.facing == EnumFacing.EAST) {
                for (z3 = -2; z3 <= 2; ++z3) {
                    for (x3 = -5; x3 <= -3; ++x3) {
                        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x3, y, z3));
                    }
                    for (x3 = 3; x3 <= 4; ++x3) {
                        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x3, y, z3));
                    }
                }
                continue;
            }
            if (this.facing != EnumFacing.WEST) continue;
            for (z3 = -2; z3 <= 2; ++z3) {
                for (x3 = 3; x3 <= 5; ++x3) {
                    this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x3, y, z3));
                }
                for (x3 = -4; x3 <= -3; ++x3) {
                    this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x3, y, z3));
                }
            }
        }
        this.func_145843_s();
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.numPowering = nbtTags.func_74762_e("numPowering");
        this.explode = nbtTags.func_74762_e("explode");
        this.machineStop = nbtTags.func_74767_n("machineStop");
        this.machineStop2 = nbtTags.func_74767_n("machineStop2");
        this.bladeDamage = nbtTags.func_74767_n("bladeDamage");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74768_a("numPowering", this.numPowering);
        nbtTags.func_74768_a("explode", this.explode);
        nbtTags.func_74757_a("machineStop", this.machineStop);
        nbtTags.func_74757_a("machineStop2", this.machineStop2);
        nbtTags.func_74757_a("bladeDamage", this.bladeDamage);
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    public float getCurrentMultiplier() {
        return this.currentMultiplier;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean getMachineStop2() {
        return this.machineStop2;
    }

    public boolean getMachineStop() {
        return this.machineStop;
    }

    public boolean getBladeDamage() {
        return this.bladeDamage;
    }

    public int getBladeDamageNumber() {
        return this.explode;
    }

    public boolean isBlacklistDimension() {
        return this.isBlacklistDimension;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return SLOTS;
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return ChargeUtils.canBeCharged(stack);
    }

    @Override
    public boolean canBoundReceiveEnergy(BlockPos location, EnumFacing side) {
        return false;
    }

    public void kill() {
        AxisAlignedBB death_zone = new AxisAlignedBB(this.func_174877_v());
        if (this.facing == EnumFacing.NORTH) {
            death_zone = new AxisAlignedBB((double)(this.func_174877_v().func_177981_b(46).func_177964_d(3).func_177958_n() + 22), (double)(this.func_174877_v().func_177981_b(46).func_177964_d(3).func_177956_o() + 22), (double)this.func_174877_v().func_177981_b(46).func_177964_d(3).func_177952_p(), (double)(this.func_174877_v().func_177981_b(46).func_177964_d(4).func_177958_n() - 22), (double)(this.func_174877_v().func_177981_b(46).func_177964_d(4).func_177956_o() - 22), (double)this.func_174877_v().func_177981_b(46).func_177964_d(4).func_177952_p());
        } else if (this.facing == EnumFacing.SOUTH) {
            death_zone = new AxisAlignedBB((double)(this.func_174877_v().func_177981_b(46).func_177970_e(3).func_177958_n() + 22), (double)(this.func_174877_v().func_177981_b(46).func_177970_e(3).func_177956_o() + 22), (double)this.func_174877_v().func_177981_b(46).func_177970_e(3).func_177952_p(), (double)(this.func_174877_v().func_177981_b(46).func_177970_e(4).func_177958_n() - 22), (double)(this.func_174877_v().func_177981_b(46).func_177970_e(4).func_177956_o() - 22), (double)this.func_174877_v().func_177981_b(46).func_177970_e(4).func_177952_p());
        } else if (this.facing == EnumFacing.WEST) {
            death_zone = new AxisAlignedBB((double)this.func_174877_v().func_177981_b(46).func_177985_f(3).func_177958_n(), (double)(this.func_174877_v().func_177981_b(46).func_177985_f(3).func_177956_o() + 22), (double)(this.func_174877_v().func_177981_b(46).func_177985_f(3).func_177952_p() + 22), (double)this.func_174877_v().func_177981_b(46).func_177985_f(4).func_177958_n(), (double)(this.func_174877_v().func_177981_b(46).func_177985_f(4).func_177956_o() - 22), (double)(this.func_174877_v().func_177981_b(46).func_177985_f(4).func_177952_p() - 22));
        } else if (this.facing == EnumFacing.EAST) {
            death_zone = new AxisAlignedBB((double)this.func_174877_v().func_177981_b(46).func_177965_g(3).func_177958_n(), (double)(this.func_174877_v().func_177981_b(46).func_177965_g(3).func_177956_o() + 22), (double)(this.func_174877_v().func_177981_b(46).func_177965_g(3).func_177952_p() + 22), (double)this.func_174877_v().func_177981_b(46).func_177965_g(4).func_177958_n(), (double)(this.func_174877_v().func_177981_b(46).func_177965_g(4).func_177956_o() - 22), (double)(this.func_174877_v().func_177981_b(46).func_177965_g(4).func_177952_p() - 22));
        }
        List entitiesToDie = this.func_145831_w().func_72872_a(Entity.class, death_zone);
        for (Entity entity : entitiesToDie) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            entity.func_70097_a(DamageSource.field_188406_j, Float.MAX_VALUE);
            this.machineStop = true;
            ++this.explode;
        }
    }

    private void explode() {
        if (this.facing == EnumFacing.NORTH) {
            this.field_145850_b.func_72876_a(null, (double)this.func_174877_v().func_177981_b(46).func_177964_d(4).func_177958_n(), (double)this.func_174877_v().func_177981_b(46).func_177964_d(4).func_177956_o(), (double)this.func_174877_v().func_177981_b(46).func_177964_d(4).func_177952_p(), (float)MekanismConfig.current().multiblock.largewindGenerationBlastRadius.val(), true);
            this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, (double)this.func_174877_v().func_177981_b(46).func_177964_d(3).func_177958_n(), (double)this.func_174877_v().func_177981_b(46).func_177964_d(3).func_177956_o(), (double)this.func_174877_v().func_177981_b(46).func_177964_d(3).func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
        } else if (this.facing == EnumFacing.SOUTH) {
            this.field_145850_b.func_72876_a(null, (double)this.func_174877_v().func_177981_b(46).func_177970_e(4).func_177958_n(), (double)this.func_174877_v().func_177981_b(46).func_177970_e(4).func_177956_o(), (double)this.func_174877_v().func_177981_b(46).func_177970_e(4).func_177952_p(), (float)MekanismConfig.current().multiblock.largewindGenerationBlastRadius.val(), true);
            this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, (double)this.func_174877_v().func_177981_b(46).func_177970_e(3).func_177958_n(), (double)this.func_174877_v().func_177981_b(46).func_177970_e(3).func_177956_o(), (double)this.func_174877_v().func_177981_b(46).func_177970_e(3).func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
        } else if (this.facing == EnumFacing.WEST) {
            this.field_145850_b.func_72876_a(null, (double)this.func_174877_v().func_177981_b(46).func_177985_f(4).func_177958_n(), (double)this.func_174877_v().func_177981_b(46).func_177985_f(4).func_177956_o(), (double)this.func_174877_v().func_177981_b(46).func_177985_f(4).func_177952_p(), (float)MekanismConfig.current().multiblock.largewindGenerationBlastRadius.val(), true);
            this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, (double)this.func_174877_v().func_177981_b(46).func_177985_f(3).func_177958_n(), (double)this.func_174877_v().func_177981_b(46).func_177985_f(3).func_177956_o(), (double)this.func_174877_v().func_177981_b(46).func_177985_f(3).func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
        } else if (this.facing == EnumFacing.EAST) {
            this.field_145850_b.func_72876_a(null, (double)this.func_174877_v().func_177981_b(46).func_177965_g(4).func_177958_n(), (double)this.func_174877_v().func_177981_b(46).func_177965_g(4).func_177956_o(), (double)this.func_174877_v().func_177981_b(46).func_177965_g(4).func_177952_p(), (float)MekanismConfig.current().multiblock.largewindGenerationBlastRadius.val(), true);
            this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, (double)this.func_174877_v().func_177981_b(46).func_177965_g(3).func_177958_n(), (double)this.func_174877_v().func_177981_b(46).func_177965_g(3).func_177956_o(), (double)this.func_174877_v().func_177981_b(46).func_177965_g(3).func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public boolean canBoundOutPutEnergy(BlockPos coord, EnumFacing side) {
        EnumFacing left = MekanismUtils.getLeft(this.facing);
        EnumFacing right = MekanismUtils.getRight(this.facing);
        if (coord.equals((Object)this.func_174877_v().func_177967_a(left, 3))) {
            return side == left;
        }
        if (coord.equals((Object)this.func_174877_v().func_177967_a(right, 3))) {
            return side == right;
        }
        if (coord.equals((Object)this.func_174877_v().func_177967_a(this.facing, 3))) {
            return side == this.facing;
        }
        return false;
    }

    @Override
    public void onPower() {
        ++this.numPowering;
    }

    @Override
    public void onNoPower() {
        --this.numPowering;
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public boolean hasOffsetCapability(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return false;
        }
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            return true;
        }
        return this.hasCapability(capability, side);
    }

    @Override
    public <T> T getOffsetCapability(@Nonnull Capability<T> capability, EnumFacing side, @Nonnull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return null;
        }
        if (this.isStrictEnergy(capability)) {
            return (T)this;
        }
        if (this.isTesla(capability, side)) {
            return (T)this.getTeslaEnergyWrapper(side);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getForgeEnergyWrapper(side));
        }
        return this.getCapability(capability, side);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side, @Nonnull Vec3i offset) {
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            EnumFacing left = MekanismUtils.getLeft(this.facing);
            EnumFacing right = MekanismUtils.getRight(this.facing);
            if (offset.equals((Object)new Vec3i(left.func_82601_c() * 3, 0, left.func_82599_e() * 3))) {
                return side != left;
            }
            if (offset.equals((Object)new Vec3i(right.func_82601_c() * 3, 0, right.func_82599_e() * 3))) {
                return side != right;
            }
            if (offset.equals((Object)new Vec3i(this.facing.func_82601_c() * 3, 0, this.facing.func_82599_e() * 3))) {
                return side != this.facing;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return MekanismConfig.current().client.largeWindGeneratorMaxRenderDistanceSquared.val();
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K && !this.rendererInitialized) {
            this.rendererInitialized = true;
            if (Mekanism.hooks.Bloom && MekanismConfig.current().client.enableBloom.val()) {
                new BloomRenderLargeWindGenerator(this);
            }
        }
    }
}

