/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.tile.generator;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedData;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TileUtils;
import mekanism.multiblockmachine.client.render.bloom.generator.BloomRenderLargeHeatGenerator;
import mekanism.multiblockmachine.common.tile.generator.TileEntityMultiblockGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeHeatGenerator
extends TileEntityMultiblockGenerator
implements IAdvancedBoundingBlock,
IFluidHandlerWrapper,
ISustainedData,
IHeatTransfer,
IComparatorSupport {
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getFuel", "getFuelNeeded"};
    public FluidTank lavaTank = new FluidTank(288000);
    public double temperature = 0.0;
    public double thermalEfficiency = 0.5;
    public double invHeatCapacity = 1.0;
    public double heatToAbsorb = 0.0;
    public double producingEnergy;
    public double lastTransferLoss;
    public double lastEnvironmentLoss;
    public int numPowering;
    private int currentRedstoneLevel;
    private boolean rendererInitialized = false;

    public TileEntityLargeHeatGenerator() {
        super("heat", "LargeHeatGenerator", MekanismConfig.current().multiblock.largeHeatGeneratorStorage.val(), MekanismConfig.current().multiblock.largeHeatGeneratorOut.val(), 2);
        this.inventory = NonNullListSynchronized.withSize(3, ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge(1, (IStrictEnergyStorage)this);
            if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
                if (FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(0))) {
                    this.lavaTank.fill(FluidContainerUtils.extractFluid(this.lavaTank, this, 0, FluidContainerUtils.FluidChecker.check(FluidRegistry.LAVA)), true);
                } else {
                    int fuelNeeded;
                    int fuel = this.getFuel((ItemStack)this.inventory.get(0));
                    if (fuel > 0 && fuel <= (fuelNeeded = this.lavaTank.getCapacity() - (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0))) {
                        this.lavaTank.fill(new FluidStack(FluidRegistry.LAVA, fuel), true);
                        if (!((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)).func_190926_b()) {
                            this.inventory.set(0, ((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)));
                        } else {
                            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                        }
                    }
                }
            }
            double prev = this.getEnergy();
            this.transferHeatTo(this.getBoost());
            if (this.canOperate()) {
                this.setActive(true);
                this.lavaTank.drain(10 * this.Thread(), true);
                this.transferHeatTo(MekanismConfig.current().multiblock.largeHeatGeneration.val() * (double)this.Thread());
            } else {
                this.setActive(false);
            }
            double[] loss = this.simulateHeat();
            this.applyTemperatureChange();
            this.lastTransferLoss = loss[0];
            this.lastEnvironmentLoss = loss[1];
            this.producingEnergy = this.getEnergy() - prev;
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.currentRedstoneLevel = newRedstoneLevel;
            }
            if (MekanismUtils.canFunction(this)) {
                Mekanism.EXECUTE_MANAGER.addSyncTask(() -> CableUtils.emit(this, 2));
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            if (this.getFuel(itemstack) > 0) {
                return true;
            }
            FluidStack fluidContained = FluidUtil.getFluidContained((ItemStack)itemstack);
            return fluidContained != null && fluidContained.getFluid() == FluidRegistry.LAVA;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged(itemstack);
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored.get() < this.BASE_MAX_ENERGY && this.lavaTank.getFluid() != null && this.lavaTank.getFluid().amount >= 10 && MekanismUtils.canFunction(this);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        if (nbtTags.func_74764_b("lavaTank")) {
            this.lavaTank.readFromNBT(nbtTags.func_74775_l("lavaTank"));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        if (this.lavaTank.getFluid() != null) {
            nbtTags.func_74782_a("lavaTank", (NBTBase)this.lavaTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, true);
        }
        if (slotID == 0) {
            return FluidUtil.getFluidContained((ItemStack)itemstack) == null;
        }
        return false;
    }

    public double getBoost() {
        int lavaBoost = 0;
        double netherBoost = 0.0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            Coord4D coord = Coord4D.get(this).offset(side, 2);
            if (!this.isLava(coord.getPos())) continue;
            ++lavaBoost;
        }
        if (this.field_145850_b.field_73011_w.getDimension() == -1) {
            netherBoost = MekanismConfig.current().multiblock.largeHeatGenerationNether.val();
        }
        return MekanismConfig.current().multiblock.largeHeatGenerationLava.val() * (double)lavaBoost + netherBoost;
    }

    private boolean isLava(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l;
    }

    public int getFuel(ItemStack itemstack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack);
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        int[] nArray;
        if (side == MekanismUtils.getRight(this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.producingEnergy = dataStream.readDouble();
            this.numPowering = dataStream.readInt();
            this.lastTransferLoss = dataStream.readDouble();
            this.lastEnvironmentLoss = dataStream.readDouble();
            TileUtils.readTankData(dataStream, this.lavaTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.producingEnergy);
        data.add(this.numPowering);
        data.add(this.lastTransferLoss);
        data.add(this.lastEnvironmentLoss);
        TileUtils.addTankData(data, this.lavaTank);
        return data;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.electricityStored;
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.output;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.BASE_MAX_ENERGY;
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.BASE_MAX_ENERGY - this.electricityStored.get();
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0;
                break;
            }
            case 5: {
                Object[] objectArray7 = new Object[1];
                objectArray = objectArray7;
                objectArray7[0] = this.lavaTank.getCapacity() - (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0);
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.lavaTank.fill(resource, doFill);
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        return fluid.getFluid().equals(FluidRegistry.LAVA) && from != this.facing;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (from == this.facing) {
            return PipeUtils.EMPTY;
        }
        return new FluidTankInfo[]{this.lavaTank.getInfo()};
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.lavaTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "lavaTank", this.lavaTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.lavaTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "lavaTank")));
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 1.0;
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        return this.canConnectHeat(side) ? 0.0 : 10000.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        if (this.getTemp() > 0.0) {
            double carnotEfficiency = this.getTemp() / (this.getTemp() + 300.0);
            double heatLost = this.thermalEfficiency * this.getTemp();
            double workDone = heatLost * carnotEfficiency;
            this.transferHeatTo(-heatLost);
            this.setEnergy(this.getEnergy() + workDone);
        }
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.invHeatCapacity * this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return side == this.facing;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        if (this.canConnectHeat(side)) {
            TileEntity adj;
            BlockPos pos = this.func_174877_v().func_177984_a().func_177967_a(side, 2);
            BlockPos pos2 = this.func_174877_v().func_177981_b(2).func_177967_a(side, 2);
            if (this.field_145850_b.func_175667_e(pos) && CapabilityUtils.hasCapability((ICapabilityProvider)(adj = this.field_145850_b.func_175625_s(pos)), Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
                return CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
            }
            if (this.field_145850_b.func_175667_e(pos2) && CapabilityUtils.hasCapability((ICapabilityProvider)(adj = this.field_145850_b.func_175625_s(pos2)), Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
                return CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
            }
        }
        return null;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.HEAT_TRANSFER_CAPABILITY || side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.HEAT_TRANSFER_CAPABILITY) {
            return (T)Capabilities.HEAT_TRANSFER_CAPABILITY.cast((Object)this);
        }
        if (side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.lavaTank.getFluidAmount(), this.lavaTank.getCapacity());
    }

    @Override
    public boolean canBoundReceiveEnergy(BlockPos location, EnumFacing side) {
        return false;
    }

    @Override
    public boolean canBoundOutPutEnergy(BlockPos coord, EnumFacing side) {
        if (coord.equals((Object)this.func_174877_v().func_177972_a(this.facing))) {
            return side == this.facing;
        }
        return false;
    }

    @Override
    public void onPower() {
        ++this.numPowering;
    }

    @Override
    public void onNoPower() {
        --this.numPowering;
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public void onPlace() {
        for (int y = 0; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x, y, z), Coord4D.get(this));
                    this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x, y, z), this.func_145838_q(), true);
                }
            }
        }
    }

    @Override
    public void onBreak() {
        for (int y = 0; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x, y, z));
                }
            }
        }
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public boolean hasOffsetCapability(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return false;
        }
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side) || capability == Capabilities.HEAT_TRANSFER_CAPABILITY || side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return this.hasCapability(capability, side);
    }

    @Override
    @Nullable
    public <T> T getOffsetCapability(@NotNull Capability<T> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return null;
        }
        if (this.isStrictEnergy(capability)) {
            return (T)this;
        }
        if (this.isTesla(capability, side)) {
            return (T)this.getTeslaEnergyWrapper(side);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.getForgeEnergyWrapper(side));
        }
        if (capability == Capabilities.HEAT_TRANSFER_CAPABILITY) {
            return (T)Capabilities.HEAT_TRANSFER_CAPABILITY.cast((Object)this);
        }
        if (side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return this.getCapability(capability, side);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side, @Nonnull Vec3i offset) {
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) {
            if (offset.equals((Object)new Vec3i(this.facing.func_82601_c(), 0, this.facing.func_82599_e()))) {
                return side != this.facing;
            }
            return true;
        }
        if (capability == Capabilities.HEAT_TRANSFER_CAPABILITY || side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (offset.equals((Object)new Vec3i(this.facing.func_82601_c(), 1, this.facing.func_82599_e()))) {
                return side != this.facing;
            }
            if (offset.equals((Object)new Vec3i(this.facing.func_82601_c(), 2, this.facing.func_82599_e()))) {
                return side != this.facing;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side) || capability == Capabilities.HEAT_TRANSFER_CAPABILITY || side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K && !this.rendererInitialized) {
            this.rendererInitialized = true;
            if (Mekanism.hooks.Bloom && MekanismConfig.current().client.enableBloom.val()) {
                new BloomRenderLargeHeatGenerator(this);
            }
        }
    }
}

