/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.tile.generator;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.common.FuelHandler;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.ISustainedData;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.CableUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import mekanism.multiblockmachine.client.render.bloom.generator.BloomRendererLargeGasGenerator;
import mekanism.multiblockmachine.common.tile.generator.TileEntityMultiblockGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeGasGenerator
extends TileEntityMultiblockGenerator
implements IAdvancedBoundingBlock,
IGasHandler,
ISustainedData,
IComparatorSupport {
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getGas", "getGasNeeded"};
    public int MAX_GAS = 486000;
    public GasTank fuelTank;
    public int burnTicks = 0;
    public int maxBurnTicks;
    public double generationRate = 0.0;
    public int clientUsed;
    public int numPowering;
    private int currentRedstoneLevel;
    private int animation;
    private boolean rendererInitialized = false;

    public TileEntityLargeGasGenerator() {
        super("gas", "LargeGasGenerator", MekanismConfig.current().multiblock.LargeGasGeneratorStorage.val(), MekanismConfig.current().multiblock.LargeGasGeneratorOut.val(), 2);
        this.inventory = NonNullListSynchronized.withSize(3, ItemStack.field_190927_a);
        this.fuelTank = new GasTank(this.MAX_GAS);
        this.upgradeComponent.setSupported(Upgrade.ENERGY);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            boolean operate;
            ChargeUtils.charge(1, (IStrictEnergyStorage)this);
            if (!((ItemStack)this.inventory.get(0)).func_190926_b() && this.fuelTank.getStored() < this.MAX_GAS) {
                Gas gasType = null;
                if (this.fuelTank.getGas() != null) {
                    gasType = this.fuelTank.getGas().getGas();
                } else if (!((ItemStack)this.inventory.get(0)).func_190926_b() && ((ItemStack)this.inventory.get(0)).func_77973_b() instanceof IGasItem && ((IGasItem)((ItemStack)this.inventory.get(0)).func_77973_b()).getGas((ItemStack)this.inventory.get(0)) != null) {
                    gasType = ((IGasItem)((ItemStack)this.inventory.get(0)).func_77973_b()).getGas((ItemStack)this.inventory.get(0)).getGas();
                }
                if (gasType != null && FuelHandler.getFuel(gasType) != null) {
                    GasStack removed = GasUtils.removeGas((ItemStack)this.inventory.get(0), gasType, this.fuelTank.getNeeded());
                    boolean isTankEmpty = this.fuelTank.getGas() == null;
                    int fuelReceived = this.fuelTank.receive(removed, true);
                    if (fuelReceived > 0 && isTankEmpty) {
                        this.output = FuelHandler.getFuel((Gas)this.fuelTank.getGas().getGas()).energyPerTick * 2.0;
                    }
                }
            }
            if ((operate = this.canOperate()) && this.getEnergy() + this.generationRate < this.getMaxEnergy()) {
                this.setActive(true);
                if (this.fuelTank.getStored() != 0) {
                    FuelHandler.FuelGas fuel = FuelHandler.getFuel(this.fuelTank.getGas().getGas());
                    this.maxBurnTicks = fuel.burnTicks;
                    this.generationRate = fuel.energyPerTick;
                }
                int toUse = this.getToUse() * this.Thread();
                this.output = Math.max(MekanismConfig.current().general.FROM_H2.val() * 2.0 * 27.0, this.generationRate * (double)this.getToUse() * 2.0 * 27.0) * (double)this.Thread();
                int total = this.burnTicks + this.fuelTank.getStored() * this.maxBurnTicks;
                total -= toUse;
                this.setEnergy(this.getEnergy() + this.generationRate * (double)toUse * (double)this.Thread());
                if (this.fuelTank.getStored() > 0) {
                    this.fuelTank.setGas(new GasStack(this.fuelTank.getGasType(), total / this.maxBurnTicks));
                }
                this.burnTicks = total % this.maxBurnTicks;
                this.clientUsed = toUse;
            } else {
                if (!operate) {
                    this.reset();
                }
                this.clientUsed = 0;
                this.setActive(false);
            }
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.currentRedstoneLevel = newRedstoneLevel;
            }
            if (MekanismUtils.canFunction(this)) {
                Mekanism.EXECUTE_MANAGER.addSyncTask(() -> CableUtils.emit(this, 3));
            }
        } else if (this.getActive()) {
            this.animation %= 10;
        }
    }

    public void reset() {
        this.burnTicks = 0;
        this.maxBurnTicks = 0;
        this.generationRate = 0.0;
        this.output = MekanismConfig.current().general.FROM_H2.val() * 2.0 * 27.0;
    }

    public int getToUse() {
        if (this.generationRate == 0.0 || this.fuelTank.getGas() == null) {
            return 0;
        }
        int max = (int)Math.ceil((float)this.fuelTank.getStored() / (float)this.fuelTank.getMaxGas() * 256.0f);
        max = Math.min(this.fuelTank.getStored() * this.maxBurnTicks + this.burnTicks, max);
        max = (int)Math.min((this.getMaxEnergy() - this.getEnergy()) / this.generationRate, (double)max);
        return max;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, true);
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null;
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && FuelHandler.getFuel(((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas()) != null;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged(itemstack);
        }
        return true;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        int[] nArray;
        if (side == MekanismUtils.getRight(this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    @Override
    public boolean canOperate() {
        return (this.fuelTank.getStored() > 0 || this.burnTicks > 0) && MekanismUtils.canFunction(this);
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getEnergy();
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.output;
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.getMaxEnergy();
                break;
            }
            case 3: {
                Object[] objectArray5 = new Object[1];
                objectArray = objectArray5;
                objectArray5[0] = this.getMaxEnergy() - this.getEnergy();
                break;
            }
            case 4: {
                Object[] objectArray6 = new Object[1];
                objectArray = objectArray6;
                objectArray6[0] = this.fuelTank.getStored();
                break;
            }
            case 5: {
                Object[] objectArray7 = new Object[1];
                objectArray = objectArray7;
                objectArray7[0] = this.fuelTank.getNeeded();
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.fuelTank);
            this.generationRate = dataStream.readDouble();
            this.output = dataStream.readDouble();
            this.clientUsed = dataStream.readInt();
            this.numPowering = dataStream.readInt();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.fuelTank);
        data.add(this.generationRate);
        data.add(this.output);
        data.add(this.clientUsed);
        data.add(this.numPowering);
        return data;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        boolean isTankEmpty;
        boolean bl = isTankEmpty = this.fuelTank.getGas() == null;
        if (this.canReceiveGas(side, stack.getGas()) && (isTankEmpty || this.fuelTank.getGas().isGasEqual(stack))) {
            int fuelReceived = this.fuelTank.receive(stack, doTransfer);
            if (doTransfer && isTankEmpty && fuelReceived > 0) {
                this.output = FuelHandler.getFuel((Gas)this.fuelTank.getGas().getGas()).energyPerTick * 2.0;
            }
            return fuelReceived;
        }
        return 0;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.fuelTank};
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        FuelHandler.FuelGas fuel;
        super.readCustomNBT(nbtTags);
        this.fuelTank.read(nbtTags.func_74775_l("fuelTank"));
        boolean isTankEmpty = this.fuelTank.getGas() == null;
        FuelHandler.FuelGas fuelGas = fuel = isTankEmpty ? null : FuelHandler.getFuel(this.fuelTank.getGas().getGas());
        if (fuel != null) {
            this.output = fuel.energyPerTick * 2.0;
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("fuelTank", (NBTBase)this.fuelTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return FuelHandler.getFuel(type) != null && side != this.facing && side != EnumFacing.UP && side != EnumFacing.DOWN;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return side != this.facing && side != EnumFacing.UP && side != EnumFacing.DOWN && capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (side != this.facing && side != EnumFacing.UP && side != EnumFacing.DOWN && capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        EnumFacing left = MekanismUtils.getLeft(this.facing);
        EnumFacing right = MekanismUtils.getRight(this.facing);
        EnumFacing back = MekanismUtils.getBack(this.facing);
        if (side != this.facing && side != EnumFacing.UP && side != EnumFacing.DOWN && capability == Capabilities.GAS_HANDLER_CAPABILITY || side != this.facing && side != left && side != right && side != back && side != EnumFacing.DOWN && (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side))) {
            return true;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fuelTank != null) {
            ItemDataUtils.setCompound(itemStack, "fuelTank", this.fuelTank.write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "fuelTank")) {
            FuelHandler.FuelGas fuel;
            this.fuelTank.read(ItemDataUtils.getCompound(itemStack, "fuelTank"));
            boolean isTankEmpty = this.fuelTank.getGas() == null;
            FuelHandler.FuelGas fuelGas = fuel = isTankEmpty ? null : FuelHandler.getFuel(this.fuelTank.getGas().getGas());
            if (fuel != null) {
                this.output = fuel.energyPerTick * 2.0;
            }
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fuelTank.getStored(), this.fuelTank.getMaxGas());
    }

    @Override
    public boolean canBoundReceiveEnergy(BlockPos location, EnumFacing side) {
        return false;
    }

    @Override
    public boolean canBoundOutPutEnergy(BlockPos coord, EnumFacing side) {
        if (coord.equals((Object)this.func_174877_v().func_177967_a(EnumFacing.UP, 2))) {
            return side == EnumFacing.UP;
        }
        return false;
    }

    @Override
    public void onPower() {
        ++this.numPowering;
    }

    @Override
    public void onNoPower() {
        --this.numPowering;
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public void onPlace() {
        for (int y = 0; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    if (y != 2) {
                        if (x == z || x == -z || this.facing == EnumFacing.NORTH && x == 0 && z == -1 || this.facing == EnumFacing.WEST && z == 0 && x == -1 || this.facing == EnumFacing.SOUTH && x == 0 && z == 1 || this.facing == EnumFacing.EAST && z == 0 && x == 1) {
                            MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x, y, z), Coord4D.get(this));
                        } else {
                            MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x, y, z), Coord4D.get(this));
                        }
                    } else if (x == 0 && z == 0) {
                        MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x, y, z), Coord4D.get(this));
                    } else {
                        MekanismUtils.makeBoundingBlock(this.field_145850_b, this.func_174877_v().func_177982_a(x, y, z), Coord4D.get(this));
                    }
                    this.field_145850_b.func_175685_c(this.func_174877_v().func_177982_a(x, y, z), this.func_145838_q(), true);
                }
            }
        }
    }

    @Override
    public void onBreak() {
        for (int y = 0; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(x, y, z));
                }
            }
        }
    }

    @Override
    public boolean hasOffsetCapability(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        EnumFacing left = MekanismUtils.getLeft(this.facing);
        EnumFacing right = MekanismUtils.getRight(this.facing);
        EnumFacing back = MekanismUtils.getBack(this.facing);
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return false;
        }
        if (side != this.facing && side != left && side != right && side != back && side != EnumFacing.DOWN && (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side)) || side != this.facing && side != EnumFacing.UP && side != EnumFacing.DOWN && capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return true;
        }
        return this.hasCapability(capability, side);
    }

    @Override
    @Nullable
    public <T> T getOffsetCapability(@Nonnull Capability<T> capability, EnumFacing side, @Nonnull Vec3i offset) {
        EnumFacing left = MekanismUtils.getLeft(this.facing);
        EnumFacing right = MekanismUtils.getRight(this.facing);
        EnumFacing back = MekanismUtils.getBack(this.facing);
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return null;
        }
        if (side != this.facing && side != left && side != right && side != back && side != EnumFacing.DOWN) {
            if (this.isStrictEnergy(capability)) {
                return (T)this;
            }
            if (this.isTesla(capability, side)) {
                return (T)this.getTeslaEnergyWrapper(side);
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.getForgeEnergyWrapper(side));
            }
        } else if (side != this.facing && side != EnumFacing.UP && side != EnumFacing.DOWN && capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return this.getCapability(capability, side);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        EnumFacing left = MekanismUtils.getLeft(this.facing);
        EnumFacing right = MekanismUtils.getRight(this.facing);
        EnumFacing back = MekanismUtils.getBack(this.facing);
        if (side != this.facing && side != left && side != right && side != back && side != EnumFacing.DOWN && (this.isStrictEnergy(capability) || capability == CapabilityEnergy.ENERGY || this.isTesla(capability, side))) {
            if (offset.equals((Object)new Vec3i(0, 2, 0))) {
                return side != EnumFacing.UP;
            }
        } else if (side != this.facing && side != EnumFacing.UP && side != EnumFacing.DOWN && capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            for (int y = 0; y < 1; ++y) {
                if (offset.equals((Object)new Vec3i(back.func_82601_c(), y, back.func_82599_e()))) {
                    return side != back;
                }
                if (offset.equals((Object)new Vec3i(left.func_82601_c(), y, left.func_82599_e()))) {
                    return side != left;
                }
                if (!offset.equals((Object)new Vec3i(right.func_82601_c(), y, right.func_82599_e()))) continue;
                return side != right;
            }
        }
        return false;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public int getAnimation() {
        return this.animation;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K && !this.rendererInitialized) {
            this.rendererInitialized = true;
            if (Mekanism.hooks.Bloom && MekanismConfig.current().client.enableBloom.val()) {
                new BloomRendererLargeGasGenerator(this);
            }
        }
    }
}

