/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.tile;

import ic2.api.energy.tile.IEnergyEmitter;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.common.Mekanism;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ITankManager;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.TileUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityMidsizeGasTank
extends TileEntityContainerBlock
implements IGasHandler,
IRedstoneControl,
ISecurityTile,
IComputerIntegration,
IComparatorSupport,
IAdvancedBoundingBlock,
ITankManager {
    private static final String[] methods = new String[]{"getMaxGas", "getStoredGas", "getGas"};
    public GasTank gasTank;
    public TileEntityGasTank.GasMode dumping = TileEntityGasTank.GasMode.IDLE;
    public int GasOut;
    public int GasStorage;
    public int currentGasAmount;
    public int currentRedstoneLevel;
    public IRedstoneControl.RedstoneControl controlType;
    public TileComponentSecurity securityComponent;
    public int numPowering;

    public TileEntityMidsizeGasTank(String name, int maxGas, int gasOut) {
        super(name);
        this.inventory = NonNullListSynchronized.withSize(2, ItemStack.field_190927_a);
        this.gasTank = new GasTank(maxGas);
        this.GasOut = gasOut;
        this.GasStorage = maxGas;
        this.securityComponent = new TileComponentSecurity(this);
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
    }

    public TileEntityMidsizeGasTank() {
        this("MidsizeGasTank", MekanismConfig.current().multiblock.MidsizeGasTankStorage.val(), MekanismConfig.current().multiblock.MidsizeGasTankOutput.val());
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            int newGasAmount;
            IGasItem item;
            TileUtils.drawGas((ItemStack)this.inventory.get(0), this.gasTank, true);
            Item item2 = ((ItemStack)this.inventory.get(1)).func_77973_b();
            TileUtils.receiveGasItem((ItemStack)this.inventory.get(1), this.gasTank, item2 instanceof IGasItem && !(item = (IGasItem)item2).getGas((ItemStack)this.inventory.get(1)).getGas().isRadiation());
            if (this.gasTank.getGas() != null && MekanismUtils.canFunction(this) && this.dumping != TileEntityGasTank.GasMode.DUMPING) {
                Mekanism.EXECUTE_MANAGER.addSyncTask(() -> this.handleTank(this.gasTank, this.getOutputTank()));
            }
            if (this.dumping == TileEntityGasTank.GasMode.DUMPING) {
                this.gasTank.draw(this.GasStorage / 400, true);
            }
            if (this.dumping == TileEntityGasTank.GasMode.DUMPING_EXCESS && this.gasTank.getNeeded() < this.GasOut) {
                this.gasTank.draw(this.GasOut - this.gasTank.getNeeded(), true);
            }
            if ((newGasAmount = this.gasTank.getStored()) != this.currentGasAmount) {
                MekanismUtils.saveChunk(this);
            }
            this.currentGasAmount = newGasAmount;
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.markNoUpdateSync();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        Item item = itemstack.func_77973_b();
        if (slotID == 1) {
            IGasItem gasItem;
            IGasItem gasItem2;
            if (item instanceof IGasItem && (gasItem2 = (IGasItem)item).getGas(itemstack) != null && gasItem2.getGas(itemstack).getGas().isRadiation()) {
                return false;
            }
            return item instanceof IGasItem && (gasItem = (IGasItem)item).getGas(itemstack) == null;
        }
        if (slotID == 0) {
            IGasItem gasItem;
            Item item2 = itemstack.func_77973_b();
            return item2 instanceof IGasItem && (gasItem = (IGasItem)item2).getGas(itemstack) != null && gasItem.getGas((ItemStack)itemstack).amount == gasItem.getMaxGas(itemstack);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        if (slotID == 0) {
            Item item2 = itemstack.func_77973_b();
            if (!(item2 instanceof IGasItem)) return false;
            IGasItem gasItem = (IGasItem)item2;
            if (this.gasTank.getGas() == null) return true;
            if (!gasItem.canReceiveGas(itemstack, this.gasTank.getGas().getGas())) return false;
            return true;
        }
        if (slotID != 1) return false;
        if (!(item instanceof IGasItem)) return false;
        IGasItem gasItem = (IGasItem)item;
        GasStack gas = gasItem.getGas(itemstack);
        if (gas == null) {
            return true;
        }
        Gas type = gas.getGas();
        if (type.isRadiation()) {
            return false;
        }
        if (this.gasTank.getGas() == null) return true;
        if (!gasItem.canProvideGas(itemstack, this.gasTank.getGas().getGas())) return false;
        return true;
    }

    @Override
    @NotNull
    public int[] func_180463_a(@NotNull EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.gasTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return this.gasTank.canDraw(type) && side == this.facing && !type.isRadiation();
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.gasTank.canReceive(type) && side == MekanismUtils.getBack(this.facing) && !type.isRadiation();
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.gasTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return side != MekanismUtils.getBack(this.facing);
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                int index = (this.dumping.ordinal() + 1) % TileEntityGasTank.GasMode.values().length;
                this.dumping = TileEntityGasTank.GasMode.values()[index];
            }
            if (type == 1) {
                this.gasTank.setGas(null);
            }
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(this), (EntityPlayerMP)player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.gasTank.setMaxGas(this.GasStorage);
            TileUtils.readTankData(dataStream, this.gasTank);
            this.dumping = TileEntityGasTank.GasMode.values()[dataStream.readInt()];
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.numPowering = dataStream.readInt();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        this.dumping = TileEntityGasTank.GasMode.values()[nbtTags.func_74762_e("dumping")];
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.numPowering = nbtTags.func_74762_e("numPowering");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        nbtTags.func_74768_a("dumping", this.dumping.ordinal());
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74768_a("numPowering", this.numPowering);
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.gasTank);
        data.add(this.dumping.ordinal());
        data.add(this.controlType.ordinal());
        data.add(this.numPowering);
        return data;
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    public TileEntity getOutputTank() {
        BlockPos pos = this.func_174877_v().func_177984_a();
        if (this.field_145850_b.func_175625_s(pos) != null) {
            return this.field_145850_b.func_175625_s(pos);
        }
        return null;
    }

    private void handleTank(GasTank tank, TileEntity tile) {
        if (tank.getGas() != null && tank.getGas().getGas() != null) {
            GasStack toSend = tank.getGas().copy().withAmount(Math.min(tank.getStored(), this.GasOut));
            tank.draw(GasUtils.emit(toSend, tile, Collections.singleton(this.facing)), true);
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.gasTank.getStored(), this.gasTank.getMaxGas());
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        Object[] objectArray;
        switch (method) {
            case 0: {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.gasTank.getMaxGas();
                break;
            }
            case 1: {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.gasTank.getStored();
                break;
            }
            case 2: {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.gasTank.getGas();
                break;
            }
            default: {
                throw new NoSuchMethodException();
            }
        }
        return objectArray;
    }

    @Override
    public boolean canBoundReceiveEnergy(BlockPos location, EnumFacing side) {
        return false;
    }

    @Override
    public boolean canBoundOutPutEnergy(BlockPos location, EnumFacing side) {
        return false;
    }

    @Override
    public void onPower() {
        ++this.numPowering;
    }

    @Override
    public void onNoPower() {
        --this.numPowering;
    }

    @Override
    public NBTTagCompound getConfigurationData(NBTTagCompound nbtTags) {
        return nbtTags;
    }

    @Override
    public void setConfigurationData(NBTTagCompound nbtTags) {
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.gasTank};
    }

    @Override
    public String getDataType() {
        return this.func_145838_q().func_149739_a() + "." + this.fullName + ".name";
    }

    @Override
    public void onPlace() {
        Coord4D current = Coord4D.get(this);
        MekanismUtils.makeAdvancedBoundingBlock(this.field_145850_b, this.func_174877_v().func_177984_a(), current);
    }

    @Override
    public void onBreak() {
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177984_a());
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    @Override
    public boolean hasOffsetCapability(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return false;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return true;
        }
        return this.hasCapability(capability, side);
    }

    @Override
    @Nullable
    public <T> T getOffsetCapability(@NotNull Capability<T> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (this.isOffsetCapabilityDisabled(capability, side, offset)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return this.getCapability(capability, side);
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@NotNull Capability<?> capability, @Nullable EnumFacing side, @NotNull Vec3i offset) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY && offset.equals((Object)new Vec3i(0, 1, 0))) {
            return side != this.facing;
        }
        return false;
    }

    @Override
    public double getEnergy() {
        return 0.0;
    }

    @Override
    public void setEnergy(double energy) {
    }

    @Override
    public double getMaxEnergy() {
        return 0.0;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(EnumFacing enumFacing, int i, boolean b) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing enumFacing, int i, boolean b) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing enumFacing) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing enumFacing) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing enumFacing) {
        return false;
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 0;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing enumFacing, double v, double v1) {
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        return false;
    }

    @Override
    public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
        return 0.0;
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return false;
    }

    @Override
    public double pullEnergy(EnumFacing side, double amount, boolean simulate) {
        return 0.0;
    }

    @Override
    public boolean canOutputEnergy(EnumFacing side) {
        return false;
    }
}

