/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.item;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismClient;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.forgeenergy.ForgeEnergyItemWrapper;
import mekanism.common.integration.ic2.IC2ItemManager;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.integration.tesla.TeslaItemWrapper;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachine;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2")})
public class ItemBlockMultiblockMachine
extends ItemBlock
implements IEnergizedItem,
ISpecialElectricItem,
ISustainedInventory,
ISustainedTank,
IEnergyContainerItem,
ISecurityItem {
    public Block metaBlock;

    public ItemBlockMultiblockMachine(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.setNoRepair();
    }

    public int func_77647_b(int i) {
        return i;
    }

    @Nonnull
    public String func_77667_c(ItemStack itemstack) {
        if (BlockStateMultiblockMachine.MultiblockMachineType.get(itemstack) != null) {
            return this.func_77658_a() + "." + BlockStateMultiblockMachine.MultiblockMachineType.get((ItemStack)itemstack).blockName;
        }
        return "null";
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack itemstack) {
        return super.func_77653_i(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemstack, World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        BlockStateMultiblockMachine.MultiblockMachineType type = BlockStateMultiblockMachine.MultiblockMachineType.get(itemstack);
        if (type != null) {
            if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
                list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.INDIGO) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
                list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.and") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.modeSwitchKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDesc") + ".");
            } else if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.modeSwitchKey)) {
                if (this.hasSecurity(itemstack)) {
                    list.add(SecurityUtils.getOwnerDisplay((EntityPlayer)Minecraft.func_71410_x().field_71439_g, MekanismClient.clientUUIDMap.get(this.getOwnerUUID(itemstack))));
                    list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.security") + ": " + SecurityUtils.getSecurityDisplay(itemstack, Side.CLIENT));
                    if (SecurityUtils.isOverridden(itemstack, Side.CLIENT)) {
                        list.add((Object)((Object)EnumColor.RED) + "(" + LangUtils.localize("gui.overridden") + ")");
                    }
                }
                if (type.isElectric && itemstack.func_190916_E() <= 1) {
                    list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack), this.getMaxEnergy(itemstack)));
                }
                list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
                if (type.supportsUpgrades && ItemDataUtils.hasData(itemstack, "upgrades")) {
                    Map<Upgrade, Integer> upgrades = Upgrade.buildMap(ItemDataUtils.getDataMap(itemstack));
                    for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
                        list.add((Object)((Object)entry.getKey().getColor()) + "- " + entry.getKey().getName() + (entry.getKey().canMultiply() ? ": " + (Object)((Object)EnumColor.GREY) + "x" + entry.getValue() : ""));
                    }
                }
            } else {
                list.addAll(MekanismUtils.splitTooltip(type.getDescription(), itemstack));
            }
        }
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState state) {
        int yPos;
        BlockPos.MutableBlockPos testPos;
        if (stack.func_190916_E() > 1) {
            return false;
        }
        boolean place = true;
        BlockStateMultiblockMachine.MultiblockMachineType type = BlockStateMultiblockMachine.MultiblockMachineType.get(stack);
        if (type == BlockStateMultiblockMachine.MultiblockMachineType.LARGE_ELECTROLYTIC_SEPARATOR || type == BlockStateMultiblockMachine.MultiblockMachineType.LARGE_CHEMICAL_INFUSER) {
            testPos = new BlockPos.MutableBlockPos();
            for (yPos = 0; yPos <= 1; ++yPos) {
                for (int xPos = -1; xPos <= 1; ++xPos) {
                    for (int zPos = -1; zPos <= 1; ++zPos) {
                        testPos.func_181079_c(pos.func_177958_n() + xPos, pos.func_177956_o() + yPos, pos.func_177952_p() + zPos);
                        Block b = world.func_180495_p((BlockPos)testPos).func_177230_c();
                        if (world.func_175701_a((BlockPos)testPos) && world.func_175668_a((BlockPos)testPos, false) && b.func_176200_f((IBlockAccess)world, (BlockPos)testPos)) continue;
                        place = false;
                    }
                }
            }
        } else if (type == BlockStateMultiblockMachine.MultiblockMachineType.LARGE_CHEMICAL_WASHER) {
            testPos = new BlockPos.MutableBlockPos();
            for (yPos = 0; yPos <= 2; ++yPos) {
                for (int xPos = -1; xPos <= 1; ++xPos) {
                    for (int zPos = -1; zPos <= 1; ++zPos) {
                        testPos.func_181079_c(pos.func_177958_n() + xPos, pos.func_177956_o() + yPos, pos.func_177952_p() + zPos);
                        Block b = world.func_180495_p((BlockPos)testPos).func_177230_c();
                        if (world.func_175701_a((BlockPos)testPos) && world.func_175668_a((BlockPos)testPos, false) && b.func_176200_f((IBlockAccess)world, (BlockPos)testPos)) continue;
                        place = false;
                    }
                }
            }
        } else if (type == BlockStateMultiblockMachine.MultiblockMachineType.DIGITAL_ASSEMBLY_TABLE) {
            testPos = new BlockPos.MutableBlockPos();
            for (yPos = 0; yPos <= 4; ++yPos) {
                for (int xPos = -5; xPos <= 5; ++xPos) {
                    for (int zPos = -5; zPos <= 5; ++zPos) {
                        testPos.func_181079_c(pos.func_177958_n() + xPos, pos.func_177956_o() + yPos, pos.func_177952_p() + zPos);
                        Block b = world.func_180495_p((BlockPos)testPos).func_177230_c();
                        if (world.func_175701_a((BlockPos)testPos) && world.func_175668_a((BlockPos)testPos, false) && b.func_176200_f((IBlockAccess)world, (BlockPos)testPos)) continue;
                        place = false;
                    }
                }
            }
        }
        if (place && super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state)) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
            if (tileEntity instanceof ISecurityTile) {
                ISecurityTile security = (ISecurityTile)((Object)tileEntity);
                security.getSecurity().setOwnerUUID(this.getOwnerUUID(stack));
                if (this.hasSecurity(stack)) {
                    security.getSecurity().setMode(this.getSecurity(stack));
                }
                if (this.getOwnerUUID(stack) == null) {
                    security.getSecurity().setOwnerUUID(player.func_110124_au());
                }
            }
            if (tileEntity instanceof IUpgradeTile) {
                IUpgradeTile upgradeTile = (IUpgradeTile)((Object)tileEntity);
                if (ItemDataUtils.hasData(stack, "upgrades")) {
                    upgradeTile.getComponent().read(ItemDataUtils.getDataMap(stack));
                }
            }
            if (tileEntity instanceof ISustainedData) {
                ISustainedData data = (ISustainedData)((Object)tileEntity);
                if (stack.func_77978_p() != null) {
                    data.readSustainedData(stack);
                }
            }
            if (tileEntity instanceof IRedstoneControl) {
                IRedstoneControl control = (IRedstoneControl)((Object)tileEntity);
                if (ItemDataUtils.hasData(stack, "controlType")) {
                    control.setControlType(IRedstoneControl.RedstoneControl.values()[ItemDataUtils.getInt(stack, "controlType")]);
                }
            }
            if (tileEntity instanceof ISustainedTank) {
                ISustainedTank tank = (ISustainedTank)((Object)tileEntity);
                if (this.hasTank(stack) && this.getFluidStack(stack) != null) {
                    tank.setFluidStack(this.getFluidStack(stack), new Object[0]);
                }
            }
            if (tileEntity instanceof ISustainedInventory) {
                ISustainedInventory inventory = (ISustainedInventory)((Object)tileEntity);
                inventory.setInventory(this.getInventory(stack), new Object[0]);
            }
            if (tileEntity instanceof TileEntityElectricBlock) {
                TileEntityElectricBlock entityElectricBlock = (TileEntityElectricBlock)tileEntity;
                entityElectricBlock.electricityStored.set(this.getEnergy(stack));
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, @Nonnull EnumHand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        BlockStateMultiblockMachine.MultiblockMachineType type = BlockStateMultiblockMachine.MultiblockMachineType.get(itemstack);
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        Object object = data[0];
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            ItemDataUtils.setList(stack, "Items", nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        Object object = data[0];
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            return ItemDataUtils.getList(stack, "Items");
        }
        return null;
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        Object object = data[0];
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            if (fluidStack == null || fluidStack.amount == 0) {
                ItemDataUtils.removeData(itemStack, "fluidTank");
            } else {
                ItemDataUtils.setCompound(itemStack, "fluidTank", fluidStack.writeToNBT(new NBTTagCompound()));
            }
        }
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        Object object = data[0];
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            if (!ItemDataUtils.hasData(itemStack, "fluidTank")) {
                return null;
            }
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "fluidTank"));
        }
        return null;
    }

    @Override
    public boolean hasTank(Object ... data) {
        ItemStack stack;
        Object object = data[0];
        return object instanceof ItemStack && (stack = (ItemStack)object).func_77973_b() instanceof ISustainedTank && stack.func_77952_i() == 2;
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.func_190916_E() > 1) {
            return 0.0;
        }
        if (!BlockStateMultiblockMachine.MultiblockMachineType.get((ItemStack)itemStack).isElectric) {
            return 0.0;
        }
        return ItemDataUtils.getDouble(itemStack, "energyStored");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (!BlockStateMultiblockMachine.MultiblockMachineType.get((ItemStack)itemStack).isElectric) {
            return;
        }
        if (amount == 0.0) {
            NBTTagCompound dataMap = ItemDataUtils.getDataMap(itemStack);
            dataMap.func_82580_o("energyStored");
            if (dataMap.func_82582_d() && itemStack.func_77978_p() != null) {
                itemStack.func_77978_p().func_82580_o("mekData");
            }
        } else {
            ItemDataUtils.setDouble(itemStack, "energyStored", Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0));
        }
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        BlockStateMultiblockMachine.MultiblockMachineType type = BlockStateMultiblockMachine.MultiblockMachineType.get(itemStack);
        return ItemDataUtils.hasData(itemStack, "upgrades") ? MekanismUtils.getMaxEnergy(itemStack, type.getStorage()) : type.getStorage();
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        if (itemStack.func_190916_E() > 1) {
            return 0.0;
        }
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return BlockStateMultiblockMachine.MultiblockMachineType.get((ItemStack)itemStack).isElectric && itemStack.func_190916_E() == 1;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (theItem.func_190916_E() > 1) {
            return 0;
        }
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min(RFIntegration.fromRF(energy), energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return RFIntegration.toRF(toReceive);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (theItem.func_190916_E() > 1) {
            return 0;
        }
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min(RFIntegration.fromRF(energy), energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return RFIntegration.toRF(toSend);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack theItem) {
        return RFIntegration.toRF(this.getEnergy(theItem));
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack theItem) {
        return RFIntegration.toRF(this.getMaxEnergy(theItem));
    }

    @Optional.Method(modid="ic2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    @Override
    public UUID getOwnerUUID(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "ownerUUID")) {
            return UUID.fromString(ItemDataUtils.getString(stack, "ownerUUID"));
        }
        return null;
    }

    @Override
    public void setOwnerUUID(ItemStack stack, UUID owner) {
        if (owner == null) {
            ItemDataUtils.removeData(stack, "ownerUUID");
            return;
        }
        ItemDataUtils.setString(stack, "ownerUUID", owner.toString());
    }

    @Override
    public ISecurityTile.SecurityMode getSecurity(ItemStack stack) {
        if (!MekanismConfig.current().general.allowProtection.val()) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        return ISecurityTile.SecurityMode.values()[ItemDataUtils.getInt(stack, "security")];
    }

    @Override
    public void setSecurity(ItemStack stack, ISecurityTile.SecurityMode mode) {
        if (this.getOwnerUUID(stack) == null) {
            ItemDataUtils.removeData(stack, "security");
        } else {
            ItemDataUtils.setInt(stack, "security", mode.ordinal());
        }
    }

    @Override
    public boolean hasSecurity(ItemStack stack) {
        BlockStateMultiblockMachine.MultiblockMachineType type = BlockStateMultiblockMachine.MultiblockMachineType.get(stack);
        return true;
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return this.hasSecurity(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityWrapper(stack, new TeslaItemWrapper(), new ForgeEnergyItemWrapper());
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergy(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getEnergy(stack) / this.getMaxEnergy(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

