/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismClient;
import mekanism.client.MekanismKeyHandler;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.config.MekanismConfig;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.multiblockmachine.common.MekanismMultiblockMachine;
import mekanism.multiblockmachine.common.tile.TileEntityMidsizeGasTank;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockMidsizeGasTank
extends ItemBlock
implements IGasItem,
ISustainedInventory,
ISecurityItem {
    public Block metaBlock;

    public ItemBlockMidsizeGasTank(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77637_a(MekanismMultiblockMachine.tabMekanismMultiblockMachine);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemstack, World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (itemstack.func_190916_E() <= 1) {
            if (gasStack == null) {
                list.add((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.empty") + ".");
            } else {
                String amount = gasStack.amount == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.toString(gasStack.amount);
                list.add((Object)((Object)EnumColor.ORANGE) + gasStack.getGas().getLocalizedName() + ": " + (Object)((Object)EnumColor.GREY) + amount);
            }
        }
        int cap = this.getMaxGas(itemstack);
        list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + (cap == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(cap)));
        if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
        } else {
            if (this.hasSecurity(itemstack)) {
                list.add(SecurityUtils.getOwnerDisplay((EntityPlayer)Minecraft.func_71410_x().field_71439_g, MekanismClient.clientUUIDMap.get(this.getOwnerUUID(itemstack))));
                list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.security") + ": " + SecurityUtils.getSecurityDisplay(itemstack, Side.CLIENT));
                if (SecurityUtils.isOverridden(itemstack, Side.CLIENT)) {
                    list.add((Object)((Object)EnumColor.RED) + "(" + LangUtils.localize("gui.overridden") + ")");
                }
            }
            list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
        }
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState state) {
        if (stack.func_190916_E() > 1) {
            return false;
        }
        boolean place = true;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(!(stack.func_77973_b() instanceof ItemBlockMidsizeGasTank) || block.func_176200_f((IBlockAccess)world, pos) && world.func_175623_d(pos.func_177982_a(0, 1, 0)))) {
            place = false;
        }
        if (place && super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state)) {
            TileEntityMidsizeGasTank tileEntity = (TileEntityMidsizeGasTank)world.func_175625_s(pos);
            tileEntity.gasTank.setMaxGas(tileEntity.GasStorage);
            tileEntity.gasTank.setGas(this.getGas(stack));
            tileEntity.getSecurity().setOwnerUUID(this.getOwnerUUID(stack));
            if (this.hasSecurity(stack)) {
                tileEntity.getSecurity().setMode(this.getSecurity(stack));
            }
            if (this.getOwnerUUID(stack) == null) {
                tileEntity.getSecurity().setOwnerUUID(player.func_110124_au());
            }
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            if (!world.field_72995_K) {
                Mekanism.packetHandler.sendUpdatePacket(tileEntity);
            }
        }
        return place;
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        return GasStack.readFromNBT(ItemDataUtils.getCompound(itemstack, "stored"));
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (itemstack.func_190916_E() > 1) {
            return;
        }
        if (stack == null || stack.amount == 0) {
            ItemDataUtils.removeData(itemstack, "stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            ItemDataUtils.setCompound(itemstack, "stored", gasStack.write(new NBTTagCompound()));
        }
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return 0x190000;
    }

    @Override
    public int getRate(ItemStack itemstack) {
        if (itemstack.func_190916_E() > 1) {
            return 0;
        }
        return 1024000;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (itemstack.func_190916_E() > 1) {
            return 0;
        }
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas() && this.getGas(itemstack).getGas().isRadiation()) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        if (itemstack.func_190916_E() > 1) {
            return null;
        }
        if (this.getGas(itemstack) == null) {
            return null;
        }
        Gas type = this.getGas(itemstack).getGas();
        int gasToUse = Math.min(this.getStored(itemstack), Math.min(this.getRate(itemstack), amount));
        this.setGas(itemstack, new GasStack(type, this.getStored(itemstack) - gasToUse));
        return new GasStack(type, gasToUse);
    }

    private int getStored(ItemStack itemstack) {
        if (itemstack.func_190916_E() > 1) {
            return 0;
        }
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        if (itemstack.func_190916_E() > 1) {
            return false;
        }
        if (type.isRadiation()) {
            return false;
        }
        return this.getGas(itemstack) == null || this.getGas(itemstack).getGas() == type;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        if (itemstack.func_190916_E() > 1) {
            return false;
        }
        if (this.getGas(itemstack) != null && (type == null || this.getGas(itemstack).getGas().isRadiation())) {
            return false;
        }
        return this.getGas(itemstack) != null && (type == null || this.getGas(itemstack).getGas() == type);
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        Object object = data[0];
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            ItemDataUtils.setList(stack, "Items", nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        Object object = data[0];
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            return ItemDataUtils.getList(stack, "Items");
        }
        return null;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getStored(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (this.getGas(stack) != null ? (double)this.getGas((ItemStack)stack).amount : 0.0) / (double)this.getMaxGas(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        GasStack gas = this.getGas(stack);
        if (gas != null) {
            MekanismRenderer.color(gas);
            return gas.getGas().getTint();
        }
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public UUID getOwnerUUID(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "ownerUUID")) {
            return UUID.fromString(ItemDataUtils.getString(stack, "ownerUUID"));
        }
        return null;
    }

    @Override
    public void setOwnerUUID(ItemStack stack, UUID owner) {
        if (owner == null) {
            ItemDataUtils.removeData(stack, "ownerUUID");
        } else {
            ItemDataUtils.setString(stack, "ownerUUID", owner.toString());
        }
    }

    @Override
    public ISecurityTile.SecurityMode getSecurity(ItemStack stack) {
        if (!MekanismConfig.current().general.allowProtection.val()) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        return ISecurityTile.SecurityMode.values()[ItemDataUtils.getInt(stack, "security")];
    }

    @Override
    public void setSecurity(ItemStack stack, ISecurityTile.SecurityMode mode) {
        if (this.getOwnerUUID(stack) == null) {
            ItemDataUtils.removeData(stack, "security");
        } else {
            ItemDataUtils.setInt(stack, "security", mode.ordinal());
        }
    }

    @Override
    public boolean hasSecurity(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return this.hasSecurity(stack);
    }
}

