/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.block.states;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.common.base.IBlockType;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.block.states.BlockStateUtils;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.LangUtils;
import mekanism.multiblockmachine.common.MultiblockMachineBlocks;
import mekanism.multiblockmachine.common.block.BlockMultiblockMachineGenerator;
import mekanism.multiblockmachine.common.tile.generator.TileEntityLargeGasGenerator;
import mekanism.multiblockmachine.common.tile.generator.TileEntityLargeHeatGenerator;
import mekanism.multiblockmachine.common.tile.generator.TileEntityLargeWindGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockStateMultiblockMachineGenerator
extends ExtendedBlockState {
    public static final PropertyBool activeProperty = PropertyBool.func_177716_a((String)"active");

    public BlockStateMultiblockMachineGenerator(BlockMultiblockMachineGenerator block, PropertyEnum<?> typeProperty) {
        super((Block)block, new IProperty[]{BlockStateFacing.facingProperty, typeProperty, activeProperty}, new IUnlistedProperty[0]);
    }

    public static class MultiblockMachineGeneratorBlockStateMapper
    extends StateMapperBase {
        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            BlockMultiblockMachineGenerator block = (BlockMultiblockMachineGenerator)state.func_177230_c();
            MultiblockMachineGeneratorType type = (MultiblockMachineGeneratorType)((Object)state.func_177229_b(block.getTypeProperty()));
            StringBuilder builder = new StringBuilder();
            if (type.hasActiveTexture()) {
                builder.append(activeProperty.func_177701_a());
                builder.append("=");
                builder.append(state.func_177229_b((IProperty)activeProperty));
            }
            if (type.hasRotations()) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockStateFacing.facingProperty);
                if (!type.canRotateTo(facing)) {
                    facing = EnumFacing.NORTH;
                }
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(BlockStateFacing.facingProperty.func_177701_a());
                builder.append("=");
                builder.append(facing.func_176610_l());
            }
            if (builder.length() == 0) {
                builder.append("normal");
            }
            ResourceLocation baseLocation = new ResourceLocation("mekanismmultiblockmachine", type.func_176610_l());
            return new ModelResourceLocation(baseLocation, builder.toString());
        }
    }

    public static enum MultiblockMachineGeneratorType implements IStringSerializable,
    IBlockType
    {
        LARGE_WIND_GENERATOR(MultiblockMachineGeneratorBlock.MULTIBLOCK_MACHINE_GENERATOR_BLOCK_1, 0, "LargeWindGenerator", 0, 200000.0, TileEntityLargeWindGenerator::new, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, true),
        LARGE_HEAT_GENERATOR(MultiblockMachineGeneratorBlock.MULTIBLOCK_MACHINE_GENERATOR_BLOCK_1, 1, "LargeHeatGenerator", 1, 160000.0, TileEntityLargeHeatGenerator::new, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, true),
        LARGE_GAS_GENERATOR(MultiblockMachineGeneratorBlock.MULTIBLOCK_MACHINE_GENERATOR_BLOCK_1, 2, "LargeGasGenerator", 2, 160000.0, TileEntityLargeGasGenerator::new, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, true);

        public MultiblockMachineGeneratorBlock blockType;
        public int meta;
        public String blockName;
        public int guiId;
        public double maxEnergy;
        public Supplier<TileEntity> tileEntitySupplier;
        public boolean hasModel;
        public Predicate<EnumFacing> facingPredicate;
        public boolean activable;
        public boolean hasRedstoneOutput;
        public boolean supportsUpgrades;
        private static final List<MultiblockMachineGeneratorType> GENERATORS_FOR_CONFIG;

        private MultiblockMachineGeneratorType(MultiblockMachineGeneratorBlock block, int m, String name, int gui, double energy, Supplier<TileEntity> tileClass, boolean model, Predicate<EnumFacing> predicate, boolean hasActiveTexture, boolean upgrades) {
            this(block, m, name, gui, energy, tileClass, model, predicate, hasActiveTexture, false, upgrades);
        }

        private MultiblockMachineGeneratorType(MultiblockMachineGeneratorBlock block, int m, String name, int gui, double energy, Supplier<TileEntity> tileClass, boolean model, Predicate<EnumFacing> predicate, boolean hasActiveTexture, boolean hasRedstoneOutput, boolean upgrades) {
            this.blockType = block;
            this.meta = m;
            this.blockName = name;
            this.guiId = gui;
            this.maxEnergy = energy;
            this.tileEntitySupplier = tileClass;
            this.hasModel = model;
            this.facingPredicate = predicate;
            this.activable = hasActiveTexture;
            this.hasRedstoneOutput = hasRedstoneOutput;
            this.supportsUpgrades = upgrades;
        }

        public static List<MultiblockMachineGeneratorType> getGeneratorsForConfig() {
            return GENERATORS_FOR_CONFIG;
        }

        public static MultiblockMachineGeneratorType get(IBlockState state) {
            Block block = state.func_177230_c();
            if (block instanceof BlockMultiblockMachineGenerator) {
                BlockMultiblockMachineGenerator generator = (BlockMultiblockMachineGenerator)block;
                return (MultiblockMachineGeneratorType)((Object)state.func_177229_b(generator.getTypeProperty()));
            }
            return null;
        }

        public static MultiblockMachineGeneratorType get(Block block, int meta) {
            if (block instanceof BlockMultiblockMachineGenerator) {
                BlockMultiblockMachineGenerator generator = (BlockMultiblockMachineGenerator)block;
                return MultiblockMachineGeneratorType.get(generator.getGeneratorBlock(), meta);
            }
            return null;
        }

        public static MultiblockMachineGeneratorType get(MultiblockMachineGeneratorBlock block, int meta) {
            for (MultiblockMachineGeneratorType type : MultiblockMachineGeneratorType.values()) {
                if (type.meta != meta || type.blockType != block) continue;
                return type;
            }
            return null;
        }

        public static MultiblockMachineGeneratorType get(ItemStack stack) {
            return MultiblockMachineGeneratorType.get(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
        }

        @Override
        public String getBlockName() {
            return this.blockName;
        }

        @Override
        public boolean isEnabled() {
            return MekanismConfig.current().multiblock.multiblockmachinegeneratorsManager.isEnabled(this);
        }

        public boolean isValidMachine() {
            return true;
        }

        public TileEntity create() {
            return this.tileEntitySupplier != null ? this.tileEntitySupplier.get() : null;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String getDescription() {
            return LangUtils.localize("tooltip." + this.blockName);
        }

        public ItemStack getStack() {
            return new ItemStack(MultiblockMachineBlocks.MultiblockGenerator, 1, this.meta);
        }

        public boolean canRotateTo(EnumFacing side) {
            return this.facingPredicate.test(side);
        }

        public boolean hasRotations() {
            return !this.facingPredicate.equals(BlockStateUtils.NO_ROTATION);
        }

        public boolean hasActiveTexture() {
            return this.activable;
        }

        static {
            GENERATORS_FOR_CONFIG = new ArrayList<MultiblockMachineGeneratorType>();
            Arrays.stream(MultiblockMachineGeneratorType.values()).filter(MultiblockMachineGeneratorType::isValidMachine).forEach(GENERATORS_FOR_CONFIG::add);
        }
    }

    public static enum MultiblockMachineGeneratorBlock {
        MULTIBLOCK_MACHINE_GENERATOR_BLOCK_1;

        PropertyEnum<MultiblockMachineGeneratorType> generatorTypeProperty;

        public PropertyEnum<MultiblockMachineGeneratorType> getProperty() {
            if (this.generatorTypeProperty == null) {
                this.generatorTypeProperty = PropertyEnum.func_177708_a((String)"type", MultiblockMachineGeneratorType.class, input -> input != null && input.blockType == this);
            }
            return this.generatorTypeProperty;
        }

        public Block getBlock() {
            if (this == MULTIBLOCK_MACHINE_GENERATOR_BLOCK_1) {
                return MultiblockMachineBlocks.MultiblockGenerator;
            }
            return null;
        }
    }
}

