/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.block.states;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.common.base.IBlockType;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.block.states.BlockStateUtils;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.LangUtils;
import mekanism.multiblockmachine.common.MultiblockMachineBlocks;
import mekanism.multiblockmachine.common.block.BlockMultiblockMachine;
import mekanism.multiblockmachine.common.tile.machine.TileEntityDigitalAssemblyTable;
import mekanism.multiblockmachine.common.tile.machine.TileEntityLargeChemicalInfuser;
import mekanism.multiblockmachine.common.tile.machine.TileEntityLargeChemicalWasher;
import mekanism.multiblockmachine.common.tile.machine.TileEntityLargeElectrolyticSeparator;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockStateMultiblockMachine
extends ExtendedBlockState {
    public static final PropertyBool activeProperty = PropertyBool.func_177716_a((String)"active");

    public BlockStateMultiblockMachine(BlockMultiblockMachine block, PropertyEnum<?> typeProperty) {
        super((Block)block, new IProperty[]{BlockStateFacing.facingProperty, typeProperty, activeProperty}, new IUnlistedProperty[0]);
    }

    public static class MultiblockMachineBlockStateMapper
    extends StateMapperBase {
        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            BlockMultiblockMachine block = (BlockMultiblockMachine)state.func_177230_c();
            MultiblockMachineType type = (MultiblockMachineType)((Object)state.func_177229_b(block.getTypeProperty()));
            StringBuilder builder = new StringBuilder();
            if (type.hasActiveTexture()) {
                builder.append(activeProperty.func_177701_a());
                builder.append("=");
                builder.append(state.func_177229_b((IProperty)activeProperty));
            }
            if (type.hasRotations()) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockStateFacing.facingProperty);
                if (!type.canRotateTo(facing)) {
                    facing = EnumFacing.NORTH;
                }
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(BlockStateFacing.facingProperty.func_177701_a());
                builder.append("=");
                builder.append(facing.func_176610_l());
            }
            if (builder.length() == 0) {
                builder.append("normal");
            }
            ResourceLocation baseLocation = new ResourceLocation("mekanismmultiblockmachine", type.func_176610_l());
            return new ModelResourceLocation(baseLocation, builder.toString());
        }
    }

    public static enum MultiblockMachineType implements IStringSerializable,
    IBlockType
    {
        LARGE_ELECTROLYTIC_SEPARATOR(MultiblockMachineBlock.MULTI_BLOCK_MACHINE_BLOCK_1, 0, "LargeElectrolyticSeparator", 3, TileEntityLargeElectrolyticSeparator::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false),
        LARGE_CHEMICAL_INFUSER(MultiblockMachineBlock.MULTI_BLOCK_MACHINE_BLOCK_1, 1, "LargeChemicalInfuser", 4, TileEntityLargeChemicalInfuser::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false),
        LARGE_CHEMICAL_WASHER(MultiblockMachineBlock.MULTI_BLOCK_MACHINE_BLOCK_1, 2, "LargeChemicalWasher", 5, TileEntityLargeChemicalWasher::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false),
        DIGITAL_ASSEMBLY_TABLE(MultiblockMachineBlock.MULTI_BLOCK_MACHINE_BLOCK_1, 3, "DigitalAssemblyTable", 6, TileEntityDigitalAssemblyTable::new, true, true, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false);

        private static final List<MultiblockMachineType> VALID_MACHINES;
        public MultiblockMachineBlock typeBlock;
        public int meta;
        public String blockName;
        public int guiId;
        public Supplier<TileEntity> tileEntitySupplier;
        public boolean isElectric;
        public boolean hasModel;
        public boolean supportsUpgrades;
        public Predicate<EnumFacing> facingPredicate;
        public boolean activable;

        private MultiblockMachineType(MultiblockMachineBlock block, int m, String name, int gui, Supplier<TileEntity> tileClass, boolean electric, boolean model, boolean upgrades, Predicate<EnumFacing> predicate, boolean hasActiveTexture) {
            this.typeBlock = block;
            this.meta = m;
            this.blockName = name;
            this.guiId = gui;
            this.tileEntitySupplier = tileClass;
            this.isElectric = electric;
            this.hasModel = model;
            this.supportsUpgrades = upgrades;
            this.facingPredicate = predicate;
            this.activable = hasActiveTexture;
        }

        public static List<MultiblockMachineType> getValidMachines() {
            return VALID_MACHINES;
        }

        public static MultiblockMachineType get(Block block, int meta) {
            if (block instanceof BlockMultiblockMachine) {
                BlockMultiblockMachine machine = (BlockMultiblockMachine)block;
                return MultiblockMachineType.get(machine.getMachineBlock(), meta);
            }
            return null;
        }

        public static MultiblockMachineType get(MultiblockMachineBlock block, int meta) {
            for (MultiblockMachineType type : MultiblockMachineType.values()) {
                if (type.meta != meta || type.typeBlock != block) continue;
                return type;
            }
            return null;
        }

        public static MultiblockMachineType get(ItemStack stack) {
            return MultiblockMachineType.get(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
        }

        @Override
        public String getBlockName() {
            return this.blockName;
        }

        @Override
        public boolean isEnabled() {
            return MekanismConfig.current().multiblock.multiblockmachinesManager.isEnabled(this);
        }

        public boolean isValidMachine() {
            return true;
        }

        public TileEntity create() {
            return this.tileEntitySupplier != null ? this.tileEntitySupplier.get() : null;
        }

        public double getUsage() {
            double d;
            switch (this) {
                case LARGE_ELECTROLYTIC_SEPARATOR: {
                    d = MekanismConfig.current().general.FROM_H2.val() * 2.0;
                    break;
                }
                case LARGE_CHEMICAL_INFUSER: {
                    d = MekanismConfig.current().multiblock.largechemicalInfuserUsage.val();
                    break;
                }
                case LARGE_CHEMICAL_WASHER: {
                    d = MekanismConfig.current().multiblock.LargeChemicalWasherUsage.val();
                    break;
                }
                case DIGITAL_ASSEMBLY_TABLE: {
                    d = MekanismConfig.current().multiblock.DigitalAssemblyTableUsage.val();
                    break;
                }
                default: {
                    d = 0.0;
                }
            }
            return d;
        }

        private double getConfigStorage() {
            double d;
            switch (this) {
                case LARGE_ELECTROLYTIC_SEPARATOR: {
                    d = MekanismConfig.current().multiblock.largelectrolyticSeparator.val();
                    break;
                }
                case LARGE_CHEMICAL_INFUSER: {
                    d = MekanismConfig.current().multiblock.largechemicalInfuserStorage.val();
                    break;
                }
                case LARGE_CHEMICAL_WASHER: {
                    d = MekanismConfig.current().multiblock.LargeChemicalWasherStorage.val();
                    break;
                }
                case DIGITAL_ASSEMBLY_TABLE: {
                    d = MekanismConfig.current().multiblock.DigitalAssemblyTableStorage.val();
                    break;
                }
                default: {
                    d = 400.0 * this.getUsage();
                }
            }
            return d;
        }

        public double getStorage() {
            return Math.max(this.getConfigStorage(), this.getUsage());
        }

        public String getDescription() {
            return LangUtils.localize("tooltip." + this.blockName);
        }

        public ItemStack getStack() {
            return new ItemStack(MultiblockMachineBlocks.MultiblockMachine, 1, this.meta);
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.func_176610_l();
        }

        public boolean canRotateTo(EnumFacing side) {
            return this.facingPredicate.test(side);
        }

        public boolean hasRotations() {
            return !this.facingPredicate.equals(BlockStateUtils.NO_ROTATION);
        }

        public boolean hasActiveTexture() {
            return this.activable;
        }

        static {
            VALID_MACHINES = new ArrayList<MultiblockMachineType>();
            Arrays.stream(MultiblockMachineType.values()).filter(MultiblockMachineType::isValidMachine).forEach(VALID_MACHINES::add);
        }
    }

    public static enum MultiblockMachineBlock {
        MULTI_BLOCK_MACHINE_BLOCK_1;

        PropertyEnum<MultiblockMachineType> machineTypeProperty;

        public PropertyEnum<MultiblockMachineType> getProperty() {
            if (this.machineTypeProperty == null) {
                this.machineTypeProperty = PropertyEnum.func_177708_a((String)"type", MultiblockMachineType.class, input -> input != null && input.typeBlock == this && input.isValidMachine());
            }
            return this.machineTypeProperty;
        }

        public Block getBlock() {
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case MULTI_BLOCK_MACHINE_BLOCK_1: 
            }
            return MultiblockMachineBlocks.MultiblockMachine;
        }
    }
}

