/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.block;

import javax.annotation.Nonnull;
import mekanism.api.IMekWrench;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockMekanismContainer;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.wrenches.Wrenches;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.multiblock.TileEntityMultiblock;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.multiblockmachine.common.MekanismMultiblockMachine;
import mekanism.multiblockmachine.common.MultiblockMachineBlocks;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachineGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public abstract class BlockMultiblockMachineGenerator
extends BlockMekanismContainer {
    protected BlockMultiblockMachineGenerator() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
        this.func_149647_a(MekanismMultiblockMachine.tabMekanismMultiblockMachine);
    }

    public static BlockMultiblockMachineGenerator getGeneratorBlock(final BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorBlock block) {
        return new BlockMultiblockMachineGenerator(){

            @Override
            public BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorBlock getGeneratorBlock() {
                return block;
            }
        };
    }

    public abstract BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorBlock getGeneratorBlock();

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateMultiblockMachineGenerator(this, this.getTypeProperty());
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType type = BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.get(this.getGeneratorBlock(), meta & 0xF);
        return this.func_176223_P().func_177226_a(this.getTypeProperty(), (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType type = (BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType)((Object)state.func_177229_b(this.getTypeProperty()));
        return type.meta;
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = MekanismUtils.getTileEntitySafe(worldIn, pos);
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock block = (TileEntityBasicBlock)tile;
            if (block.facing != null) {
                state = state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)block.facing);
            }
        }
        if (tile instanceof IActiveState) {
            IActiveState activeState = (IActiveState)tile;
            state = state.func_177226_a((IProperty)BlockStateMultiblockMachineGenerator.activeProperty, (Comparable)Boolean.valueOf(activeState.getActive()));
        }
        return state;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = MekanismUtils.getTileEntity(world, pos)) instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock block = (TileEntityBasicBlock)tileEntity;
            block.onNeighborChange(neighborBlock);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityliving, ItemStack itemstack) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        EnumFacing change = EnumFacing.SOUTH;
        if (tileEntity.canSetFacing(EnumFacing.DOWN) && tileEntity.canSetFacing(EnumFacing.UP)) {
            int height = Math.round(entityliving.field_70125_A);
            if (height >= 65) {
                change = EnumFacing.UP;
            } else if (height <= -65) {
                change = EnumFacing.DOWN;
            }
        }
        if (change != EnumFacing.DOWN && change != EnumFacing.UP) {
            EnumFacing enumFacing;
            int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (side) {
                case 0: {
                    enumFacing = EnumFacing.NORTH;
                    break;
                }
                case 1: {
                    enumFacing = EnumFacing.EAST;
                    break;
                }
                case 2: {
                    enumFacing = EnumFacing.SOUTH;
                    break;
                }
                case 3: {
                    enumFacing = EnumFacing.WEST;
                    break;
                }
                default: {
                    enumFacing = change;
                }
            }
            change = enumFacing;
        }
        tileEntity.setFacing(change);
        boolean bl = tileEntity.redstone = world.func_175687_A(pos) > 0;
        if (tileEntity instanceof IBoundingBlock) {
            IBoundingBlock block = (IBoundingBlock)((Object)tileEntity);
            block.onPlace();
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IActiveState activeState;
        TileEntity tileEntity;
        if (MekanismConfig.current().client.enableAmbientLighting.val() && (tileEntity = MekanismUtils.getTileEntitySafe(world, pos)) instanceof IActiveState && (activeState = (IActiveState)tileEntity).getActive() && activeState.lightUpdate()) {
            return MekanismConfig.current().client.ambientLightingLevel.val();
        }
        return 0;
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    @Deprecated
    public float func_180647_a(IBlockState state, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return SecurityUtils.canAccess(player, tile) ? super.func_180647_a(state, player, world, pos) : 0.0f;
    }

    public void func_149666_a(CreativeTabs creativetabs, NonNullList<ItemStack> list) {
        for (BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType type : BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.values()) {
            if (!type.isEnabled()) continue;
            list.add((Object)new ItemStack((Block)this, 1, type.meta));
        }
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        if (tileEntity instanceof IBoundingBlock) {
            IBoundingBlock block = (IBoundingBlock)((Object)tileEntity);
            block.onBreak();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult raytrace;
        IMekWrench wrenchHandler;
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        int metadata = state.func_177230_c().func_176201_c(state);
        ItemStack stack = entityplayer.func_184586_b(hand);
        if (!stack.func_190926_b() && (wrenchHandler = Wrenches.getHandler(stack)) != null && wrenchHandler.canUseWrench(entityplayer, hand, stack, raytrace = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos))) {
            if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                wrenchHandler.wrenchUsed(entityplayer, hand, stack, raytrace);
                if (entityplayer.func_70093_af()) {
                    MekanismUtils.dismantleBlock((Block)this, state, world, pos);
                    return true;
                }
            } else {
                SecurityUtils.displayNoAccess(entityplayer);
            }
            return true;
        }
        int guiId = BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.get((BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorBlock)this.getGeneratorBlock(), (int)metadata).guiId;
        if (guiId != -1 && tileEntity != null && !entityplayer.func_70093_af()) {
            if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                entityplayer.openGui((Object)MekanismMultiblockMachine.instance, guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                SecurityUtils.displayNoAccess(entityplayer);
            }
            return true;
        }
        return false;
    }

    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        int metadata = state.func_177230_c().func_176201_c(state);
        if (BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.get(this.getGeneratorBlock(), metadata) == null) {
            return null;
        }
        return BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.get(this.getGeneratorBlock(), metadata).create();
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType type = BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.get(state);
        if (type != null) {
            switch (type) {
                case LARGE_WIND_GENERATOR: 
                case LARGE_HEAT_GENERATOR: {
                    return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
                }
            }
        }
        return super.func_193383_a(world, state, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    @Nonnull
    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType type = BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.get(state);
        if (type == null) {
            return super.func_185496_a(state, world, pos);
        }
        switch (type) {
            default: 
        }
        return super.func_185496_a(state, world, pos);
    }

    @Override
    @Nonnull
    protected ItemStack getDropItem(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        ISustainedTank tank;
        TileEntityContainerBlock block;
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        ItemStack itemStack = new ItemStack(MultiblockMachineBlocks.MultiblockGenerator, 1, state.func_177230_c().func_176201_c(state));
        if (itemStack.func_77978_p() == null && !(tileEntity instanceof TileEntityMultiblock)) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (tileEntity == null) {
            return ItemStack.field_190927_a;
        }
        if (tileEntity instanceof ISecurityTile) {
            ISecurityTile tile = (ISecurityTile)((Object)tileEntity);
            ISecurityItem securityItem = (ISecurityItem)itemStack.func_77973_b();
            if (securityItem.hasSecurity(itemStack)) {
                securityItem.setOwnerUUID(itemStack, tile.getSecurity().getOwnerUUID());
                securityItem.setSecurity(itemStack, tile.getSecurity().getMode());
            }
        }
        if (tileEntity instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock entityElectricBlock = (TileEntityElectricBlock)tileEntity;
            IEnergizedItem electricItem = (IEnergizedItem)itemStack.func_77973_b();
            electricItem.setEnergy(itemStack, entityElectricBlock.electricityStored.get());
        }
        if (tileEntity instanceof TileEntityContainerBlock && (block = (TileEntityContainerBlock)tileEntity).handleInventory()) {
            ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
            inventory.setInventory(block.getInventory(new Object[0]), itemStack);
        }
        if (tileEntity instanceof IUpgradeTile) {
            IUpgradeTile upgradeTile = (IUpgradeTile)((Object)tileEntity);
            upgradeTile.getComponent().write(ItemDataUtils.getDataMap(itemStack));
        }
        if (tileEntity instanceof ISustainedData) {
            ISustainedData data = (ISustainedData)((Object)tileEntity);
            data.writeSustainedData(itemStack);
        }
        if (tileEntity instanceof IRedstoneControl) {
            IRedstoneControl control = (IRedstoneControl)((Object)tileEntity);
            ItemDataUtils.setInt(itemStack, "controlType", control.getControlType().ordinal());
        }
        if (((ISustainedTank)itemStack.func_77973_b()).hasTank(itemStack) && tileEntity instanceof ISustainedTank && (tank = (ISustainedTank)((Object)tileEntity)).getFluidStack(new Object[0]) != null) {
            ((ISustainedTank)itemStack.func_77973_b()).setFluidStack(tank.getFluidStack(new Object[0]), itemStack);
        }
        return itemStack;
    }

    @Deprecated
    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return false;
    }

    public EnumFacing[] getValidRotations(World world, @Nonnull BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing[] valid = new EnumFacing[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!basicTile.canSetFacing(dir)) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis)) {
            basicTile.setFacing(axis);
            return true;
        }
        return false;
    }

    public PropertyEnum<BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType> getTypeProperty() {
        return this.getGeneratorBlock().getProperty();
    }

    public boolean canCreatureSpawn(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EntityLiving.SpawnPlacementType type) {
        int meta = state.func_177230_c().func_176201_c(state);
        switch (meta) {
            default: 
        }
        return super.canCreatureSpawn(state, world, pos, type);
    }

    public boolean func_149740_M(IBlockState blockState) {
        BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType type = BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.get(blockState);
        return type != null && type.hasRedstoneOutput;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile;
        BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType type = BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.get(blockState);
        if (type != null && type.hasRedstoneOutput && (tile = worldIn.func_175625_s(pos)) instanceof IComparatorSupport) {
            IComparatorSupport support = (IComparatorSupport)tile;
            return support.getRedstoneLevel();
        }
        return 0;
    }
}

