/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common.block;

import javax.annotation.Nonnull;
import mekanism.api.IMekWrench;
import mekanism.api.gas.IGasItem;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.block.BlockMekanismContainer;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.integration.wrenches.Wrenches;
import mekanism.common.security.ISecurityItem;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.multiblockmachine.common.MekanismMultiblockMachine;
import mekanism.multiblockmachine.common.MultiblockMachineBlocks;
import mekanism.multiblockmachine.common.block.states.BlockStateMidsizeGasTank;
import mekanism.multiblockmachine.common.tile.TileEntityMidsizeGasTank;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMidsizeGasTank
extends BlockMekanismContainer {
    public BlockMidsizeGasTank() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
        this.func_149647_a(MekanismMultiblockMachine.tabMekanismMultiblockMachine);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateMidsizeGasTank(this);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = MekanismUtils.getTileEntitySafe(worldIn, pos);
        if (tile instanceof TileEntityMidsizeGasTank) {
            TileEntityMidsizeGasTank tank = (TileEntityMidsizeGasTank)tile;
            if (tank.facing != null) {
                state = state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)tank.facing);
            }
        }
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        if (tileEntity == null) {
            return;
        }
        EnumFacing change = EnumFacing.SOUTH;
        if (tileEntity.canSetFacing(EnumFacing.DOWN) && tileEntity.canSetFacing(EnumFacing.UP)) {
            int height = Math.round(placer.field_70125_A);
            if (height >= 65) {
                change = EnumFacing.UP;
            } else if (height <= -65) {
                change = EnumFacing.DOWN;
            }
        }
        if (change != EnumFacing.DOWN && change != EnumFacing.UP) {
            EnumFacing enumFacing;
            int side = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (side) {
                case 0: {
                    enumFacing = EnumFacing.NORTH;
                    break;
                }
                case 1: {
                    enumFacing = EnumFacing.EAST;
                    break;
                }
                case 2: {
                    enumFacing = EnumFacing.SOUTH;
                    break;
                }
                case 3: {
                    enumFacing = EnumFacing.WEST;
                    break;
                }
                default: {
                    enumFacing = change;
                }
            }
            change = enumFacing;
        }
        tileEntity.setFacing(change);
        boolean bl = tileEntity.redstone = world.func_175687_A(pos) > 0;
        if (tileEntity instanceof IBoundingBlock) {
            IBoundingBlock block = (IBoundingBlock)((Object)tileEntity);
            block.onPlace();
        }
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        if (tileEntity instanceof IBoundingBlock) {
            IBoundingBlock block = (IBoundingBlock)((Object)tileEntity);
            block.onBreak();
        }
        super.func_180663_b(world, pos, state);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock block = (TileEntityBasicBlock)tileEntity;
            block.onNeighborChange(neighborBlock);
        }
    }

    @Deprecated
    public float func_180647_a(IBlockState state, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return SecurityUtils.canAccess(player, tile) ? super.func_180647_a(state, player, world, pos) : 0.0f;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult raytrace;
        IMekWrench wrenchHandler;
        if (world.field_72995_K) {
            return true;
        }
        TileEntityMidsizeGasTank tileEntity = (TileEntityMidsizeGasTank)world.func_175625_s(pos);
        ItemStack stack = entityplayer.func_184586_b(hand);
        if (!stack.func_190926_b() && (wrenchHandler = Wrenches.getHandler(stack)) != null && wrenchHandler.canUseWrench(entityplayer, hand, stack, raytrace = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos))) {
            if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                wrenchHandler.wrenchUsed(entityplayer, hand, stack, raytrace);
                if (entityplayer.func_70093_af()) {
                    MekanismUtils.dismantleBlock((Block)this, state, world, pos);
                    return true;
                }
                if (tileEntity != null) {
                    tileEntity.setFacing(tileEntity.facing.func_176746_e());
                    world.func_175685_c(pos, (Block)this, true);
                }
            } else {
                SecurityUtils.displayNoAccess(entityplayer);
            }
            return true;
        }
        if (tileEntity != null && !entityplayer.func_70093_af()) {
            if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                entityplayer.openGui((Object)MekanismMultiblockMachine.instance, 7, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                SecurityUtils.displayNoAccess(entityplayer);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.func_185496_a(state, world, pos);
    }

    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        return new TileEntityMidsizeGasTank();
    }

    @Override
    @Nonnull
    protected ItemStack getDropItem(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        ISecurityItem securityItem;
        TileEntityMidsizeGasTank tileEntity = (TileEntityMidsizeGasTank)world.func_175625_s(pos);
        ItemStack itemStack = new ItemStack(MultiblockMachineBlocks.MidsizeGasTank);
        if (itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (tileEntity != null && (securityItem = (ISecurityItem)itemStack.func_77973_b()).hasSecurity(itemStack)) {
            securityItem.setOwnerUUID(itemStack, tileEntity.getSecurity().getOwnerUUID());
            securityItem.setSecurity(itemStack, tileEntity.getSecurity().getMode());
        }
        IGasItem storageTank = (IGasItem)itemStack.func_77973_b();
        storageTank.setGas(itemStack, tileEntity.gasTank.getGas());
        ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
        inventory.setInventory(tileEntity.getInventory(new Object[0]), itemStack);
        return itemStack;
    }

    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityMidsizeGasTank tileEntity = (TileEntityMidsizeGasTank)world.func_175625_s(pos);
        return tileEntity.getRedstoneLevel();
    }

    public EnumFacing[] getValidRotations(World world, @Nonnull BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing[] valid = new EnumFacing[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!basicTile.canSetFacing(dir)) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis)) {
            basicTile.setFacing(axis);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP || face == EnumFacing.DOWN ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
    }
}

