/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.common;

import io.netty.buffer.ByteBuf;
import mekanism.api.MekanismAPI;
import mekanism.common.Mekanism;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.config.MekanismConfig;
import mekanism.common.fixers.MekanismDataFixers;
import mekanism.common.network.PacketSimpleGui;
import mekanism.multiblockmachine.common.CreativeTabMekanismMultiblockMachine;
import mekanism.multiblockmachine.common.MekanismMultiblockMachineRecipe;
import mekanism.multiblockmachine.common.MultiblockMachineBlocks;
import mekanism.multiblockmachine.common.MultiblockMachineCommonProxy;
import mekanism.multiblockmachine.common.MultiblockMachineGuiHandler;
import mekanism.multiblockmachine.common.MultiblockMachineItems;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachine;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachineGenerator;
import mekanism.multiblockmachine.common.fixers.MultiblockMachineTEFixer;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="mekanismmultiblockmachine", useMetadata=true, guiFactory="mekanism.multiblockmachine.client.gui.MultiblockMachineGuiFactory")
@Mod.EventBusSubscriber
public class MekanismMultiblockMachine
implements IModule {
    public static final String MODID = "mekanismmultiblockmachine";
    @SidedProxy(clientSide="mekanism.multiblockmachine.client.MultiblockMachineClientProxy", serverSide="mekanism.multiblockmachine.common.MultiblockMachineCommonProxy")
    public static MultiblockMachineCommonProxy proxy;
    @Mod.Instance(value="mekanismmultiblockmachine")
    public static MekanismMultiblockMachine instance;
    public static Version versionNumber;
    public static final int DATA_VERSION = 1;
    public static CreativeTabMekanismMultiblockMachine tabMekanismMultiblockMachine;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        MultiblockMachineBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        MultiblockMachineItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
        MultiblockMachineBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        proxy.registerBlockRenders();
        proxy.registerItemRenders();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
        proxy.loadConfiguration();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Mekanism.modulesLoaded.add(this);
        PacketSimpleGui.handlers.add(proxy);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new MultiblockMachineGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        proxy.registerTileEntities();
        proxy.registerTESRs();
        CompoundDataFixer fixer = FMLCommonHandler.instance().getDataFixer();
        ModFixs fixes = fixer.init(MODID, 1);
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new MultiblockMachineTEFixer(MekanismDataFixers.MekFixers.TILE_ENTITIES));
        Mekanism.logger.info("Loaded Mekanism Multi Block Machine module.");
    }

    @Override
    public Version getVersion() {
        return versionNumber;
    }

    @Override
    public String getName() {
        return "MultiblockMachine";
    }

    @Override
    public void writeConfig(ByteBuf dataStream, MekanismConfig config) {
        config.multiblock.write(dataStream);
    }

    @Override
    public void readConfig(ByteBuf dataStream, MekanismConfig destConfig) {
        destConfig.multiblock.read(dataStream);
    }

    @Override
    public void resetClient() {
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID) || event.getModID().equals("mekanism")) {
            proxy.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onBlacklistUpdate(MekanismAPI.BoxBlacklistEvent event) {
        for (BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType multiblockMachineGeneratorType : BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.values()) {
            MekanismAPI.addBoxBlacklist(MultiblockMachineBlocks.MultiblockGenerator, multiblockMachineGeneratorType.meta);
        }
        for (Enum enum_ : BlockStateMultiblockMachine.MultiblockMachineType.values()) {
            MekanismAPI.addBoxBlacklist(MultiblockMachineBlocks.MultiblockMachine, ((BlockStateMultiblockMachine.MultiblockMachineType)enum_).meta);
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        MekanismMultiblockMachineRecipe.addRecipes();
    }

    static {
        versionNumber = new Version(999, 999, 999);
        tabMekanismMultiblockMachine = new CreativeTabMekanismMultiblockMachine();
    }
}

