/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.client.render.machine;

import java.util.EnumMap;
import java.util.Map;
import mekanism.api.gas.GasStack;
import mekanism.client.Utils.RenderTileEntityTime;
import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.GasRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.multiblockmachine.client.model.machine.ModelDigitalAssemblyTable;
import mekanism.multiblockmachine.common.MultiblockMachineBlocks;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachineGenerator;
import mekanism.multiblockmachine.common.tile.machine.TileEntityDigitalAssemblyTable;
import mekanism.multiblockmachine.common.util.MekanismMultiblockMachineUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderDigitalAssemblyTable
extends RenderTileEntityTime<TileEntityDigitalAssemblyTable> {
    public static final RenderDigitalAssemblyTable INSTANCE = new RenderDigitalAssemblyTable();
    private static final int stages = 3600;
    public static ResourceLocation OVERLAY_ON = MekanismMultiblockMachineUtils.getResource(MekanismMultiblockMachineUtils.ResourceType.RENDER_MACHINE, "DigitalAssemblyTable/DigitalAssemblyTable_ON.png");
    public static ResourceLocation OVERLAY_OFF = MekanismMultiblockMachineUtils.getResource(MekanismMultiblockMachineUtils.ResourceType.RENDER_MACHINE, "DigitalAssemblyTable/DigitalAssemblyTable_OFF.png");
    private static Map<EnumFacing, GasRenderMap<MekanismRenderer.DisplayInteger[]>> cachedCenterInputGas = new EnumMap<EnumFacing, GasRenderMap<MekanismRenderer.DisplayInteger[]>>(EnumFacing.class);
    private static Map<EnumFacing, GasRenderMap<MekanismRenderer.DisplayInteger[]>> cachedCenterOutputGas = new EnumMap<EnumFacing, GasRenderMap<MekanismRenderer.DisplayInteger[]>>(EnumFacing.class);
    private static Map<EnumFacing, MekanismRenderer.DisplayInteger[]> energyDisplays1 = new EnumMap<EnumFacing, MekanismRenderer.DisplayInteger[]>(EnumFacing.class);
    private static Map<EnumFacing, MekanismRenderer.DisplayInteger[]> energyDisplays2 = new EnumMap<EnumFacing, MekanismRenderer.DisplayInteger[]>(EnumFacing.class);
    private static Map<EnumFacing, FluidRenderMap<MekanismRenderer.DisplayInteger[]>> cachedCenterInputFluids = new EnumMap<EnumFacing, FluidRenderMap<MekanismRenderer.DisplayInteger[]>>(EnumFacing.class);
    private static Map<EnumFacing, FluidRenderMap<MekanismRenderer.DisplayInteger[]>> cachedCenterOutputFluids = new EnumMap<EnumFacing, FluidRenderMap<MekanismRenderer.DisplayInteger[]>>(EnumFacing.class);
    private ModelDigitalAssemblyTable model = new ModelDigitalAssemblyTable();

    public static void resetDisplayInts() {
        cachedCenterInputGas.clear();
        cachedCenterOutputGas.clear();
        energyDisplays1.clear();
        energyDisplays2.clear();
        cachedCenterInputFluids.clear();
        cachedCenterOutputFluids.clear();
    }

    public ModelDigitalAssemblyTable getModel() {
        return this.model;
    }

    public void render(TileEntityDigitalAssemblyTable tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        ItemStack stack;
        MekanismRenderer.DisplayInteger[] displayList;
        MekanismRenderer.GlowInfo glowInfo;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_147499_a(tileEntity.getEnergy() > 0.0 ? OVERLAY_ON : OVERLAY_OFF);
        MekanismRenderer.rotate(tileEntity.facing, 0.0f, 180.0f, 90.0f, 270.0f);
        float actualRate = (float)tileEntity.DoorHeight / 16.0f;
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.renderWithPiston(Math.max(0.0f, actualRate), 0.0625f, tileEntity.getEnergy() != 0.0, tileEntity.getActive(), this.field_147501_a.field_147553_e, this.getTime());
        GlStateManager.func_179121_F();
        if (tileEntity.getEnergy() > 0.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            glowInfo = MekanismRenderer.enableGlow();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            this.func_147499_a(TextureMap.field_110575_b);
            MekanismRenderer.DisplayInteger[] displayEnergyList1 = this.getEnergy1DisplayList(tileEntity.facing);
            displayEnergyList1[tileEntity.getScaledEnergyLevel(3599)].render();
            MekanismRenderer.DisplayInteger[] displayEnergyList2 = this.getEnergy2DisplayList(tileEntity.facing);
            displayEnergyList2[tileEntity.getScaledEnergyLevel(3599)].render();
            MekanismRenderer.disableGlow(glowInfo);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
        }
        if (tileEntity.inputGasTank.getStored() > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179140_f();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            glowInfo = MekanismRenderer.enableGlow();
            displayList = this.getInputGasListAndRender(tileEntity.inputGasTank.getGas(), tileEntity.facing);
            MekanismRenderer.color(tileEntity.inputGasTank.getGas());
            displayList[Math.min(3599, (int)(tileEntity.inputGasScale * 3599.0f))].render();
            MekanismRenderer.resetColor();
            MekanismRenderer.disableGlow(glowInfo);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
        }
        if (tileEntity.outputGasTank.getStored() > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179140_f();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            glowInfo = MekanismRenderer.enableGlow();
            displayList = this.getOutputGasListAndRender(tileEntity.outputGasTank.getGas(), tileEntity.facing);
            MekanismRenderer.color(tileEntity.outputGasTank.getGas());
            displayList[Math.min(3599, (int)(tileEntity.outputGasScale * 3599.0f))].render();
            MekanismRenderer.resetColor();
            MekanismRenderer.disableGlow(glowInfo);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
        }
        if (tileEntity.inputFluidTank.getFluidAmount() > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179140_f();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            this.func_147499_a(TextureMap.field_110575_b);
            glowInfo = MekanismRenderer.enableGlow(tileEntity.inputFluidTank.getFluid());
            displayList = this.getInputFluidRender(tileEntity.inputFluidTank.getFluid(), tileEntity.facing);
            MekanismRenderer.color(tileEntity.inputFluidTank.getFluid());
            displayList[Math.min(3599, (int)(tileEntity.inputFluidScale * 3599.0f))].render();
            MekanismRenderer.resetColor();
            MekanismRenderer.disableGlow(glowInfo);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
        }
        if (tileEntity.outputFluidTank.getFluidAmount() > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179140_f();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            this.func_147499_a(TextureMap.field_110575_b);
            glowInfo = MekanismRenderer.enableGlow(tileEntity.outputFluidTank.getFluid());
            displayList = this.getOutputFluidRender(tileEntity.outputFluidTank.getFluid(), tileEntity.facing);
            MekanismRenderer.color(tileEntity.outputFluidTank.getFluid());
            displayList[Math.min(3599, (int)(tileEntity.outputFluidScale * 3599.0f))].render();
            MekanismRenderer.resetColor();
            MekanismRenderer.disableGlow(glowInfo);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
        }
        if (!(stack = tileEntity.func_70301_a(14)).func_190926_b() && (stack.func_77973_b() == Item.func_150898_a((Block)MultiblockMachineBlocks.MultiblockMachine) || stack.func_77973_b() == Item.func_150898_a((Block)MultiblockMachineBlocks.MultiblockGenerator) && !stack.func_77969_a(BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.LARGE_WIND_GENERATOR.getStack()))) {
            GlStateManager.func_179094_E();
            if (stack.func_77973_b() == Item.func_150898_a((Block)MultiblockMachineBlocks.MultiblockMachine)) {
                GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 2.5f), (float)((float)z + 0.5f));
                GlStateManager.func_179152_a((float)2.8375f, (float)2.8375f, (float)2.8375f);
            } else if (stack.func_77973_b() == Item.func_150898_a((Block)MultiblockMachineBlocks.MultiblockGenerator) && !stack.func_77969_a(BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.LARGE_WIND_GENERATOR.getStack())) {
                GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 2.5f), (float)((float)z + 0.5f));
                GlStateManager.func_179152_a((float)3.125f, (float)3.125f, (float)3.125f);
            }
            MekanismRenderer.rotate(tileEntity.facing, 270.0f, 90.0f, 0.0f, 180.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_147499_a(OVERLAY_ON);
        MekanismRenderer.rotate(tileEntity.facing, 0.0f, 180.0f, 90.0f, 270.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.renderGlass(0.0625f);
        GlStateManager.func_179121_F();
    }

    private MekanismRenderer.DisplayInteger[] getInputGasListAndRender(GasStack gasStack, EnumFacing side) {
        if (cachedCenterInputGas.containsKey(side) && cachedCenterInputGas.get(side).containsKey(gasStack)) {
            return (MekanismRenderer.DisplayInteger[])cachedCenterInputGas.get(side).get(gasStack);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(gasStack.getGas().getSprite());
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[3600];
        for (int i = 0; i < 3600; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            switch (side) {
                case NORTH: {
                    toReturn.minZ = 1.22;
                    toReturn.maxZ = 1.78;
                    toReturn.minX = -4.775;
                    toReturn.maxX = -4.15;
                    break;
                }
                case SOUTH: {
                    toReturn.minZ = -0.78;
                    toReturn.maxZ = -0.22;
                    toReturn.maxX = 5.775;
                    toReturn.minX = 5.15;
                    break;
                }
                case WEST: {
                    toReturn.minX = 1.22;
                    toReturn.maxX = 1.78;
                    toReturn.maxZ = 5.775;
                    toReturn.minZ = 5.15;
                    break;
                }
                case EAST: {
                    toReturn.minX = -0.78;
                    toReturn.maxX = -0.22;
                    toReturn.minZ = -4.775;
                    toReturn.maxZ = -4.15;
                }
            }
            toReturn.minY = 1.3015625;
            toReturn.maxY = 1.3015625 + (double)((float)i / 3600.0f) * 2.25 - 0.001;
            MekanismRenderer.renderObject(toReturn);
            MekanismRenderer.DisplayInteger.endList();
        }
        if (cachedCenterInputGas.containsKey(side)) {
            cachedCenterInputGas.get(side).put(gasStack, displays);
        } else {
            GasRenderMap map = new GasRenderMap();
            map.put(gasStack, displays);
            cachedCenterInputGas.put(side, map);
        }
        return displays;
    }

    private MekanismRenderer.DisplayInteger[] getOutputGasListAndRender(GasStack gasStack, EnumFacing side) {
        if (cachedCenterOutputGas.containsKey(side) && cachedCenterOutputGas.get(side).containsKey(gasStack)) {
            return (MekanismRenderer.DisplayInteger[])cachedCenterOutputGas.get(side).get(gasStack);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(gasStack.getGas().getSprite());
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[3600];
        for (int i = 0; i < 3600; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            switch (side) {
                case NORTH: {
                    toReturn.minZ = 1.22;
                    toReturn.maxZ = 1.78;
                    toReturn.maxX = 5.775;
                    toReturn.minX = 5.15;
                    break;
                }
                case SOUTH: {
                    toReturn.minZ = -0.78;
                    toReturn.maxZ = -0.22;
                    toReturn.minX = -4.775;
                    toReturn.maxX = -4.15;
                    break;
                }
                case WEST: {
                    toReturn.minX = 1.22;
                    toReturn.maxX = 1.78;
                    toReturn.minZ = -4.775;
                    toReturn.maxZ = -4.15;
                    break;
                }
                case EAST: {
                    toReturn.minX = -0.78;
                    toReturn.maxX = -0.22;
                    toReturn.maxZ = 5.775;
                    toReturn.minZ = 5.15;
                }
            }
            toReturn.minY = 1.4375;
            toReturn.maxY = 1.4375 + (double)((float)i / 3600.0f) * 2.25 - 0.001;
            MekanismRenderer.renderObject(toReturn);
            MekanismRenderer.DisplayInteger.endList();
        }
        if (cachedCenterOutputGas.containsKey(side)) {
            cachedCenterOutputGas.get(side).put(gasStack, displays);
        } else {
            GasRenderMap map = new GasRenderMap();
            map.put(gasStack, displays);
            cachedCenterOutputGas.put(side, map);
        }
        return displays;
    }

    private MekanismRenderer.DisplayInteger[] getInputFluidRender(FluidStack fluid, EnumFacing side) {
        if (cachedCenterInputFluids.containsKey(side) && cachedCenterInputFluids.get(side).containsKey(fluid)) {
            return (MekanismRenderer.DisplayInteger[])cachedCenterInputFluids.get(side).get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        MekanismRenderer.prepFlowing(toReturn, fluid);
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[3600];
        for (int i = 0; i < 3600; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getFluid().getStill(fluid) != null) {
                switch (side) {
                    case NORTH: {
                        toReturn.minZ = 3.22;
                        toReturn.maxZ = 3.78;
                        toReturn.minX = -4.775;
                        toReturn.maxX = -4.15;
                        break;
                    }
                    case SOUTH: {
                        toReturn.minZ = -2.78;
                        toReturn.maxZ = -2.22;
                        toReturn.maxX = 5.775;
                        toReturn.minX = 5.15;
                        break;
                    }
                    case WEST: {
                        toReturn.minX = 3.22;
                        toReturn.maxX = 3.78;
                        toReturn.maxZ = 5.775;
                        toReturn.minZ = 5.15;
                        break;
                    }
                    case EAST: {
                        toReturn.minX = -2.78;
                        toReturn.maxX = -2.22;
                        toReturn.minZ = -4.775;
                        toReturn.maxZ = -4.15;
                    }
                }
                toReturn.minY = 1.4375;
                toReturn.maxY = 1.4375 + (double)((float)i / 3600.0f) * 2.25 - 0.001;
                MekanismRenderer.renderObject(toReturn);
            }
            MekanismRenderer.DisplayInteger.endList();
        }
        if (cachedCenterInputFluids.containsKey(side)) {
            cachedCenterInputFluids.get(side).put(fluid, displays);
        } else {
            FluidRenderMap map = new FluidRenderMap();
            map.put(fluid, displays);
            cachedCenterInputFluids.put(side, map);
        }
        return displays;
    }

    private MekanismRenderer.DisplayInteger[] getOutputFluidRender(FluidStack fluid, EnumFacing side) {
        if (cachedCenterOutputFluids.containsKey(side) && cachedCenterOutputFluids.get(side).containsKey(fluid)) {
            return (MekanismRenderer.DisplayInteger[])cachedCenterOutputFluids.get(side).get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        MekanismRenderer.prepFlowing(toReturn, fluid);
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[3600];
        for (int i = 0; i < 3600; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getFluid().getStill(fluid) != null) {
                switch (side) {
                    case NORTH: {
                        toReturn.minZ = 3.22;
                        toReturn.maxZ = 3.78;
                        toReturn.maxX = 5.775;
                        toReturn.minX = 5.15;
                        break;
                    }
                    case SOUTH: {
                        toReturn.minZ = -2.78;
                        toReturn.maxZ = -2.22;
                        toReturn.minX = -4.775;
                        toReturn.maxX = -4.15;
                        break;
                    }
                    case WEST: {
                        toReturn.minX = 3.22;
                        toReturn.maxX = 3.78;
                        toReturn.minZ = -4.775;
                        toReturn.maxZ = -4.15;
                        break;
                    }
                    case EAST: {
                        toReturn.minX = -2.78;
                        toReturn.maxX = -2.22;
                        toReturn.maxZ = 5.775;
                        toReturn.minZ = 5.15;
                    }
                }
                toReturn.minY = 1.3015625;
                toReturn.maxY = 1.3015625 + (double)((float)i / 3600.0f) * 2.25 - 0.001;
                MekanismRenderer.renderObject(toReturn);
            }
            MekanismRenderer.DisplayInteger.endList();
        }
        if (cachedCenterOutputFluids.containsKey(side)) {
            cachedCenterOutputFluids.get(side).put(fluid, displays);
        } else {
            FluidRenderMap map = new FluidRenderMap();
            map.put(fluid, displays);
            cachedCenterOutputFluids.put(side, map);
        }
        return displays;
    }

    private MekanismRenderer.DisplayInteger[] getEnergy1DisplayList(EnumFacing side) {
        if (energyDisplays1.containsKey(side)) {
            return energyDisplays1.get(side);
        }
        MekanismRenderer.Model3D model3D = new MekanismRenderer.Model3D();
        model3D.baseBlock = Blocks.field_150355_j;
        model3D.setTexture(MekanismRenderer.energyIcon);
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[3600];
        energyDisplays1.put(side, displays);
        for (int i = 0; i < 3600; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            switch (side) {
                case NORTH: {
                    model3D.minZ = 5.205;
                    model3D.maxZ = 5.775;
                    model3D.minX = 3.23;
                    model3D.maxX = 3.77;
                    break;
                }
                case SOUTH: {
                    model3D.minZ = -4.7525;
                    model3D.maxZ = -4.21;
                    model3D.minX = -2.7100000000000004;
                    model3D.maxX = -2.23;
                    break;
                }
                case WEST: {
                    model3D.minX = 5.205;
                    model3D.maxX = 5.775;
                    model3D.minZ = -2.7100000000000004;
                    model3D.maxZ = -2.23;
                    break;
                }
                case EAST: {
                    model3D.minX = -4.7525;
                    model3D.maxX = -4.21;
                    model3D.minZ = 3.2100000000000004;
                    model3D.maxZ = 3.73;
                }
            }
            model3D.minY = 1.3015625;
            model3D.maxY = 1.3015625 + (double)((float)i / 3600.0f) * 2.25 - 0.001;
            MekanismRenderer.renderObject(model3D);
            MekanismRenderer.DisplayInteger.endList();
        }
        return displays;
    }

    private MekanismRenderer.DisplayInteger[] getEnergy2DisplayList(EnumFacing side) {
        if (energyDisplays2.containsKey(side)) {
            return energyDisplays2.get(side);
        }
        MekanismRenderer.Model3D model3D = new MekanismRenderer.Model3D();
        model3D.baseBlock = Blocks.field_150355_j;
        model3D.setTexture(MekanismRenderer.energyIcon);
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[3600];
        energyDisplays2.put(side, displays);
        for (int i = 0; i < 3600; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            switch (side) {
                case NORTH: {
                    model3D.minZ = 5.205;
                    model3D.maxZ = 5.775;
                    model3D.minX = -2.77;
                    model3D.maxX = -2.23;
                    break;
                }
                case SOUTH: {
                    model3D.minZ = -4.7525;
                    model3D.maxZ = -4.21;
                    model3D.minX = 3.2899999999999996;
                    model3D.maxX = 3.77;
                    break;
                }
                case WEST: {
                    model3D.minX = 5.205;
                    model3D.maxX = 5.775;
                    model3D.minZ = 3.2899999999999996;
                    model3D.maxZ = 3.77;
                    break;
                }
                case EAST: {
                    model3D.minX = -4.7525;
                    model3D.maxX = -4.21;
                    model3D.minZ = -2.77;
                    model3D.maxZ = -2.23;
                }
            }
            model3D.minY = 1.3015625;
            model3D.maxY = 1.3015625 + (double)((float)i / 3600.0f) * 2.25 - 0.001;
            MekanismRenderer.renderObject(model3D);
            MekanismRenderer.DisplayInteger.endList();
        }
        return displays;
    }

    public boolean isGlobalRenderer(TileEntityDigitalAssemblyTable te) {
        return true;
    }
}

