/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.client.jei;

import java.util.Collection;
import java.util.stream.Collectors;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.multiblockmachine.client.gui.machine.GuiDigitalAssemblyTable;
import mekanism.multiblockmachine.client.gui.machine.GuiLargeChemicalInfuser;
import mekanism.multiblockmachine.client.gui.machine.GuiLargeChemicalWasher;
import mekanism.multiblockmachine.client.gui.machine.GuiLargeElectrolyticSeparator;
import mekanism.multiblockmachine.client.jei.machine.other.DigitalAssemblyTableRecipeWrapper;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachine;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeWrapperFactory;

public class MultiblockRecipeRegistryHelper {
    public static void registerLargeSeparator(IModRegistry registry) {
        if (!BlockStateMultiblockMachine.MultiblockMachineType.LARGE_ELECTROLYTIC_SEPARATOR.isEnabled()) {
            return;
        }
        registry.addRecipeClickArea(GuiLargeElectrolyticSeparator.class, 80, 30, 16, 6, new String[]{RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.getJEICategory()});
        MultiblockRecipeRegistryHelper.registerRecipeItem(registry, BlockStateMultiblockMachine.MultiblockMachineType.LARGE_ELECTROLYTIC_SEPARATOR, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR);
    }

    public static void registerLargeChemicalInfuser(IModRegistry registry) {
        if (!BlockStateMultiblockMachine.MultiblockMachineType.LARGE_CHEMICAL_INFUSER.isEnabled()) {
            return;
        }
        registry.addRecipeClickArea(GuiLargeChemicalInfuser.class, 47, 50, 28, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_INFUSER.getJEICategory()});
        registry.addRecipeClickArea(GuiLargeChemicalInfuser.class, 101, 50, 28, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_INFUSER.getJEICategory()});
        MultiblockRecipeRegistryHelper.registerRecipeItem(registry, BlockStateMultiblockMachine.MultiblockMachineType.LARGE_CHEMICAL_INFUSER, RecipeHandler.Recipe.CHEMICAL_INFUSER);
    }

    public static void registerLargeChemicalWasher(IModRegistry registry) {
        if (!BlockStateMultiblockMachine.MultiblockMachineType.LARGE_CHEMICAL_WASHER.isEnabled()) {
            return;
        }
        registry.addRecipeClickArea(GuiLargeChemicalWasher.class, 61, 39, 55, 8, new String[]{RecipeHandler.Recipe.CHEMICAL_WASHER.getJEICategory()});
        MultiblockRecipeRegistryHelper.registerRecipeItem(registry, BlockStateMultiblockMachine.MultiblockMachineType.LARGE_CHEMICAL_WASHER, RecipeHandler.Recipe.CHEMICAL_WASHER);
    }

    public static void registerDigitalAssemblyTable(IModRegistry registry) {
        if (!BlockStateMultiblockMachine.MultiblockMachineType.DIGITAL_ASSEMBLY_TABLE.isEnabled()) {
            return;
        }
        MultiblockRecipeRegistryHelper.addRecipes(registry, RecipeHandler.Recipe.DIGITAL_ASSEMBLY_TABLE, DigitalAssemblyTableRecipeWrapper::new);
        registry.addRecipeClickArea(GuiDigitalAssemblyTable.class, 123, 37, 36, 10, new String[]{RecipeHandler.Recipe.DIGITAL_ASSEMBLY_TABLE.getJEICategory()});
        MultiblockRecipeRegistryHelper.registerRecipeItem(registry, BlockStateMultiblockMachine.MultiblockMachineType.DIGITAL_ASSEMBLY_TABLE, RecipeHandler.Recipe.DIGITAL_ASSEMBLY_TABLE);
    }

    private static void registerRecipeItem(IModRegistry registry, BlockStateMultiblockMachine.MultiblockMachineType type, RecipeHandler.Recipe recipe) {
        registry.addRecipeCatalyst((Object)type.getStack(), new String[]{recipe.getJEICategory()});
    }

    private static <INPUT extends MachineInput<INPUT>, OUTPUT extends MachineOutput<OUTPUT>, RECIPE extends MachineRecipe<INPUT, OUTPUT, RECIPE>> void addRecipes(IModRegistry registry, RecipeHandler.Recipe<INPUT, OUTPUT, RECIPE> type, IRecipeWrapperFactory<RECIPE> factory) {
        String recipeCategoryUid = type.getJEICategory();
        registry.handleRecipes(type.getRecipeClass(), factory, recipeCategoryUid);
        registry.addRecipes((Collection)type.get().values().stream().map(arg_0 -> factory.getRecipeWrapper(arg_0)).collect(Collectors.toList()), recipeCategoryUid);
    }
}

