/*
 * Decompiled with CFR 0.152.
 */
package mekanism.multiblockmachine.client;

import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.item.ItemLayerWrapper;
import mekanism.multiblockmachine.client.gui.GuiMidsizeGasTank;
import mekanism.multiblockmachine.client.gui.generator.GuiLargeGasGenerator;
import mekanism.multiblockmachine.client.gui.generator.GuiLargeHeatGenerator;
import mekanism.multiblockmachine.client.gui.generator.GuiLargeWindGenerator;
import mekanism.multiblockmachine.client.gui.machine.GuiDigitalAssemblyTable;
import mekanism.multiblockmachine.client.gui.machine.GuiLargeChemicalInfuser;
import mekanism.multiblockmachine.client.gui.machine.GuiLargeChemicalWasher;
import mekanism.multiblockmachine.client.gui.machine.GuiLargeElectrolyticSeparator;
import mekanism.multiblockmachine.client.render.generator.RenderLargeGasGenerator;
import mekanism.multiblockmachine.client.render.generator.RenderLargeHeatGenerator;
import mekanism.multiblockmachine.client.render.generator.RenderLargeWindGenerator;
import mekanism.multiblockmachine.client.render.item.generator.RenderMultiblockGeneratorItem;
import mekanism.multiblockmachine.client.render.item.machine.RenderMultiblockMachineItem;
import mekanism.multiblockmachine.client.render.machine.RenderDigitalAssemblyTable;
import mekanism.multiblockmachine.client.render.machine.RenderLargeChemicalInfuser;
import mekanism.multiblockmachine.client.render.machine.RenderLargeChemicalWasher;
import mekanism.multiblockmachine.client.render.machine.RenderLargeElectrolyticSeparator;
import mekanism.multiblockmachine.common.MultiblockMachineBlocks;
import mekanism.multiblockmachine.common.MultiblockMachineCommonProxy;
import mekanism.multiblockmachine.common.MultiblockMachineItems;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachine;
import mekanism.multiblockmachine.common.block.states.BlockStateMultiblockMachineGenerator;
import mekanism.multiblockmachine.common.tile.TileEntityMidsizeGasTank;
import mekanism.multiblockmachine.common.tile.generator.TileEntityLargeGasGenerator;
import mekanism.multiblockmachine.common.tile.generator.TileEntityLargeHeatGenerator;
import mekanism.multiblockmachine.common.tile.generator.TileEntityLargeWindGenerator;
import mekanism.multiblockmachine.common.tile.machine.TileEntityDigitalAssemblyTable;
import mekanism.multiblockmachine.common.tile.machine.TileEntityLargeChemicalInfuser;
import mekanism.multiblockmachine.common.tile.machine.TileEntityLargeChemicalWasher;
import mekanism.multiblockmachine.common.tile.machine.TileEntityLargeElectrolyticSeparator;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MultiblockMachineClientProxy
extends MultiblockMachineCommonProxy {
    private static final IStateMapper generatorMapper = new BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorBlockStateMapper();
    private static final IStateMapper machineMapper = new BlockStateMultiblockMachine.MultiblockMachineBlockStateMapper();

    @Override
    public void registerTESRs() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLargeWindGenerator.class, (TileEntitySpecialRenderer)new RenderLargeWindGenerator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLargeHeatGenerator.class, (TileEntitySpecialRenderer)new RenderLargeHeatGenerator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLargeGasGenerator.class, (TileEntitySpecialRenderer)new RenderLargeGasGenerator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLargeElectrolyticSeparator.class, (TileEntitySpecialRenderer)new RenderLargeElectrolyticSeparator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLargeChemicalInfuser.class, (TileEntitySpecialRenderer)new RenderLargeChemicalInfuser());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLargeChemicalWasher.class, (TileEntitySpecialRenderer)new RenderLargeChemicalWasher());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDigitalAssemblyTable.class, (TileEntitySpecialRenderer)RenderDigitalAssemblyTable.INSTANCE);
    }

    @Override
    public void registerItemRenders() {
        this.registerItemRender(MultiblockMachineItems.gas_adsorption_fractionation_module);
        this.registerItemRender(MultiblockMachineItems.high_frequency_fusion_molding_module);
        this.registerItemRender(MultiblockMachineItems.LaserLenses);
        this.registerItemRender(MultiblockMachineItems.advanced_electrolysis_core);
        Item.func_150898_a((Block)MultiblockMachineBlocks.MultiblockGenerator).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new RenderMultiblockGeneratorItem());
        Item.func_150898_a((Block)MultiblockMachineBlocks.MultiblockMachine).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new RenderMultiblockMachineItem());
    }

    @Override
    public void registerBlockRenders() {
        ModelLoader.setCustomStateMapper((Block)MultiblockMachineBlocks.MultiblockGenerator, (IStateMapper)generatorMapper);
        ModelLoader.setCustomStateMapper((Block)MultiblockMachineBlocks.MultiblockMachine, (IStateMapper)machineMapper);
        for (BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType multiblockMachineGeneratorType : BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)multiblockMachineGeneratorType.blockType.getBlock()), (int)multiblockMachineGeneratorType.meta, (ModelResourceLocation)this.getInventoryMRL(multiblockMachineGeneratorType.func_176610_l()));
        }
        for (Enum enum_ : BlockStateMultiblockMachine.MultiblockMachineType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)((BlockStateMultiblockMachine.MultiblockMachineType)enum_).typeBlock.getBlock()), (int)((BlockStateMultiblockMachine.MultiblockMachineType)enum_).meta, (ModelResourceLocation)this.getInventoryMRL(((BlockStateMultiblockMachine.MultiblockMachineType)enum_).func_176610_l()));
        }
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MultiblockMachineBlocks.MidsizeGasTank), stack -> {
            ResourceLocation baseLocation = new ResourceLocation("mekanismmultiblockmachine", "MidsizeGasTank");
            return new ModelResourceLocation(baseLocation, "facing=north");
        });
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)MultiblockMachineBlocks.MultiblockGasTank), stack -> {
            ResourceLocation baseLocation = new ResourceLocation("mekanismmultiblockmachine", "MultiblockGasTank");
            return new ModelResourceLocation(baseLocation, "facing=north");
        });
    }

    private ModelResourceLocation getInventoryMRL(String type) {
        return new ModelResourceLocation(new ResourceLocation("mekanismmultiblockmachine", type), "inventory");
    }

    public void registerItemRender(Item item) {
        MekanismRenderer.registerItemRender("mekanismmultiblockmachine", item);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        IRegistry modelRegistry = event.getModelRegistry();
        this.generatorModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, "large_wind_generator", BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.LARGE_WIND_GENERATOR);
        this.generatorModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, "large_heat_generator", BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.LARGE_HEAT_GENERATOR);
        this.generatorModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, "large_gas_generator", BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType.LARGE_GAS_GENERATOR);
        this.machineModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, "large_electrolytic_separator", BlockStateMultiblockMachine.MultiblockMachineType.LARGE_ELECTROLYTIC_SEPARATOR);
        this.machineModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, "large_chemical_infuser", BlockStateMultiblockMachine.MultiblockMachineType.LARGE_CHEMICAL_INFUSER);
        this.machineModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, "large_chemical_washer", BlockStateMultiblockMachine.MultiblockMachineType.LARGE_CHEMICAL_WASHER);
        this.machineModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, "digital_assembly_table", BlockStateMultiblockMachine.MultiblockMachineType.DIGITAL_ASSEMBLY_TABLE);
    }

    private void generatorModelBake(IRegistry<ModelResourceLocation, IBakedModel> modelRegistry, String type, BlockStateMultiblockMachineGenerator.MultiblockMachineGeneratorType generatorType) {
        ModelResourceLocation modelResourceLocation = this.getInventoryMRL(type);
        ItemLayerWrapper itemLayerWrapper = new ItemLayerWrapper((IBakedModel)modelRegistry.func_82594_a((Object)modelResourceLocation));
        RenderMultiblockGeneratorItem.modelMap.put(generatorType, itemLayerWrapper);
        modelRegistry.func_82595_a((Object)modelResourceLocation, (Object)itemLayerWrapper);
    }

    private void machineModelBake(IRegistry<ModelResourceLocation, IBakedModel> modelRegistry, String type, BlockStateMultiblockMachine.MultiblockMachineType machineType) {
        ModelResourceLocation modelResourceLocation = this.getInventoryMRL(type);
        ItemLayerWrapper itemLayerWrapper = new ItemLayerWrapper((IBakedModel)modelRegistry.func_82594_a((Object)modelResourceLocation));
        RenderMultiblockMachineItem.modelMap.put(machineType, itemLayerWrapper);
        modelRegistry.func_82595_a((Object)modelResourceLocation, (Object)itemLayerWrapper);
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public GuiScreen getClientGui(int ID, EntityPlayer player, World world, BlockPos pos) {
        GuiMekanismTile guiMekanismTile;
        TileEntity tileEntity = world.func_175625_s(pos);
        switch (ID) {
            case 0: {
                guiMekanismTile = new GuiLargeWindGenerator(player.field_71071_by, (TileEntityLargeWindGenerator)tileEntity);
                break;
            }
            case 1: {
                guiMekanismTile = new GuiLargeHeatGenerator(player.field_71071_by, (TileEntityLargeHeatGenerator)tileEntity);
                break;
            }
            case 2: {
                guiMekanismTile = new GuiLargeGasGenerator(player.field_71071_by, (TileEntityLargeGasGenerator)tileEntity);
                break;
            }
            case 3: {
                guiMekanismTile = new GuiLargeElectrolyticSeparator(player.field_71071_by, (TileEntityLargeElectrolyticSeparator)tileEntity);
                break;
            }
            case 4: {
                guiMekanismTile = new GuiLargeChemicalInfuser(player.field_71071_by, (TileEntityLargeChemicalInfuser)tileEntity);
                break;
            }
            case 5: {
                guiMekanismTile = new GuiLargeChemicalWasher(player.field_71071_by, (TileEntityLargeChemicalWasher)tileEntity);
                break;
            }
            case 6: {
                guiMekanismTile = new GuiDigitalAssemblyTable(player.field_71071_by, (TileEntityDigitalAssemblyTable)tileEntity);
                break;
            }
            case 7: {
                guiMekanismTile = new GuiMidsizeGasTank(player.field_71071_by, (TileEntityMidsizeGasTank)tileEntity);
                break;
            }
            default: {
                guiMekanismTile = null;
            }
        }
        return guiMekanismTile;
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre event) {
        RenderDigitalAssemblyTable.resetDisplayInts();
    }
}

