/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.integration.forgeenergy.ForgeEnergyIntegration;
import mekanism.common.integration.ic2.IC2Integration;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.integration.tesla.TeslaIntegration;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.CableUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.content.turbine.TurbineFluidTank;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityTurbineValve
extends TileEntityTurbineCasing
implements IFluidHandlerWrapper,
IEnergyWrapper,
IComputerIntegration,
IComparatorSupport {
    private static final String[] methods = new String[]{"isFormed", "getSteam", "getFlowRate", "getMaxFlow", "getSteamInput"};
    public boolean ic2Registered = false;
    public TurbineFluidTank fluidTank;
    private CapabilityWrapperManager<IEnergyWrapper, TeslaIntegration> teslaManager = new CapabilityWrapperManager<IEnergyWrapper, TeslaIntegration>(IEnergyWrapper.class, TeslaIntegration.class);
    private CapabilityWrapperManager<IEnergyWrapper, ForgeEnergyIntegration> forgeEnergyManager = new CapabilityWrapperManager<IEnergyWrapper, ForgeEnergyIntegration>(IEnergyWrapper.class, ForgeEnergyIntegration.class);
    private int currentRedstoneLevel;

    public TileEntityTurbineValve() {
        super("TurbineValve");
        this.fluidTank = new TurbineFluidTank(this);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.ic2Registered && MekanismUtils.useIC2()) {
            this.register();
        }
        if (!this.field_145850_b.field_72995_K) {
            int newRedstoneLevel;
            if (this.structure != null) {
                Mekanism.EXECUTE_MANAGER.addSyncTask(() -> CableUtils.emit(this));
            }
            if ((newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
                this.updateComparatorOutputLevelSync();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        if (this.structure != null) {
            return !((SynchronizedTurbineData)this.structure).locations.contains(Coord4D.get(this).offset(side));
        }
        return false;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return false;
    }

    @Optional.Method(modid="ic2")
    public void register() {
        IEnergyTile registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTile(this.field_145850_b, this.func_174877_v())) != this) {
            if (registered != null && this.ic2Registered) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(registered));
                this.ic2Registered = false;
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
                this.ic2Registered = true;
            }
        }
    }

    @Optional.Method(modid="ic2")
    public void deregister() {
        IEnergyTile registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTile(this.field_145850_b, this.func_174877_v())) != null && this.ic2Registered) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(registered));
            this.ic2Registered = false;
        }
    }

    @Override
    public double getMaxOutput() {
        return this.structure != null ? ((SynchronizedTurbineData)this.structure).getEnergyCapacity() : 0.0;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (MekanismUtils.useIC2()) {
            this.register();
        }
    }

    public void onChunkUnload() {
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (this.sideIsOutput(from)) {
            double toSend = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), RFIntegration.fromRF(maxExtract)));
            if (!simulate) {
                this.setEnergy(this.getEnergy() - toSend);
            }
            return RFIntegration.toRF(toSend);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing from) {
        return this.structure != null;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing from) {
        return RFIntegration.toRF(this.getEnergy());
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        return RFIntegration.toRF(this.getMaxEnergy());
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public int addEnergy(int amount) {
        return 0;
    }

    @Optional.Method(modid="ic2")
    public boolean isTeleporterCompatible(EnumFacing side) {
        return this.canOutputEnergy(side);
    }

    @Override
    public boolean canOutputEnergy(EnumFacing side) {
        return this.sideIsOutput(side);
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return false;
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return this.sideIsOutput(direction) && receiver instanceof IEnergyConductor;
    }

    @Optional.Method(modid="ic2")
    public int getStored() {
        return IC2Integration.toEUAsInt(this.getEnergy());
    }

    @Optional.Method(modid="ic2")
    public void setStored(int energy) {
        this.setEnergy(IC2Integration.fromEU(energy));
    }

    @Optional.Method(modid="ic2")
    public int getCapacity() {
        return IC2Integration.toEUAsInt(this.getMaxEnergy());
    }

    @Optional.Method(modid="ic2")
    public int getOutput() {
        return IC2Integration.toEUAsInt(this.getMaxOutput());
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return IC2Integration.toEU(Math.min(this.getEnergy(), this.getMaxOutput()));
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return false;
    }

    @Optional.Method(modid="ic2")
    public double getOutputEnergyUnitsPerTick() {
        return IC2Integration.toEU(this.getMaxOutput());
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing direction, double amount, double voltage) {
        return amount;
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        if (this.structure != null) {
            double toDraw = Math.min(IC2Integration.fromEU(amount), this.getMaxOutput());
            this.setEnergy(Math.max(this.getEnergy() - toDraw, 0.0));
        }
    }

    @Override
    public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
        return 0.0;
    }

    @Override
    public double pullEnergy(EnumFacing side, double amount, boolean simulate) {
        double toGive = Math.min(this.getEnergy(), amount);
        if (toGive < 1.0E-4 || side != null && !this.sideIsOutput(side)) {
            return 0.0;
        }
        if (!simulate) {
            this.setEnergy(this.getEnergy() - toGive);
        }
        return toGive;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.fluidTank.getInfo();
        } else {
            fluidTankInfoArray = PipeUtils.EMPTY;
        }
        return fluidTankInfoArray;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        int filled = this.fluidTank.fill(resource, doFill);
        if (doFill) {
            ((SynchronizedTurbineData)this.structure).newSteamInput += filled;
        }
        if (filled < ((SynchronizedTurbineData)this.structure).getFluidCapacity() && ((SynchronizedTurbineData)this.structure).dumpMode != TileEntityGasTank.GasMode.IDLE) {
            filled = Math.min(((SynchronizedTurbineData)this.structure).getFluidCapacity(), resource.amount);
        }
        return filled;
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        if (fluid.getFluid() == FluidRegistry.getFluid((String)"steam")) {
            return !this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure;
        }
        return false;
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize("gui.industrialTurbine");
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        if (method == 0) {
            return new Object[]{this.structure != null};
        }
        if (this.structure == null) {
            return new Object[]{"Unformed"};
        }
        switch (method) {
            case 1: {
                return new Object[]{((SynchronizedTurbineData)this.structure).fluidStored != null ? ((SynchronizedTurbineData)this.structure).fluidStored.amount : 0};
            }
            case 2: {
                return new Object[]{((SynchronizedTurbineData)this.structure).clientFlow};
            }
            case 3: {
                double rate = (double)((SynchronizedTurbineData)this.structure).lowerVolume * ((double)((SynchronizedTurbineData)this.structure).clientDispersers * MekanismConfig.current().generators.turbineDisperserGasFlow.val());
                rate = Math.min(rate, (double)((SynchronizedTurbineData)this.structure).vents * MekanismConfig.current().generators.turbineVentGasFlow.val());
                return new Object[]{rate};
            }
            case 4: {
                return new Object[]{((SynchronizedTurbineData)this.structure).lastSteamInput};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_OUTPUTTER_CAPABILITY || capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.sideIsOutput(this.facing) || capability == CapabilityEnergy.ENERGY)) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            if (capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_OUTPUTTER_CAPABILITY) {
                return (T)this;
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
            }
            if (capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.sideIsOutput(this.facing)) {
                return (T)this.teslaManager.getWrapper(this, this.facing);
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.forgeEnergyManager.getWrapper(this, this.facing));
            }
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }
}

