/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.multiblock.TileEntityInternalMultiblock;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTurbineRotor
extends TileEntityInternalMultiblock {
    public int blades = 0;
    private int position = -1;
    public float rotationLower;
    public float rotationUpper;

    @Override
    public void onNeighborChange(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            this.updateRotors();
        }
    }

    public void updateRotors() {
        TileEntityTurbineRotor rotor = this.nextRotor(this.func_174877_v().func_177977_b());
        if (rotor != null) {
            rotor.updateRotors();
        } else {
            this.scanRotors(0);
        }
    }

    private void scanRotors(int index) {
        TileEntityTurbineRotor rotor;
        if (index != this.position) {
            this.position = index;
            this.sendUpdatePacket();
        }
        if ((rotor = this.nextRotor(this.func_174877_v().func_177984_a())) != null) {
            rotor.scanRotors(index + 1);
        }
    }

    public boolean addBlade() {
        TileEntityTurbineRotor next = this.nextRotor(this.func_174877_v().func_177977_b());
        if (next != null && next.blades < 2) {
            return next.addBlade();
        }
        if (this.blades < 2) {
            ++this.blades;
            this.sendUpdatePacket();
            return true;
        }
        next = this.nextRotor(this.func_174877_v().func_177984_a());
        if (next != null) {
            return next.addBlade();
        }
        return false;
    }

    public boolean removeBlade() {
        TileEntityTurbineRotor next = this.nextRotor(this.func_174877_v().func_177984_a());
        if (next != null && next.blades > 0) {
            return next.removeBlade();
        }
        if (this.blades > 0) {
            --this.blades;
            this.sendUpdatePacket();
            return true;
        }
        next = this.nextRotor(this.func_174877_v().func_177977_b());
        if (next != null) {
            return next.removeBlade();
        }
        return false;
    }

    public int getHousedBlades() {
        return this.blades;
    }

    public int getPosition() {
        return this.position;
    }

    private TileEntityTurbineRotor nextRotor(BlockPos pos) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile instanceof TileEntityTurbineRotor) {
            TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)tile;
            return rotor;
        }
        return null;
    }

    private void sendUpdatePacket() {
        Mekanism.packetHandler.sendUpdatePacket(this);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            int prevBlades = this.blades;
            int prevPosition = this.position;
            this.blades = dataStream.readInt();
            this.position = dataStream.readInt();
            if (prevBlades != this.blades || prevPosition != prevBlades) {
                this.rotationLower = 0.0f;
                this.rotationUpper = 0.0f;
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.blades);
        data.add(this.position);
        return data;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.blades = nbtTags.func_74762_e("blades");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74768_a("blades", this.getHousedBlades());
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void setMultiblock(String id) {
        super.setMultiblock(id);
        this.sendUpdatePacket();
    }
}

