/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.IHeatTransfer;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NonNullListSynchronized;
import mekanism.common.util.PipeUtils;
import mekanism.generators.common.item.ItemHohlraum;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityReactorPort
extends TileEntityReactorBlock
implements IFluidHandlerWrapper,
IGasHandler,
IHeatTransfer,
IConfigurable {
    public boolean fluidEject;

    public TileEntityReactorPort() {
        super("name", 1.0);
        this.inventory = NonNullListSynchronized.withSize(0, ItemStack.field_190927_a);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtTags) {
        super.readCustomNBT(nbtTags);
        this.fluidEject = nbtTags.func_74767_n("fluidEject");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtTags) {
        super.writeCustomNBT(nbtTags);
        nbtTags.func_74757_a("fluidEject", this.fluidEject);
    }

    @Override
    public boolean isFrame() {
        return false;
    }

    @Override
    public void onUpdate() {
        if (this.changed) {
            this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        }
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            Mekanism.EXECUTE_MANAGER.addSyncTask(() -> CableUtils.emit(this));
            if (this.fluidEject && this.getReactor() != null && this.getReactor().getSteamTank().getFluid() != null) {
                FluidTank tank = this.getReactor().getSteamTank();
                EmitUtils.forEachSide(this.func_145831_w(), this.func_174877_v(), EnumSet.allOf(EnumFacing.class), (arg_0, arg_1) -> TileEntityReactorPort.lambda$onUpdate$1((IFluidTank)tank, arg_0, arg_1));
            }
        }
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.getReactor().getWaterTank().fill(resource, doFill);
    }

    @Override
    @Nullable
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.getReactor().getSteamTank().drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        return this.getReactor() != null && !this.fluidEject && this.getReactor().hasRecipe(fluid.getFluid());
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return this.getReactor() != null && (fluid == null || FluidContainerUtils.canDrain(this.getReactor().controller.steamTank.getFluid(), fluid));
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.getReactor() == null) {
            return PipeUtils.EMPTY;
        }
        return new FluidTankInfo[]{this.getReactor().getWaterTank().getInfo(), this.getReactor().getSteamTank().getInfo()};
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.getReactor() != null) {
            if (stack.getGas() == MekanismFluids.Deuterium) {
                return this.getReactor().getDeuteriumTank().receive(stack, doTransfer);
            }
            if (stack.getGas() == MekanismFluids.Tritium) {
                return this.getReactor().getTritiumTank().receive(stack, doTransfer);
            }
            if (stack.getGas() == MekanismFluids.FusionFuel) {
                return this.getReactor().getFuelTank().receive(stack, doTransfer);
            }
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return type == MekanismFluids.Deuterium || type == MekanismFluids.Tritium || type == MekanismFluids.FusionFuel;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        GasTankInfo[] gasTankInfoArray;
        if (this.getReactor() != null) {
            GasTankInfo[] gasTankInfoArray2 = new GasTankInfo[3];
            gasTankInfoArray2[0] = this.getReactor().getDeuteriumTank();
            gasTankInfoArray2[1] = this.getReactor().getTritiumTank();
            gasTankInfoArray = gasTankInfoArray2;
            gasTankInfoArray2[2] = this.getReactor().getFuelTank();
        } else {
            gasTankInfoArray = IGasHandler.NONE;
        }
        return gasTankInfoArray;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.HEAT_TRANSFER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == Capabilities.CONFIGURABLE_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.HEAT_TRANSFER_CAPABILITY || capability == Capabilities.CONFIGURABLE_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean canOutputEnergy(EnumFacing side) {
        return true;
    }

    @Override
    public double getEnergy() {
        if (this.getReactor() == null) {
            return 0.0;
        }
        return this.getReactor().getBufferedEnergy();
    }

    @Override
    public void setEnergy(double energy) {
        if (this.getReactor() != null) {
            this.getReactor().setBufferedEnergy(energy);
        }
    }

    @Override
    public double getMaxEnergy() {
        if (this.getReactor() == null) {
            return 0.0;
        }
        return this.getReactor().getBufferSize();
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return true;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return false;
    }

    @Override
    public double getMaxOutput() {
        return Double.MAX_VALUE;
    }

    @Override
    public double getTemp() {
        if (this.getReactor() != null) {
            return this.getReactor().getTemp();
        }
        return 0.0;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 5.0;
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        if (this.getReactor() != null) {
            return this.getReactor().getInsulationCoefficient(side);
        }
        return 0.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        if (this.getReactor() != null) {
            this.getReactor().transferHeatTo(heat);
        }
    }

    @Override
    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        if (this.getReactor() != null) {
            return this.getReactor().applyTemperatureChange();
        }
        return 0.0;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return this.getReactor() != null;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        TileEntity adj = Coord4D.get(this).offset(side).getTileEntity((IBlockAccess)this.field_145850_b);
        if (CapabilityUtils.hasCapability((ICapabilityProvider)adj, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d()) && !(adj instanceof TileEntityReactorBlock)) {
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    @Override
    @Nonnull
    public ItemStack func_70301_a(int slotID) {
        return this.getReactor() != null && this.getReactor().isFormed() ? this.getReactor().getInventory().get(slotID) : ItemStack.field_190927_a;
    }

    @Override
    public int func_70302_i_() {
        return this.getReactor() != null && this.getReactor().isFormed() ? 1 : 0;
    }

    @Override
    public void func_70299_a(int slotID, @Nonnull ItemStack itemstack) {
        if (this.getReactor() != null && this.getReactor().isFormed()) {
            this.getReactor().getInventory().set(slotID, itemstack);
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
                itemstack.func_190920_e(this.func_70297_j_());
            }
        }
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        int[] nArray;
        if (this.getReactor() != null && this.getReactor().isFormed()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = InventoryUtils.EMPTY;
        }
        return nArray;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return false;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return this.getReactor() == null;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        Item item;
        if (this.getReactor() != null && this.getReactor().isFormed() && (item = itemstack.func_77973_b()) instanceof ItemHohlraum) {
            ItemHohlraum hohlraum = (ItemHohlraum)item;
            return hohlraum.getGas(itemstack) != null && hohlraum.getGas((ItemStack)itemstack).amount == hohlraum.getMaxGas(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        Item item;
        if (this.getReactor() != null && this.getReactor().isFormed() && (item = itemstack.func_77973_b()) instanceof ItemHohlraum) {
            ItemHohlraum hohlraum = (ItemHohlraum)item;
            return hohlraum.getGas(itemstack) == null;
        }
        return false;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            boolean prevEject = this.fluidEject;
            this.fluidEject = dataStream.readBoolean();
            if (prevEject != this.fluidEject) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.fluidEject);
        return data;
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K) {
            this.fluidEject = !this.fluidEject;
            String modeText = " " + (Object)((Object)(this.fluidEject ? EnumColor.DARK_RED : EnumColor.DARK_GREEN)) + LangUtils.transOutputInput(this.fluidEject) + ".";
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + " " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurator.reactorPortEject") + modeText));
            Mekanism.packetHandler.sendUpdatePacket(this);
            this.markNoUpdateSync();
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K && player.func_184812_l_() && this.getReactor() != null) {
            this.getReactor().setPlasmaTemp(1.0E9);
        }
        return EnumActionResult.PASS;
    }

    private static /* synthetic */ void lambda$onUpdate$1(IFluidTank tank, TileEntity tile, EnumFacing side) {
        IFluidHandler handler;
        if (!(tile instanceof TileEntityReactorPort) && (handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) != null && PipeUtils.canFill(handler, tank.getFluid())) {
            tank.drain(handler.fill(tank.getFluid(), true), true);
        }
    }
}

